/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/


/*
 * ip/telnet.c - IP user telnet under Vkernel with stdin/stdout
 *
 * by Bill Nowicki
 *  January 1983
 *
 * March 1983 (WIN)
 *	- If ASSUME_SERVER is defined, we do not link in the network server
 * 5/83 Marvin Theimer
 *	- Internet server is now loaded rather than linked in.  This gets rid
 *	  of the ASSUME_SERVER business.
 * 6/83 Marvin Theimer
 *	- Changed format so that internet server is loaded via the team 
 *	  server.
 * 7/83 Marvin Theimer
 *	- Changed format so that internet server is loaded via the new 
 *	  ExecProg routine.
 * 9/83 TPM
 *	- Modified for new calling sequence to ExecProg.
 * 10/83 Marvin Theimer
 *	- Modified (again) for new calling sequence to ExecProg.
 */

# include <Vteams.h>
# include <Vgts.h>
# include <Vteams.h>

#define INTERNET_SERVER_FILE "internetserver"

extern ProcessId ExecProg();
extern RootMessage *RootMsg;

main (argc, argv)
    int argc;
    char **argv;
  {
    char *argv1[2];
    Message msg;
    SystemCode error;
    ProcessId pid;

    if (GetPid(INTERNET_SERVER,ANY_PID)==0 ||
            ValidPid(GetPid(INTERNET_SERVER,ANY_PID))==0) 
      {
        printf("Loading internet server.\n");
	argv1[0] = INTERNET_SERVER_FILE;
	argv1[1] = NULL;
        pid = ExecProg(argv1, 1, 0, RootMsg, RootMsg, &error);
	if (pid == NULL)
	  {
	    printf("Couldn't create an internetserver: %s.\n", 
	    	    ErrorString(error));
	    Flush(stdout);
	    exit();
	  }
	Delay(1,0);		/* Give the internet server a chance to
				   initialize itself before sending it a
				   request. */
      }

    ModifyPad(stdout,ReportEscSeq);
    if (argc == 2)
	Telnet(stdin, stdout, argv[1]);
    else
	Telnet(stdin,stdout, NULL);
  }
