/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/


/*
 * hosts.c - IP host name lookup
 *
 * Marvin Theimer and Bill Nowicki October 1983
 *
 * This version has hardwired table
 */

# include <Vio.h>
# include <ctype.h>

# define Arpanet (10 << 24)	/* Arpanet in IP address position */
# define SUNet (36 << 24)	/* Stanford Network (Class A now) */
# define CSDNet (40 << 16)

struct HostAdrType
  {
      char *hostName;
      unsigned long hostAdr;
  }
 Hosts[] =
  {
	"shasta", (SUNet | CSDNet | (0300)),
	"diablo", (SUNet | CSDNet | (0301)),
	"sail", (SUNet | CSDNet | (0302)),
	"score",  (SUNet | CSDNet | (0303)),
	"dsn", (SUNet | CSDNet | (0310)),
	"navajo", (SUNet | CSDNet | (0313)),
	"whitney",(SUNet | CSDNet | (0314)),
	"glacier", (SUNet | CSDNet | (0315)),
	"fuji", (SUNet | CSDNet | (0316)),
	"star",   (SUNet | CSDNet | (0317)),
	"su-star",   (SUNet | CSDNet | (0317)),
	"carmel", (SUNet | CSDNet | (0324)),
	"sierra", (SUNet | CSDNet | (0325)),
	"sumex", (SUNet | (45 << 16) | 87),
	"ardvax", (SUNet | (45<< 16) | 85),
	"safe", (SUNet | (45<< 16) | 86),
	"isia",  (Arpanet | (1 << 16) | (22)),
	"isib",  (Arpanet | (3 << 16) | (52)),
	"isic",  (Arpanet | (2 << 16) | (22)),
	"isid",  (Arpanet | (27)),
	"isie",  (Arpanet | (1 << 16) | (52)),
	"isif",  (Arpanet | (2 << 16) | (52)),
	"isi-vaxa", (Arpanet | (2 << 16) | (27)),
	"isi-vaxb", (Arpanet | (52)),
	0,0
    };


/*
 * GetHostAddress:
 * Returns the host address for the specified host name string.
 */

GetHostAddress(in,out,host)
    File *in, *out;
    char *host;
  {
    int i;
    int f1, f2, f3, f4;

    Lower(host);
    for (i = 0; Hosts[i].hostName != NULL; i++)
      {
	if (strcmp(host, Hosts[i].hostName) == 0)
	  {
	    fprintf(out,"Trying %s...",host);
	    Flush(out);
	    return(Hosts[i].hostAdr);
          }
      }
    if (isdigit(host[0]))
      {
        if (sscanf(host, "%d.%d.%d.%d", &f1, &f2, &f3, &f4) == 4)
	  {
	    fprintf(out,"Trying %s...",host);
	    Flush(out);
	    return((f1 << 24) | (f2 << 16) | (f3 << 8) | f4);
	  }
      }
    fprintf(out,"Sorry, %s is unknown.\r\n", host);
    return(0);
  }

