/*	help.c:		a help program for the V system			*/
/*		Kenneth Brooks		4/4/83				*/

#include <Vio.h>
#include <Vgts.h>
#include "/usr/include/sys/types.h"
#include "/usr/include/sys/dir.h"

File *in;
char filename[80] = "/usr/sun/help/";
int line = 0, error = 0;

main(argc, argv)  int argc;  char **argv;
{
  int ch, cmd;

  if (argc < 2)  strcat(filename, "V.help");
  else if (argv[1][0] == '?')  { ListTopics(); return;}
  else {
    strcat(filename, argv[1]);
    strcat(filename, ".help");
    }

  ModifyPad(stdout, LF_Output);
  in = Open(filename, FREAD, &error);
  if (in == NULL || error != 0) { printf("No help for %s\n",argv[1]); }
  else do {
    ch = getc(in);
    if (ch >= 0) putchar(ch);
    if (ch == '\n')  if (line++ >= 25) {
	printf("\033[1m--- more ---\033[0m");  Flush(stdout);
	cmd = getchar();
	printf("\b\b\b\b\b\b\b\b\b\b\b\b\b\033K");
	if (cmd == '\03') return;
	line = 0;
	}
    }
   while (ch != EOF);
  Close(in);
  }

ListTopics()
{
  struct direct entry;
  char *p;
  int i, j, c;

  printf("Topics available:\n");
  in = Open(filename, FREAD, &error);
  if (in == NULL || error != 0) { printf("Can't find directory!\n");
/*^*/  printf("in = %x, error %s\n", in, ErrorString(error)); }
  else do {
    p = (char *) &entry;
    *p++ = c = getc(in);
    if (c == EOF) break;
    for (i=1; i<16; i++)  *p++ = getc(in);
    if (entry.d_ino == 0) continue;  /* deleted entry */
    for (i=0; i<14 && entry.d_name[i] != 0; i++)
	if (entry.d_name[i] == '.')  goto gotdot;
    continue;  /* no dot in this filename */

gotdot:
    if (strncmp(entry.d_name+i, ".help", 5) != 0) continue; /*wrong extension*/
    for (j=0; j<i; j++)  putchar(entry.d_name[j]);
    Format(i);
    }
   while (1);

  Close(in);
  }

Format(n)  int n;
{
  static int position = 0;

  if (++position == 5) {
    putchar('\n');
    position = 0;
    }
  else {
    if (n < 8) putchar('\t');
    putchar('\t');
    }
  }
