/*
 * fexecute.c - run a program on the current fileserver (session host).
 *
 * Based on code from the Executive, by Tim Mann, Bill Nowicki, et al.
 * Hacked by Rob Nagler and Dave Cheriton sometime in early 1983.
 *
 * Standalone execution fixed April 1983 by Bill Nowicki
 *
 * Restructured by RJN 9/3/83:
 *	-- now killing programs works correctly, ie. ProcessFAD's are closed;
 *	   thus killing the remote process (both VGTS kill and (^^e).
 *	-- closing (^^c) works correctly.
 *	-- user knows he is executing a program on his session host.
 *	-- ModifyPAD is only called if stdin server is the VGTS
 *
 * TPM 9/17/83 - errors to stderr
 * TPM 9/21/83 - corrected EOF handling, changed name from "default"
 */

/*
 * Control flow:
 * 	1) First check for explicit invocation, i.e.,
 *	      fexecute <remote-program>
 *	   If so, then change argv to point to "<remote-program>".
 *
 *	2) try to run the remote program, failure: print error and exit.
 *
 *	3) Set up "pid1", so that it is reading from stdin and sending to
 *	   remote process. "pid2" reads from the remote process and writes
 *	   to stdout.   Pid1 is ReaderProcess() and pid2 is 
 *	   SimpleReaderProcess().
 *
 *	4) Wait for pid1 to die or send a message.  If a message is
 *	   sent, then close input to remote process and wait for pid2 to die.
 *	   Otherwise kill pid2 and close instances.
 *
 *	Death of pid1 happens if:
 *		a) File exception occurs (pid1 is the break process for stdin).
 *		b) Remote execution terminates and it is killed by pid2.
 *		c) Pid1 reads a (^^e) from keyboard (exit)
 *	Pid1 sends a message if:
 *		a) pid1 reads a (^^c) from the keyboard (close input)
 */
#include <Vio.h>
#include <Vgts.h>
#include <chars.h>

#define READER_STACK 		512	/* small stack for reader process */
#define ROOT_PROCESS_PRIORITY	4	/* should be a system manifest */
#define READER_PRIORITY 	(ROOT_PROCESS_PRIORITY + 1)
#define CTRL_CHAR	TELNET_ESCAPE

extern SystemCode RemoteExecute();
extern SimpleReaderProcess(), ReaderProcess();
extern ProcessId GetPid();
char BannerBuffer[ 100 ];

main( argc, argv )
    int argc;
    char **argv; 
 {
    SystemCode err;
    ProcessId pid1, pid2;
    File *ProcessFAD[2];
    Message msg;


    if (strcmp(argv[0],"fexecute")==0)
      {
      	   /*
	    *  skip our name if we were invoked explicitly
	    */
        argc--;
	argv++;
      }

    if ( argc == 0 )
      {
        fputs("fexecute: no arguments\n",stderr);
	exit(1);
      }

    err = RemoteExecute( ProcessFAD, argv[0], &(argv[1]), FCREATE );
    if ( err != OK )
      {
	fputs( argv[0], stderr );
        fputs( ": remote execution failed: ", stderr );
	fputs( ErrorString( err ), stderr );
        putc( '\n', stderr );
	exit( err );
      }

    pid1 = Create( READER_PRIORITY, ReaderProcess, READER_STACK );
    pid2 = Create( READER_PRIORITY + 1, SimpleReaderProcess, READER_STACK );


    if ( GetPid( VGT_SERVER, LOCAL_PID ) == stdin->fileserver )
      {
        ModifyPad( stdin, CR_Input+LF_Output+Echo+LineBuffer );
        strcpy( BannerBuffer, "Remotely executing: " );
        strncat( BannerBuffer, argv[ 0 ]
	         , sizeof( BannerBuffer ) - 1 - strlen( BannerBuffer ) );
        SetVgtBanner( stdin, BannerBuffer );
      }
    else
        fputs( "Running program on session host\n\n", stderr );

    /* So kill program works correctly */
    SetBreakProcess( stdin, pid1 );

    Ready( pid1, 4, stdin, ProcessFAD[1], stdout, pid2 );
    Ready( pid2, 4, ProcessFAD[0], stdout, stdout, pid1 );

    /* wait for the reader process to die or send a message */
    if ( ReceiveSpecific( msg, pid1 ) != 0 )
      {
        Close( ProcessFAD[1] );
        ReceiveSpecific( msg, pid2 );
      }
    else
      {
        Close( ProcessFAD[1] );
      }

    DestroyProcess( pid1 );
    DestroyProcess( pid2 );

    Close( ProcessFAD[0] );

    Flush( stdout );

  } /* main */

SimpleReaderProcess( in, to, err, pid )
    register File *in, *to, *err;
    ProcessId pid;
/*
 * Read characters from in and write to to.
 * Terminate on EOF
 */
  {
    register int c;

    while ( (c = getc( in )) != EOF )
      {
        putc( c, to );
        if ( BufferEmpty( in ) ) 
	    Flush(to);
      }

    if (in->lastexception != END_OF_FILE)
      {
	fputs("fexecute: error reading from remote program: ", stderr);
	fputs(ErrorString(in->lastexception), stderr);
	Flush(stderr);
      }

    Destroy( pid );
    Destroy( 0 );
	
  } /* SimpleReaderProcess */

ReaderProcess( in, to, err, pid )
    register File *in, *to, *err;
    ProcessId pid;
  {
/*
 * read from the input pad and send to the remote command.
 * Right now does no input cooking.
 * pid is the process going in the other direction, which we
 * kill if we finish.
 */
    register int c;
    Message msg;
    msg[ 0 ] = 0;

    while ( (c=getc(in))!=EOF )
      {
        if ( c == CTRL_CHAR )
	  {
	    switch( getc(in) )
	      {
		case 'e':	/*kill*/
		    Destroy( pid );
		    Destroy( 0 );
		    break;

	        case 'c': /* close */
		    Send( msg, Creator( 0 ) );
		    break;

		case CTRL_CHAR:
		    putc( c, to );
		    Flush( to );
		    break;

                default:
		    putc( CTRL_CHAR, to );
		    putc( c, to );
		    Flush( to );
		    break;
	      }
	  }
        else
	  {
	    putc( c, to );
	    if ( BufferEmpty( in ) ) 
	         Flush(to);
	  }  /* if */
      }  /* while */

    if (in->lastexception != END_OF_FILE)
      {
	fputs("fexecute: error reading from stdin: ", stderr);
	fputs(ErrorString(in->lastexception), stderr);
	Flush(stderr);
	Destroy( pid );
	Destroy( 0 );
      }
    else
      {
	Send( msg, Creator( 0 ) );  /* creator closes the fad & kills us */
      }
	

  } /* ReaderProcess */


