/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Main program for the server exec.
 *
 * Tim Mann, 8/19/83
 */

#include <Venviron.h>
#include <Vio.h>
#include <Vgts.h>

short ExecDebug;		/* extra debugging information */


/*
 * main:
 */

main()
  {
    File *initFile;
    char initFileName[32];
    SystemCode error;
    ProcessId myPid;

    InitFirstTeam();

    /* Figure out which init file to read based on our Ethernet address,
     *   which we get by reading the first 8 bits of our pid (kludge!) */
    myPid = GetPid(ACTIVE_PROCESS, LOCAL_PID);
    sprintf(initFileName, "[public]autoboot/boot%x", myPid>>24);

    initFile = Open(initFileName, FREAD, &error);
    if (error != OK)
      {
	printf("Can't read autoboot file %s\n", initFileName);
	initFile = stdin;
      }

    Exec( stdin, stdout, stderr, initFile );

    Close(initFile);
    printf("Autoboot complete\n");

    /* Hang forever */
    ReceiveSpecific(initFileName, myPid);  /* initFileName is a 
					    * random valid pointer */
  }
