/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Alias mechanism for V shell.
 * Marvin Theimer.
 *
 * Marvin Theimer, 8/83
 *	File first created.
 */

#include <Vio.h>
#include "sh.h"

extern char *strsave();




/*
 * InitAliases:
 * Initialize data structures for alias facility.
 */

InitAliases(aliases)
    AliaseRec aliases[];
  {
    int i;

    for (i = 0; i < MaxAliases; i++)
      {
	aliases[i].alias = NULL;
      }
  }




/*
 * DoAliases:
 * If the command word is an alias then replace it with its true value.
 * If the command specifies an alias then enter it into the defns.
 * Returns FALSE if this is an alias defn., signalling that this command
 * has been dealt with.
 */

int DoAliases(line, aliases, error)
    char *line;
    AliaseRec aliases[];
    SystemCode *error;
  {
    int i;
    char cmdBuf[LineLength];
    char *cmdPtr, *cmdPtr1, *cmd;

    *error = OK;

    /* Locate the command word and the rest of the line. */
    cmdPtr = line;
    while ((*cmdPtr == ' ') || (*cmdPtr == '\t'))
	cmdPtr++;
    cmdPtr1 = cmdPtr;
    cmd = cmdBuf;
    while ((*cmdPtr1 != ' ') && (*cmdPtr1 != '\t') && 
    	   (*cmdPtr1 != '\n') && (*cmdPtr1 != '\0'))
      {
        *cmd++ = *cmdPtr1++;
      }
    *cmd = '\0';

    /* Check if this is an alias defn. */
    if (Equal(cmdBuf, "alias"))
      {
        cmdPtr = cmdPtr1;
        while ((*cmdPtr == ' ') || (*cmdPtr == '\t'))
	    cmdPtr++;
	cmdPtr1 = cmdPtr;
	cmd = cmdBuf;
	while ((*cmdPtr1 != ' ') && (*cmdPtr1 != '\t') && 
	       (*cmdPtr1 != '\n') && (*cmdPtr1 != '\0'))
	  {
	    *cmd++ = *cmdPtr1++;
	  }
	*cmd = '\0';
	if (cmd == cmdBuf)
	  {
	    return(TRUE);	/* Print aliases command */
	  }
	else
	  {
	    if (!AddAlias(cmdBuf, cmdPtr1, aliases))
	      {
		*error = NO_SERVER_RESOURCES;
	      }
	    return(FALSE);
	  }
      }

    /* Check for aliases and replace it if found. */
    for (i = 0; i < MaxAliases; i++)
      {
	if ((aliases[i].alias != NULL) && Equal(cmdBuf, aliases[i].alias))
	  {
	    strcpy(cmdBuf, aliases[i].cmd);
				/* Copy alias defn. */
	    strcat(cmdBuf, cmdPtr1);
				/* Copy rest of command line. */
	    strcpy(line, cmdBuf);
				/* Copy new command line to old one. */
	    return(TRUE);
	  }
      }
    return(TRUE);
  }




/*
 * AddAlias:
 * Add a new alias defn.  Returns 1 if successful, 0 otherwise.
 */

int AddAlias(alias, cmd, aliases)
    char *alias, *cmd;
    AliaseRec aliases[];
  {
    int i;

    /* Check whether this is a redefinition. */
    for (i = 0; i < MaxAliases; i++)
      {
	if ((aliases[i].alias != NULL) && (Equal(aliases[i].alias, alias)))
	  {
	    aliases[i].cmd = strsave(cmd);
	    return(1);
	  }
      }

    /* Not a redefn.  Look for an empty slot for a new defn. */
    for (i = 0; i < MaxAliases; i++)
      {
	if (aliases[i].alias == NULL)
	  {
	    aliases[i].alias = strsave(alias);
	    aliases[i].cmd = strsave(cmd);
	    return(1);
	  }
      }
    return(0);
  }




/*
 * RemoveAlias:
 * Removes the specified alias defn. or all defns if alias == NULL.
 */

RemoveAlias(alias, aliases)
    char *alias;
    AliaseRec aliases[];
  {
    int i;

    for (i = 0; i < MaxAliases; i++)
      {
	if ((aliases[i].alias != NULL) && 
		((alias == NULL) || (Equal(aliases[i].alias, alias))))
	  {
	    free(aliases[i].alias);
	    free(aliases[i].cmd);
	    aliases[i].alias = NULL;
	    return;
	  }
      }
  }




/*
 * PrintAliases:
 * Print all currently defined aliases.
 */

PrintAliases(aliases, out)
    AliaseRec aliases[];
    File *out;
  {
    int i;

    for (i = 0; i < MaxAliases; i++)
      {
	if (aliases[i].alias != NULL)
	  {
	    fprintf(out, "%s  %s\n", aliases[i].alias, aliases[i].cmd);
	  }
      }
  }
