/*	vedit.h:	Global declarations for Ved			*/

#include <Vio.h>
#include "ansipad.h"

#define MAX_FILE_NAME_LEN	79

#define CHUNKSIZE 256
#define CHUNKFILLPOINT ((CHUNKSIZE * 19)/20)
#define CHUNKSPLITPOINT ((CHUNKSIZE * 7)/10)

typedef struct chunk {
  struct chunk	*prev, *next;
  unsigned short length;
  char		text[CHUNKSIZE];
  }  *Chunk;

typedef struct Rowrec {
  Chunk chunk;
  char *cp;
  char length;	/* in columns, not in bytes */
  char exists,  /* there is text here */
       continues, /* this row is a continuation */
       continued; /* this row has a continuation */
  }  Rowrec;

typedef struct mark {
  struct chunk	*chunk;
  char		*cp;
  }  Mark;

typedef struct marklink {
	Mark	*pmark;
	struct marklink *next;
	}  *Marklink;

typedef struct pos {
  unsigned short row, col;
  }  Pos;

typedef File *	Padtype;

typedef struct BUFFER {
	char	filename[80];
	Rowrec	*rows;
	Marklink Marklist;
	Mark	headmark, endmark, regionmark;
	Mark	curmark, mousemark;
	Pos	curpos;
	short	modified;
	short	selectionexists;
	Padtype	pad;
	File	*infile;
	Process_id keyproc;	/* this pad's keyboard input watcher */
	}  BUFFER;

struct BUFTABLE {
	Padtype	pad;
	short	viewx, viewy;
	BUFFER	*ptr;
	};

typedef struct {
	short code, bufid, type, x, y, buttons; /* x also serves as character */
	short unused[10];
	} Vedmsg;

#define Maxbufs	9
#define	Nrows	27
#define	Ncols	80

/* message types for messages within ved */
#define Key	1
#define Mouse	2

/* message types for mainproc -> root process */
#define CREATE_KEYPROC	1
#define DESTROY_KEYPROC 2
#define RESTART_MAINPROC 3

/* The character pointers in a Mark are absolute: if they are equal,
   the Marks are equal.  But if chunk pointers are then unequal, chaos! */
#define MarkEQ(a,b)	(a.cp == b.cp)
#define MarkNEQ(a,b)	(a.cp != b.cp)
#define Atend(m)	(m.cp == endmark.cp)
#define Atstart(m)	(m.cp == headmark.cp)
#define PageAtHead()	(rows[0].cp == headmark.cp)
#define Settoend(m)	(m = endmark)
#define Chunkend(chunk)	(chunk->text + chunk->length)

extern Rowrec	*rows;
extern Mark	headmark, endmark, regionmark, mousemark, eolmark, tempmark;
extern char	filename[80], linebuf[], filename2[];
extern char	searchstring[], repstring[];
extern int	wishcol, searchlen, replen, thisbuffer;
extern short	modified, selectionexists, incommandwindow;
extern Chunk	killbuffer, killbuftail;
extern Pos	eolpos, zeropos;
extern Mark	readfile_end;
extern SystemCode paderr;
extern Process_id mainproc, keyproc, rootproc;
extern struct BUFTABLE buffers[];

extern File	*pad, *infile;
extern unsigned char	charsize[];
extern char	chartab[];
extern short	charpt[];
extern int	debug, backupoption, addmarkfail, quoted, hiquote;

extern Mark	curmark;
extern Pos	curpos;  /* contains the two pseudo-variables below */
#define		currow		curpos.row
#define		curcol		curpos.col

#define	MarkSetcursor(mark)	Setcursor(mark, Markpos(mark))
#define NewChunk()	((struct chunk *) calloc(1,sizeof(struct chunk)))
/* BackToPad: if (incommandwindow) {SelectPad(pad); incommandwindow = 0;} */
/* purpose: get us out of command window back to the current editing window */
#define BackToPad()	(incommandwindow ? (SelectPad(pad), \
			 incommandwindow = 0) : 0)
#define myput(a,c)	if (debug&a) putchar(c)
#define myprint(a)	if (debug&a) printf

extern Mark	Makemark(),Posmark(),DispRow(),Rowmark(),Rowsend();
extern Mark	Findend(),BlockInsert();
extern Mark	Backrows(),ForwardWord(),BackWord();
extern Pos	Makepos(),Markpos();
extern int	Advance(),Retract(),ShowChar(),CountWidth();
extern int	Markcol(),WriteWithAsk(),SaveIfModified();
extern int	Search(),ReverseSearch(),TextString();
extern File	*OpenPad();
extern char	*Bakname();

extern Chunk 	BlockDelete(),CutSubchunk(),CopyText(),CopySection();
extern Chunk	ReadFile(),MakeChunk(),StringText(),ReplaceSelection();
extern Mark 	*Firstmark(),*Nextmark();
extern Marklink Marklist;
