/*
 * Handle ved menus
 *
 * A fixed menu appears at the bottom of every ved window.
 * The user can select from the commands in the menu and the action will
 * be taken.
 */
#include "vedit.h"
#include "menu.h"
#include "chardef.h"

struct MenuEntry
  {
    char *name;
    int  command[2];
  };

struct MenuEntry FixedMenuEntries[ 7 ];

InitFixedMenu( )
/*
 * Set up static menu
 */
  {
    register struct MenuEntry *entry = &FixedMenuEntries[0];
    register unsigned long (*hit)[2];
    register char *menu;
    char *end;
       
    /* C will not allow you to statically initialize a structure */
    entry->name = "  Scroll-Line  "; 	
    (entry)->command[0] = SCROLL_UP_LINE;
    (entry++)->command[1] =  SCROLL_DOWN_LINE;
    entry->name = "  Half-Page  "; 	
    (entry)->command[0] =  NEXT_HALF_PAGE;
    (entry++)->command[1] =  PREV_HALF_PAGE;
    entry->name = "  Full-Page  "; 	
    (entry)->command[0] =  NEXT_FULL_PAGE;
    (entry++)->command[1] =  PREV_FULL_PAGE;
    entry->name = "  Search  ";   	
    (entry)->command[0] =  FORWARD_SEARCH;
    (entry++)->command[1] =  REVERSE_SEARCH;
    entry->name = "   Tag   ";	
    (entry)->command[0] =  TAG_SEARCH;
    (entry++)->command[1] =  TAG_SEARCH;
    entry->name = "  Mark/Point  ";	
    (entry)->command[0] =  GOTO_THE_MARK;
    (entry++)->command[1] =  SET_THE_MARK;

    entry->name = NULL;			 
    (entry)->command[0] = 0;
    (entry++)->command[1] = 0;

    hit = FixedMenuHits;
    menu = FixedMenu;
    end = FixedMenu + Ncols + 1;
    for( entry = FixedMenuEntries; ( entry->name != NULL ) && ( menu < end )
    	 ; entry++ )
      {
        strcat( menu, entry->name );
	while( *menu != NULL )
	  {
	    (*hit)[0] = entry->command[0];
	    (*hit++)[1] = entry->command[1];
	    menu++;
          }
        *menu++ = MENU_NAME_SEPERATOR;
	(*hit)[0] = INVALID_COMMAND;
	(*hit++)[1] = INVALID_COMMAND;
      }

    /* terminate menu at last seperator of a command that will 
     * be fully displayed 
     */
    while( --menu > end || *menu != MENU_NAME_SEPERATOR )
      {
        *menu = NULL;
	(*--hit)[0] = INVALID_COMMAND;
	(*hit)[1] = INVALID_COMMAND;
      }

    *menu = ' ';	/* replace seperator */
    (*hit)[0] = INVALID_COMMAND;
    (*hit)[1] = INVALID_COMMAND;
    FixedMenu[ Ncols ] = NULL;

  } /* InitFixedMenu */
              
	  
DisplayFixedMenu( PadFile, Row )
    File *PadFile;
    int Row;
/*
 * Display the fixed menu on the bottom of the pad
 */
  {
    PadPosition( PadFile, Row, 0 );
    PadInverse( PadFile );
    fputs(  FixedMenu ,PadFile );
    PadNormal( PadFile );
    PadPosition( PadFile, currow, curcol );

  } /* DisplayFixedMenu */


