/*	file.c:		Functions involving remote file reading and 	*/
/*	writing.  Functions for killbuffer and straytext operations,	*/
/*	and buffer initialization.					*/

#include "vedit.h"
#include <Vioprotocol.h>
#include <Vnaming.h>

extern char *ErrorString();
extern SystemCode GetContextName(), GetFileName();
extern File *Open();
extern char *CurrentContextName;

static char iobuffer[2000];
Mark readfile_end;  /* a side-effect output: sometimes wanted, sometimes not*/

/* RJN - 8/12/83 - created to handle absolute path names. */


File *OpenName( AbsoluteName, RelativeName )  
    char AbsoluteName[], RelativeName[];
/*
 * Tries to open "newname", if successful it does a GetFileName on the instance
 * and then a GetContextName to the local name server to complete the name
 * NOTE: this routine presumes that both of the Names may be mangled, ie.
 * 	 it uses RelName for a scratch area.  Also note that they both must
 * 	 be at least MAX_FILE_NAME_LEN in size.
 */
  {
    File *FileDesc;
    SystemCode error;
    ProcessId ServerPid;
    ContextId Context;
    int AbsoluteNameLen, RelativeNameLen;
    

    /* open and verify existence of the file */
    FileDesc = Open(RelativeName, FREAD | FBLOCK_MODE, &error);
    /*^*/ myprint(0x20)("Open of %s returned %x  error=%x\n",RelativeName,FileDesc,error);
    if (error || (FileDesc==NULL))
      {
        NewMsg("can't read ");
	Msg(": " );
	Msg(RelativeName);
	AbsoluteName[0] = '\0';
	if ( CurrentContextName == NULL ) 
	    return( NULL );

	if ( strlen( RelativeName ) + strlen( CurrentContextName ) 
		> MAX_FILE_NAME_LEN )
  	  {
	    NewMsg( "Context Name combined with filename is too long!" );
          }
	else	  
	  {
	    strcat( AbsoluteName, CurrentContextName );
	    strcat( AbsoluteName, RelativeName );
	  }
        return( NULL );
      }
    
    RelativeNameLen = MAX_FILE_NAME_LEN;
    ServerPid = FileDesc->fileserver;

    /* get the file name */
    if ( (error = GetFileName( RelativeName, &RelativeNameLen, &ServerPid
	            		      , &Context, FileDesc->fileid )) != OK )
      {
        /* failed to get name */
        NewMsg( AbsoluteName ); 
	Msg( ": failed to get absolute pathname: " ); 
	Msg( ErrorString( error ) );
	AbsoluteName[0] = '\0';
	strncat( AbsoluteName, RelativeName, MAX_FILE_NAME_LEN );
	return( FileDesc );
      }

    AbsoluteNameLen = MAX_FILE_NAME_LEN - RelativeNameLen;

    if ( (error = GetContextName( AbsoluteName, &AbsoluteNameLen, &ServerPid
 	, &Context, GetPid( NAME_SERVER, LOCAL_PID ) )) != OK )
      {
        /* failed to get name */
        NewMsg( RelativeNameLen ); 
	Msg( ": failed to get context name: " ); 
	Msg( ErrorString( error ) );
	AbsoluteName[0] = '\0';
	strncat( AbsoluteName, RelativeName, MAX_FILE_NAME_LEN );
	return( FileDesc );
      }
      
    /* append file name to context name in AbsoluteName */
    AbsoluteName[ AbsoluteNameLen ] = '\0';
    RelativeName[ RelativeNameLen ] = '\0';
    strncat( AbsoluteName, RelativeName, MAX_FILE_NAME_LEN - AbsoluteNameLen );
   
    return( FileDesc );

  } /* OpenName */

Chunk  ReadFile(fileid)  File *fileid;
{ 
  Chunk chunk,headchunk;
  register char *cp,*ecp,*bufcp,*bufecp;
  int i, n, blocksize, stop, chunkspace;
  int alldone = 0;

  if ( fileid == NULL ) return( NULL );

  blocksize = fileid->blocksize;
  n = Read(fileid, iobuffer, blocksize);
  fileid->block++;
  bufcp = iobuffer;  bufecp = iobuffer + n;

  headchunk = chunk = NewChunk();
  if (chunk == NULL) goto Nomem;
  chunk->prev = chunk->next = NULL;
  chunk->length = CHUNKFILLPOINT;
  cp = chunk->text;  ecp = cp + CHUNKFILLPOINT;

  while (1) {
    stop = bufecp - bufcp;  chunkspace = ecp - cp;
    if (stop > chunkspace) stop = chunkspace;
  /* tight loop: vast speed advantage */
    for (i = 0; i < stop; i++) *cp++ = *bufcp++;

    if (bufcp == bufecp) {
	if (alldone) {
	    readfile_end = Makemark(chunk,cp);
	    chunk->length = cp - chunk->text;
	    return(headchunk);
	    }
	n = Read(fileid, iobuffer, blocksize);
	fileid->block++;
	if (n < blocksize) {  /* end of file */
	    if (fileid->lastexception != END_OF_FILE)
		printf("\nError in reading: %s\n",
		    ErrorString(fileid->lastexception));
	    Close(fileid);
	    alldone = 1;
	    }
	bufcp = iobuffer;  bufecp = iobuffer + n;
	}

    if (cp == ecp) {
	chunk->next = NewChunk();
	if (chunk->next == NULL) goto Nomem;
	chunk->next->prev = chunk;
	chunk = chunk->next;  cp = chunk->text;
	chunk->length = CHUNKFILLPOINT;
	ecp = cp + CHUNKFILLPOINT;
	}
    }

  /* this is what we do if we run out of memory */
Nomem:
  if (headmark.chunk)  {
    FreeText(headmark.chunk->next);
    NewMsg("File too large!");
    chunk = headmark.chunk;
    chunk->next = NULL;
    chunk->length = 0;
    return(chunk);
    }
  else  return(MakeChunk(NULL, 0));
  }  /* end of ReadFile */


/* WriteFile: given an ordered pair of marks and a filename, write the
   text between the marks as the named file.  */
int WriteFile(fname,start,end)  char *fname;  Mark start,end;
{ File *fileid,*Open();
  Chunk chunk;
  register char *cp,*bp;  char *chunkend;
  register int i,k,n;  int error=0, looptype=0, blocksize;

  /* return to editor pad now, because writing takes a long time */
  if (incommandwindow)  {SelectPad(pad);  incommandwindow = 0;}
  if (backupoption) Makebak(fname);
  fileid = Open(fname, FCREATE | FBLOCK_MODE, &error);
/*^*/ myprint(0x20)("Open of %s returned %x  error=%x\n",fname,fileid,error);
  if (error || (fileid == NULL)) {
    NewMsg("can't write ");  Msg(fname);  Beep();
    return(0);
    }

  blocksize = fileid->blocksize;
  chunk = start.chunk;  cp = start.cp;  chunkend = Chunkend(chunk);
  bp = iobuffer;  i = 0;

  while (looptype < 2) {
   /* calculate the longest tight loop we can do */
    n = chunkend - cp;  looptype = 0;
    if (blocksize - i < n) {n = blocksize - i;  looptype = 1;}
    if ( (chunk == end.chunk) && (end.cp - cp <= n) )
	{ n = end.cp - cp;  looptype = 2;}

    for (k=0; k<n; k++)  *bp++ = *cp++;
    i += k;

    if (looptype == 0) {
	chunk = chunk->next;
	if (!chunk ||(int) chunk&1) {
	    printf("Bad WriteFile\n");
	    if ((int) chunk & 1) printf("Odd chunk %x\n",chunk);
	    Close(fileid);
	    return(0);
	    }
	cp = chunk->text;  chunkend = cp + chunk->length;
/*^*/ myprint(4)("scanning chunk %x  ",chunk);
	}
    if (looptype == 1 || i == blocksize) {
	Write(fileid,iobuffer,blocksize);
	fileid->block++;
	i = 0;  bp = iobuffer;
/*^*/ myprint(4)("wrote a block\n");
	}
    else if (looptype == 2) {
	Write(fileid,iobuffer,i);
	Close(fileid);
/*^*/ myprint(0x20)("Writing complete with %d bytes\n",i);
	}

    } /* end while - end of file writing loop */

  NewMsg("wrote ");  Msg(fname);
  return(1);
  }

/* RJN - 8/15/83 - changed to handle absolute pathnames */
/* WriteWithAsk: write out the whole buffer to the stored "filename", but if
   that filename is empty then ask for one.  Return value 1 signifies normal,
   0 signifies abort by ^G. */
int WriteWithAsk()
{ int n;

  if (filename[0] == '\0') {
    NewMsg("File name, please: ");  n = Getline(linebuf,72);
    if (n < 0) return(0);
    else if (n == 0) return(1);
    else
      {
        modified = !WriteFile(linebuf, headmark, endmark);
	if ( !modified )	/* if written get the absolute name */
           Close( OpenName( filename, linebuf ) );
	else
	   strcpy( filename, linebuf );
      }
    }
  else
      modified = !WriteFile( filename, headmark, endmark );

  Banner();
  return(1);
  }

/* SaveIfModified: protection against loss of a modified buffer.  If the
   modified bit is on, asks the user whether to save the file.  If user
   responds with ^G, SaveIfModified returns 0, meaning that the calling
   action should abort.  Otherwise it does a WriteWithAsk - write the buffer,
   asking for a filename if necessary.  */
int SaveIfModified()
{ int n;

  if (!modified) return(1);
  else {
    NewMsg("Buffer is modified: save it? ");
    n = Yesno();
    if (n<0) n = 0;				/* ^G abort */
    else if (n > 0)  n = WriteWithAsk();	/* yes */
    else n = 1;					/* no */
    return(n);
    }
  }

CopyFile( InputName, OutputName )
    char *InputName, *OutputName;
/*
 * Copies InputName to OutputName
 * returns 0 if unsuccessful, 1 otherwise
 */
  {
    register File *infile, *outfile;
    register unsigned count;
    int done;
    SystemCode error;
    static char *buffer = NULL;
    static unsigned buffersize = 0;

    infile = Open( InputName, FREAD|FBLOCK_MODE, &error);
    if( error || (infile == NULL)) 
      {
	return( 0 );
      }
    outfile = Open( OutputName, FCREATE|FBLOCK_MODE, &error);
    if( error || (outfile == NULL) )
      {
        return( 0 );
      }

    buffersize = infile->blocksize;
    if ( buffer == NULL || buffersize != infile->blocksize )
      {
        if ( buffer != NULL ) 
	    free( buffer );
	buffer = (char *)malloc( buffersize = infile->blocksize );
      }

    done = 0;

    do
      {
        if ( (count = Read( infile, buffer, buffersize )) < buffersize )
          {
	    if ( infile->lastexception != END_OF_FILE )
	      {
	 	break;
	      }
	    done = 1;
	  }
	infile->block++;
	if ( Write( outfile, buffer, count ) != count )
	  {
	    break;
	  }	    
        outfile->block++ ; /* move to next block */
      }
    while( !done );

    Close(infile);
    Close(outfile);
    
    return( done );

  } /* CopyFile */

/* RJN - 8/15 - modified to make backups using copy instead of remote 
 *	        execution facility of unix.  In future, would like to
 *		have a rename facility provided by the servers
 */
/* Makebak: Takes a filename and moves that file to a file of that name	    */
Makebak( FileName )
    char *FileName;
  {

/*^*/ myprint(0x20)("Makebak: \"%s\" from \"%s\"\n",Bakname(FileName),FileName);
/*^*/ Flush(stdout);

  if ( !CopyFile( FileName, Bakname( FileName ) ) )
    {
      NewMsg( "Backup failed for file:" );
      Msg( FileName );
    }

  } /* Makebak */


/* RJN - 8/15/83 - modified to handle context names correctly.  Prior to this
 *		   change, local names for contexts didn't work.
 */
	          
/* Bakname: Takes a filename and appends .BAK to it, guaranteeing that the  */
/* result has a filename no longer than 14 chars, as required by UNIX.	    */
/* Bakname returns a static pointer, so call it, use the result, and throw  */
/* it away at once.							    */
char *Bakname(s)  char *s;
{ static char newstring[84];
  register char *beginname, *endname, *p;
  int namelen;

  strcpy(newstring, s );
  p = beginname = newstring;
  while (*p != 0 && p < newstring + 80) {
    if (*p == '/' || *p == '[' ) beginname = p + 1;
    p++;
    }
  endname = p;
  namelen = endname - beginname;
  if (namelen > 10) endname -= (namelen - 10);
  strcpy(endname,".BAK");
  return(newstring);
  } /* Bakname */



/* InitBuffer: given the starting chunk and ending mark of a piece of text,
   turns it into the buffer.  If you already have a buffer,
   free it before calling InitBuffer, or storage will be lost.  */
InitBuffer(headchunk, end_mark)  Chunk headchunk;  Mark end_mark;
{
  headmark = Makemark(headchunk, headchunk->text);
  mousemark = regionmark = headmark;
  endmark = end_mark;
  }


/* ClearBuffer: the other way to initialize a buffer */
ClearBuffer()
{ Chunk chunk;

  chunk = MakeChunk(NULL, 0);
  headmark.chunk = chunk;  headmark.cp = chunk->text;
  mousemark = regionmark = endmark = headmark;
  }


/* Note on creating a buffer:  It requires 5 steps, in order.
   1. Get the contents in straytext form.  (ReadFile)
   2. Give valid values to the standard Marks.  (InitBuffer)
   3. Allocate the row descriptor array, "rows". (in NewBuffer)
   4. Display, establishing row descriptor data.  (Display)
   5. Set the cursor - curmark, curpos  (Setcursor, MarkSetcursor)

   ClearBuffer substitutes for steps 1 and 2, in the special case that the
buffer will be empty.  All these steps should be completed before any other
operations are performed on the buffer.
*/

/***************  killbuffer and straytext operations  ******************/
Chunk killbuffer,killbuftail;

/* KillbufAdd: add a new chunk of text onto the killbuffer */
KillbufAdd(newchunk) Chunk newchunk;
{ register char *p,*q;
  if (killbuftail->length + newchunk->length <= CHUNKSIZE) {
    for (p=Chunkend(killbuftail), q=newchunk->text; q < Chunkend(newchunk);)
	*p++ = *q++;
    killbuftail->length += newchunk->length;
    if (newchunk->next) {
	killbuftail->next = newchunk->next;
	newchunk->next->prev = killbuftail;
	}
    free(newchunk);
    }
  else {
    killbuftail->next = newchunk;  newchunk->prev = killbuftail;
    killbuftail = newchunk;
    }

  while(killbuftail->next)  killbuftail = killbuftail->next;
  }

/* KillbufAddNewline: add a newline character onto the killbuffer */
KillbufAddNewline()
{
  if (killbuftail->length < CHUNKSIZE)
    killbuftail->text[killbuftail->length++] = '\n';
  else {
    killbuftail->next = MakeChunk(killbuftail, 1);
    killbuftail = killbuftail->next;
    killbuftail->text[0] = '\n';
    }
  }


/* CopyText: given the first chunk of a piece of text, return a copy of it */
Chunk  CopyText(startchunk)  Chunk startchunk;
{ Chunk chunk, copychunk, copyhead;
  register char *cp, *ecp, *copycp, *copyecp;
  register int i, stop, copyspace;

  chunk = startchunk;  cp = chunk->text;  ecp = Chunkend(chunk);
  copyhead = copychunk = MakeChunk(NULL, CHUNKFILLPOINT);
  copycp = copychunk->text;  copyecp = copycp + CHUNKFILLPOINT;

  while (1) {
    stop = ecp - cp;  copyspace = copyecp - copycp;
    if (stop > copyspace) stop = copyspace;

    for (i = 0; i < stop; i++) *copycp++ = *cp++;

    if (cp == ecp) {
	if (!chunk->next) {  /* end of material to copy */
	    copychunk->length = copycp - copychunk->text;
	    return(copyhead);
	    }
	chunk = chunk->next;  cp = chunk->text;  ecp = Chunkend(chunk);
	}

    if (copycp == copyecp) {
	copychunk->next = MakeChunk(copychunk, CHUNKFILLPOINT);
	copychunk = copychunk->next;  copycp = copychunk->text;
	copyecp = copycp + CHUNKFILLPOINT;
	}
    }
  }  /* end of CopyText */

/* CopySection: given the starting and ending marks of a part of the buffer,
   return a straytext copy of it. */
Chunk  CopySection(startmk, endmk)  Mark startmk, endmk;
{ Chunk chunk, copychunk, copyhead;
  register char *cp, *ecp, *copycp, *copyecp;
  register int i, stop, copyspace;

  chunk = startmk.chunk;  cp = startmk.cp;  ecp = Chunkend(chunk);
  copyhead = copychunk = MakeChunk(NULL, CHUNKFILLPOINT);
  copycp = copychunk->text;  copyecp = copycp + CHUNKFILLPOINT;

  while (1) {
    stop = ecp - cp;  copyspace = copyecp - copycp;
    if (endmk.chunk == chunk) stop = endmk.cp - cp;  /* guaranteed <= stop */
    if (stop > copyspace) stop = copyspace;

    for (i = 0; i < stop; i++) *copycp++ = *cp++;

    if (cp == ecp) {
	if (!chunk->next) {  /* end of buffer! */
	    ErrorMsg("CopySection: unexpected end of text");
	    copychunk->length = copycp - copychunk->text;
	    return(copyhead);
	    }
	chunk = chunk->next;  cp = chunk->text;  ecp = Chunkend(chunk);
	}

    if (cp == endmk.cp) {  /* proper ending */
	copychunk->length = copycp - copychunk->text;
	return(copyhead);
	}

    if (copycp == copyecp) {
	copychunk->next = MakeChunk(copychunk, CHUNKFILLPOINT);
	copychunk = copychunk->next;  copycp = copychunk->text;
	copyecp = copycp + CHUNKFILLPOINT;
	}
    }
  }  /* end of CopySection */


/* TextString: copy a section out of the buffer into a string of maximum */
/* length len.  Returns the actual length.				 */
int TextString(m1, m2, s, len)
  Mark m1, m2;
  char *s;
  int len;
{
  char *limit = s + len;
  register char *p = s;
  int eof = 0;

  while (MarkNEQ(m1, m2) && p < limit && !eof) {
    *p++ = *m1.cp++;
    eof = Advance(&m1);
    }
  if (p < limit) *p = '\0';
  return(p - s);
  }


/* StringText: copy a string into a new sparetext. 			*/
Chunk StringText(s, len)
  char *s;
  int len;
{
  Chunk chunk, texthead;
  register char *p, *cp, *ecp;
  char *endstr = s + len;

  texthead = chunk = MakeChunk(NULL, CHUNKFILLPOINT);
  cp = chunk->text;  ecp = cp + CHUNKFILLPOINT;
  p = s;

  while (p < endstr) {
    *cp++ = *p++;
    if (cp >= ecp) {
	chunk->next = MakeChunk(chunk, CHUNKFILLPOINT);
	chunk = chunk->next;  cp = chunk->text;
	ecp = cp + CHUNKFILLPOINT;
	}
    }
  chunk->length = cp - chunk->text;
  return(texthead);
  }

  
/* MakeChunk: takes the prev and length fields as parameters, and returns
   a new chunk with the next and line fields NULL.  If no memory is 
   available, it will keep prompting the user until he either makes some
   space or quits. */
Chunk  MakeChunk(prev, length)  Chunk prev;  int length;
{ register Chunk chunk;
  chunk = NewChunk();	/* a simple call to calloc */
  while (chunk == NULL) {
    OutOfMemory();
    chunk = NewChunk();
    }
  chunk->prev = prev;  chunk->length = length;
  chunk->next = NULL;
  return(chunk);
  }

/* FreeText: given a pointer to the start of a straytext, frees its storage */
FreeText(chunk)  Chunk chunk;
{ Chunk temp;
  while (chunk) {
    temp = chunk->next;
    free(chunk);
    chunk = temp;
    }
  }

/* Findend: given a straytext pointer, return a Mark to the end of text. */
Mark  Findend(chunk)  register Chunk chunk;
{ Mark textend;

  if (chunk == NULL)  ErrorMsg("Findend of NULL");
  for (; chunk->next; chunk = chunk->next);  /* seek last chunk */
  textend.chunk = chunk;  textend.cp = Chunkend(chunk);
  return(textend);
  }


/* OutOfMemory: Complain to the user about lack of memory and get him to */
/* do something about it.  Does not check that he has in fact solved	 */
/* the problem.  At the moment OutOfMemory is called only from MakeChunk,*/
/* which does check.							 */
OutOfMemory()
{ char ch;
  register int bufnum, currentbuf;

  NewMsg("Out of memory!  Please do one of the following:");
  NewMsg("  Pick a window to delete");
  NewMsg("  c  - continue (after you free something)");
  NewMsg("  q  - save and quit");
  NewMsg("  ^C - quit without saving");

  while (1) {
    NewMsg("");
    bufnum = PickWindow(1, &ch);
    if (bufnum >= 0) {
	if (bufnum == thisbuffer) 
	    NewMsg("Can't delete the current window without quitting");
	else {
	    currentbuf = thisbuffer;
	    PickBuffer(bufnum);
	    DeleteBuffer();
	    PickBuffer(currentbuf);
	    return;
	    }
	}
    else switch(ch) {
	case 'c': return;
	case 'q': SaveAsNeeded();
	  /*FALLTHRU*/
	case '\03': exit(1);
	default:  NewMsg("What?");
	}
    }  /* end while (1) */
  }


/* SaveAsNeeded: Save all modified buffers, saving thisbuffer LAST.	*/
/* That is so that if the current one is in an inconsistent state,	*/
/* any other buffers will be safely saved first.			*/
SaveAsNeeded()
{ register int i;
  int mybuffer = thisbuffer, swapped = 0;
  
  for (i=0; i<Maxbufs; i++) {
    if (i != mybuffer && buffers[i].pad != NULL && buffers[i].ptr->modified) {
	PickBuffer(i);
	WriteFile(filename, headmark, endmark);
	swapped = 1;
	}
    }
  if (swapped) {
    if (buffers[mybuffer].ptr->modified) {
	PickBuffer(mybuffer);
	WriteFile(filename, headmark, endmark);
	}
    }
  else {
    if (modified) WriteFile(filename, headmark, endmark);
    }
  }


/* AnyBufsModified: returns 1 if there are any modified buffers, else 0.  */
int AnyBufsModified()
{ register int i, anymod;

  anymod = modified;	/* current buffer's modified bit */
  for (i = 0; i < Maxbufs; i++)
    if (buffers[i].pad != NULL && buffers[i].ptr->modified &&
	    i != thisbuffer)
	anymod = 1;
  return(anymod);
  }


/* MarkGT: comparison of Marks.  This is one of the disoptimized operations
   in this data structure system, and takes time proportional to the number
   of chunks in the buffer.  Needed only when a Region operation is to be
   done.  Returns 1 if the first argument follows the second, else 0.
   -1 if the two are in disjoint spaces (error!) and cannot be compared.
*/
int MarkGT(m1, m2)  Mark m1, m2;
{ Chunk chunk;
/* 1. same chunk */
  if (m1.chunk == m2.chunk) {
    if (m1.cp > m2.cp) return(1);
    else return(0);
    }
/* 2. look for m2 in a chunk after m1 */
  for (chunk = m1.chunk->next; chunk; chunk = chunk->next)
    if (chunk == m2.chunk)  return(0);
/* 3. look for m2 in a chunk before m1 */
  for (chunk = m1.chunk->prev; chunk; chunk = chunk->prev)
    if (chunk == m2.chunk)  return(1);
/* error: m2 is nowhere to be found from m1 */
  ErrorMsg("MarkGT on unrelated marks");
  return(-1);
  }
