/*	device.c:	Functions dealing with the mouse and the	*/
/*	interaction line.  Hopefully changes of I/O environment will	*/
/*	changes only here and in vedit.c .				*/

#include <Venviron.h>
#include "Vgts.h"

#undef max
#undef min
#include "vedit.h"
#include "chardef.h"
#include "ansipad.h"
#include "menu.h"

#define PosEQ(p,q)	(p.row == q.row && p.col == q.col)
#define PosNE(p,q)	(p.row != q.row || p.col != q.col)
#define PosGT(p,q)	(p.row == q.row ? (p.col > q.col) : (p.row > q.row))
#define PosGE(p,q)	(p.row == q.row ? (p.col >= q.col) : (p.row > q.row))
#define PosLT(p,q)	(p.row == q.row ? (p.col < q.col) : (p.row < q.row))
#define PosLE(p,q)	(p.row == q.row ? (p.col <= q.col) : (p.row < q.row))

Pos mousepos;

MouseAction(msg)  register Vedmsg *msg;  /* as it came from KeyboardProcess */
{ Pos clickpos, releasepos;
  Mark clickmark, releasemark;
  Chunk temptext;
/*^*/ myprint(0x10)("Mouse buttons %d   ",msg->buttons);

/*** Button 1 ***/
    if (msg->buttons == LeftButton) {
	if (selectionexists) Deselect();
	PadCursorOff(pad);
	DynamicSelect(msg, &clickpos, &releasepos);
	if ( releasepos.row == Nrows ) releasepos.col = 0;
	clickmark = Posmark(&clickpos);
	releasemark = Posmark(&releasepos);
        if (MarkEQ(clickmark,releasemark)) { /* simply place the cursor */
	    if (clickpos.row == Nrows)
		PosSetcursor(Makepos(Nrows-1, Ncols));
	    else Setcursor(clickmark, clickpos);
	    ModifyPad(pad, ReportTransition);  /* NoCursor off */
	    }
	else {  /* we have a selection */
	    selectionexists = 1;
	    if (PosGT(releasepos,clickpos)) {
		mousepos = releasepos;  mousemark = releasemark;
		MarkSetcursor(clickmark);
		}
	    else {
		mousepos = clickpos;  mousemark = clickmark;
		MarkSetcursor(releasemark);
		}
	    }
	wishcol = curcol;
	}
     else
        {
          MapMouse(msg->x, msg->y, &clickpos);
	  
	  /* if button is clicked in last row don't allow cut or paste */
	  if ( clickpos.row == Nrows )
	    {
	      if ( msg->buttons == MiddleButton )
		{
	          wishcol = curcol;
	          return( FixedMenuSelection( clickpos.col, 0 ) );
		}
	      else if ( msg->buttons == RightButton )
		{
	          wishcol = curcol;
	          return( FixedMenuSelection( clickpos.col, 1 ) );
		}
	    }
	  /* check for cut  */
	  else if ( (msg->buttons == MiddleButton) &&  selectionexists) 
	    {
	      KillSelection();
	      wishcol = curcol;
	    }
	  /* is it a paste */
          else if ( (msg->buttons == RightButton) && killbuffer != NULL) 
	    {
	      if (selectionexists)  ExchangeSelection();
	      else 
	        {
	          temptext = CopyText(killbuffer);
	          InsertSelected(temptext);
	        }
	      wishcol = curcol;
	    }  /* end of Button 3 */
       }

/*** a mouse message with no buttons held is ignored ***/
     return( INVALID_COMMAND );
  }


/* ExchangeSelection: swap selected text with the killbuffer. */
ExchangeSelection()
{ Chunk temptext;

  PreAdjust(mousemark, mousepos, &eolmark, &eolpos);
  temptext = BlockDelete(curmark, mousemark);
  if (killbuffer) {
    curmark = BlockInsert(curmark, killbuffer);
    selectionexists = 1;
    }
   else {
    ModifyPad(pad, ReportTransition);
    selectionexists = 0;
    }
  AdjustDisplay(curmark, eolmark, &curpos, &eolpos);
  if (currow == Nrows) Scroll();
  if (selectionexists)  Select(curmark, mousemark);
   else Setcursor(curmark, curpos);
  killbuffer = temptext;
  }


/* ReplaceSelection: replace selected text with new, and return the 	*/
/* text that was removed.  The new is selected if selectit is nonzero.	*/
Chunk ReplaceSelection(nchunk, selectit)
  Chunk nchunk;
  int selectit;
{
  Chunk dchunk;

  PreAdjust(mousemark, mousepos, &eolmark, &eolpos);
  dchunk = BlockDelete(curmark, mousemark);
  curmark = BlockInsert(curmark, nchunk);  /* mousemark ends up after */
  AdjustDisplay(curmark, eolmark, &curpos, &eolpos);
  if (currow == Nrows) Scroll();
  if (selectit) Select(curmark, mousemark);
  else {
    Setcursor(curmark, curpos);
    selectionexists = 0;
    ModifyPad(pad, ReportTransition);
    }
  return(dchunk);
  }


/* KillSelection: delete the current selection to the killbuffer */
KillSelection()
{ 
  if (!selectionexists) {
	ErrorMsg("KillSelection with no selection");
	return;
	}
  FreeText(killbuffer);
  PreAdjust(mousemark, mousepos, &eolmark, &eolpos);
  killbuffer = BlockDelete(curmark, mousemark);
  AdjustDisplay(curmark, eolmark, &curpos, &eolpos);
  ModifyPad(pad, ReportTransition);
  selectionexists = 0;
  Setcursor(curmark, curpos);
  }

/* InsertSelected: take a piece of sparetext and insert it at curmark,
   making it the new selection.  */
InsertSelected(newtext)  Chunk newtext;
{ Mark premark;

  mousemark = curmark;
  PreAdjust(curmark, curpos, &eolmark, &eolpos);
  curmark = BlockInsert(curmark,newtext);
  AdjustDisplay(curmark, eolmark, &curpos, &eolpos);
  if (currow == Nrows) Scroll();
  MarkSetcursor(curmark);
  Select(curmark, mousemark);
  }

/* RJN - 8/18/83 - added RealCol to allow for fixed menu selection */

/* DynamicSelect: handles selection with mouse-tracking inverse video to
   display it.  Begins with the msg from the mouse click that started it,
   returns the pos of that click and of the point of release.  */
DynamicSelect(msg,ppos1,ppos2)  Vedmsg *msg;  Pos *ppos1,*ppos2;
{ Pos clickpos, oldpos, mousepos;
  register int i;
  register RealCol;
  short x, y, buttons;
  
  ModifyPad(pad, ReportTransition + NoCursor);
  MapMouse(msg->x, msg->y, &clickpos);
  if (clickpos.row == Nrows) clickpos.col = 0;
  oldpos = clickpos;

  do {
    i = GetMouseStatus(pad, &x, &y, &buttons);
    if (i >= 0) {
        MapMouse(x, y, &mousepos);
	RealCol = mousepos.col;
	if (mousepos.row == Nrows) mousepos.col = 0;
	if (PosEQ(mousepos,oldpos)) ;  /* no motion - no action */
	else if (PosGT(mousepos, oldpos)) {  /* forward motion */
	    if (PosGE(oldpos, clickpos))  Darken(oldpos,mousepos);
	    else if (PosLE(mousepos, clickpos)) Lighten(oldpos,mousepos);
	    else {Lighten(oldpos,clickpos);  Darken(clickpos,mousepos);}
	    Flush(pad);  RedrawPad(pad);
	    }
	else {		/* backward motion */
	    if (PosGE(mousepos,clickpos)) Lighten(mousepos,oldpos);
	    else if (PosLE(oldpos,clickpos)) Darken(mousepos,oldpos);
	    else {Darken(mousepos,clickpos);  Lighten(clickpos,oldpos);}
	    Flush(pad);  RedrawPad(pad);
	    }
	oldpos = mousepos;
	}  /* end if (i >= 0) */
    Delay(0, 2);
    }
     while (buttons == LeftButton && i >= 0);
    
  if (buttons != 0 || i < 0) {  /* mouse went off edge of pad 
  				  or several buttons were depressed */
    if (PosGT(mousepos, clickpos)) Lighten(clickpos, mousepos);
    else if (PosLT(mousepos, clickpos)) Lighten(mousepos, clickpos);
    *ppos1 = *ppos2 = clickpos;
    return( 0 );
    }

   /* Need to know actual location of click */
   oldpos.col = RealCol;
  *ppos1 = clickpos; /* pos where mouse was first clicked */
  *ppos2 = oldpos;  /* last pos when the mouse was in this pad */
  return( 1 );
  }

/* Lighten and Darken: Turn the region between two positions to inverse or
   normal video.  */
Lighten(firstpos,lastpos)  Pos firstpos,lastpos;
{ Mark firstmark, lastmark;
  firstmark = Posmark(&firstpos);
  lastmark = Posmark(&lastpos);
  PadNormal(pad);
  DisplayBetween(firstmark,lastmark,firstpos);
  }

Darken(firstpos,lastpos)  Pos firstpos,lastpos;
{ Mark firstmark, lastmark;
  firstmark = Posmark(&firstpos);
  lastmark = Posmark(&lastpos);
  PadInverse(pad);
  DisplayBetween(firstmark,lastmark,firstpos);
  PadNormal(pad);
  }


/* MapMouse: given a mouse message, return a pad identifier and a row,column
   pair.  A pad i.d. of -1 means the mouse was clicked out in the gray.  */
MapMouse(x,y,ppos)  register short x, y;  register Pos *ppos;
{
  PadFindPoint(pad,Nrows, x,y,&(ppos->row),&(ppos->col) );
  if (ppos->row > 255) ppos->row = 0; /* unsigned: I really mean < 0 */
  if (ppos->col > 255) ppos->col = 0;
/*^*/myprint(0x10)("MapMouse world (%d,%d) pos (%d,%d)\n",
	x,y,ppos->row,ppos->col);
  }

/* Select: darken and record a selection.  */
Select(firstmark, lastmark)  Mark firstmark, lastmark;
{
  mousemark = lastmark;  mousepos = Markpos(mousemark);
  MarkSetcursor(firstmark);
  PadInverse(pad);
  DisplayBetween(firstmark,lastmark,curpos);
  PadNormal(pad);
  ModifyPad(pad, ReportTransition + NoCursor);
  selectionexists = 1;
  }

/* Deselect: undo any selection present, leaving a normal cursor at the end of
   the selected area.  */
Deselect()
{ PadNormal(pad);
  DisplayBetween(curmark, mousemark, curpos);
  ModifyPad(pad, ReportTransition);  /* NoCursor off */
  selectionexists = 0;
  }

extern int OKCR;	/* cf. visual.c */

/* DisplayBetween: display the material between two marks, starting at	*/
/* the given position - which should normally be the Markpos of the first */
/* mark.  It is assumed that DisplayBetween only rewrites text that was	*/
/* already there, so no row calculations are done.			*/
DisplayBetween(start, end, startpos)  Mark start, end;  Pos startpos;
{ register int row=startpos.row, col=startpos.col;
  register int prevcol, eof=0;
  register char ch;
  Mark m;

  m = start;
  PadPosition(pad,row,col);
  OKCR = 0;
  while(MarkNEQ(m,end) && !eof) {
      ch = *m.cp++;
      eof = Advance(&m);		/* take care of chunk-crossings */
      prevcol = col;
      col = ShowChar(ch,col); 	/* display, update col */
      if (col <= 0) {
	  PadPosition(pad,row,prevcol);
	  for ( ; prevcol < Ncols; prevcol++) PadSend(pad,' ');
	  row++;
	  if (row >= Nrows) break;
	  if (col < 0) {	/* overrun */
		Retract(&m);
		col = 0;
		}
	  PadReturn(pad);	/* NOT clearing to end of line */
	  PadNewLine(pad);
	  }
      }
  if (!eof) {
    ch = *m.cp;
    prevcol = col;
    col = CountWidth(ch,col);
    if (col < 0) {
	for (; prevcol < Ncols; prevcol++) PadSend(pad,' ');
	}
    }
  OKCR = 1;
  }


/********************  Interaction window routines  *******************/

/* Msg: write to the interaction window */
Msg(s)  register char *s;
{ register char ch;
  while ( (ch = *s++) != '\0')  putchar(ch);
  Flush(stdout);
  }

/* NewMsg: write to the interaction window on a new line */
NewMsg(s)  register char *s;
{ register char ch;
  putchar('\n');
  while ( (ch = *s++) != '\0')  putchar(ch);
  Flush(stdout);
  }

/* Getline: get input in the interaction window, terminated by CR.
   Buffer must be at least max long; at most (max-1) data characters will
   be stored in it, zero-terminated.  The number of data characters read
   is returned. */

int Getline(buf,max)  char *buf;  int max;
{ register char ch;
  int i;

  SelectPad(stdout);
  incommandwindow = 1;
  for (i = 0; i < max - 1; i++) {
    ch = getchar();
    if (ch == '\r' || ch == ESC)  break;
    else if (ch == '\007')  return(-1);
    else if (ch == '\b' || ch == DEL) {
	if (i > 0) {
	    i -= 2;  printf("\b \b");
	    ch = buf[i+1];
	    if (ch < ' ' && ch != '\n') printf("\b \b");
	    }
	}
    else if (ch == '\n') {
	buf[i] = ch;
	PadInverse(stdout);
	putchar('\\');
	PadNormal(stdout);
	}
    else  {
	buf[i] = ch;
	if (ch < ' ') {putchar('^');  putchar(ch + '@');}
	else  putchar(ch);}
    Flush(stdout);
    }
  Flush(stdout);
  buf[i] = '\0';
  return(i);
  }
  

/**************  Routines for ansi standard terminal interface  **************/
static char escsequence[20];

PadEscSequence(p,string)  File *p;  register char *string;
{
  PadSend(p,'\033');	/* escape */
  while (*string != '\0')  PadSend(p,*string++);
  }

PadCRLF(p)  File *p;
{ 
  PadClearToEOL(p);
  PadReturn(p);
  PadNewLine(p);
  }

PadPutCursor(p,row,col)  File *p;  int row,col;
{
  sprintf(escsequence,"[%d;%df",row+1,col+1);
  PadEscSequence(p,escsequence);
  }

PadScrollUp(p, top, bottom)  File *p;  int top, bottom;
{
  sprintf(escsequence,"[%d;%dr",top+1,bottom+1);
  PadEscSequence(p,escsequence);
  PadEscSequence(p,"D");
  }

PadScrollDown(p, top, bottom)  File *p;  int top, bottom;
{
  sprintf(escsequence,"[%d;%dr",top+1,bottom+1);
  PadEscSequence(p,escsequence);
  PadEscSequence(p,"M");
  }
