@make(report)
@device(dover)
@style(references stdnumeric)
@use(bibliography "/ng/lantz/scribe.bib")
@begin(titlepage)
@begin(titlebox)
@majorheading[
DRAW:
A Draw program for the SUN Workstation
Internals and Implementation Guide
]
@end(titlebox)
@heading[
David Kaelbling
@value(date)
]
@end(titlepage)

@section[Introduction]

This manual describes some of the design decisions and internal workings of
the SUN Draw program.  This manual is not meant to explain how to use the
program -- for that examine the User's Manual.

In very broad terms, this program runs in two major parts:  the front end
User Interface (the draw program itself) resides on either the SUN or a
remote host communicating with the SUN, and the VGTS@cite(Vservers) which
runs on the SUN.  The VGTS runs in a separate address space, and is
responsible for displaying objects on the screen.  It handles all of the
window management, mouse tracking, screen updating, etc., functions.  All
the User Interface does is feed it the proper commands.

The draw program is entirely my own work.  The primitives of the VGTS were
extended to include spline drawing, filling of closed objects, line drawing
with multiple nibs, and in short just about everything that relates to the
actual figures which appear in the window on the screen.  Bill Nowicki, Per
Bothner, and Jim Boyce all assisted me in some way or another with this.


@section[Spline definitions within the VGTS]

In order to define a spline for the VGTS to display, a block of information
must be allocated and passed to the VGTS.  All of the normal VGTS primitives
work with splines, and are documented in the V Servers Manual@cite(VServers)
and V Commands Manual@cite(VCommands).  The block of information describing
a spline is passed via the 'string' parameter in all of the VGTS primitive
calls.  The format of this block is described in the file
@b[/usr/sun/include/splines.h], and in the appendix of this manual.
Splines are of type @w[@t[SDF@ux[@ ]SPLINE]] to the VGTS.  The block of
storage is of type @t[SPLINE] to C.  The fields within the spline definition
block are as follows:

@Begin(description)
unsigned short @b[order];@\
This defines the order of interpolation to be used by the spline generation
routines.  Currently orders 1 through 5 are supported.  Order 1 splines
consist solely of the control points themselves, order 2 splines are
polygons, order 3 splines use quadratic interpolation, etc.

unsigned short @b[numvert];@\
The number of vertices (data points) given in the block of storage begun by
the @c[head] field, described below.  Negative numbers are not allowed, and
similarly a spline with 0 control points is meaningless.  1 point will
produce just that -- a single point.

enum Nib @b[nib];@\
This field contains the identifier for the nib to be used when drawing the
border of the spline.  The various possible values for this field are
defined in @b[splines.h], and consist of four shapes (square, circular,
horizontal bar, and vertical dash) in four sizes each.  Size 0 nibs are a
single point, and size 3 nibs are up to 7 pixels in the longest direction.

unsigned short @b[border];@\
A boolean used to control whether or not the border of the splines is drawn.
In order to be visible, a spline must either have a border, be filled, or
both.

unsigned short @b[closed];@\
This boolean specifies that the spline should use closed end conditions.
Only closed splines can be filled.  There is no need to duplicate the first
few control points of a spline in the last positions for closed splines.  The
program does this automatically.

unsigned short @b[filled];@\
When true, this boolean indicates that the VGTS should attempt to fill the
object in question.  Note that only closed splines with more than one
control point and order higher than one can be filled.

unsigned short @b[opaque];@\
Meaningful only for filled splines, this boolean controls whether or not the
fill pattern obscures what it covers, or permits it to show through.  More
specifically, if this is true @b[GXcopyPattern] will be used to paint the
fill pattern, otherwise @b[GXandPattern] will be used.

enum Pattern @b[pat];@\
This, too, is meaningful only for filled splines.  It specifies the fill
pattern (as defined in @b[splines.h]) to be used when filling the the
object.

POINT @b[head];@\
@begin(multiple)
Storage for a single point (a pair of shorts labelled x and y) is allocated
here.  If more than one control point is to be used, the others must lie
contiguously in storage immediately after this head cell.

The control points given here are relative to the Xmin and Ymin fields
specified when calling @t[AddItem()] and @t[ChangeItem()].  The VGTS will
compute the approximate bounding box of the spline, and convert these
points to absolute coordinates within the World Coordinate System.  This is
done so that spline objects within symbol calls will relocate properly.
Calls to @t[InquireItem()] will return the true bounding box of a spline.
@end(multiple)
@End(description)


@section[VGTS Spline Module Structure]

The individual modules used to generate splines within the VGTS are
organized in a directed acyclic graph.  At the root is the routine
@t[DisplaySpline()], which is the primary contact point between the VGTS and
the spline routines.  @t[DisplaySpline()] will, based upon the various
parameters described above, call one of the following routines:
@Begin(itemize)
@t[XYbrush()] to place individual points on the screen.  This is done when
the spline is of order 1.

@t[XYfillPolygon()] if the spline is filled and of order 2.

@t[XYpolygon()] if the border of an order 2 spline is to be drawn.
Occasionally, @t[XYspline()] may be called instead.  The reasons for this
are given below.

@t[XYfillSpline()] for filled splines of order 3 or higher.

@t[XYspline] for splines of order 3 or higher whose border needs to be drawn.
@End(itemize)

Both @t[XYfillPolygon()] and @t[XYfillSpline()] call the routines
@t[XYfillInit()], @t[XYfillLine()], and @t[XYfillScreen()].  These routines
do the actual filling of the object.  @t[XYfillScreen()] will call
@t[XYpattern()] to paint a segment of fill pattern on the screen.
The line drawing routine @t[XYputLine()] will pass the coordinates of each
point along a line to a specified routine.  To draw a line with a given nib
on the screen, this routine will be @t[XYbrush()].  To fill an object, this
will be @t[fillpoint()].

All splines are actually just polygons with a large number of sides.  In
order to make the spline generation routines run faster, they use a static
table of blending function weights rather than compute the proper blending
function each time.  The weights are stored as 16 bit fractions (that is,
they started as floating point numbers, were multiplied by 2@+[16], and then
converted to integers).  As little true floating point arithmetic as
possible is done@foot[Since the screen resolution of the SUNs is at most
1024 by 1024 (10 bits), the loss of accuracty caused by this form of
representation should not be noticeable.  The difference in speed is quite
noticeable.].  These weights were computed by the program @t[splinegen.c], and
assume closed end conditions.  To simulate open end conditions, the program
constructs a knot vector which duplicates the end control points of the
spline as often as necessary.

Splines can be generated with up to 64 (actually 1 << @t[XYsplineRes])
subintervals per group of control points.  At normal magnification this is
far more exact than necessary.  Accordingly, as the view is zoomed in and
out, the actual number of subintervals computed varies.  The equations
are tuned to a normal spline displayed entirely on the screen with no
magnification.

Lines are typically drawn by placing the nib down at each point along the
line.  However, when the line segment lies entirely on the screen, it is
often faster to use the standard Bresenham algorithm available on the SUNs
to draw a number of lines connecting points in the nibs placed at the
endpoints of the segment.  The routine @t[XYline()] computes the cost of
using these two methods, and decides on which one to use.  The faster
connect-the-dots style line drawing is only used when line segments lie
entirely in the visible portion of the view because of skew problems.  When
long parallel lines are clipped, some of them skew slightly, and what should
be a solid, thick band ends up having ugly white dots strewn at regular
intervals through it.

Because of this limitation, when @t[DisplaySpline()] is deciding how to draw
the border of a polygon, it will examine the current view zoom factor.  If
the view is zoomed in, then portions of the polygon will probably lie off
the screen, and the slower place-the-nib-everywhere algorithm will have to
be used.  To make the drawing go faster, it then declares the polygon to be
a spline of order 2, and has @t[XYspline()] break it up into the proper
number of subintervals.  Many of these subintervals will lie entirely within
the screen, and drawing will run much faster.  In addition, line segments
which line entirely outside the visible drawing area can be rapidly
discarded.


@section[The Fill Algorithm]

The fill algorithm used is a variation on the (YX) edge parity algorithm
presented in Newman and Sproull@cite(NewmanSproull1979).  The basic idea of
the algorithm is to count the parity of edge crossings on each scan line.
If an odd number of transitions have occurred up to a given point, then that
point is inside the figure.  The major stumbling points for the standard
algorithm are the treatment of singularities and nearly horizontal lines.
Singularities are a problem in that they must count as an even number of
transitions, whereas a normal edge vertex should count as an odd number.
Nearly horizontal lines are a problem because most line drawing algorithms
will place several pixels on a single scan line.  The fill algorithm
requires an odd number (usually one).

The solution to the multiple pixels per scan line problem is relatively
straightforward.  A degenerate finite state automaton is used as a peephole
optimizer to eliminate them.  Horizontal lines are discarded entirely.

The solution chosen for the singularity problem is one which I have not seen
in any of the reference texts I have read@cite(FoleyvanDam1982,
NewmanSproull1979) (this doesn't mean it is new to the world -- just that it
was new to me).  I chose to do a simple comparison on the endpoints of a
line, and always draw it from the top down, leaving off the top endpoint.
By this method, edge connections where the sign of the slope of adjacent
line segments does not change are treated properly:  the connection point is
only considered to be part of one of the two segments.  Singularities where
the sign of the slope changes from positive to negative have the topmost
points left off of both lines, and thus work correctly.  Singularities of
the other form have both segments generate points on the bottom scan line,
and thus work correctly.

As points are generated, they are stored for later recall.  They data
structure used here is an array with one entry per scan line in the visible
area.  Each entry is the head of a singly linked list of cells containing
the transitions on that scan line, sorted by @i[x].  New points are inserted
in sorted order.  When all of the transitions have been generated, pairs of
points are pulled out of each list, and each pair represents an area within
the object.  This data structure works well since the sort on @i[y] can be
done in constant time (an array lookup), and the sort on @i[x] is
satisfactory (insertion sort works fine, since we expect only a small number
of transitions per scan line).

In the interests of efficiency, a fair amount of effort is spent clipping
line segments before they are used to generate transitions.  Portions which
lie above, below, or to the right of the viewing area are discarded
entirely.  Since portions to the left of the viewing area are not actually
displayed, it suffices to keep for them a count of the number of transitions
per scan line.  The actual points where the transitions occur are never
computed.


@section[User Interface module organization]

The User Interface is organized in a relatively conventional way.  The
central routine is a large case statement, which gets a command and invokes a
specific routine to deal with it.  Command input is done by the
@t[GetInput()] routine, which will get a mouse click from the VGTS and
convert it into a command.  Conversion to a specific command is done by
using the VGTS @t[FindMousedObject()] primitive to discover which of the
commands in the Menu the user pointed at.  Mouse clicks in the drawing area
are dealt with by the User Interface, which will (if appropriate) scan the
list of displayed objects and locate a nearby sticky point to move the mouse
location to.  Sticky points are located by the @t[FindObject()] routine.

The various specific command routines serve as a second level of user
interface.  They will typically use the @t[SelectObject()] routine to
have the user select an object and enter a number of data points.  They
will then verify the user's intent and pass the information on to a
primitive routine which will actually update the internal data structures.
These primitives (and their support routines) are the ones which do all of
the actual work inside the front end.  They will communicate to the VGTS,
updating its data structures as well.


@section[User Interface Data Structures]

Considerable effort was spent selecting appropriate data structures for the
User Interface.  The primary requirements for the display list data
structure were good insertion, deletion, and sequential scanning
properties.@foot(Sequential scanning is required by the @t[FindObject()]
routine which converts a point in space to an object near there.  The program
never attempts to locate objects in any other way:  it calls one of these
routines, which must perforce scan all objects, and then uses the pointer
that is returned.) Doubly linked lists provide all of these.  To facilitate
the @b[Undo] command, and to make certain commands (like @b[Move] and
@b[Copy]) more efficient, I decided to maintain a central object list which
contained the detailed descriptions of all of the objects which could still
be referenced, either through the current display list or through one of the
backup display lists.  Since the primary requirements of this data structure
were reasonable insertion and deletion properties, I once again chose a
doubly linked list.  Garbage collection within this list is done by
reference counts, since it is impossible to create circularly dependent
lists of items, and since the counts can be maintained easily.

The result of this is that the central objects list is pointed to by
@t[itemlist], and consists of a linked list of @t[ITEM@ux[@ ]DESCRIPTOR]s.
@t[itemlist] points to the last element of the list.
The current display list is headed by @t[activelist], and is a doubly linked
list of blocks which consist of a pointer into the @t[itemlist], an offset,
and the links.  The offset field is useful for moving objects and for
creating groups of objects.  In this way, moving an object does not make it
appear to be an entirely new object, as it still uses the same item
descriptor block, but with a new offset.


@section[Future Extensions]

There are a number of features which are missing from the current
implementation of this program which would be useful to have.  Some of them
are:
@Begin(itemize)
@begin(multiple)
The command structure of the program could be better.  Many people seem
confused about the distinction between @b[Done] and @b[Almost Done].  What
people seem to want is to have the two merged, so that the program is always
executing some command, and you simply choose a new command to switch
between them.

This will require more changes than just putting everything into a loop --
in particular, some of the miscellaneous commands expect only to work at the
top level (like @b[Clear Screen], which could leave dangling pointers around
if executed in the middle of a partially parsed command), and others (like
@b[Debug]) should be valid all of the time.
@end(multiple)

Confirmation is not uniform.  Creating a @c[template] does not require
confirmation, but other things do.  These inconsistencies should be removed.

@begin(multiple)
A way to accept both text and mouse input is necessary, so that people can
abort out of @t[GetString()].  The VGTS @t[GetEvent()] call isn't quite good
enough, since it doesn't return the VGT where a click occurred, making it
impossible to distinguish between menu commands, data points, and stray
clicks.  Maybe have @t[GetString()] abort if it recieves @u[any] mouse
click?  Or perhaps assume any mouse click it gets is in the Menu, and only
deal with a subset of the commands.

Fixing this would have the benefit of getting rid of the synchronization
errors problem.
@end(multiple)

@begin(multiple)
Writing Press Files.  Currently, the only way to get output is to create
press files from bitmaps of the screen as the program is running.  This is
not satisfactory.  To get such a press file, the following things must be
done.
@Begin(enumerate)
Move the drawing area viewport so that its bottom left corner is in the
bottom left corner of the physical screen.

Create a new executive, and within it run the @b[bits] program@foot(The
command @b[help bits] works at the exec level.).  @b[bits] will create a
window in the upper left hand corner of the screen.  Move the windows on the
screen around so that the drawing area is completely unobscured.

Use the right mouse key inside the @b[bits] window to give the command
@b[Lookup named raster], @b[The screen].

Give the command @b[Save a fresh copy] to @b[bits].  This will cause
@b[bits] to copy the current screen contents into its work area.

Stretch the edges of the @b[bits] window so that the top and right edges of
the image of the screen are visible.

By holding down the middle key on the mouse, move both of these edges inward
to trim the image to just the drawing area.  This process is slow -- move
the mouse slowly, and give @b[bits] plenty of time to update the screen.

Give the command @b[Invert] to bits.

Have @b[bits] do @b[Write raster] to dump the trimmed, inverted bitmap out
to a file.  (This file will be in @t[.sun] format).

@b[Quit] out of @b[bits].

Run the @b[bitpress] program.  Currently, this program is not installed, but
is available in my directory on Diablo under @t[/ng/drk/draw/bitpress].  The
proper incantation to produce a press file (rather than just sending output
straight to the dover) is @t[bitpress -p file.press file.sun].
@End(enumerate)

If you have any trouble with this process, try finding Per Bothner.  Both
the @b[bits] and @b[bitpress] programs are his work.

Resolution is poor (about the same as the old Alto Draw program produced),
and the mechanism is cumbersome.  If you try to print large bitmaps with
lots of black on the dover, the dover will run out of memory and die a
horrible death.  The only way to discover if your bitmap is too large is to
try it and see.
@end(multiple)

Read Alto Draw files.  I spent a lot of time just trying to find out what
the Alto Draw file format is -- my results are in the file
@t[/ng/drk/draw/file.format] on Diablo.  See the appendix.

@b[Alter] is unimplemented.  This @u[really] should be fixed.  It should be
possible to change any of the paramenters of a spline (closed, filled,
border, nib, pat, @u[numvert], etc.).  In addition to adding and deleting
control points, moving them should be provided too.  Altering a group should
consist of adding items, deleting items, and unbundling a specific copy.
Altering text is also straightforward -- change font (repositioning),
positioning, or entire string.  Changing individual letters is probably not
worthwhile.

Freehand drawing would be nice to have.  Probably the best way to implement
it would be to query the mouse position as quickly as possible, filter out
multiple points, and as long as a button is down, create a spline.  Using
the right (grid) button will work fine for constrained drawing, and using
the left button will work fine for freehand drawing.  Freehand drawing
between sticky points probably isn't much good.

Rather than trying to maintain a complete list of all of the existing
fonts, it would be better to let the user type in a font name for 'special'
fonts.

It would be nice if text were echoed in the proper font, rather than just
the standard one.  Unfortunately, this can't be done in the exec pad.
Another graphics view and VGT would have to be created just for this
purpose.  Trying to update the screen for each character typed (i.e., using
the main drawing area instead of a special echo area) would be too slow.

Rubberbanding and dragging would both be very nice features to have.
Unfortunately, the VGTS does not supply them, and redrawing splines is slow
enough that it is impractical to simulate it.  If the VGTS ever gets
extended, some of the obvious places for this form of feedback are in
@b[copy] and @b[move], as well as in @b[draw] (both for @c[templates] and
for control points of splines).
@End(itemize)


@newpage
@Section[Appendix I:  Spline Data Structure]

This is a listing of the file @b[/usr/sun/include/splines.h].
@begin(verbatim)
@include(/usr/sun/include/splines.h)
@end(verbatim)

@newpage
@section[Appendix II:  Alto Draw file format]

This is a copy of the file @b[/ng/drk/draw/file.format].
@begin(verbatim)
@include(/ng/drk/draw/file.format)
@end(verbatim)
