/*
 * silly.c - edit .sil files on the VGTS
 * Bill Nowicki Januray 1983
 *
 * Wishlist:
 *	- Press file generation
 *	- Alternate font selection
 *	- Undelete
 *	- Handle Macros. Does anybody really use these?
 */

# include "silly.h"

# include <Vgts.h>
# include <text.h>

# ifdef VAX
# define File FILE
# include <stdio.h>
# else VAX
# include <Vio.h>
# endif VAX

/*
 * definitions for .sil files
 */

char FontMap[] =  
  {
  	/*
	 * Map SIL internal font numbers into VGTS numbers.
	 * Note I only use the first 8, and add 8 if italic.
	 */
    Helvetica10,
    Helvetica10B,
    Helvetica7,
    Helvetica7B,
    Template64,
    Template64,
    Template64,
    Template64,
    Helvetica10I,
    Helvetica10BI,
    Helvetica7I,
    Helvetica7BI,
    Template64,
    Template64,
    Template64,
    Template64
  };

struct Object Table[MaxObjects];	/* table of all objects */
struct Object *SelectList = NULL;	/* list of selected objects */

short CurrentObject = 0;	/* where to start looking for empty objects */
short Debug = 0;		/* extra debugging information */
short Changed = 0;		/* If we made changes since last save */
short MarkX = 0, MarkY = 0;	/* coordinates of the mark */
short Width = 1;		/* width of lines */
short CurrentFont = 0;		/* internal font number for new text */
short sdf, vgt;			/* the sdf and vgt we use */

Quit()
  {
    /*
     * gracefully exit.  Not too much work on Unix.
     */
     DeleteVGT(vgt,1);
     if (Debug) printf("Deleted vgt\r\n");
     DeleteSDF(sdf);
     if (Debug) printf("Deleted sdf\r\n");
     ResetTTY();
     exit();
  }

GetByte(f)
    File *f;
  {
  	/*
	 * get a byte from the file
	 */
    return(getc(f) & 255 );
  }

GetShort(f)
    File *f;
  {
  	/*
	 * get a short (16-bit) word from the file
	 * in big-endian order
	 */
    int temp = getc(f) << 8;
    return( (temp | getc(f)) & 0xFFFF );
  }


PrettyPut(c)
 char c;
  {
    /*
     * put a character, but make darn sure it is printable!
     */
     if (c<' ' || c > '~' )
       printf("<0%o>", c & 255);
     else
       putchar(c);
  }

PutByte(c,f)
    File *f;
    char c;
  {
    /*
     * write a byte to a file
     */
    putc( (c&255),f);
  }

PutShort(n,f)
    File *f;
    short n;
  {
    /*
     * write a short to a file, in big endian order
     */
    putc( (n>>8)&255, f); 
    putc( (n & 255), f);
  }

main(argc, argv)
 char **argv;
 {

    int i,vecs,start,end;
    short item;
    File *f;
    char fileName[256];
    char vgtName[256];

    if (argc>1 && argv[1][0]=='-')
      {
        char *p = argv[1]+1;
	argc--; argv++;
	while (*p)
	  {
	    switch (*p)
	      {
	        case 'd': Debug=1; break;
		default: 
		  printf("Unknown option: %c\n", *p);
	      }
	    p++;
	  }
      }
      
     if ( argc > 1 ) f=fopen( argv[1], "r" );
     else 
      {
        printf("usage: silly [-d] file\r\n");
	exit();
      }
     strcpy(fileName,argv[1]);
     if (f==NULL)
         {
           printf( "Cannot open %s\r\n", argv[1] );
         }
     strcpy(vgtName,"Silly ");
     strcat(vgtName,fileName);

# ifdef VAX
     printf("Remote SIL format editor for VGTS\r\n");
# else VAX
     printf("SIL format editor for VGTS\r\n");
# endif VAX

     GetTTY();
     sdf = CreateSDF();
     DefineSymbol(sdf,MarkSymbol,"mark");
     AddItem(sdf,0,-5,5,5,-5,0,SDF_GENERAL_LINE,NULL);
     AddItem(sdf,0,5,-5,5,-5,0,SDF_GENERAL_LINE,NULL);
     EndSymbol(sdf,MarkSymbol,0);
     DefineSymbol( sdf, TopSymbol, fileName );
     AddCall(sdf,MarkItem,0,0,MarkSymbol);
     vgt = CreateVGT(sdf, GRAPHICS+ZOOMABLE, TopSymbol, vgtName );
     DefaultView(vgt, 0, 0, 0, 200, 0, 0, 0, 0);
     if (Debug) printf("sdf=%d, vgt=%d\r\n", sdf, vgt);
     EndSymbol( sdf, TopSymbol, vgt );
     DefineSilFonts();

     ParseFile(f);
     printf("Use mouse buttons: Mark, Select, Menu\r\n");
     while (1) MainLoop(f,fileName);
  }

DefineSilFonts()
  {
  	/*
	 * Tell the VGTS which fonts we want to use
	 */
    printf("Defining fonts:");
    DefineFont("Helvetica10",NULL); 	putchar('.'); fflush(stdout);
    DefineFont("Helvetica10B",NULL);	putchar('.'); fflush(stdout);
    DefineFont("Helvetica7",NULL); 	putchar('.'); fflush(stdout);
    DefineFont("Helvetica7B",NULL); 	putchar('.'); fflush(stdout);
    DefineFont("Helvetica7I",NULL); 	putchar('.'); fflush(stdout);
    DefineFont("Helvetica7BI",NULL); 	putchar('.'); fflush(stdout);
    DefineFont("Template64",NULL); 	putchar('.'); fflush(stdout);
    printf(" Done loading fonts\r\n");
  }

ParseFile(f)
    File *f;
  {
	/*
	 * read the .sil file into internal data structures,
	 * and draw the initial screen.
	 */
     short password;
     short link, xmin, ymin, xmax, ymax, length, font, ital;
     short newymin, newymax;
     long start, end, objs;
     register struct Object *ob = Table;
  
    SelectList = NULL;
    for (objs=0;objs<FirstItem;objs++, ob++)
      {
        ob->state = Special;
      }
     CurrentObject = objs + 1;
     while (ob<Table+MaxObjects) 
       {
         ob->state = Empty;
	 ob++;
       }
    if (f==NULL) return;

    ob = Table+FirstItem;
    EditSymbol(sdf,TopSymbol);
    password = GetShort(f);
    if (password!=Password)
      {
        printf("WARNING: does not look like a SIL file, Password=0%o\r\n",password);
      }

    time(&start);
    while (feof(f)==0 ) 
      {
	link = GetShort(f);
	if (feof(f)) break;
	if (link != -1)
    	    if (Debug) printf("Link=0%o", link);
	xmin = GetShort(f) & CoordMask;
	ymin = GetShort(f) & CoordMask;
	xmax = GetShort(f) & CoordMask;
	ymax = GetShort(f);
	font = GetFont(ymax);
	ital = ymax & (CoordMask+1);
	ymax &= CoordMask;
	if (Debug) 
	    printf(" Object xmin=%d, ymin=%d, xmax=%d, ymax=%d ", 
		xmin,ymin,xmax,ymax);
	  /*
	   * Alto numbers from top down, VGTS bottom up.
	   * Also, VGTS includes borders, while SIL does not.
	   * Therefore we must fudge.
	   */
	newymin = YOffset - ymax + 1;
	newymax = YOffset - ymin;
	xmax--;
	ob->state = Used;
	ob->selected = 0;
	ob->number = objs;
	ob->xmin = xmin;
	ob->ymin = newymin;
	ob->xmax = xmax;
	ob->ymax = newymax;
        ob->fontNumber = font;
	if (font==LineFont)
	  {
	    ob->kind = Line;
            AddItem( sdf, objs++, xmin, xmax, newymin, newymax, BLACK,
	    	SDF_FILLED_RECTANGLE, NULL);
	    if (Debug) printf("Line\r\n");
	  }
	else
	  {
	    int odd;
	    char *string;
	    register char *p;
	    
	    length = GetByte(f);
	    if (length==0)
	      {
	        GetByte(f);
		if (Debug) printf("Zero length string\r\n");
	        continue;
	      }
	    odd = length &1;
	    string = (char *) malloc(length+1);
	    if (length>200)
	      {
	        printf("Strange string length, %d\r\n", length);
		Quit();
	      }
	    if (string==NULL)
	      {
	        printf("Ran out of memory\r\n");
		Quit();
	      }
	    if (Debug) printf("\r\n   String length %d:",length);
	    for (p=string;length-->0 && !feof(f);p++)
	      {
	        *p = GetByte(f);
	        if (Debug) PrettyPut(*p);
	      }
	    *p++ = 0;
	    if (!odd) GetByte(f);
	    if (Debug) printf("   in Font %d\r\n",font);
	    ob->kind = Text;
	    ob->string = string;
	    font = FontMap[ (font&7) + (ital ? 8 : 0) ];
	    if (font==Template64) 
	        {
		  newymin = newymax;
		}
            AddItem( sdf, objs++, xmin, xmax, newymin, newymax, font, 
	    	SDF_TEXT, string);
	  }
	ob++;
       }
     EndSymbol( sdf, TopSymbol, vgt );
     time(&end);
     if (start==end) end++;
     printf("%d objects in %d seconds, or %d objects/second\r\n",
     	objs, end-start, objs/(end-start));
     CurrentObject = objs + 1;
     while (ob<Table+MaxObjects) 
       {
         ob->state = Empty;
	 ob++;
       }
  }


PutSilFile(f)
  {
  	/*
	 * write the data structure to the indicated SIL file
	 */
    register struct Object *ob = Table+FirstItem;
    short silymin, silymax, length;

    PutShort(Password,f);
    for (;ob<Table+MaxObjects;ob++)
     if (ob->state==Used)
      {
        silymin = YOffset - ob->ymax;
        silymax = YOffset - ob->ymin + 1;
	if (Debug) 
	  printf("%s object %d xmin=%d, ymin=%d\r\n",
	    ob->kind==Text ? "Text" : "Line", ob->number, 
	    ob->xmin, ob->ymin );
	if (ob->kind==Text && 
	  (ob->string==NULL || strlen(ob->string)==0)) 
	    {
	      if (Debug) printf("%s string\r\n",
	        ob->string ? "Empty" : "NULL" );
	      continue;
	    }
        PutShort(-1,f);
	PutShort(ob->xmin,f);
	PutShort(silymin,f);
	PutShort(ob->xmax+1,f);
	PutShort( (ob->fontNumber<<12) | silymax, f);
	if (ob->kind==Text)
	  {
	    register char *p = ob->string;
	    
	    if (Debug) printf("Put string %s\r\n", p);
	    length = strlen(p);
	    PutByte(length,f);
	    for (;*p;p++) PutByte(*p,f);
	    if ( (length&1)==0) PutByte(0,f);
	  }
      }
  }

static PopUpEntry mainPopup[] = 
  {
    "Quit", 		CommandQuit,
    "Debug", 		CommandDebug,
    "Line Width",	CommandWidth,
    "Draw Line",	CommandDraw,
    "Add Text",		CommandText,
    "Default Font",	CommandFont,
    "Change Font",	CommandChange,
    "Write", 		CommandWrite,
    "Delete",		CommandDelete,
# ifndef VAX
    "Stretch Line",	CommandStretch,
    "Move",		CommandMove,
    "Copy",		CommandCopy,
    "Box",		CommandBox,
# endif VAX
    0, 0
  };

MainLoop(f,name)
  File *f;
  char *name;
  {
    	/*
	 * main command loop 
	 */
    short x, y, buttons;
    
    GetMouseClick(&x,&y,&buttons);
    switch (buttons)
      {
        case LeftButton:		DoMark(x,y);	break;
	case MiddleButton:		DoSelect(x,y,1);break;
	case LeftButton+MiddleButton:	DoLine(x,y);	break;
	case MiddleButton+RightButton:	DoSelect(x,y,0);break;
	case RightButton:
		switch (popup(mainPopup))
		  {
		    case CommandQuit:	Quit();
		    case CommandDelete:	DoDelete();	break;
		    case CommandWrite:	DoWrite(f,name);break;
		    case CommandDraw:	DoDraw();	break;
		    case CommandText:	DoText();	break;
		    case CommandFont:	DoFont();	break;
		    case CommandChange:	DoChange();	break;
		    case CommandWidth:	DoWidth();	break;
# ifndef VAX
		    case CommandMove:	DoMove(0);	break;
		    case CommandCopy:	DoMove(1);	break;
		    case CommandBox:	DoBox();	break;
		    case CommandStretch:DoStretch();	break;
# endif VAX
		    case CommandDebug:
		    		if (Debug) 
				  {
				    printf("Debug mode OFF\r\n");
				    Debug = 0;
				  }
				else
				  {
				    printf("Debug mode ON\r\n");
				    Debug = 1;
				  }
				break;
		  }
		break;
	default:		printf("Strange button combination: %d\r\n", buttons);
      }
  }

struct Object *GetFreeObject()
  {
  	/*
	 * return a free object desriptor.
	 * Search the object table from the last point we found one,
	 * and wrap around the end.
	 */
    register struct Object *ob = Table + CurrentObject;
    short num = CurrentObject;
    
    while (1)
      {
        if (ob->state==Empty) 
	  {
	      ob->number=num;
	      CurrentObject=num+1;
	      ob->state=Used;
    	      return(ob);
	  }
	if (++num >= MaxObjects)
	  {
	    num = FirstItem;
	    ob = Table + num;
	  }
	 else ob++;
	if (CurrentObject==num) return(NULL);
      }
  }


DoText()
  {
  	/*
	 * Add some text
	 */
    register struct Object *ob;
    char string[256];
    int length;
    
    printf("Enter some text: ");
    ResetTTY();
    gets(string);
    GetTTY();
    length = strlen(string);
    if (length==0)
      {
        printf("You did not type anything.\r\n");
	return;
      }

    ob = GetFreeObject();
    if (ob==NULL)
      {
        printf("Too many objects already\r\n");
	return;
      }
    ob->kind = Text;
    ob->string = (char *)malloc(length+1);
    strcpy(ob->string,string);
    ob->fontNumber=CurrentFont;
    ob->xmin = MarkX;
    ob->xmax = MarkX+length*8;
    ob->ymin = MarkY;
    ob->ymax = MarkY+16;
    EditSymbol(sdf,TopSymbol);
    if (FontMap[ ob->fontNumber ]==Template64) 
      {
        AddItem( sdf, ob->number, ob->xmin, ob->xmax, ob->ymax, 0,
	    FontMap[ ob->fontNumber ], SDF_TEXT, string);
      }
    else
      {
        AddItem( sdf, ob->number, ob->xmin, ob->xmax, ob->ymin, ob->ymax,
	    FontMap[ ob->fontNumber ], SDF_TEXT, string);
      }
    EndSymbol(sdf,TopSymbol,vgt);
  }


static PopUpEntry fontMenu[] = 
      {
        "Helvetica 10", 	0,
	"Helvetica 10 Bold",	1,
	"Helvetica 7",		2,
	"Helvetica 7 Bold",	3,
	"Helvetica 7 Italic",	10,
	"Template 64",		4,
	0, 0
      };


DoFont()
  {
  	/*
	 * Select a new default font for new text.
	 * some day, of course, we want to allow this to be
	 * user-defined.
	 */
    short newFont;
    
    printf("New default font M: ");
    newFont = popup(fontMenu);
    if (newFont<0)
      {
        printf("not changed\r\n");
	return;
      }
    printf("new font is %s\r\n", fontMenu[newFont].string);
    CurrentFont = newFont;
  }

char *Sel(s)
  char *s;
  {
  	/*
	 * Returns a pointer to a string with the Inverse video
	 * bit on the front of it.
	 */
    static char buf[256];
    buf[0] = BegInverse;
    strcpy(buf+1,s);
    return(buf);
  }

DoChange()
  {
  	/*
	 * Change the font of text already displayed
	 */
    short newFont;
    register struct Object *ob = SelectList;

    if (ob==NULL)
      {
        printf("You have to select some text first\r\n");
	return;
      }
    printf("Select a font to impose M: ");
    newFont = popup(fontMenu);
    if (newFont<0)
      {
        printf("not changed\r\n");
	return;
      }
    EditSymbol(sdf,TopSymbol);
    for (;ob;ob = ob->next)
      {
	switch (ob->kind)
	  {
	    case Text:
	        ob->fontNumber = newFont;
		ChangeItem( sdf, ob->number, ob->xmin, ob->xmax, 
		  FontMap[ ob->fontNumber ]==Template64 ? 
		  		ob->ymax : ob->ymin, 0,
#ifdef INVERT
		    FontMap[ ob->fontNumber ], SDF_TEXT, Sel(ob->string));
#else INVERT
		    FontMap[ ob->fontNumber ], SDF_TEXT, ob->string);
	        InquireItem(sdf,ob->number, &(ob->xmin), &(ob->xmax), 
	    	    NULL, &(ob->ymax), NULL, NULL, NULL);
	        ChangeItem(sdf,ob->number+SelectFlag,ob->xmin, ob->xmax, 
			ob->ymin - 4, ob->ymax, 
			HILIGHT, SDF_FILLED_RECTANGLE, NULL);
#endif INVERT
		break;
	  }
      }
    EndSymbol(sdf,TopSymbol,vgt);

    printf("font imposed is %s\r\n", fontMenu[newFont].string);
  }


static PopUpEntry widthMenu[] = 
      {
        "1 (thin)",	1,
	"2",		2,
	"3",		3,
	"4",		4,
	"5",		5,
	"6",		6,
	"7",		7,
	"8 (thick)",	8,
	0, 0
      };

DoWidth()
  {
  	/*
	 * Select a new default line width
	 */
    short newWidth;
    
    printf("New line width M: ");
    newWidth = popup(widthMenu);
    if (newWidth<0)
      {
        printf("not changed\r\n");
	return;
      }
    printf("new width is %d\r\n", newWidth);
    Width = newWidth;
  }


DoDraw()
  {
  	/*
	 * Draw a line
	 */
    short x, y, buttons;
    
    printf("Draw to point B: ");
    GetMouseClick(&x,&y,&buttons);
    DoLine(x,y);
    printf("\r\n");
  }

DoLine(x,y)
  short x,y;
  {
    register struct Object *ob;

    ob = GetFreeObject();
    if (ob==NULL)
      {
        printf("Too many objects already");
	return;
      }
    ob->kind=Line;
    ob->fontNumber=LineFont;
    if ( abs(MarkX-x) < abs(MarkY-y) )
      {
        /*
	 * Vertical "line"
	 */
	ob->ymin = min(MarkY,y);
	ob->ymax = max(MarkY,y);
	ob->xmin = MarkX;
	ob->xmax = MarkX+Width-1;
	x = MarkX;
      }
    else
      {
        /*
	 * Horizontal "line"
	 */
	ob->xmin = min(MarkX,x);
	ob->xmax = max(MarkX,x);
	ob->ymin = MarkY;
	ob->ymax = MarkY+Width-1;
	y = MarkY;
      }
    EditSymbol(sdf,TopSymbol);
    AddItem( sdf, ob->number, ob->xmin, ob->xmax, ob->ymin, ob->ymax, BLACK,
	    	SDF_FILLED_RECTANGLE, NULL);
    DeleteItem(sdf,MarkItem);
    AddCall(sdf,MarkItem,x,y,MarkSymbol);
    EndSymbol(sdf,TopSymbol,vgt);
    MarkX = x;
    MarkY = y;
  }

DoMark(x,y)
  {
  	/*
	 * position the marker
	 */
    printf("Mark at (%d, %d)\r\n", x, y);
    EditSymbol(sdf,TopSymbol);
    DeleteItem(sdf,MarkItem);
    AddCall(sdf,MarkItem,x,y,MarkSymbol);
    EndSymbol(sdf,TopSymbol,vgt);
    MarkX = x;
    MarkY = y;
  }

UnSelect(n)
  {
  	/*
	 * Remove the given object from the select list.
	 * If zero, remove the whole list.
	 */
    register struct Object *ob = SelectList;

    if (n)
      {
        printf("Not implemented yet\r\n");
	return;
      }

    EditSymbol(sdf,TopSymbol);
    for (;ob;ob = ob->next)
      {
        ob->selected = 0;
	switch (ob->kind)
	  {
	    case Text:
#ifdef INVERT
	        ChangeItem(sdf,ob->number,ob->xmin, ob->xmax, 
		  FontMap[ ob->fontNumber ]==Template64 ? 
		  		ob->ymax : ob->ymin, 0,
		    FontMap[ ob->fontNumber ], SDF_TEXT, ob->string);
#else INVERT
		DeleteItem(sdf,ob->number+SelectFlag);
#endif INVERT
		break;

	    case Line:
	    	ChangeItem(sdf,ob->number,ob->xmin, ob->xmax, ob->ymin, ob->ymax, 
			BLACK, SDF_FILLED_RECTANGLE, NULL);
		break;
	  }
      }
    EndSymbol(sdf,TopSymbol,vgt);
    SelectList = NULL;
  }


DoSelect(x,y,unFlag)
  {
  	/*
	 * Select something at the given point.
	 * "unFlag" means deselect everything else first.
	 */
	 
    LISTTYPE thing, FindSelectedObject();
    int num;
    register struct Object *ob;
    
    if (unFlag) UnSelect(0);
    thing = FindSelectedObject(sdf,x,y,vgt,All);
    if (thing.NumOfElements==0)
      {
        printf("Could not find anything near there\r\n");
	return;
      }
    num = thing.Header->item;
    if (num>MaxObjects) return;    
    ob = Table+num;
    switch (ob->kind)
      {
	case Line:
	    EditSymbol(sdf,TopSymbol);
	    ChangeItem(sdf,num,ob->xmin, ob->xmax, ob->ymin, ob->ymax, GRAY,
	    	SDF_FILLED_RECTANGLE, NULL);
	    EndSymbol(sdf,TopSymbol,vgt);

            if (ob->selected == 0)
	      {
    	        printf("Select line number %d\r\n", num);
	        ob->next = SelectList;
	        SelectList = ob;
		ob->selected = 1;
	      }
	    break;

	case Text:
	    EditSymbol(sdf,TopSymbol);
#ifdef INVERT
	    ChangeItem(sdf,num,ob->xmin, ob->xmax, ob->ymin, ob->ymax, 
		    FontMap[ ob->fontNumber ], SDF_TEXT, Sel(ob->string));
#else INVERT
	    InquireItem(sdf,num, &(ob->xmin), &(ob->xmax), 
	    	NULL, &(ob->ymax), NULL, NULL, NULL);
	    AddItem(sdf,num+SelectFlag,ob->xmin, ob->xmax, 
	    	ob->ymin - 4, ob->ymax, 
	    	HILIGHT, SDF_FILLED_RECTANGLE, NULL);
#endif INVERT
	    EndSymbol(sdf,TopSymbol,vgt);

            if (ob->selected == 0)
	      {
	        printf("Select text ``%s''\r\n", ob->string);
	        ob->next = SelectList;
	        SelectList = ob;
		ob->selected = 1;
	      }
	    break;
      }
  }

DoDelete()
  {
	/*
	 * Delete items that are selected
	 */
    register struct Object *ob = SelectList;
    int count = 0;

    if (ob==NULL)
      {
        printf("You have to select something first\r\n");
	return;
      }
    printf("Deleted ");
    EditSymbol(sdf,TopSymbol);
    for (;ob;ob=ob->next)
      {
        DeleteItem(sdf,ob->number);
	DeleteItem(sdf,ob->number+SelectFlag);
	ob->state = Deleted;
	count++;
      }
    EndSymbol(sdf,TopSymbol,vgt);
    printf("%d item%s\r\n", count, count==1 ? "" : "s");
    SelectList = NULL;
  }


DoWrite(f,name)
  File *f;
  char *name;
  {
  	/*
	 * Write the SIL file out
	 */
    extern File *freopen();
    
    f = freopen(name,"w",f);
    if (f==NULL)
      {
        printf("Unable to open %s for writing!\r\n", name);
	return;
      }
    printf("Writing file %s...",name);
    fflush(f);
    PutSilFile(f);
    fclose(f);
    printf("done.\r\n");
  }
