/*
 * datsun.c - display vector files on the VGTS
 * Bill Nowicki September 1982
 */

# include <Vgts.h>

# ifdef VAX
# include <stdio.h>
# define File FILE
# else VAX
# include <Vio.h>
# endif VAX

short sdf, vgt;

Quit()
  {
    /*
     * gracefully exit.  Not too much work on Unix.
     */
     DeleteVGT(vgt,1);
     printf("Deleted vgt\r\n");
     DeleteSDF(sdf);
     printf("Deleted sdf\r\n");
     ResetTTY();
     exit();
  }

main(argc, argv)
 char **argv;
 {

    float x,y;
    int	screenx, screeny, lastx, lasty, ipen;
    int i,vecs,start,end;
    short item;
    File *f;

     if ( argc > 1 ) f=fopen( argv[1], "r" );
     else 
      {
        printf("usage: datsun file\n");
	exit();
      }
     if (f==NULL)
         {
           printf( "Cannot open %s\n", argv[1] );
	   exit(1);
         }

# ifdef VAX  
     printf("Remote VGTS vector test\n");
# else VAX
     printf("VGTS vector test\n");
# endif VAX
     GetTTY();
     sdf = CreateSDF();
     DefineSymbol( sdf, 1, "test" );
     vgt = CreateVGT(sdf, GRAPHICS+ZOOMABLE, 1, "datsun" );
     DefaultView(vgt, 500, 320, 0, 50, -2, 0, 0, 0);
     printf("sdf=%d, vgt=%d\r\n", sdf, vgt);
     lastx = lasty = 0;
     i = 0;
     vecs = 0;
     time(&start);
     while (feof(f)==0 ) 
      {
	fscanf(f,"%f%f%d", &x, &y, &ipen);
	screenx = x * 1500;
	screeny = y * 1500;
	if (ipen==1) 
	 {
	    AddItem( sdf, 0, lastx, screenx, lasty, screeny, 0, 
	    	SDF_GENERAL_LINE, 0);
	    vecs++;
	 }
	lastx = screenx;
	lasty = screeny;
       }
     EndSymbol( sdf, 1, vgt );
     time(&end);
     printf("%d vectors in %d seconds, or %d vectors/second\r\n",
     	vecs, end-start, vecs/(end-start));
     printf("hit return to erase:\r\n"); fflush(stdout); getchar();
     Quit();
  }

Random( first, last )
  {
  	/*
	 * generates a random number between "first" and "last" inclusive.
	 */
    int value = rand()/2;
    value %= (last - first + 1);
    value += first;
    return(value);
  }
