#include <Vio.h>

#define BLKS_IN_BUFFER 8
#define TRUE	1
#define FALSE	0

extern File *Open();

main( argc,argv )
  int argc;
  char **argv;
  {
    char inputfile[128], outputfile[128];
    SystemCode error;
    File *infile, *outfile;
    char *buffer;
    int count, done, buffersize, bufferblocks;

    if( argc != 3 )
      {
	printf("Input Filename: ");
	scanf("%s",inputfile);
	printf("Output Filename: ");
	scanf("%s",outputfile);
      }
    else
      {
	strcpy(inputfile, *++argv );
	strcpy(outputfile, *++argv );
      }
    
    infile = Open( inputfile, FREAD|FBLOCK_MODE, &error);
    if( error || (infile == NULL)) 
      {
        PrintError( error, inputfile );
	exit( 1 );
      }
    outfile = Open(outputfile, FCREATE|FBLOCK_MODE, &error);

    if( error || (outfile == NULL) )
      {
        PrintError( error, outputfile );
        exit( 1 );
      }

    buffersize = infile->blocksize;
    done = FALSE;
    buffer = (char *) calloc( 1, buffersize );

    do
      {
        if ( (count = Read( infile, buffer, buffersize )) < buffersize )
          {
	    if ( infile->lastexception != END_OF_FILE )
	      {
	        printf( "%s: error on block number %d: %s\n"
		      , inputfile, infile->block
		      , ErrorString( infile->lastexception ) );
	 	break;
	      }
	    done = TRUE;
	  }
	infile->block++;
	if ( Write( outfile, buffer, count ) != count )
	  {
	    printf( "%s: error on block number %d: %s\n"
		      , outputfile, outfile->block
		      , ErrorString( outfile->lastexception ) );
	    break;
	  }	    
        outfile->block++ ; /* move to next block */
      }
    while( !done );

    Close(infile);
    Close(outfile);
  }
