#include <Vio.h>
#include "checkers.h"

EndGame(s)
    char s[];
    /* Prints the string "s" as a prompt, then quits. */
  {
    Prompt(s);
    Delay(1, 0);
    Quit();
  }


main( argc, argv ) int argc; char **argv;

    /* This is the driving routine for the checkers program. */

  {
    extern int   Board[], PrevBoard[], Value, PrevValue, Rcount, Bcount;

    int         *bestb, *oldb, s;


    /* Change the team priority, so that other processes are not starved. */
    SetTeamPriority( GetPid(ACTIVE_PROCESS), 126);


    bestb = (int *) calloc( sizeof(int), 64 );
    oldb = (int *) calloc( sizeof(int), 64 );

    Rcount = Bcount = 12;

	/*
	 * Set up the VGT for the checker board.
	 * The user will be prompted (by the VGTS view manager) for the
	 * location of the view containing the checker board, and the
	 * initial board configuration will be displayed.
	 */
    SetupVGT();

    /* Display the board (initial configuration). */
    FullDisplay(Board, TRUE);

    /* Print a 'welcoming message'. */
    Silly_Comment( "Welcome to V checkers." );


    /* Copy the (initial) board into PrevBoard, in case the first thing that
     * the human does is request to back up a move. */
    Copy(PrevBoard, Board, 64*BYTES_PER_WORD);
    PrevValue = Value;

    /* Do the following until the game is over: */

    while(1)
      {
        /* Prompt for the human's move. */
        Prompt("It's your move.");

	/* Get the human's next move. */
        Player_move();

       /* The computer resigns if there are no more black pieces on the board.
 	*/
        if( No_man( BC, BK ) )
            EndGame( "  You win!" );

	/* Let the user know that the computer is calculating its move. */
	Prompt("...thinking...");

	/* Save a copy of the current board. */
	Copy( oldb, Board, 64*BYTES_PER_WORD );

       /* Determine the computer's move and display the altered board which
        * reflects it.
	*/

	/* Computer makes its move. */
	Value = Tree( Board, bestb, 0, -INFINITY );

	/* If the machine couldn't make a move, then "Value" will be INFINITY.
	 * (In situations where a loss is known, but a computer move was
	 * possible, "Value" will be slightly greater than INFINITY, because
	 * in such a case the computer will find itself stymied until a lower
	 * level.)
	 */
	if (Value == INFINITY)
 	    EndGame( "  You win!" );

	Copy( Board, bestb, 64*BYTES_PER_WORD );

       /*
	* Update the squares which the computer has changed,
	* and update Rcount and Bcount.
        */
	Rcount = Bcount = 0;
	for (s = 7; s < 56; ++s)
	  {
	    switch (Board[s])
	      {
		case RC:
		case RK:  ++Rcount; break;
		case BC:
		case BK:  ++Bcount;
	      }
	    if (Board[s] != oldb[s])
		UpdateDisplayedSquare(s, FALSE);
	  }
	UpdateValueIndicator();

	/*
        * The computer wins if there are no more red pieces for the human
        * to move.
	*/
        if( No_man( RC, RK ) )
            EndGame( "  You lose." );
	/*
        * Print a commentary on the play, based on the amount of change
        * in the board valuation between moves by the human.
	*/
        if( Value < (-INFINITY + 100) )
            Silly_Comment( "You should resign." );
        else if( Value < -500 )
            Silly_Comment( "Consider resigning?" );
        else if( (Value-PrevValue) > 200 )
            Silly_Comment( "You're better than I thought" );
        else if( (Value-PrevValue) > 100 )
            Silly_Comment( "Well done" );
        else if( (PrevValue-Value) > 200 )
            Silly_Comment( "Fell for it didn't you" );
        else if( (PrevValue-Value) > 100 )
            Silly_Comment( "Thanks" );
	else
	    Silly_Comment(0);

      }
  }
