#include "checkers.h"

unsigned Ch_man( board, i )
    int *board, i;

   /* This function determines whether or not a black piece (man or king)
    * can jump a red one.  For a jump to occur, the red piece must be
    * diagonally adjacent to the black one, whose position is indicated
    * by 'i', and there must be an empty square diagonally adjacent to
    * the red piece.  One (1) is returned if a jump is possible, zero (0)
    * is returned if it isn't.  Note that this function only checks for
    * a capture; it does not indicate what can be captured or the red
    * piece's position.
    */
  {
    unsigned    p;

    switch( board[i] )
      {
        case BK :

       /* Check the squares 'behind' the black king, since a king */
       /* can jump backwards as well as forwards. */
            p = board[i-7];

            /* Note that zero (0) here is for an empty board square. */

            if( ( (p==RC) || (p==RK) ) && (board[i-14]==0) )
                return( 1 );
            p = board[i-6];
            if( ( (p==RC) || (p==RK) ) && (board[i-12]==0) )
                return( 1 );
	    /*
	     * NOTE: There is NO "break;" here, because we need to perform
	     * the following checks as well.
	     */

        case BC :
        /* Check the squares ahead of the black man (or king) */
            p = board[i+6];
            if( ( (p==RC) || (p==RK) ) && (board[i+12]==0) )
                return( 1 );
            p = board[i+7];
            if( ( (p==RC) || (p==RK) ) && (board[i+14]==0) )
                return( 1 );
	    break;
      }
    return( 0 );
  }
