/*
*  Checkers: a simple checker playing program.
*  Copyright 1981 (c) All Rights reserved David R. Cheriton
*  Transliterated from Zed and Verex, July 1983.
*
*   A program which attempts to play checkers
*
* MANIFEST definitions:  'INFINITY' represents the state of utter
*                                   defeat or absolute victory,
*                        'OB'       means 'out of bounds' on the
*                                   checker board,
*                        'EMPTY'    is for an empty board square,
*                        'RC'       means red checker or man,
*                        'BC'       is a black man or checker,
*                        'RK'       represents a red king, and
*                        'BK'       is for a black king.
*
*/
#include <Vio.h>

#define INFINITY 	  4000
#define OB 	  -1
#define EMPTY 	  0
#define RC 	  1
#define BC 	  2
#define RK 	  3
#define BK 	  4

	/*
	 * The VGTS item number for the board, which should be greater than
	 * that of any of the 'pieces' (OB to BK above).
	 */
#define BOARD 5


	/* Misc. constants. */
#define FALSE 0
#define TRUE 1


#define SQUARE_SIZE 64

/* Constants used in the main menu. */
#define REDRAW 1
#define PASS 2
#define DEPTH 3
#define EDIT 4
#define RESIGN 5
#define BACKUP 6

/* The position of the Edit mode menu. */
#define EDIT_MENU_X 17*SQUARE_SIZE/2
#define EDIT_MENU_Y SQUARE_SIZE
