/* @(#) ucred.h 1.1@(#) Solbourne id 9/21/93 23:51:48 */
/*
 * Copyright 1990 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*	@(#)ucred.h	1.6 88/08/19 SMI	*/

#ifndef _sys_ucred_h
#define _sys_ucred_h

#include <sys/label.h>
#include <sys/audit.h>

/*
 * User credential structure
 */
struct ucred {
 	u_short		cr_ref;			/* reference count */
 	u_short  	cr_uid;			/* effective user id */
 	u_short 	cr_gid;			/* effective group id */
 	u_short		cr_auid;		/* user id, for auditing */
 	u_short  	cr_ruid;		/* real user id */
 	u_short		cr_rgid;		/* real group id */
 	int    		cr_groups[NGROUPS];	/* groups, 0 terminated */
 	blabel_t	cr_label;		/* Mandatory Access Control */
 	audit_state_t	cr_audit;		/* audit_state */
};

#ifdef KERNEL
#ifdef	solbourne
#include <sys/osmp_lock.h>
#include <smpdefs.h>
extern slock cred_lock;
#define	crhold(cr)	atomic(&cred_lock, ++(cr)->cr_ref)
#else	solbourne
#define	crhold(cr)	(cr)->cr_ref++
#endif	solbourne
void crfree();
struct ucred *crget();
struct ucred *crcopy();
struct ucred *crdup();
struct ucred *crgetcred();
#endif KERNEL

#endif /*!_sys_ucred_h*/
