/* @(#) lkstat.h 1.1@(#) Solbourne id 9/21/93 23:49:45 */
/*
 * The design is fairly simple. 
 *  An array of lock stat structures is defined globally. A linked list is 
 * maintained for the free elements.
 * 
 * Each lock_stat has a name. Once assigned to a lock, the element is taken
 * off the structure and is kept on a queue which is hashed by the first 
 * character of the name.  This is for quick searches since multiple locks 
 * could share the same lock structure.
 */

#ifndef _sys_lkstat_h
#define _sys_lkstat_h 
#ifndef LOCORE

#include <sys/queue.h>


#define MAXSTAT 300 

extern int lkstat_max_spin;
int lock_stat_collect;		/* global to start and stop the statistics */

typedef struct lock_stat {
  unsigned char intlk;          /* interlock byte for atomic incr */
  char *lk_name;                /* name tag for lock statitics */
  unsigned int  lk_attach;	/* number of attaches */
  unsigned int  lk_hits;		/* number of hits */	
  unsigned int  lk_misses;	/* number of misses */
  unsigned int  lk_spins_on_restore;	/* counter for "thunder" */
  struct lock_stat *next ;	/* pointer to the next free slot */
  struct lock_stat *hashq;      /* used when element of the hashq */
  unsigned int  lk_owner;	/* cpu no which has locked this structure */
  unsigned int   pad[3];        /* pad */
} lkstat;

typedef lkstat *lkstat_t;

lkstat  lock_stat_array[MAXSTAT] ; /* Array of all the stat structures */

typedef struct lock_queue {
  lkstat_t free_slot;
  int free_cnt;
} lkqueue;

/*
 * In order to keep it simple the lock stat is an array of MAXSTAT
 * For fast assignment free slot is indicated by free_lkstat
 * A linked list of free slots is kept.
 */

lkqueue free_lkstat;  

struct q_node hashq[HASH_NO];  

extern lkstat_t lkstat_get_elm(/*char *name */);
#define atomic_lk(lp, op) \
	{ \
	    int b;  \
	    b = block_n_lock_nodbg(lp); \
	    op; \
	    unblock_n_unlock_nodbg(lp, b); \
	}

		
#endif LOCORE
#endif _sys_lkstat_h
