/* @(#) evcnt.h 1.1@(#) Solbourne id 9/21/93 23:49:03 */
/*
 * Copyright 1993 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*
 * The event count mechanism for OS/MP is designed to be simple and reasonably
 * efficient.  Every event has a count (initialized to 0) and a list of
 * waiters, each with the count at which they want to be awakened.
 *
 * For a discussion of the theory behind event counts and sequencers as used
 * here, see "Synchronization with Eventcounts and Sequencers" by Reed and
 * Kanodia, CACM, February 1979/
 */
#ifndef _sys_evcnt_h
#define	_sys_evcnt_h

/* define functions which make up the interface to event counts. */
struct evcnt	*evcnt_init(/* struct evcnt *ev */);
void		evcnt_advance(/* struct evcnt *ev, int count*/);
int		evcnt_await(/* struct evcnt *ev, int val, int pri */);
void		evcnt_destroy(/* struct evcnt */);
#define		evcnt_read(ev) ((ev)->ev_val)

/*
 * The event structure itself.  Note that we don't really need the
 * wait list, we could just wakeup everybody whose waiting and let
 * them check the event value theirselves.  However, this is really
 * inefficient for the common case where you have waits on n, n+1, n+2, ...
 */
struct evcnt {
	int		ev_val;			/* current value */
	struct evcnt_wait {
	    int		evw_val;		/* value being waited for */
	    struct evcnt_wait	*evw_prev, *evw_next;	/* wait list */
	}		*ev_whead, *ev_wtail;	/* wait list */
};

/* define sequencers. */
typedef int	sequencer;
void		seq_init(/* sequencer *, int */);
int		seq_ticket(/* sequencer * */);
#define		seq_last(seq) (*(seq))

#endif /*!_sys_evcnt_h*/
