/* @(#) vmparam.h 1.1@(#) Solbourne id 9/21/93 23:59:55 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*	@(#)vmparam.h 1.10 88/08/19 SMI	*/

/*
 * Copyright (c) 1987 by Sun Microsystems, Inc.
 */

#ifndef _sun4_vmparam_h
#define _sun4_vmparam_h

#include <machine/param.h>

/*
 * Machine dependent constants for Kbus based systems
 */

/*
 * USRTEXT is the start of the user text/data space, while USRSTACK
 * is the top (end) of the user stack.  LOWPAGES and HIGHPAGES are
 * the number of pages from the beginning of the user address space
 * to the beginning of the text and from the end of the stack to the
 * end of the user address space respectively.
 */
#define	USRTEXT		0x2000
#define	USRSTACK	(KERNELBASE)
#define	LOWPAGES	btoc(USRTEXT)
#define	HIGHPAGES	0
#ifdef Series4
/*
 * Note that KSADDR is placed such that the user stack and the kernel
 * stack do not alias on top of each other in the Series4 TLB.
 */
#define	KSTACKSEG	0xfd800000
#endif Series4

/*
 * Virtual memory related constants for UNIX resource control, all in bytes
 */
#define	DFLSSIZ		(8*1024*1024)		 /* initial stack size limit */

#define	DFLDSIZ_KBUS	((512*1024*1024)-USRTEXT) /* initial data size limit */
#define	MAXDSIZ_KBUS	((512*1024*1024)-USRTEXT) /* max data size limit */
#define	MAXSSIZ_KBUS	((512*1024*1024)-KERNELSIZE) /* max stack size limit */


#define DFLDSIZ		dfldsiz
#define MAXDSIZ		maxdsiz
#define MAXSSIZ		maxssiz

#ifndef LOCORE
extern unsigned int	dfldsiz;
extern unsigned int 	maxdsiz;
extern unsigned int	maxssiz;
#endif !LOCORE

#define	SSIZE		1			/* initial stack size */
#define	SINCR		1			/* increment of stack */

/*
 * Alignment required on DVMA region to provide sun compatibality
 */
#define	DVMA_ALIGN	0x01000000

/*
 * Size of the kernel segkmem system pte table.  This virtual
 * space is controlled by the resource map "kernelmap".
 */
#ifdef Series4
#define	SYSLIMIT	KSTACKSEG
#endif Series4
#ifdef Series5
#define	SYSLIMIT	IO_ZERO_WIN
#endif Series5
#if	defined(Series6) || defined(Series7)
#define	SYSLIMIT	KERN_PHYS_WIN
#endif Series6 || Series7

#define	KRESERVED	(NCARGS + MINMAPSIZE + 0x200000 + DVMASIZE\
				+ HEAPBYTES + BUFBYTES + MBPOOLBYTES)

#define	SYSPTSIZE	((SYSLIMIT - SYSBASE - KRESERVED) / MMU_PAGESIZE)

/*
 * Minimum allowable virtual address space to be used
 * by the seg_map segment driver for fast kernel mappings.
 */
#define	MINMAPSIZE	0x200000

/*
 * The time for a process to be blocked before being very swappable.
 * This is a number of seconds which the system takes as being a non-trivial
 * amount of real time. You probably shouldn't change this;
 * it is used in subtle ways (fractions and multiples of it are, that is, like
 * half of a ``long time'', almost a long time, etc.)
 * It is related to human patience and other factors which don't really
 * change over time.
 */
#define	MAXSLP 		20

/*
 * A swapped in process is given a small amount of core without being bothered
 * by the page replacement algorithm. Basically this says that if you are
 * swapped in you deserve some resources. We protect the last SAFERSS
 * pages against paging and will just swap you out rather than paging you.
 * Note that each process has at least UPAGES pages which are not
 * paged anyways so this number just means a swapped in process is
 * given around 32k bytes.
 */
#define	SAFERSS		3		/* nominal ``small'' resident set size
					   protected against replacement */

/*
 * DISKRPM is used to estimate the number of paging i/o operations
 * which one can expect from a single disk controller.
 */
#define	DISKRPM		60

/*
 * Paging thresholds (see vm_pageout.c).
 * Strategy of 3/17/83:
 *	lotsfree is 256k bytes, but at most 1/8 of memory
 *	desfree is 100k bytes, but at most 1/16 of memory
 *	minfree is 32k bytes, but at most 1/2 of desfree
 *
 * Strategy as of 5/28/92:
 *      Machines are in general bigger/faster, so calculate
 *	starting numbers based on memory available but stay
 *	within MIN and MAX bounds.
 */
#define	MINLOTSFREE	(256 * 1024)
#define MAXLOTSFREE	(2048 * 1024)
#define	LOTSFREEFRACT	8
#define	MINDESFREE	(100 * 1024)
#define MAXDESFREE	(800 * 1024)
#define	DESFREEFRACT	16
#define	MINMINFREE	(32 * 1024)
#define MAXMINFREE	(512 * 1024)
#define	MINFREEFRACT	2


/*
 * There are two clock hands, initially separated by HANDSPREAD bytes
 * (but at most all of user memory).  The amount of time to reclaim
 * a page once the pageout process examines it increases with this
 * distance and decreases as the scan rate rises.
 *
 * Solbourne Mod -- base handspread value on amount of memory installed,
 * but stay within MIN and MAX bounds.
 */

#define	MINHANDSPREAD	(2 * 1024 * 1024)
#define MAXHANDSPREAD	(16 * 1024 * 1024)

/*
 * Paged text files that are less than PGTHRESH bytes
 * may be "prefaulted in" instead of demand paged.
 */
#define PGTHRESH	(280 * 1024)

#endif /*!_sun4_vmparam_h*/
