/* @(#) reg.h 1.1@(#) Solbourne id 9/22/93 00:18:57 */
/*
 * Copyright 1991 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*	@(#)reg.h 1.3 90/12/05 SMI	*/

/*
 * Copyright (c) 1985 by Sun Microsystems, Inc.
 */

#ifndef _sparc_reg_h
#define	_sparc_reg_h

#ifdef	solbourne
/*
 * Register window definitions
 */
#ifdef	Series4
#define	NWINDOW		7			/* # of implemented windows */
#endif	Series4
#ifdef	Series5
#define	NWINDOW		8			/* # of implemented windows */
#endif	Series5
#ifdef	S4000
#define	NWINDOW		8			/* # of implemented windows */
#endif	S4000
#ifdef Series6
#define	NWINDOW		8			/* # of implemented windows */
#endif	/* Series6 */
#ifdef Series7
#define	NWINDOW		8			/* # of implemented windows */
#endif	/* Series7 */
#endif	solbourne

/*
 * Location of the users' stored
 * registers relative to R0.
 * Usage is u.u_ar0[XX].
 */
#define	PSR	(0)
#define	PC	(1)
#define	nPC	(2)
#define	Y	(3)
#define	G1	(4)
#define	G2	(5)
#define	G3	(6)
#define	G4	(7)
#define	G5	(8)
#define	G6	(9)
#define	G7	(10)
#define	O0	(11)
#define	O1	(12)
#define	O2	(13)
#define	O3	(14)
#define	O4	(15)
#define	O5	(16)
#define	O6	(17)
#define	O7	(18)

#ifdef	solbourne
#define	IPR	(19)
#endif	solbourne

/* the following defines are for portability */
#define	PS	PSR
#define	SP	O6
#define	R0	O0
#define	R1	O1

/*
 * And now for something completely the same...
 */
#ifndef LOCORE
struct regs {
	int	r_psr;		/* processor status register */
	int	r_pc;		/* program counter */
	int	r_npc;		/* next program counter */
	int	r_y;		/* the y register */
	int	r_g1;		/* user global regs */
	int	r_g2;
	int	r_g3;
	int	r_g4;
	int	r_g5;
	int	r_g6;
	int	r_g7;
	int	r_o0;
	int	r_o1;
	int	r_o2;
	int	r_o3;
	int	r_o4;
	int	r_o5;
	int	r_o6;
	int	r_o7;
};

#define	r_ps	r_psr		/* for portablility */
#define	r_r0	r_o0
#define	r_sp	r_o6

#ifdef	solbourne
struct excregs {		/* for exceptions... */
	int	r_psr;		/* processor status register */
	int	r_pc;		/* program counter */
	int	r_npc;		/* next program counter */
	int	r_y;		/* the y register */
	int	r_g1;		/* user global regs */
	int	r_g2;
	int	r_g3;
	int	r_g4;
	int	r_g5;
	int	r_g6;
	int	r_g7;
	int	r_o0;
	int	r_o1;
	int	r_o2;
	int	r_o3;
	int	r_o4;
	int	r_o5;
	int	r_o6;
	int	r_o7;
	int	r_ipr;		/* interrupt priority level */
	int	r_fsr;
	int	r_fqaddr;
	int	r_fqinst;

#if	defined(Series6) || defined(Series7)
	int	r_fc;		/* fault cause register */
	int	r_adfa;		/* asynchronous data fault address register */
	int	r_ksfa;		/* kbus SECC fault address register */
	int	r_kmfa;		/* kbus MECC fault address register */
	int	r_msfa;		/* mbus SECC fault address register */
	int	r_mmfa;		/* mbus MECC fault address register */
	int	r_sdfa;		/* synchronous data fault address register */
	int	r_ktfa;		/* kbus timeout fault address register */
	int	r_kafa;		/* kbus async fault address register */
	int	r_kts;		/* kbus timeout SPACE/TTYPE register */
	int	r_mfid;		/* mbus fault ID register */
	int	r_bcs;		/* board control and status register */
	int	r_kss;		/* kbus SECC syndrome register */
	int	r_kms;		/* kbus MECC syndrome register */
	int	r_amss;		/* async mbus SECC syndrome register */
	int	r_amms;		/* async mbus MECC syndrome register */
	int	r_mms;		/* sync mbus ECC syndrome register */
#ifdef viking
	int	r_mxer0;	/* mxcc error reg (upper half) */
	int	r_mxer1;	/* mxcc error reg (lower half) */
	int	r_mxst0;	/* mxcc status reg (upper half) */
	int	r_mxst1;	/* mxcc status reg (lower half) */
	int	r_mxrst;	/* mxcc reset reg */
#endif viking
#endif	/* Series6 || Series7 */

};

struct x_excregs {		/* excregs struct extended for %l and %i */
	struct excregs excregs;
	int	r_i0;
	int	r_i1;
	int	r_i2;
	int	r_i3;
	int	r_i4;
	int	r_i5;
	int	r_i6;
	int	r_i7;
	int	r_l0;
	int	r_l1;
	int	r_l2;
	int	r_l3;
	int	r_l4;
	int	r_l5;
	int	r_l6;
	int	r_l7;
	int	r_o0;
	int	r_o1;
	int	r_o2;
	int	r_o3;
	int	r_o4;
	int	r_o5;
	int	r_o6;
	int	r_o7;
};

#define r_ps	r_psr		/* for portablility */
#define r_r0	r_o0
#define r_sp	r_o6

/*
 * define ctlregs struct
 *
 * NOTE: pdb reads this information from sash while
 * remote debugging.  Ideally, the size of this structure
 * should remain constant.  If not, pdb needs to be 
 * recompiled.
 */
#if	defined(Series4) || defined(Series5)
struct ctlregs {
	int	r_wim;		/* window invalid mask */
	int	r_tbr;		/* trap base register */
	int	r_dir;		/* device ID register */
	int	r_ixr;		/* interrupt transmit register */
	int	r_itxc;		/* interrupt transmitter control register */
	int	r_ipr;		/* interrupt priority register */
	int	r_ipv;		/* interrupt pending vector */
	int	r_irxc;		/* interrupt receiver control register */
	int	r_fpar;		/* fault physical address register */
	int	r_fes;		/* fault ecc syndrome register */
	int	r_kcb;
	int	r_fcr;		/* fault cause register */
	int	r_mmcr;		/* memory management ctrl register */
	int	r_fvar;		/* fault virtual address register */
	int	r_pdep;		/* page directory entry pointer */
	int	r_bid;		/* board ID register */
	int	r_led;		/* led register */
/* 17 int's */
};
#endif	defined(Series4) || defined(Series5)
#if	defined(S4000)
struct ctlregs {
	int	r_wim;		/* window invalid mask */
	int	r_tbr;		/* trap base register */
	int	r_mmcr;		/* memory management ctrl register */
	int	r_pdbr;		/* page directory base register  */
	int	r_fvar;		/* fault virtual address register */
	int	r_pder;		/* page directory entry register */
	int	r_ptor;		/* page table offset register */
	int	r_fpar;		/* fault physical address register */
	int	r_fpsr;		/* fault physical space register */
	int	r_piid;		/* process id invalidation */
	int	r_pid;		/* process id */
	int	r_bcr;		/* bus control register */
	int	r_fcr;		/* fault cause register */
	int	r_ptw0;		/* programmable translation window 0 */
	int	r_ptw1;		/* programmable translation window 1 */
	int	r_ptw2;		/* programmable translation window 2 */
	int	r_war0;		/* watchpoint address register 0 */
	int	r_war1;		/* watchpoint address register 1 */
	int	r_wcr;		/* watchpoint control register */
/* 19 int's */
};
#endif	defined(S4000)

#if	defined(Series6) || defined(Series7)
struct ctlregs {
	int	r_wim;		/* window invalid mask */
	int	r_tbr;		/* trap base register */
	int	r_kcb;		/* kbus check byte register */
	int	r_mcb;		/* mbus check byte register */
	int	r_led;		/* LED register */
	int	r_dir;		/* device ID register */
	int	r_ixr;		/* interrupt transmit register */
	int	r_itxc;		/* interrupt transmit control register */
	int	r_ipr;		/* interrupt priority register */
	int	r_ipv;		/* interrupt pending vector */
	int	r_irxc;		/* interrupt receiver control register */
#ifdef viking
	int	r_mcntl;	/* MMU control register */
#endif viking
#ifdef cypress
	int	r_scr;		/* MMU system control register */
#endif cypress
	int	r_context;	/* MMU context register */
	int	r_mfsr;		/* MMU fault status register */
	int	r_mfar;		/* MMU fault address register */
	int	r_afsr;		/* MMU async fault status register (cypress) */
	int	r_afar;		/* MMU async fault address register (cypress) */
/* 17 int's */
};
#endif	/* Series6 || Series7 */
#endif	solbourne
#endif !LOCORE

/*
 * Floating point definitions.
 */

#define	FPU			/* we have an external float unit */

#ifndef LOCORE

#define	FQ_DEPTH	16		/* maximum instuctions in FQ */

/*
 * struct fp_status is the floating point processor state
 * struct fpu is the sum total of all possible floating point state
 * which includes the state of external floating point hardware,
 * fpa registers, etc..., if it exists.
 */
struct	fq {
	union {				/* FPU inst/addr queue */
		double	whole;
		struct  fpq;
	} FQu;
};

struct fpq {
	unsigned long *addr;		/* address */
	unsigned long instr;		/* instruction */
};

#define	FPU_REGS_TYPE unsigned
#define	FPU_FSR_TYPE unsigned

struct	fp_status {
	union {				 /* FPU floating point regs */
		FPU_REGS_TYPE Fpu_regs[32];	/* 32 singles */
		double	Fpu_dregs[16];		/* 16 doubles */
	} fpu_fr;
	FPU_FSR_TYPE Fpu_fsr;		/* FPU status register */
	unsigned Fpu_flags;		/* control flags */
	unsigned Fpu_extra;		/* extra word */
	unsigned Fpu_qcnt;		/* count of valid entries in fps_q */
	struct fq Fpu_q[FQ_DEPTH];	/* FPU instruction address queue */
};

#define	fpu_regs	f_fpstatus.fpu_fr.Fpu_regs
#define	fpu_dregs	f_fpstatus.fpu_fr.Fpu_dregs
#define	fpu_fsr		f_fpstatus.Fpu_fsr
#define	fpu_flags	f_fpstatus.Fpu_flags
#define	fpu_extra	f_fpstatus.Fpu_extra
#define	fpu_q		f_fpstatus.Fpu_q
#define	fpu_qcnt	f_fpstatus.Fpu_qcnt

struct fpu {
	struct fp_status f_fpstatus;
};
#endif !LOCORE


/*
 * Definition of bits in the Sun-4 FSR (Floating-point Status Register)
 *   ________________________________________________________________________
 *  |  RD |  RP | TEM | NS | res | vers | FTT | QNE | PR | FCC | AEXC | CEXC |
 *  |-----|---- |-----|----|-----|------|-----|-----|----|-----|------|------|
 *   31 30 29 28 27 23  22  21 20 19  17 16 14   13   12  11 10 9    5 4    0
 */
#define	FSR_CEXC	0x0000001f	/* Current Exception */
#define	FSR_AEXC	0x000003e0	/* ieee accrued exceptions */
#define	FSR_FCC		0x00000c00	/* Floating-point Condition Codes */
#define	FSR_PR		0x00001000	/* Partial Remainder */
#define	FSR_QNE		0x00002000	/* Queue not empty */
#define	FSR_FTT		0x0001c000	/* Floating-point Trap Type */
#define FSR_VERS	0x000e0000	/* version field */
#define FSR_RESV	0x00300000	/* reserved */
#define FSR_NS		0x00400000	/* non-standard fp */
#define FSR_EFM         0x00400000      /* Enable Fast Mode (diag)*/
#define FSR_TEM		0x0f800000	/* ieee Trap Enable Mask */
#define	FSR_RP		0x30000000	/* Rounding Precision */
#define	FSR_RD		0xc0000000	/* Rounding Direction */

#define FSR_VERS_SHIFT	(17)		/* amount to shift version field */

/*
 * Definition of CEXC (Current EXCeption) bit field of fsr
 */
#define	FSR_CEXC_NX	0x00000001	/* inexact */
#define	FSR_CEXC_DZ	0x00000002	/* divide-by-zero */
#define	FSR_CEXC_UF	0x00000004	/* underflow */
#define	FSR_CEXC_OF	0x00000008	/* overflow */
#define	FSR_CEXC_NV	0x00000010	/* invalid */

/*
 * Definition of AEXC (Accrued EXCeption) bit field of fsr
 */
#define	FSR_AEXC_NX	(0x1 << 5)	/* inexact */
#define	FSR_AEXC_DZ	(0x2 << 5)	/* divide-by-zero */
#define	FSR_AEXC_UF	(0x4 << 5)	/* underflow */
#define	FSR_AEXC_OF	(0x8 << 5)	/* overflow */
#define	FSR_AEXC_NV	(0x10 << 5)	/* invalid */

#ifdef	solbourne
/*
 * Definition of FCC (Condition Code) field within the FSR
 */
#define FCC_EQ		0		/* equal */
#define FCC_LT		1		/* less than */
#define FCC_GT		2		/* greater than */
#define FCC_UN		3		/* unordered */
#define FSR_FCC_SHIFT	10	/* shift needed to justfy fcc field */
#define FSR_FCC_EQ	(FCC_EQ << FSR_FCC_SHIFT)
#define FSR_FCC_LT	(FCC_LT << FSR_FCC_SHIFT)
#define FSR_FCC_GT	(FCC_GT << FSR_FCC_SHIFT)
#define FSR_FCC_UN	(FCC_UN << FSR_FCC_SHIFT)
#endif	solbourne

/*
 * Defintion of FTT (Floating-point Trap Type) field within the FSR
 */
#define	FTT_NONE	0		/* no excepitons */
#define	FTT_IEEE	1		/* IEEE exception */
#define	FTT_UNFIN	2		/* unfinished fpop */
#define	FTT_UNIMP	3		/* unimplemented fpop */
#define	FTT_SEQ		4		/* sequence error */
#define	FTT_ALIGN	5	/* alignment, by software convention */
#define	FTT_DFAULT	6	/* data fault, by software convention */
#define	FSR_FTT_SHIFT	14	/* shift needed to justfy ftt field */
#define	FSR_FTT_IEEE	(FTT_IEEE   << FSR_FTT_SHIFT)
#define	FSR_FTT_UNFIN	(FTT_UNFIN  << FSR_FTT_SHIFT)
#define	FSR_FTT_UNIMP	(FTT_UNIMP  << FSR_FTT_SHIFT)
#define	FSR_FTT_SEQ	(FTT_SEQ    << FSR_FTT_SHIFT)
#define	FSR_FTT_ALIGN	(FTT_ALIGN  << FSR_FTT_SHIFT)
#define	FSR_FTT_DFAULT	(FTT_DFAULT << FSR_FTT_SHIFT)

/*
 * Values of VERS (version) field within the FSR
 * NOTE: these values are overloaded; the cpu type must be used to
 * further discriminate amongst these.  For that reason, no #defines are
 * provided.
 *
 * Version	cpu = 21-22, 51-54		cpu = 23-24, 55-57
 *	0	Weitek 1164/5 (FAB 1-4)		TI 8847
 *	1	Weitek 1164/5 (FAB 5-6)		LSI L64814
 *	2	TI 8847				TI TMS390C602A
 *	3	Weitek 3170			Weitek 3171
 *	4	Meiko				?
 *	5	?				?
 *	6	?				?
 *	7	No FP Hardware			No FP Hardware
 */


/*
 * Definition of TEM (Trap Enable Mask) bit field of fsr
 */
#define	FSR_TEM_NX	(0x1 << 23)	/* inexact */
#define	FSR_TEM_DZ	(0x2 << 23)	/* divide-by-zero */
#define	FSR_TEM_UF	(0x4 << 23)	/* underflow */
#define	FSR_TEM_OF	(0x8 << 23)	/* overflow */
#define	FSR_TEM_NV	(0x10 << 23)	/* invalid */

/*
 * Definition of RP (Rounding Precision) field of fsr
 */
#define	RP_DBLEXT	0		/* double-extended */
#define	RP_SINGLE	1		/* single */
#define	RP_DOUBLE	2		/* double */
#define	RP_RESERVED	3		/* unused and reserved */

/*
 * Defintion of RD (Rounding Direction) field of fsr
 */
#define	RD_NEAR		0		/* nearest or even if tie */
#define	RD_ZER0		1		/* to zero */
#define	RD_POSINF	2		/* positive infinity */
#define	RD_NEGINF	3		/* negative infinity */

/*
 * Definition of the FP enable flags of the pcb struct
 * Normal operation, all flags are zero
 */
#define	FP_UNINITIALIZED	1
#define	FP_STARTSIG		2
#define	FP_DISABLE		4
#define	FP_ENABLE		8

#ifndef LOCORE
/*
 * How a register window looks on the stack.
 */
struct rwindow {
	int	rw_local[8];		/* locals */
	int	rw_in[8];		/* ins */
};

#define	rw_fp	rw_in[6]		/* frame pointer */
#define	rw_rtn	rw_in[7]		/* return address */

#endif !LOCORE

#endif /*!_sparc_reg_h*/
