/* @(#) kmreg.h 1.1@(#) Solbourne id 9/21/93 23:58:08 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*
 * header file for SAE keyboard driver, the keyboard is an IBM compatible
 * 101/102 key keyboard with AT, XT and alternate AT modes.
 * The keyboard is self clocked and we must program the uart for
 * 1 start bit, 8 data bits, 1 odd parity bit and 1 stop bit.
 * We use the alternate AT mode(HN mode), programmed to send up/down
 * codes and repeat for all keyboard keys.
 */

/*
 * command/response bytes understood/sent by the keyboard
 */
#define	KB_LEDSET	0xed	/* set leds to match bits in following byte */
#define	KB_CLICKOFF	0xeb	/* disable keyclick */
#define	KB_ECHO		0xee	/* echo this byte back from keyboard */
#define	KB_SETMODE	0xf0	/* set keyboard into mode specified in following byte */
#define	KB_READID	0xf2	/* keyboard responds with 2 byte keyboard ID */
#define	KB_SETRATE	0xf3	/* set keyboard repeat rate/delay from following byte */
#define	KB_ENABLE	0xf4	/* enable keyboard (keyboard clears buffer and ACK's) */
#define	KB_DISABLE	0xf5	/* keyboard ACK's and ignores keypresses */
#define	KB_DEFAULT	0xf6	/* keyboard ACK's and goes to power on state */
#define	KB_SAMREP	0xf7	/* set all keyboard keys to repeat and send make only */
#define	KB_SAMB		0xf8	/* set all keyboard keys to send make/break, no repeat */
#define	KB_SAM		0xf9	/* set all keyboard keys to send make only, no repeat */
#define	KB_SAMBREP	0xfa	/* set all keyboard keys to repeat and send make/break */
#define	KB_SKMREP	0xfb	/* set key to repeat and send make only */
#define	KB_SKMB		0xfc	/* set key to send make/break only, no repeat */
#define	KB_SKM		0xfd	/* set key to send make only, no repeat */
#define	KB_RESEND	0xfe	/* keyboard should resend last data */
#define	KB_RESET	0xff	/* reset keyboard, respond with KB_TESTOK if ok */

#define	KB_BREAK	0xf0	/* sent by keyboard before break code */
#define	KB_ACK		0xfa	/* sent by keyboard as response to valid data */
#define	KB_DIAGFAIL	0xfc	/* sent by keyboard on diagnostic failure */
#define	KB_RESEND	0xfe	/* sent by keyboard on bad command/input parity error */
#define	KB_ECHOR	0xee	/* sent by keyboard in response to KB_ECHO command */
#define	KB_TESTOK	0xaa	/* sent by keyboard on successful self test */
#define	KB_OVERRUN	0x00	/* sent by keyboard on buffer overrun */
#define	KB_ATID2	0x83	/* second byte of PC AT 101 key keyboard ID */
#define	KB_IDBYTE1	0xab	/* first byte of keyboard ID */
#define	KB_SAE1ID2	0x9e	/* second byte of SAE1 keyboard ID */
/*
 * these are left here for backwards compatibility
 */
#define	KB_ID1		0x83
#define	KB_ID2		0xab

/*
 * timeout period for keyboard commands
 */
#define	KM_KBDTIMOUT	(hz)	/* one second keyboard command timeout */

/*
 * keyboard led bits
 */
#define	KB_SLLED	0x01	/* scroll lock led bit */
#define	KB_NLLED	0x02	/* num lock led bit */
#define	KB_CLLED	0x04	/* caps lock led bit */

/*
 * keyboard key code mode selectors
 */
#define	KB_XTMODE	0x01	/* keyboard will send XT scan codes */
#define	KB_ATMODE	0x02	/* keyboard will send AT scan codes */
#define	KB_HNMODE	0x03	/* keyboard will send HN scan codes */
#define	KB_MODEQ	0x00	/* keyboard will send byte with current mode */

/*
 * the byte controlling keyboard repeat interval and delay has the following format
 *
 *	 7 65 43 2 0
 *	+-+--+--+---+
 *	|0|d |e | i |
 *	+-+--+--+---+
 *
 *	bit 7 is always zero
 *	delay is set to ((1 + d) * 4.16 * 60) ms
 *	interval is set to (4.16 * i * 2**e) ms
 */

/*
 * There are two 128 entry tables each entry is 32 bits long.
 * The two tables correspond to unaugmented, and shifted
 * keypresses when the keyboard mode is set to
 * translate mode, raw up/down codes are sent when in raw mode.
 * The keyboard translation table entries are laid out as follows.
 * The 32 bit entry has flags in the top 8 bits and the character(s)
 * to send in the lower 24 bits.
 *
 *	 3 3 2   2  2 2      1 1      
 *	 1 0 9   7  4 3      6 5      8 7      0
 *	+-+-+-+-+----+--------+--------+--------+
 *	|n|k|c|u|type| char 3 | char 2 | char 1 |
 *	+-+-+-+-+----+--------+--------+--------+
 *
 *	n - key affected by num lock
 *	k - key affected by caps lock
 *	c - key affected by control key
 *	u - unused bit field
 *	type - type of key/sequence length specifier
 *	char 1 - 1st char to send of 1 byte sequences, 2nd of 2 byte, 3rd of 3 byte
 *	char 2 - 1st char of 2 byte sequences, 2nd char of 3 byte sequences
 *	char 3 - 1st char of 3 byte sequences
 */
#define	KB_TBLSIZE	128	/* each table has 128 entries */

/*
 * keyboard scan code translation modes
 */
#define	KB_RAW		0x00	/* send raw up/down scan codes */
#define	KB_XLATE	0x01	/* translate scan codes to table defined values */

/*
 * key code translation table selectors
 */
#define	KB_NORMTAB	0x00	/* unaugmented keyboard table */
#define	KB_SHIFTTAB	0x01	/* shifted keyboard table */

/*
 * translation table flag bits
 */
#define	KB_NUMLCK	0x80000000	/* key affected by num lock key */
#define	KB_CAPLCK	0x40000000	/* key affected by caps lock key */
#define	KB_CTLKEY	0x20000000	/* key affected by control key */

/*
 * translation table entry types 
 */
#define	KB_SHIFTKEY	0x01000000	/* key is a shift key */
#define	KB_BREAKKEY	0x02000000	/* key is a break key */
#define	KB_1CHAR	0x03000000	/* send char 1 */
#define	KB_2CHAR	0x04000000	/* send char 2, then char 1 */
#define	KB_3CHAR	0x05000000	/* send char 3, then char 2, then char 1 */
#define	KB_SHIFTTOGGLE	0x06000000	/* key is a toggling shift key */
#define	KB_NOKEY	0x0f000000	/* key does not exist or should be ignored */
#define	KB_TYPEMASK	0x0f000000	/* mask for key type bits */

/*
 * standard ASCII control sequence prefixes
 */
#define	KB_CSIPFX	0x001b5b00	/* ASCII <ESC> [ prefix */
#define	KB_SS2PFX	0x001b4e00	/* ASCII <ESC> N prefix */
#define	KB_SS3PFX	0x001b4f00	/* ASCII <ESC> O prefix */

/*
 * bits for keyboard alt/shift/control state status byte
 */
#define	KB_LSHIFT	0x01	/* left shift key is down */
#define	KB_LALT		0x02	/* left alt key is down */
#define	KB_LCTRL	0x04	/* left control key is down */
#define	KB_RSHIFT	0x08	/* right shift key is down */
#define	KB_RALT		0x10	/* right alt key is down */
#define	KB_RCTRL	0x20	/* right control key is down */
#define	KB_CAPSLCKD	0x40	/* caps lock key is down */
#define	KB_NUMLCKD	0x80	/* num lock key is down */
#define	KB_ALTDN	(KB_LALT|KB_RALT)	/* an alt key is down */
#define	KB_SHIFTDN	(KB_LSHIFT|KB_RSHIFT)	/* a shift key is down */
#define	KB_CTLDN	(KB_LCTRL|KB_RCTRL)	/* a control key is down */

/*
 * defines for mouse
 */
#define	MS_PREMASK	0xf8	/* isolates top 5 bits of byte */
#define	MS_PREAMBLE	0x10	/* top 5 bits are 10000B if valid preamble */

/*
 * defines for keyboard driver ioctls
 */
#define	KIOGKBENT	_IOWR(K, 1, struct kbtblent)	/* get kbd translation table entry */
#define	KIOSKBENT	_IOWR(K, 2, struct kbtblent)	/* set kbd translation table entry */
#define	KIOGKBMOD	_IOR(K, 3, int)			/* get keyboard translation mode */
#define	KIOSKBMOD	_IOW(K, 4, int)			/* set keyboard translation mode */
#define	KIOSKBRINT	_IOW(K, 5, char)		/* set keyboard repeat interval/delay */
#define	KIOGKBID	_IOR(K, 5, short)		/* get keyboard ID */

/*
 * keyboard translation table get/set definition structure
 */
struct kbtblent {
	unsigned char	table;	/* selects which table to get/set */
	unsigned char	index;	/* selects which entry in table to get/set */
	unsigned long	entry;	/* entry from table or to put in table */
};

/*
 * keyboard definition for a particular type of keyboard
 */
struct kb_struct {
	u_char	*noreptab;	/* list of keys to disable repeat for */
	u_int	*normtab;	/* unaugmented key translation table */
	u_int	*shifttab;	/* augmented key translation table */
};

/*
 * keyboard ID to definition match table entry
 */
struct kb_typetab {
	u_char			id;		/* ID byte for keyboard */
	struct kb_struct	*kbstruct;	/* keyboard structure for this ID */
};
