/* @(#) diag.h 1.4@(#) Solbourne id 2/10/94 19:52:01 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*
 * diag.h
 *
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */
#ifndef	_machine_diag_h
#define	_machine_diag_h

#ifndef lint
#ifdef sccs
static char sccsid[] = "@(#)diag.h	1.24 12/22/88 ";
#endif
#endif

/*
 * Definitions for Bootrom diagnostics
 */

#define ROM_LEVEL 1	/* Bootrom compatibility level */
			/* checked during POST */

/*
 * miscellaneous registers:
 */
#define r_null		%g0	
#define	r_temp1		%g6	/* scratch register */
#define	r_temp2		%g7	/* scratch register */
#define	r_temp3		%g5	/* scratch register */
#define r_frame_ptr	%i6	/* frame pointer */
#define r_ret_add	%i7	/* return address (if non-leaf routine) */
#define r_stack_ptr	%o6	/* stack pointer */
#define r_retl_add	%o7	/* return address (if leaf routine) */

/*
 * globals used by rom0 and basic tests:
 */
#define	r_test_num	%g1	/* Currently executing test  */
#define	r_test_error	%g2	/* Error code from currently executing test */
#define	r_rom0vec	%g3	/* rom0 vector */

/*
 * test type codes:
 */
#define A_TEST		0	/* Test written in assembly code */
#define B_TEST		1	/* Executed during Burn-in only */
#define C_TEST		2	/* Test written in C code */
#define M_TEST		4	/* Run only by Master CPU */

#ifdef Series6
#define S_TEST		8	/* don't run if DIAGMODE = "short" */
#endif Series6

#ifdef Series7
/*
 * Test List Structure Offsets
 */
#define TL_ENTRY	0	/* Offset to Test Entry Point */
#define TL_FLAGS	4	/* Offset to Test Flags */
#define TL_NAME		8	/* Offset to Name String Pointer */
#define TL_FRU		12	/* Offset to FRU List */
#define TL_TIMEOUT	16	/* Timeout Value */
#define TL_SIZE		20	/* Size of struct (in bytes) */
/*
 * Test Flag defines
 */
#define BURNIN_FLAG	1	/* Test only run in Burnin mode */
#define NORMAL_FLAG	2	/* Test only run in Burnin or Normal mode */
#define MASTER_FLAG	4	/* Test only run by System Master */
#define SUBMASTER_FLAG	8	/* Test only run by Mbus Sub-Master */
/*
 * FRU List defines 
 */
#define FRU_MAX		3	/* Allowed number of identified FRU's */
#define FRU_SIZE	32	/* Max length (including null char) */
#endif Series7

/*
 * Interrupt bus messages:
 * The following commands are sent from the master cpu (or stim board)
 * to slave CPUs in their idle loop. (positioned above 0x8f to be higher 
 * priority than system board interrupts)
 */
#define DG_CMD_FIRST	0x90	/* first command vector */
#define MASTER_CMD	0x90	/* pass mastership to another CPU */
#define SLAVE_CMD	0x91	/* cmd slave to complete selftest */
#define GOTO_CMD	0x92	/* go to "address" */
#define MULTI_CMD	0x93	/* go to "address" using parameter block */
#define	LOOP_CMD	0x94 	/* loop on test */
#define RESTART_CMD	0x95	/* restart test sequence */
#define NEXT_CMD	0x96 	/* run next test */
#define RUN_CMD		0x97	/* run specified test */
#define DUMP_CMD	0x98	/* dump error block */
#define BOOT_CMD	0x99	/* go to boot code */
#define FPDUMP_CMD	0x9a	/* floating point dump */
#define CONT_CMD	0x9b	/* continue on error */
#define DTRAP_DUMP_CMD	0x9c	/* dump dtrap information to memory */
#define BREAK_CMD	0x9d	/* breakpoint command */
#define ABORT_CMD	0x9e	/* abort command sequence */
#define HALT_CMD	0xa0	/* stop looping */
#define PREFETCH_ON_CMD		0xa1	/* turn on mxcc prefetch */
#define PREFETCH_OFF_CMD	0xa2	/* turn off mxcc prefetch */
#define STOREBUF_ON_CMD		0xa3	/* turn on viking store buffer */
#define STOREBUF_OFF_CMD	0xa4	/* turn off viking store buffer */
#define MIX_ON_CMD		0xa5	/* turn on viking MIX */
#define MIX_OFF_CMD		0xa6	/* turn off viking MIX */
#define CACHE_ON_CMD		0xa7	/* turn on all caches */
#define CACHE_OFF_CMD		0xa8	/* turn off all caches */
#define ICACHE_ON_CMD		0xa9	/* turn on viking icache */
#define ICACHE_OFF_CMD		0xaa	/* turn off viking icaches */
#define DCACHE_ON_CMD		0xab	/* turn on viking dcache */
#define DCACHE_OFF_CMD		0xac	/* turn off viking dcache */
#define MC_ON_CMD		0xad	/* turn on mxcc mc */
#define MC_OFF_CMD		0xae	/* turn off mxcc mc */
#define LOCK_CACHE_CMD		0xaf	/* lock cache blocks */
#define UNLOCK_CACHE_CMD	0xb0	/* lock cache blocks */
#define DTRAP_CMD 		0xc0	/* test dtrap handler */
#define INACTIVE_CMD 		0xc1	/* test inactive reset handler */
#define START_SLAVE_CMD		0xd0	/* Start OS on Slave processor */
#define DG_CMD_LAST		0xd0	/* last command vector */

/*
 * status messages:
 */
#define SLAVE_OK_STAT	0xfc	/* status message - slave passed selftest */
#define SLAVE_FAIL_STAT 0xfd	/* status message - slave failed selftest */
#define NACK		0xfe	/* command not acknowledged */
#define ACK		0xff	/* command acknowledged */

#define INT_ACK		(ACK<<8)	/* ACK adjusted for IXR/IPV regs */
#define INT_NACK	(NACK<<8)	/* NACK adjusted for IXR/IPV regs */

/*
 * diagnostic test control flags:
 */
#define HALT_FLAG	0x01	/* stop looping */
#define	LOOP_FLAG	0x02 	/* loop on test */
#define RUN_FLAG	0x04	/* run requested test */
#define CONT_FLAG	0x08	/* loop on test - continue on error */
#define DATA_FLAG	0x10	/* data area initialized */

#define PIL(x)	(x<<8)
#define	SLOT_TO_PERSLOT(slot)	(DG_SLOT_INFO+((slot)-1)*DG_SLOT_SIZE)

/* 
 * Note, when the DGRAM test has completed, the entire DGRAM is zeroed.
 * Therefore, the default value for all DGRAM state variables should be 
 * zero.
 */

#ifdef Series4
/*******************************************************************
 *
 * diagnostic ram partitions:
 */
#define DG_ERROR_BLOCK	0x000	/* start of error block */
#define DG_EB_NREGS	49	/* # of regs saved in error block */
#define DG_FP_NREGS	34	/* # of fp registers dumped */
#define DG_PARAM	0x100	/* start of test parameters (see below) */
#define DG_CONFIG	0x200	/* start of configuration table (see below) */
#define DG_VECTOR	0x400	/* start of exception vector table */

/*
 * while the kernel is running we use location zero in the 
 * diagnostic ram to keep a software copy of the sic ipr
 */
#define	DG_CUR_IPR	0x00	/* software copy of sic ipr */

/*
 * Parameter block variables (DG_PARAM)
 */
#define DG_FLAGS	DG_PARAM	/* test flags (1 byte) */
#define DG_TEST		DG_FLAGS+1	/* test number (1 byte) */
#define DG_ERROR	DG_TEST+1	/* error code (1 byte) */
#define DG_CMD		DG_ERROR+1	/* test command (1 byte) */
#define DG_LPCNT	DG_CMD+1	/* loop counter (4 bytes) */
#define DG_CODE1	DG_LPCNT+4	/* 1st LED code displayed (2 bytes) */
#define DG_CODE2	DG_CODE1+2	/* 2nd LED code displayed (2 bytes) */
#define DG_TESTSW	DG_CODE2+2	/* test switch: 0=test, 1=normal */
					/* (1 byte) */
#define DG_MBID		DG_TESTSW+1	/* BID of master cpu (1 byte) */
#define DG_MS		DG_MBID+1	/* master/slave status (see below) */
#define DG_MS_UNDETERMINED	0	/* Mastership not determined */
#define DG_MS_SLAVE		1	/* slave */
#define DG_MS_MASTER		2	/* master */
#define DG_MS_SLAVE_FAILED	3	/* Slave that failed */
#define DG_MS_MASTER_FAILED	4	/* Master that failed */
#define DG_MS_OLD_MASTER	DG_MS_MASTER_FAILED	

#define DG_BID		DG_MS+1		/* our BID (1 byte)  */
#define	DG_BURNIN	DG_BID+1	/* Burnin jumper present, */
					/* 0 = not present (1 byte) */
#define DG_ST		DG_BURNIN+1	/* Self test status (see below) */

/*
 * area used by rom for double trap and warm start information
 */
#define DG_ROM_STATE	DG_ST+4		/* rom state (see below) */
#define ROM_ST_COLD	0x00		/* normal cold start */
#define ROM_ST_WARM	0x01		/* warm start */
#define ROM_ST_DTRAP	0x02		/* double trap info */
#define ROM_ST_SINGLE	0x04		/* don't try to stop other CPUs */
#define ROM_ST_NOAUTO	0x08		/* force no autoboot */
#define ROM_ST_AUTO	0x10		/* force autoboot */
#define ROM_ST_CMD	0x20		/* execute command if autoboot */
#define ROM_ST_INTR	0x40		/* control-C */

#define	DG_ROM_PC	DG_ROM_STATE+1	/* saved pc for double trap */
#define	DG_ROM_NPC	DG_ROM_PC+4	/* saved npc for double trap */
#define	DG_ROM_TBR	DG_ROM_NPC+4	/* saved tbr for double trap */
#define	DG_ROM_PSR	DG_ROM_TBR+4	/* saved psr for double trap */
#define	DG_ROM_FCR	DG_ROM_PSR+4	/* saved fcr for double trap */
#define DG_ROM_O7	DG_ROM_FCR+4	/* saved %o7 for double trap */
#define DG_TEMP		DG_ROM_O7+4	/* start of scratch area */

/*
 * macros for accessing test parameters in DGRAM  
 */
#define	SETFLAG(flag) \
	set	(DG_FLAGS<<3),r_temp1;		\
	lduba	[r_temp1]ASI_DIAG_RAM,r_temp2;	\
	or	r_temp2,(flag),r_temp2;		\
	stba	r_temp2,[r_temp1]ASI_DIAG_RAM

#define	CLRFLAG(flag) \
	set	(DG_FLAGS<<3),r_temp1;		\
	lduba	[r_temp1]ASI_DIAG_RAM,r_temp2;	\
	andn	r_temp2,flag,r_temp2;		\
	stba	r_temp2,[r_temp1]ASI_DIAG_RAM

#define	TSTFLAG(flag) \
	set	(DG_FLAGS<<3),r_temp1;		\
	lduba	[r_temp1]ASI_DIAG_RAM,r_temp2;	\
	andcc	r_temp2,(flag),r_null

#define PUTDGB(addr,reg) \
	set	(addr<<3),r_temp2;		\
	stba	reg,[r_temp2]ASI_DIAG_RAM

#define GETDGB(addr,reg) \
	set	(addr<<3),r_temp2;		\
	lduba	[r_temp2]ASI_DIAG_RAM,reg

/*
 *	Kbus Diagnostic Transaction defines...
 *	ASI definitions:
 */
#define ASI_KDT	0x74	/* Kbus Diagnostic Transaction Space */
#define ASI_PDR	0x24	/* Physical Diagnostic Register Space */

/*
 *	PDR register bits:
 */
#define PDR_PM0	0x01	/* Physical Match 0 - 23:16 (active low) */
#define PDR_PM1	0x02	/* Physical Match 1 - 31:24 (active low) */
#define PDR_OWN	0x04	/* Own status (active low) */
#define PDR_VAL	0x08	/* Valid status (active low) */
#define PDR_TT	0x70	/* Mask for encode transaction type (see below) */

/*
 *	PDR register encoded transaction types:
 */
#define ETT_FLUSH	1	/* flush (IOB to flush a block to memory) */
#define ETT_IOW		2	/* IO write */
#define ETT_IORW	3	/* IO Read or IO Read-Modify-Write */
#define ETT_WI		4	/* Write & Invalidate */
#define ETT_IOB		5	/* IOB */
#define ETT_CR		6	/* Cacheable Read */
#define ETT_RI		7	/* Read & Invalidate */

/*
 *	Diagnostic Probe Transaction encodings:
 */
#define	DT_PDRLD	0	/* Load PDR register */
#define DT_TAGLD	1	/* Load Bus Watcher Tags */
#define DT_COCV		4	/* Clear OWN and VAL */
#define DT_COSV		5	/* Clear OWN, set VAL */
#define DT_SOCV		6	/* Set OWN, clear VAL */
#define DT_SOSV		7	/* Set OWN and VAL */

/**********************************************************************/
#endif Series4

#ifdef Series5
/**********************************************************************
 * diagnostic ram partitions:
 *
 * Note: DG_PARAM must start at beginning of DGRAM for quick kernel 
 *       access.
 */
#define DG_PARAM	0x000	/* start of OS and diag params (see below) */
#define DG_ERROR_BLOCK	0x100	/* start of error block */
#define DG_EB_NREGS	49	/* # of regs saved in error block */
#define DG_FP_NREGS	34	/* # of fp registers dumped */
#define DG_CONFIG	0x200	/* start of configuration table (see below) */
#define DG_VECTOR	0x400	/* start of exception vector table */

/*
 * Parameter block variables (DG_PARAM)
 *
 * Kernel area must be at the beginning of DGRAM...
 * while the kernel is running we keep a software copy of the sic ipr here.
 */
#define	DG_CUR_IPR	DG_PARAM	/* software copy of sic ipr */

/*
 * variable which indicates DGRAM has been initialized
 */
#define DGRAM_STATE 	DG_CUR_IPR+16	/* DGRAM state. Invalid if !="GOOD" */
#define DGRAM_STATE_GOOD 	(('G'<<24)|('O'<<16)|('O'<<8)|('D'))

/*
 * area for warm start information
 */
#define DG_RESET_TYPE	DGRAM_STATE+4	/* "COLD" or "WARM" */
#define DG_RESET_COLD	(('C'<<24)|('O'<<16)|('L'<<8)|('D'))
#define DG_RESET_WARM	(('W'<<24)|('A'<<16)|('R'<<8)|('M'))
#define DG_WARM_VECTOR	DG_RESET_TYPE+4	/* warm reset vector */

/*
 * area used by rom for double trap and warm start information
 */
#define DG_ROM_STATE	DG_WARM_VECTOR+4 /* rom state (see flags below) */
#define ROM_ST_COLD	0x00		/* normal cold start */
#define ROM_ST_WARM	0x01		/* warm start */
#define ROM_ST_DTRAP	0x02		/* double trap info */
#define ROM_ST_SINGLE	0x04		/* don't try to stop other CPUs */
#define ROM_ST_NOAUTO	0x08		/* force no autoboot */
#define ROM_ST_AUTO	0x10		/* force autoboot */
#define ROM_ST_CMD	0x20		/* execute command if autoboot */
#define ROM_ST_INTR	0x40		/* control-C */

#define	DG_ROM_PC	DG_ROM_STATE+1	/* saved pc for double trap */
#define	DG_ROM_NPC	DG_ROM_PC+4	/* saved npc for double trap */
#define	DG_ROM_TBR	DG_ROM_NPC+4	/* saved tbr for double trap */
#define	DG_ROM_PSR	DG_ROM_TBR+4	/* saved psr for double trap */
#define	DG_ROM_FCR	DG_ROM_PSR+4	/* saved fcr for double trap */
#define DG_ROM_O7	DG_ROM_FCR+4	/* saved %o7 for double trap */
#define	DG_ROM_CSUM	DG_ROM_O7+4	/* checksum of state area */

#define DG_FLAGS	DG_ROM_CSUM+32	/* test flags (1 byte) */
#define DG_TEST		DG_FLAGS+1	/* test # and test index (2 bytes) */
#define DG_ERROR	DG_TEST+2	/* error code (1 byte) */
#define DG_LED1		DG_TEST		/* 1st LED value displayed */
#define DG_LED2		DG_ERROR	/* 2nd LED value displayed */

#define DG_CMD		DG_ERROR+1	/* test command (1 byte) */
#define DG_LPCNT	DG_CMD+1	/* loop counter (4 bytes) */
#define DG_CODE1	DG_LPCNT+4	/* 1st LED code displayed (2 bytes) */
#define DG_CODE2	DG_CODE1+2	/* 2nd LED code displayed (2 bytes) */
#define DG_TESTSW	DG_CODE2+2	/* test switch: 0=test, 1=normal */
					/* (1 byte) */
#define DG_MBID		DG_TESTSW+1	/* BID of master cpu (1 byte) */
#define DG_MS		DG_MBID+1	/* master/slave status (see below) */
#define DG_MS_UNDETERMINED	0	/* Mastership not determined */
#define DG_MS_SLAVE		1	/* slave */
#define DG_MS_MASTER		2	/* master */
#define DG_MS_SLAVE_FAILED	3	/* Slave that failed */
#define DG_MS_MASTER_FAILED	4	/* Master that failed */
#define DG_MS_OLD_MASTER	DG_MS_MASTER_FAILED	

#define DG_BID		DG_MS+1		/* our BID (1 byte)  */
#define	DG_BURNIN	DG_BID+1	/* Burnin jumper, 0 = not present */
#define DG_ST		DG_BURNIN+1	/* Selftest status (see below) */
#define DG_TEMP		DG_ST+4		/* start of scratch area */

/*
 * macros for accessing test parameters in DGRAM  
 */
#define	SETFLAG(flag) \
	set	(DG_FLAGS<<2),r_temp1;		\
	lduba	[r_temp1]ASI_DIAG_RAM,r_temp2;	\
	or	r_temp2,(flag),r_temp2;		\
	stba	r_temp2,[r_temp1]ASI_DIAG_RAM

#define	CLRFLAG(flag) \
	set	(DG_FLAGS<<2),r_temp1;		\
	lduba	[r_temp1]ASI_DIAG_RAM,r_temp2;	\
	andn	r_temp2,flag,r_temp2;		\
	stba	r_temp2,[r_temp1]ASI_DIAG_RAM

#define	TSTFLAG(flag) \
	set	(DG_FLAGS<<2),r_temp1;		\
	lduba	[r_temp1]ASI_DIAG_RAM,r_temp2;	\
	andcc	r_temp2,(flag),r_null

#define PUTDGB(addr,reg) \
	set	(addr<<2),r_temp2;		\
	stba	reg,[r_temp2]ASI_DIAG_RAM

#define GETDGB(addr,reg) \
	set	(addr<<2),r_temp2;		\
	lduba	[r_temp2]ASI_DIAG_RAM,reg

#ifndef SIMULATOR
#define TRIGGER	\
	sta	%g0,[%g0]0xd8
#else
#define TRIGGER	nop
#endif SIMULATOR

/*
 *	Diagnostic ASI defines:
 */
#define ASI_CTEST	0x40	/* Cache Test operations base ASI */
#define ASI_TIR		0x84	/* Test Information Register, 4-bytes, RO */
#define ASI_FTIR	0x85	/* FTLB Test Info Register, 4-bytes, RO */
#define ASI_CTAG	0x90	/* Cache Tag operations base ASI, WO */
#define ASI_CTAG_INV	0x94	/* Cache Tag flash invalidation, WO */
#define ASI_FLUSH	0xb5	/* Read Flush RAM entry, 4-bytes, RO */
#define ASI_CRDAT	0xcf	/* CRDAT Bus state, 4-bytes, RO */
#define ASI_KCB		0xd2	/* Kbus Check Byte Register, 2-bytes, WO */
#define ASI_PDR		0xd4	/* Physical Diagnostic Register, 1-byte, RO */
#define ASI_DGRAM	0xe0	/* Diagnostic RAM, 2K-byte, RW */
#define ASI_KDT		0xf4	/* Diagnostic Transaction Space */
#define ASI_CLR_CORRUPT	0xf8	/* Corrupt Block RAM bit clear, WO */
#define ASI_SET_CORRUPT	0xf9	/* Corrupt Block RAM bit set, WO */

/*
 * Cache test operations
 */
#define CTEST_ET	0x20	/* Enable TIR update */
#define CTEST_NX	0x10	/* No exception on FTLB/GTLB miss */
#define CTEST_SD	0x08	/* Set dirty bit on cache write */
#define CTEST_VAL	0x08	/* Set this bit to get a cache hit */
#define CTEST_INST	0x00	/* Instruction Space */
#define CTEST_SUP	0x01	/* Instruction Space */
#define CTEST_DATA	0x02	/* Data Space */
#define CTEST_I		(ASI_CTEST|CTEST_INST)
#define CTEST_I_ET	(ASI_CTEST|CTEST_INST|CTEST_ET)
#define CTEST_I_SD	(ASI_CTEST|CTEST_INST|CTEST_SD)
#define CTEST_I_ETSD	(ASI_CTEST|CTEST_INST|CTEST_ET|CTEST_SD)
#define CTEST_I_NX	(ASI_CTEST|CTEST_INST|CTEST_NX)
#define CTEST_I_ETNX	(ASI_CTEST|CTEST_INST|CTEST_ET|CTEST_NX)
#define CTEST_I_NXSD	(ASI_CTEST|CTEST_INST|CTEST_NX|CTEST_SD)
#define CTEST_I_ETNXSD	(ASI_CTEST|CTEST_INST|CTEST_ET|CTEST_NX|CTEST_SD)
#define CTEST_D		(ASI_CTEST|CTEST_DATA)
#define CTEST_D_ET	(ASI_CTEST|CTEST_DATA|CTEST_ET)
#define CTEST_D_SD	(ASI_CTEST|CTEST_DATA|CTEST_SD)
#define CTEST_D_ETSD	(ASI_CTEST|CTEST_DATA|CTEST_ET|CTEST_SD)
#define CTEST_D_NX	(ASI_CTEST|CTEST_DATA|CTEST_NX)
#define CTEST_D_ETNX	(ASI_CTEST|CTEST_DATA|CTEST_ET|CTEST_NX)
#define CTEST_D_NXSD	(ASI_CTEST|CTEST_DATA|CTEST_NX|CTEST_SD)
#define CTEST_D_ETNXSD	(ASI_CTEST|CTEST_DATA|CTEST_ET|CTEST_NX|CTEST_SD)

/*
 * Cache TAG test operations
 */
#define CTAG_SV		0x08	/* Set Valid Bit */
#define CTAG_SO		0x02	/* Set OWN bit */
#define CTAG_COCV	(ASI_CTAG)
#define CTAG_COSV	(ASI_CTAG|CTAG_SV)
#define CTAG_SOCV	(ASI_CTAG|CTAG_SO)
#define CTAG_SOSV	(ASI_CTAG|CTAG_SV|CTAG_SO)

/*
 *	PDR register bits:
 */
#define PDR_PM0		0x01	/* Physical Match 0 - 23:16 (active high) */
#define PDR_PM1		0x02	/* Physical Match 1 - 31:24 (active high) */
#define PDR_OWN		0x04	/* Own status (active low) */
#define PDR_TT		0xf0	/* Mask for encode transaction type */
				/* (see below) */

/*
 *	PDR register encoded transaction types:
 */
#define ETT_RI		0x80	/* Read & Invalidate */
#define ETT_CR		0x90	/* Cacheable Read */
#define ETT_IOB		0xa0	/* IOB */
#define ETT_WI		0xb0	/* Write & Invalidate */
#define ETT_IORW	0xc0	/* IO Read or IO Read-Modify-Write */
#define ETT_IOW		0xd0	/* IO Write */
#define ETT_DWRIO	0x50	/* Timeout trans, Double Word to RIO */
#define ETT_FLUSH	0xe0	/* flush (IOB to flush a block to memory) */
#define ETT_PROBE	0x70	/* Probe */
#define ETT_PROBE2	0x60	/* Probe? */
#define ETT_PROBE_COCV	0x30	/* Probe: clear own, clear valid */
#define ETT_PROBE_COSV	0x20	/* Probe: clear own, set valid */
#define ETT_PROBE_SOCV	0x10	/* Probe: set own, clear valid */
#define ETT_PROBE_SOSV	0x00	/* Probe: set own, set valid */

/*
 *	Diagnostic Probe Transaction encodings:
 */
#define	DT_PDRLD	0	/* Load PDR register */
#define DT_PMODIFY	3	/* PMODIFY cycle */
#define DT_COCV		4	/* Load tags, clear own, clear valid */
#define DT_COSV		5	/* Load tags, clear own, set valid */
#define DT_SOCV		6	/* Load tags, set own, clear valid */
#define DT_SOSV		7	/* Load tags, set own, set valid */

/**********************************************************************/
#endif Series5

#ifdef Series6
/**********************************************************************
 * diagnostic ram partitions:
 *
 * NOTE: for Series6, all 4-byte DGRAM variables must be 
 *	 4-byte aligned
 */
#define DG_PARAM	0x100000 /* start of boot parameter block */
#define DG_PARAM_END	0x100800 /* end of boot parameter block */

#define DG_ERROR_BLOCK	0x100800 /* start of error block */
#define DG_ERROR_END	0x101000 /* end of error block */
#define DG_EB_NREGS	69	 /* # of regs saved in error block */
#define DG_FP_NREGS	34	 /* # of fp registers dumped */

#define DG_CONFIG	0x101000 /* start of config table */
#define DG_CONFIG_END	0x101800 /* end of config table */

#define DG_VECTOR	0x101800 /* exception vector table */
#define DG_VECTOR_END	0x102000 /* end of exception vector table */

/*
 * Boot Parameter block variables (DG_PARAM)
 *
 * The kernel keeps the cpu number here
 */
#define	DG_CPU_NUM	DG_PARAM	

/*
 * Series6 replacement for CPUSTAT reg (see cpuboard.h) 
 */
#define DG_CPUSTAT		DG_CPU_NUM+16	
#define CPUSTAT_VALID		(('C'<<24)|('V'<<16))
#define CPUSTAT_VALID_MASK	0xFFFF0000

/* 
 * DGRAM state. Invalid if !="GOOD" 
 */
#define DGRAM_STATE 		DG_CPUSTAT+4	
#define DGRAM_STATE_GOOD 	(('G'<<24)|('O'<<16)|('O'<<8)|('D'))

/*
 * area for warm start information
 */
#define DG_RESET_TYPE	DGRAM_STATE+4	/* "COLD" or "WARM" */
#define DG_RESET_COLD	(('C'<<24)|('O'<<16)|('L'<<8)|('D'))
#define DG_RESET_WARM	(('W'<<24)|('A'<<16)|('R'<<8)|('M'))
#define DG_WARM_VECTOR	DG_RESET_TYPE+4		/* warm reset vector */

/*
 * area used by rom for double trap and warm start information
 */
#define DG_ROM_STATE	DG_WARM_VECTOR+4 /* rom state (see flags below) */
#define ROM_ST_VALID	(('S'<<24)|('V'<<16)|(0<<8)|(0)) /* most significant 16 bits */
#define ROM_ST_MASK	0xffff		/* mask for flags */
#define ROM_ST_COLD	0x0000		/* normal cold start */
#define ROM_ST_WARM	0x0001		/* warm start */
#define ROM_ST_ERROR 	0x0002		/* error mode reset occurred */
#define ROM_ST_DTRAP	0x0004		/* error mode reset info valid */
#define ROM_ST_SINGLE	0x0008		/* don't try to stop other CPUs */
#define ROM_ST_NOAUTO	0x0010		/* force no autoboot */
#define ROM_ST_AUTO	0x0020		/* force autoboot */
#define ROM_ST_CMD	0x0040		/* execute command if autoboot */
#define ROM_ST_INTR	0x0080		/* control-C */

/*
 * Registers saved on DTRAP...
 */
#define	DG_ROM_FCR	DG_ROM_STATE+4	/* saved fcr */
#define	DG_ROM_PC	DG_ROM_FCR+4	/* saved pc */
#define	DG_ROM_NPC	DG_ROM_PC+4	/* saved npc */
#define	DG_ROM_TBR	DG_ROM_NPC+4	/* saved tbr */
#define	DG_ROM_PSR	DG_ROM_TBR+4	/* saved psr */
#ifdef viking
#define DG_ROM_MCNTL	DG_ROM_PSR+4	/* saved MMU control */
#define DG_ROM_MFSR	DG_ROM_MCNTL+4	/* saved MMU fault/status */
#endif viking
#ifdef cypress
#define DG_ROM_SCR	DG_ROM_PSR+4	/* saved MMU control */
#define DG_ROM_MFSR	DG_ROM_SCR+4	/* saved MMU fault/status */
#endif cypress
#define DG_ROM_MFAR	DG_ROM_MFSR+4	/* saved MMU fault address */
#define DG_ROM_CNTX	DG_ROM_MFAR+4	/* saved context */
#define DG_ROM_CNTXP	DG_ROM_CNTX+4	/* saved contex table ptr */
#ifdef viking
#define DG_ROM_MXCTL	DG_ROM_CNTXP+4	/* saved MXCC control */
#define DG_ROM_MXRST	DG_ROM_MXCTL+4	/* saved MXCC reset */
#define DG_ROM_MXER0	DG_ROM_MXRST+4  /* saved MXCC error (high) */
#define DG_ROM_MXER1	DG_ROM_MXER0+4  /* saved MXCC error (low) */
#define DG_ROM_MXST0	DG_ROM_MXER1+4  /* saved MXCC status (high) */
#define DG_ROM_MXST1	DG_ROM_MXST0+4  /* saved MXCC status (low) */
#define DG_ROM_O7	DG_ROM_MXST1+4  /* saved %o7 */
#endif viking
#ifdef cypress
#define DG_ROM_AFSR	DG_ROM_CNTXP+4	/* saved AFSR */
#define DG_ROM_AFAR	DG_ROM_AFSR+4	/* saved AFAR */
#define DG_ROM_RR	DG_ROM_AFAR+4	/* saved RR */
#define DG_ROM_PAD	DG_ROM_RR+12	/* pad to align with viking */
#define DG_ROM_O7	DG_ROM_PAD+4	/* saved %o7 */
#endif cypress
#define	DG_ROM_CSUM	DG_ROM_O7+4	/* checksum of state area */

#define DG_FLAGS	DG_ROM_CSUM+32	/* test flags (4 bytes) */
#define DG_TEST		DG_FLAGS+4	/* test # (4 bytes) */
#define DG_INDEX	DG_TEST+4	/* test loop index (4 bytes) */
#define DG_ERROR	DG_INDEX+4	/* error code (4 bytes) */
#define DG_LED1		DG_TEST		/* 1st LED value displayed */
#define DG_LED2		DG_ERROR	/* 2nd LED value displayed */

#define DG_CMD		DG_ERROR+4	/* test command (4 bytes) */
#define DG_LPCNT	DG_CMD+4	/* loop counter (4 bytes) */
#define DG_CODE1	DG_LPCNT+4	/* 1st LED code displayed (4 bytes) */
#define DG_CODE2	DG_CODE1+4	/* 2nd LED code displayed (4 bytes) */
#define DG_TESTSW	DG_CODE2+4	/* test switch: 0=test, 1=normal */
					/* (4 bytes) */
#define DG_MBID		DG_TESTSW+4	/* BID of master cpu (4 bytes) */
#define DG_MS		DG_MBID+4	/* master/slave status (see below) */
#define DG_MS_UNDETERMINED	0	/* Mastership not determined */
#define DG_MS_SLAVE		1	/* slave */
#define DG_MS_MASTER		2	/* master */
#define DG_MS_SLAVE_FAILED	3	/* Slave that failed */
#define DG_MS_MASTER_FAILED	4	/* Master that failed */
#define DG_MS_OLD_MASTER	DG_MS_MASTER_FAILED	

#define DG_BID		DG_MS+4		/* our BID (4 bytes)  */
#define	DG_BURNIN	DG_BID+4	/* Burnin jumper, 0 = not present */
#define DG_ST		DG_BURNIN+4	/* Selftest status (see below) */
#define DG_CPU_DONE	DG_ST+4		/* CPU passed Self test */
#define DG_DIAGMODE	DG_CPU_DONE+4	/* DIAGMODE: 0 = normal, 1 = short */
#define DG_MASTER_OK	DG_DIAGMODE+4	/* master OK flag */
#define DG_CDB		DG_MASTER_OK+4	/* flag for CDB test active */
#define DG_FREQ		DG_CDB+4	/* flag for frequency info */
#define DG_VFREQ	DG_FREQ+4	/* stated/measured processor MHZ */
#define DG_MFREQ	DG_VFREQ+4	/* measured MBus MHZ */
#define DG_CMDFLAG	DG_MFREQ+4	/* command acknowledge flag */
#define DG_ARGC		DG_CMDFLAG+4	/* command argument count */
#define DG_ARGV		DG_ARGC+4	/* arg vectors (8 MAX!) */
#define DG_EM_NO_INV	(DG_ARGV+(8*4))	/* No invalidation on EM reset */
#define DG_TEMP		DG_EM_NO_INV+4	/* start of scratch area */

#define DG_TEMP_END	DG_PARAM_END-4	/* last scratch location */
#define DG_TEMP_SIZE	((DG_PARAM_END-DG_TEMP)/4)
					/* scratch size in words */

#define FREQ_VALID	(('F'<<24)|('R'<<16)|('E'<<8)|('Q'))
#define MASTER_CONT	(('C'<<24)|('O'<<16)|('N'<<8)|('T'))
#define CDB_TEST	(('T'<<24)|('E'<<16)|('S'<<8)|('T'))
#define EM_NO_INV	(('N'<<24)|('O'<<16)|('I'<<8)|('N'))

/*
 * macros for accessing test parameters in DGRAM  
 */
#define	SETFLAG(flag) 				\
	set	DG_FLAGS,r_temp1;		\
	lda	[r_temp1]ASI_KBUS_ID,r_temp2;	\
	or	r_temp2,(flag),r_temp2;		\
	sta	r_temp2,[r_temp1]ASI_KBUS_ID

#define	CLRFLAG(flag) 				\
	set	DG_FLAGS,r_temp1;		\
	lda	[r_temp1]ASI_KBUS_ID,r_temp2;	\
	andn	r_temp2,flag,r_temp2;		\
	sta	r_temp2,[r_temp1]ASI_KBUS_ID

#define	TSTFLAG(flag) 				\
	set	DG_FLAGS,r_temp1;		\
	lda	[r_temp1]ASI_KBUS_ID,r_temp2;	\
	andcc	r_temp2,flag,r_null

#define PUTDGW(addr,reg) 			\
	set	addr,r_temp1;			\
	sta	reg,[r_temp1]ASI_KBUS_ID

#define GETDGW(addr,reg) 			\
	set	addr,r_temp1;			\
	lda	[r_temp1]ASI_KBUS_ID,reg

#define PUTDGB(addr,reg) 			\
	set	addr,r_temp1;			\
	lda	[r_temp1]ASI_KBUS_ID,r_temp1;	\
	set	0xff000000,r_temp2;		\
	srl	r_temp2,((addr&3)<<3),r_temp2;	\
	andn	r_temp1,r_temp2,r_temp1;	\
	sll	reg,24,r_temp2;			\
	srl	r_temp2,((addr&3)<<3),r_temp2;	\
	or	r_temp1,r_temp2,r_temp2;	\
	set	addr,r_temp1;			\
	sta	r_temp2,[r_temp1]ASI_KBUS_ID
	
#define GETDGB(addr,reg) 			\
	set	addr,r_temp1;			\
	lduba	[r_temp1]ASI_KBUS_ID,reg

#define DGINFO(slot,reg,) 			\
	set	DG_SLOT_INFO,reg; 		\
	sub	slot,1,r_temp1; 		\
	sll	r_temp1,DG_SLOT_SHIFT,r_temp1;	\
	add	reg,r_temp1,reg
		
#define TRIG_TYPE_BIST	0x700000	/* before BIST executed */
#define TRIG_TYPE_ERROR	0x330000	/* for test_error() */
#define TRIG_TYPE_UE	0x330010	/* for unexpected exception (UE--xx) */
#define TRIG_TYPE_AE	0x330020	/* for async error. Contents of MXCC_ERROR  */
					/* (2 sta instructions) are written to this */
					/* address 		    		    */

#ifdef MSIM
#define TRIGGER(type)	\
	nop
#else
#define TRIGGER(type)	\
	set	type,%o0;	\
	lda	[%o0]ASI_KBUS_ID,%g0
#endif MSIM


/*
 *	Mbus (L3 cache) Probe Transaction encodings:
 */
#define	CPROBE		0x00	/* Cache Probe (updates CTI register) */
#define CPROBE_ARM	0x01	/* CTI register enable probe */
#define CPROBE_SC	0x02	/* Set Corrupt */
#define CPROBE_CC	0x03	/* Clear Corrupt */
#define CPROBE_TAG	0x10	/* L3 Cache Tag Write, modify S,V,O,D */
#define CPROBE_TAG_S	0x08	/* OR'ed with CPROBE_TAG, sets Space bit */  
#define CPROBE_TAG_V	0x04	/* OR'ed with CPROBE_TAG, sets Valid bit */  
#define CPROBE_TAG_O	0x02	/* OR'ed with CPROBE_TAG, sets Own bit */  
#define CPROBE_TAG_D	0x01	/* OR'ed with CPROBE_TAG, sets Dirty bit */  

/*
 * CTI register bits:
 */
#define CTI_BANK	0x00000001	/* odd/even bank valid bit */
#define CTI_ODD		0x0000ffbe	/* mask for odd bank info */
#define CTI_O_C		0x00000002	/* odd bank "C" bit (corrupt) */
#define CTI_O_D		0x00000004	/* odd bank "D" bit (dirty) */
#define CTI_O_O		0x00000008	/* odd bank "O" bit (own) */
#define CTI_O_V		0x00000010	/* odd bank "V" bit (valid) */
#define CTI_O_M		0x00000020	/* odd bank "M" bit (match) */
#define CTI_O_TAG	0x00007f80	/* odd bank tag data */
#define CTI_O_S		0x00008000	/* odd bank "S" bit (space) */
#define CTI_EVEN	0xffbe0000	/* mask for even bank info */
#define CTI_E_C		0x00020000	/* even bank "C" bit (corrupt) */
#define CTI_E_D		0x00040000	/* even bank "D" bit (dirty) */
#define CTI_E_O		0x00080000	/* even bank "O" bit (own) */
#define CTI_E_V		0x00100000	/* even bank "V" bit (valid) */
#define CTI_E_M		0x00200000	/* even bank "M" bit (match) */
#define CTI_E_TAG	0x7f800000	/* even bank tag data */
#define CTI_E_S		0x80000000	/* even bank "S" bit (space) */

/*
 *	Kbus watcher probe transaction encodings:
 */
#define	WPROBE		0x00	/* Kbus Probe (updates KTI register) */
#define WPROBE_ROM_EN	0x01	/* EAROM Write enable */
#define WPROBE_ROM_DIS	0x02	/* EAROM Write disable */
#define WPROBE_KI	0x03	/* Interrupt Register probe write */
#define WPROBE_TAG	0x04	/* Watcher Tag Write, modify S,O,V */
#define WPROBE_TAG_V	0x01	/* OR'ed with WPROBE_TAG, sets Valid bit */
#define WPROBE_TAG_O	0x02	/* OR'ed with WPROBE_TAG, sets Own bit */
#define WPROBE_TAG_S	0x08	/* OR'ed with WPROBE_TAG, sets Space bit */

#define WPROBE_IR_MSK	0x00000F00 /* mask for interrupt level in IR write */
#define WPROBE_IR_SHFT	0x8 	   /* shift value interrupt level in IR */

/*
 * WTI register bits:
 */
#define WTI_BANK	0x00000001	/* odd/even bank valid bit */
#define WTI_ODD		0x0000ffb8	/* mask for odd bank info */
#define WTI_O_O		0x00000008	/* odd bank "O" bit (own) */
#define WTI_O_V		0x00000010	/* odd bank "V" bit (valid) */
#define WTI_O_M		0x00000020	/* odd bank "M" bit (match) */
#define WTI_O_TAG	0x00007f80	/* odd bank tag data */
#define WTI_O_S		0x00008000	/* odd bank "S" bit (space) */
#define WTI_EVEN	0xffb80000	/* mask for even bank info */
#define WTI_E_O		0x00080000	/* even bank "O" bit (own) */
#define WTI_E_V		0x00100000	/* even bank "V" bit (valid) */
#define WTI_E_M		0x00200000	/* even bank "M" bit (match) */
#define WTI_E_TAG	0x7f800000	/* even bank tag data */
#define WTI_E_S		0x80000000	/* even bank "S" bit (space) */

/*
 * Self test TLB entry usage...
 */
#ifdef viking
#define TLB_INDEX_SHIFT	12		/* Convert TLB index to offset */
#define TLB_ENTRY(x)	((x)<<TLB_INDEX_SHIFT) /* TLB entry # to TLB address */
#endif viking

#ifdef cypress
#ifdef cypress625
#define TLB_INDEX_SHIFT	4		/* Convert TLB index to offset */
#define	TLB_NEXT	8		/* Offset to next RAM/CAM entry */
#else
#define TLB_INDEX_SHIFT	3		/* Convert TLB index to offset */
#define	TLB_NEXT	4		/* Offset to next RAM/CAM entry */
#endif cypress625
#define TLB_ENTRY(x)	((x)<<TLB_INDEX_SHIFT) /* TLB entry # to TLB address */
#endif cypress

#define TLB_ENT_TEMP	0		/* used for scratch purposes */ 
#define TLB_ENT_FE	1		/* virtual space "FE" */
#define TLB_ENT_FC	2		/* virtual space "FC" */
#define TLB_ENT_FD	3		/* virtual space "FD" */
#define TLB_ENT_FF	4		/* virtual space "FF" */
#define TLB_ENT_F0	5		/* virtual space "F0" */
#define TLB_ENT_IO	6		/* first IO space */ 
#define TLB_ENT_NUMIO	16		/* # of IO space entries */
#define TLB_ENT_END	TLB_ENT_IO+TLB_ENT_NUMIO /* next available entry */


#define NOWN_SPACE 	0xfd000000	/* virtual space which maps to Mbus space "B" */ 
#define OWN_SPACE 	0xfc000000	/* virtual space which maps to Mbus space "9" */ 

/**********************************************************************/
#endif /* Series6 */ 

#ifdef Series7 
/**********************************************************************
 * diagnostic ram partitions:
 *
 * For Series7, the DGRAM is shared by up to 4 local processors.
 * The DGRAM is therefore partitioned into 4 logical blocks, each
 * block reserved for a specific local processor.  The Following
 * map illustrates how the DGRAM is logically partitioned:
 *
 *      ====== +================+  === 
 *      100000 |                |   ^
 *             |    DG_PARAM    |   |
 *        03ff |    (1Kbytes)   |   |
 *             +----------------+   |
 *        0400 |                |   |
 *             | DG_ERROR_BLOCK |   |
 *        07ff |    (1Kbytes)   |   
 *             +----------------+   Processor 0 (MID 0x8)
 *        0800 |                |   
 *             |    DG_CONFIG   |   |
 *        0bff |    (1Kbytes)   |   |
 *             +----------------+   |
 *        0c00 |                |   |
 *             |    DG_VECTOR   |   |
 *      100fff |    (1Kbytes)   |   v
 *      ====== +================+  ===
 *      101000 |                |   ^
 *             |    DG_PARAM    |   |
 *        13ff |    (1Kbytes)   |   |
 *             +----------------+   |
 *        1400 |                |   |
 *             | DG_ERROR_BLOCK |   |
 *        17ff |    (1Kbytes)   |   
 *             +----------------+   Processor 1 (MID 0x9)
 *        1800 |                |   
 *             |    DG_CONFIG   |   |
 *        1bff |    (1Kbytes)   |   |
 *             +----------------+   |
 *        1c00 |                |   |
 *             |    DG_VECTOR   |   |
 *      101fff |    (1Kbytes)   |   v
 * 	====== +================+  === 
 *      102000 |                |   ^
 *             |    DG_PARAM    |   |
 *        23ff |    (1Kbytes)   |   |
 *             +----------------+   |
 *        2400 |                |   |
 *             | DG_ERROR_BLOCK |   |
 *        27ff |    (1Kbytes)   |   
 *             +----------------+   Processor 2 (MID 0xA)
 *        2800 |                |   
 *             |    DG_CONFIG   |   |
 *        2bff |    (1Kbytes)   |   |
 *             +----------------+   |
 *        2c00 |                |   |
 *             |    DG_VECTOR   |   |
 *      102fff |    (1Kbytes)   |   v
 *      ====== +================+  ===
 *      103000 |                |   ^
 *             |    DG_PARAM    |   |
 *        33ff |    (1Kbytes)   |   |
 *             +----------------+   |
 *        3400 |                |   |
 *             | DG_ERROR_BLOCK |   |
 *        37ff |    (1Kbytes)   |   
 *             +----------------+   Processor 3 (MID 0xB)
 *        3800 |                |   
 *             |    DG_CONFIG   |   |
 *        3bff |    (1Kbytes)   |   |
 *             +----------------+   |
 *        3c00 |                |   |
 *             |    DG_VECTOR   |   |
 *      103fff |    (1Kbytes)   |   v
 *      ====== +================+  ===
 *
 *
 */
#define DG_PARAM	0x00100000 /* start of boot parameter block */
#define DG_PARAM_END	0x00100400 /* end of boot parameter block */

#define DG_ERROR_BLOCK	0x00100400 /* start of error block */
#define DG_ERROR_END	0x00100800 /* end of error block */
#define DG_EB_NREGS	69	 /* # of regs saved in error block */
#define DG_FP_NREGS	34	 /* # of fp registers dumped */

#define DG_CONFIG	0x00100800 /* start of config table */
#define DG_CONFIG_END	0x00100c00 /* end of config table */

#define DG_VECTOR	0x00100c00 /* exception vector table */
#define DG_VECTOR_END	0x00101000 /* end of exception vector table */

/*
 * Boot Parameter block variables (DG_PARAM)
 *
 * Reserve the first location for kernel use 
 */
#define	DG_CPU_NUM		DG_PARAM	
/*
 * Second location is the configuration table format revision #
 */
#define DG_DGREV		DG_CPU_NUM+4
/*
 * Series7 replacement for CPUSTAT reg (see cpuboard.h) 
 */
#define DG_CPUSTAT		DG_DGREV+4	
#define CPUSTAT_VALID		(('C'<<24)|('V'<<16))
#define CPUSTAT_VALID_MASK	0xFFFF0000

/* 
 * DGRAM state. Invalid if !="GOOD" 
 */
#define DGRAM_STATE 		DG_CPUSTAT+4	
#define DGRAM_STATE_GOOD 	(('G'<<24)|('O'<<16)|('O'<<8)|('D'))

/*
 * area for warm start information
 */
#define DG_RESET_TYPE	DGRAM_STATE+4	/* "COLD" or "WARM" */
#define DG_RESET_COLD	(('C'<<24)|('O'<<16)|('L'<<8)|('D'))
#define DG_RESET_WARM	(('W'<<24)|('A'<<16)|('R'<<8)|('M'))
#define DG_WARM_VECTOR	DG_RESET_TYPE+4		/* warm reset vector */

/*
 * area used by rom for double trap and warm start information
 */
#define DG_ROM_STATE	DG_WARM_VECTOR+4 /* rom state (see flags below) */
#define ROM_ST_VALID	(('S'<<24)|('V'<<16)|(0<<8)|(0)) /* most significant 16 bits */
#define ROM_ST_MASK	0xffff		/* mask for flags */
#define ROM_ST_COLD	0x0000		/* normal cold start */
#define ROM_ST_WARM	0x0001		/* warm start */
#define ROM_ST_ERROR 	0x0002		/* error mode reset occurred */
#define ROM_ST_DTRAP	0x0004		/* error mode reset info valid */
#define ROM_ST_SINGLE	0x0008		/* don't try to stop other CPUs */
#define ROM_ST_NOAUTO	0x0010		/* force no autoboot */
#define ROM_ST_AUTO	0x0020		/* force autoboot */
#define ROM_ST_CMD	0x0040		/* execute command if autoboot */
#define ROM_ST_INTR	0x0080		/* control-C */

/*
 * Registers saved on DTRAP...
 */
#define	DG_ROM_FCR	DG_ROM_STATE+4	/* saved fcr */
#define	DG_ROM_PC	DG_ROM_FCR+4	/* saved pc */
#define	DG_ROM_NPC	DG_ROM_PC+4	/* saved npc */
#define	DG_ROM_TBR	DG_ROM_NPC+4	/* saved tbr */
#define	DG_ROM_PSR	DG_ROM_TBR+4	/* saved psr */
#ifdef viking
#define DG_ROM_MCNTL	DG_ROM_PSR+4	/* saved MMU control */
#define DG_ROM_MFSR	DG_ROM_MCNTL+4	/* saved MMU fault/status */
#endif viking
#ifdef cypress
#define DG_ROM_SCR	DG_ROM_PSR+4	/* saved MMU control */
#define DG_ROM_MFSR	DG_ROM_SCR+4	/* saved MMU fault/status */
#endif cypress
#define DG_ROM_MFAR	DG_ROM_MFSR+4	/* saved MMU fault address */
#define DG_ROM_CNTX	DG_ROM_MFAR+4	/* saved context */
#define DG_ROM_CNTXP	DG_ROM_CNTX+4	/* saved contex table ptr */
#ifdef viking
#define DG_ROM_MXCTL	DG_ROM_CNTXP+4	/* saved MXCC control */
#define DG_ROM_MXRST	DG_ROM_MXCTL+4	/* saved MXCC reset */
#define DG_ROM_MXER0	DG_ROM_MXRST+4  /* saved MXCC error (high) */
#define DG_ROM_MXER1	DG_ROM_MXER0+4  /* saved MXCC error (low) */
#define DG_ROM_MXST0	DG_ROM_MXER1+4  /* saved MXCC status (high) */
#define DG_ROM_MXST1	DG_ROM_MXST0+4  /* saved MXCC status (low) */
#define DG_ROM_O7	DG_ROM_MXST1+4  /* saved %o7 */
#endif viking
#ifdef cypress
#define DG_ROM_AFSR	DG_ROM_CNTXP+4	/* saved AFSR */
#define DG_ROM_AFAR	DG_ROM_AFSR+4	/* saved AFAR */
#define DG_ROM_RR	DG_ROM_AFAR+4	/* saved RR */
#define DG_ROM_PAD	DG_ROM_RR+12	/* pad to align with viking */
#define DG_ROM_O7	DG_ROM_PAD+4	/* saved %o7 */
#endif cypress
#define	DG_ROM_CSUM	DG_ROM_O7+4	/* checksum of state area */

#define DG_FLAGS	DG_ROM_CSUM+32	/* test flags (4 bytes) */
#define DG_TEST		DG_FLAGS+4	/* test # (4 bytes) */
#define DG_INDEX	DG_TEST+4	/* test loop index (4 bytes) */
#define DG_ERROR	DG_INDEX+4	/* error code (4 bytes) */
#define DG_LED1		DG_TEST		/* 1st LED value displayed */
#define DG_LED2		DG_ERROR	/* 2nd LED value displayed */

#define DG_CMD		DG_ERROR+4	/* test command (4 bytes) */
#define DG_LPCNT	DG_CMD+4	/* loop counter (4 bytes) */
#define DG_CODE1	DG_LPCNT+4	/* 1st LED code displayed (4 bytes) */
#define DG_CODE2	DG_CODE1+4	/* 2nd LED code displayed (4 bytes) */
#define DG_TESTSW	DG_CODE2+4	/* test switch: 0=test, 1=normal */
					/* (4 bytes) */
#define DG_MBID		DG_TESTSW+4	/* BID of master cpu (4 bytes) */
#define DG_BID		DG_MBID+4	/* our BID (4 bytes)  */
#define	DG_BURNIN	DG_BID+4	/* Burnin jumper, 0 = not present */
#define DG_ST		DG_BURNIN+4	/* Selftest status (see below) */
#define DG_CPU_DONE	DG_ST+4		/* CPU passed Self test */
#define DG_DIAGMODE	DG_CPU_DONE+4	/* DIAGMODE: 0 = normal, 1 = short */
#define DG_CDB		DG_DIAGMODE+4	/* flag for CDB test active */
#define DG_CMDFLAG	DG_CDB+4	/* command acknowledge flag */
#define DG_ARGC		DG_CMDFLAG+4	/* command argument count */
#define DG_ARGV		DG_ARGC+4	/* arg vectors (8 MAX!) */
#define DG_EM_NO_INV	(DG_ARGV+(8*4))	/* No invalidation on EM reset */
#define DG_TEMP		DG_EM_NO_INV+4	/* start of scratch area */

#define DG_TEMP_END	DG_PARAM_END-4	/* last scratch location */
#define DG_TEMP_SIZE	((DG_PARAM_END-DG_TEMP)/4)
					/* scratch size in words */

#define CDB_TEST	(('T'<<24)|('E'<<16)|('S'<<8)|('T'))
#define EM_NO_INV	(('N'<<24)|('O'<<16)|('I'<<8)|('N'))

/*
 * macros for accessing test parameters in DGRAM  
 */
#define	SETFLAG(flag) 				\
	set	KID_MIDR,r_temp1;		\
	lda	[r_temp1]ASI_KBUS_ID,r_temp3;	\
	and	r_temp3,3,r_temp3;		\
	sll	r_temp3,12,r_temp3;		\
	set	DG_FLAGS,r_temp1;		\
	or	r_temp1,r_temp3,r_temp1;	\
	lda	[r_temp1]ASI_KBUS_ID,r_temp2;	\
	or	r_temp2,(flag),r_temp2;		\
	sta	r_temp2,[r_temp1]ASI_KBUS_ID

#define	CLRFLAG(flag) 				\
	set	KID_MIDR,r_temp1;		\
	lda	[r_temp1]ASI_KBUS_ID,r_temp3;	\
	and	r_temp3,3,r_temp3;		\
	sll	r_temp3,12,r_temp3;		\
	set	DG_FLAGS,r_temp1;		\
	or	r_temp1,r_temp3,r_temp1;	\
	lda	[r_temp1]ASI_KBUS_ID,r_temp2;	\
	andn	r_temp2,flag,r_temp2;		\
	sta	r_temp2,[r_temp1]ASI_KBUS_ID

#define	TSTFLAG(flag) 				\
	set	KID_MIDR,r_temp1;		\
	lda	[r_temp1]ASI_KBUS_ID,r_temp3;	\
	and	r_temp3,3,r_temp3;		\
	sll	r_temp3,12,r_temp3;		\
	set	DG_FLAGS,r_temp1;		\
	or	r_temp1,r_temp3,r_temp1;	\
	lda	[r_temp1]ASI_KBUS_ID,r_temp2;	\
	andcc	r_temp2,flag,r_null
/*
 * Macros for accessing DGRAM
 */
#define PUTDGW(addr,reg) 			\
	set	KID_MIDR,r_temp1;		\
	lda	[r_temp1]ASI_KBUS_ID,r_temp3;	\
	and	r_temp3,3,r_temp3;		\
	sll	r_temp3,12,r_temp3;		\
	set	addr,r_temp1;			\
	or	r_temp1,r_temp3,r_temp1;	\
	sta	reg,[r_temp1]ASI_KBUS_ID

#define GETDGW(addr,reg) 			\
	set	KID_MIDR,r_temp1;		\
	lda	[r_temp1]ASI_KBUS_ID,r_temp3;	\
	and	r_temp3,3,r_temp3;		\
	sll	r_temp3,12,r_temp3;		\
	set	addr,r_temp1;			\
	or	r_temp1,r_temp3,r_temp1;	\
	lda	[r_temp1]ASI_KBUS_ID,reg

#define PUTDGH(addr,reg) 			\
	set	KID_MIDR,r_temp1;		\
	lda	[r_temp1]ASI_KBUS_ID,r_temp3;	\
	and	r_temp3,3,r_temp3;		\
	sll	r_temp3,12,r_temp3;		\
	set	addr,r_temp1;			\
	or	r_temp1,r_temp3,r_temp1;	\
	stha	reg,[r_temp1]ASI_KBUS_ID

#define GETDGH(addr,reg) 			\
	set	KID_MIDR,r_temp1;		\
	lda	[r_temp1]ASI_KBUS_ID,r_temp3;	\
	and	r_temp3,3,r_temp3;		\
	sll	r_temp3,12,r_temp3;		\
	set	addr,r_temp1;			\
	or	r_temp1,r_temp3,r_temp1;	\
	lduha	[r_temp1]ASI_KBUS_ID,reg

#define PUTDGB(addr,reg) 			\
	set	KID_MIDR,r_temp1;		\
	lda	[r_temp1]ASI_KBUS_ID,r_temp3;	\
	and	r_temp3,3,r_temp3;		\
	sll	r_temp3,12,r_temp3;		\
	set	addr,r_temp1;			\
	or	r_temp1,r_temp3,r_temp1;	\
	stba	reg,[r_temp1]ASI_KBUS_ID

#define GETDGB(addr,reg) 			\
	set	KID_MIDR,r_temp1;		\
	lda	[r_temp1]ASI_KBUS_ID,r_temp3;	\
	and	r_temp3,3,r_temp3;		\
	sll	r_temp3,12,r_temp3;		\
	set	addr,r_temp1;			\
	or	r_temp1,r_temp3,r_temp1;	\
	lduba	[r_temp1]ASI_KBUS_ID,reg

#define DGINFO(slot,reg,) 			\
	set	KID_MIDR,r_temp1;		\
	lda	[r_temp1]ASI_KBUS_ID,r_temp3;	\
	and	r_temp3,3,r_temp3;		\
	sll	r_temp3,12,r_temp3;		\
	set	DG_SLOT_INFO,reg; 		\
	sub	slot,1,r_temp1; 		\
	sll	r_temp1,DG_SLOT_SHIFT,r_temp1;	\
	add	reg,r_temp1,reg;		\
	or	reg,r_temp3,reg
/*
 * The DNRAM is a 2Kbyte by 8-bit RAM that occupies ID spaces 
 * addresses 0x00900000 thru 0x00900ffe at every half-word 
 * address.
 *
 * The DNRAM is partitioned into 4 logical blocks, each block is 
 * reserved for a specific local processor.  The Following
 * map illustrates how the DNRAM is logically partitioned:
 *
 *      ====== +================+  === 
 *      900000 |                |   ^
 *             |                |   |
 *             |                |   Processor 0 (MID 0x8)
 *             |                |   |
 *      9003fe |                |   v
 *      ====== +================+  ===
 *      900400 |                |   ^
 *             |                |   |    
 *             |                |   Processor 1 (MID 0x9)
 *             |                |   |
 *      9007fe |                |   v
 * 	====== +================+  === 
 *      900800 |                |   ^
 *             |                |   |   
 *             |                |   Processor 2 (MID 0xA)
 *             |                |   |
 *      900bfe |                |   v
 *      ====== +================+  ===
 *      900c00 |                |   ^
 *             |                |   |   
 *             |                |   Processor 3 (MID 0xB)
 *             |                |   |
 *      900ffe |                |   v
 *      ====== +================+  ===
 *
 */
#define DN_INC		2	   		/* half-word addresses */
#define DN_MAGIC	0x00900000 		/* Magic Number */
#define DN_REV		(DN_MAGIC+DN_INC)	/* Format revision number */
#define DN_OK		(DN_REV+DN_INC)		/* DN node OK */
#define DN_PID		(DN_OK+DN_INC)		/* Processor ID */
#define DN_PHASE	(DN_PID+DN_INC)		/* Test/Boot phase number */
#define DN_RESET	(DN_PHASE+DN_INC)	/* Reset cause */
#define DN_RES1		(DN_RESET+DN_INC)	/* reserved */
#define DN_TNUM		(DN_RES1+DN_INC)	/* Test/Sequence number */
#define DN_TIME		(DN_TNUM+DN_INC)	/* Timeout value */
#define DN_RES2		(DN_TIME+DN_INC)	/* reserved */
#define DN_ERVAL	(DN_RES2+DN_INC)	/* Error number valid */
#define DN_ERCODE	(DN_ERVAL+DN_INC)	/* Error number */
#define DN_RES3		(DN_ERCODE+DN_INC)	/* reserved */
#define DN_CMD		(DN_RES3+DN_INC)	/* Command byte */
#define DN_CMDP1	(DN_CMD+DN_INC)		/* Command parameter 1 */
#define DN_CMDP2	(DN_CMDP1+DN_INC)	/* Command parameter 2 */
#define DN_FRUS		(DN_CMDP2+DN_INC) 	/* FRU list */
#define DN_NUM_FRUS	3			/*  3 entries */
#define DN_FRUS_SIZE	32			/*  each entry = 32 chars */
#define DN_TNAME	(DN_FRUS+(DN_NUM_FRUS*DN_FRUS_SIZE*DN_INC))
						/* Test Name String */
#define DN_TNAME_SIZE	64			/*  name = 64 chars */
#define DN_RNAME	(DN_TNAME+(DN_TNAME_SIZE*DN_INC))	
						/* Register mnemonic */
#define DN_RNAME_SIZE	16			/*  mnemonic = 16 chars */
#define DN_RDATA	(DN_RNAME+(DN_RNAME_SIZE*DN_INC))	
						/* Register data */
#define DN_RDATA_SIZE	8
#define DN_RSIZE	(DN_RDATA+(DN_RDATA_SIZE*DN_INC))
						/* Register size */
#define DN_RES4		(DN_RSIZE+DN_INC)	/* reserved */
#define DN_END		(0x1e0*DN_INC)		/* DN test area */

/*
 * Macros for accessing DNRAM
 */
#define PUTDNB(addr,reg) 			\
	set	KID_MIDR,r_temp1;		\
	lda	[r_temp1]ASI_KBUS_ID,r_temp3;	\
	and	r_temp3,3,r_temp3;		\
	sll	r_temp3,10,r_temp3;		\
	set	addr,r_temp1;			\
	or	r_temp1,r_temp3,r_temp1;	\
	stba	reg,[r_temp1]ASI_KBUS_ID

#define GETDNB(addr,reg) 			\
	set	KID_MIDR,r_temp1;		\
	lda	[r_temp1]ASI_KBUS_ID,r_temp3;	\
	and	r_temp3,3,r_temp3;		\
	sll	r_temp3,10,r_temp3;		\
	set	addr,r_temp1;			\
	or	r_temp1,r_temp3,r_temp1;	\
	lduba	[r_temp1]ASI_KBUS_ID,reg
		
#define TRIG_TYPE_BIST	0x920000	/* before BIST executed */
#define TRIG_TYPE_ERROR	0x920010	/* for test_error() */
#define TRIG_TYPE_UE	0x920020	/* for unexpected exception (UE--xx) */
#define TRIG_TYPE_AE	0x920030	/* for async error. Contents of MXCC_ERROR  */
					/* (2 sta instructions) are written to this */
					/* address 		    		    */

#define TRIGGER(type)	\
	set	KID_MIDR,%o0;		\
	lda	[%o0]ASI_KBUS_ID,%o0;	\
	and	%o0,7,%o0;		\
	sll	%o0,12,%o0;		\
	set	type,%o1;		\
	or	%o1,%o0,%o1;		\
	lda	[%o1]ASI_KBUS_ID,%g0

/*
 * CTAR bits:
 */
#define CTAR_MASK	0x00ffffe0	/* Tag Index (PA[23:5]) */
#define HIGH_TAG_INDEX	0x00ffffe0	/* Highest Tag Index */
#define NUM_BLOCKS	0x00080000	/* number of 32byte blocks */
#define NUM_TAGS	NUM_BLOCKS	/* number of cache tags */
/*
 * CTIR bits:
 */
#define CTIR_DP		0x80000000	/* diagnostic parity  */
#define CTIR_VAV	0x01000000	/* Virtual Tag Valid */
#define CTIR_VA_MASK	0x00ff0000	/* Virtual Tag Data (VA[19:12]) */
#define CTIR_TAG_MASK	0x0000ff00	/* Physical Tag Data (PA[31:24]) */
#define CTIR_MV		0x00000020	/* Module Valid */
#define CTIR_MO		0x00000010	/* Module Owned */
#define CTIR_V		0x00000008	/* Valid */
#define CTIR_O		0x00000004	/* Owned */
#define CTIR_C		0x00000002	/* Corrupt */
#define CTIR_P		0x00000001	/* Parity (even) */
#define CTIR_INC	0x00000040	/* even and odd blocks */
#define CTIR_COUNT	(NUM_TAGS/2)	/* written simultaneously */
					
/*
 * CTDR bits:
 */
#define CTDR_DP		0x80000000	/* diagnostic parity  */
#define CTDR_VAV	0x01000000	/* Virtual Tag Valid */
#define CTDR_VA_MASK	0x00ff0000	/* Virtual Tag Data (VA[19:12]) */
#define CTDR_TAG_MASK	0x0000ff00	/* Physical Tag Data (PA[31:24]) */
#define CTDR_MV		0x00000020	/* Module Valid */
#define CTDR_MO		0x00000010	/* Module Owned */
#define CTDR_V		0x00000008	/* Valid */
#define CTDR_O		0x00000004	/* Owned */
#define CTDR_C		0x00000002	/* Corrupt */
#define CTDR_P		0x00000001	/* Parity (even) */
#define CTDR_INC	0x00000020	/* only 1 block written at a time */

/*
 * WTAR bits:
 */
#define WTAR_MASK	0x00ffffe0	/* Tag Index (PA[23:5]) */
/*
 * WTIR bits:
 */
#define WTIR_DP		0x80000000	/* diagnostic parity  */
#define WTIR_TAG_MASK	0x0000ff00	/* Physical Tag Data (PA[31:24]) */
#define WTIR_V		0x00000008	/* Valid */
#define WTIR_O		0x00000004	/* Owned */
#define WTIR_P		0x00000001	/* Parity (even) */
#define WTIR_INC	0x00000040	/* even and odd blocks */
#define WTIR_COUNT	(NUM_TAGS/2)	/* written simultaneously */
/*
 * WTDR bits:
 */
#define WTDR_DP		0x80000000	/* diagnostic parity  */
#define WTDR_TAG_MASK	0x0000ff00	/* Physical Tag Data (PA[31:24]) */
#define WTDR_V		0x00000008	/* Valid */
#define WTDR_O		0x00000004	/* Owned */
#define WTDR_P		0x00000001	/* Parity (even) */
#define WTDR_INC	0x00000020	/* only 1 block written at a time */

/*
 * Self test TLB entry usage...
 */
#ifdef viking
#define TLB_INDEX_SHIFT	12		/* Convert TLB index to offset */
#define TLB_ENTRY(x)	((x)<<TLB_INDEX_SHIFT) /* entry # to TLB address */
#endif viking

#ifdef cypress
#ifdef cypress625
#define TLB_INDEX_SHIFT	4		/* Convert TLB index to offset */
#define	TLB_NEXT	8		/* Offset to next RAM/CAM entry */
#else
#define TLB_INDEX_SHIFT	3		/* Convert TLB index to offset */
#define	TLB_NEXT	4		/* Offset to next RAM/CAM entry */
#endif cypress625
#define TLB_ENTRY(x)	((x)<<TLB_INDEX_SHIFT) /* entry # to TLB address */
#endif cypress

#define TLB_ENT_TEMP	0		/* used for scratch purposes */ 
#define TLB_ENT_FE	1		/* virtual space "FE" */
#define TLB_ENT_FC	2		/* virtual space "FC" */
#define TLB_ENT_FD	3		/* virtual space "FD" */
#define TLB_ENT_FF	4		/* virtual space "FF" */
#define TLB_ENT_F0	5		/* virtual space "F0" */
#define TLB_ENT_IO	6		/* first IO space */ 
#define TLB_ENT_NUMIO	16		/* # of IO space entries */
#define TLB_ENT_END	TLB_ENT_IO+TLB_ENT_NUMIO /* next available entry */


#define MEM_SPACE0 	0xfc000000	/* virtual space which maps to 1st */
					/* 16M of Mbus space "B" */ 
#define MEM_SPACE16 	0xfd000000	/* virtual space which maps to 2nd */
					/* 16M of Mbus space "B" */ 

/**********************************************************************/
#endif /* Series7 */

/*
 * strings for self test status (DG_ST_STATUS)
 */
#define DG_ST_DONE	(('D'<<24)|('O'<<16)|('N'<<8)|('E'))
#define DG_ST_BASIC	(('B'<<24)|('A'<<16)|('S'<<8)|('I'))
#define DG_ST_PASS	(('P'<<24)|('A'<<16)|('S'<<8)|('S'))

/*
 * Alternate names for display loop variables:
 */
#define DG_LED1		DG_TEST		/* 1st LED value displayed */
#define DG_LED2		DG_ERROR	/* 2nd LED value displayed */

/* miscellaneous */
#define DTRAP_CODE	0xff		/* error code for double trap failure */
#define DG_SEC		10		/* number of 100ms intervals in a second */
#define DG_MIN		(DG_SEC*60)	/* number of 100ms intervals in a minute */

#define	IOSP1_BASE	0x10000000	/* select I/O space 1 */
#define BLOCK_SIZE	0x20		/* size of Kbus cache block */


#if defined(Series4) || defined(Series5)
/*********************************************************************
 * Configuration block definitions (DG_CONFIG) for 15 slot (or less) backplane
 *
 * If the format must change in the future, change the REV and 
 * modify the dgoffset(), dgslotshift() and dgslotsize() routines 
 * in lib/misc.s.
 */
#define DG_CONFIG_REV	2	/* current format revision */
/*
 * Configuration Header:  1 byte for number of 'type' boards, plus 15 
 * bytes for their slot numbers.
 */
#define DG_HDR_SIZE	16		/* 16 bytes per header entry */
#define DG_CPU_COUNT	DG_CONFIG	/* cpu board count & slots */
#define DG_MEM_COUNT	DG_CPU_COUNT+DG_HDR_SIZE /* mem board count/slots */
#define DG_SYS_COUNT	DG_MEM_COUNT+DG_HDR_SIZE /* sys board count/slots */
#define DG_GPX_COUNT	DG_SYS_COUNT+DG_HDR_SIZE /* gpx board count/slots */
#define DG_COP_COUNT	DG_GPX_COUNT+DG_HDR_SIZE /* cop board count/slots */
#define DG_TY_COUNT	DG_COP_COUNT+DG_HDR_SIZE /* TyBoard count/slots */
#define DG_RES1_COUNT	DG_TY_COUNT+DG_HDR_SIZE	 /* reserved for future */
#define DG_RES2_COUNT	DG_RES1_COUNT+DG_HDR_SIZE /* reserved for future */
#define DG_RES3_COUNT	DG_RES2_COUNT+DG_HDR_SIZE /* reserved for future */

/*******
 * Slot Configuration...
 *
 * per slot information block defines:
 */
#define DG_SLOT_INFO	DG_RES3_COUNT+DG_HDR_SIZE
#define DG_SLOT_SIZE	8			/* size of slot info blocks */
#define DG_SLOT_SHIFT	3			/* shift for x8 */

#define DG_SLOT1	DG_SLOT_INFO		/* slot 1 information */
#define DG_SLOT2	DG_SLOT1+DG_SLOT_SIZE	/* slot 2 information */
#define DG_SLOT3	DG_SLOT2+DG_SLOT_SIZE	/* slot 3 information */
#define DG_SLOT4	DG_SLOT3+DG_SLOT_SIZE	/* slot 4 information */
#define DG_SLOT5	DG_SLOT4+DG_SLOT_SIZE	/* slot 5 information */
#define DG_SLOT6	DG_SLOT5+DG_SLOT_SIZE	/* slot 6 information */
#define DG_SLOT7	DG_SLOT6+DG_SLOT_SIZE	/* slot 7 information */
#define DG_SLOT8	DG_SLOT7+DG_SLOT_SIZE	/* slot 8 information */
#define DG_SLOT9	DG_SLOT8+DG_SLOT_SIZE	/* slot 9 information */
#define DG_SLOTA	DG_SLOT9+DG_SLOT_SIZE	/* slot 10 information */
#define DG_SLOTB	DG_SLOTA+DG_SLOT_SIZE	/* slot 11 information */
#define DG_SLOTC	DG_SLOTB+DG_SLOT_SIZE	/* slot 12 information */
#define DG_SLOTD	DG_SLOTC+DG_SLOT_SIZE	/* slot 13 information */
#define DG_SLOTE	DG_SLOTD+DG_SLOT_SIZE	/* slot 14 information */
#define DG_SLOTF	DG_SLOTE+DG_SLOT_SIZE	/* slot 15 information */

/* miscellaneous configuration information */
#define DG_MEM_TOTAL	DG_SLOTF+DG_SLOT_SIZE	/* total mem size in Mbytes */

/*******  The definitions below must never change *********
 *
 * The first two bytes in each DG_SLOTx block contains the following:
 */
#define DG_BD_PRESENT	0	/* indicates presence of board (1)*/
#define DG_ID_OFF	1	/* ID space offset (1) */

/******* 
 * If DG_SLOTx contains information specific to a memory board,
 * add the following:
 */
#define DG_MEM_SIZE	DG_ID_OFF+1	/* size in Mbytes (2)*/
#define DG_MEM_BASE	DG_MEM_SIZE+2	/* base address (4) */

/******* 
 * If DG_SLOTx contains information specific to a cpu board, add
 * the following:
 */
#define DG_CPU_MS	DG_ID_OFF+1	/* master/slave status (1) */
#define DG_CPU_STATUS	DG_CPU_MS+1	/* self-test status (1) */
#define DG_CPU_TYPE	DG_CPU_STATUS+1	/* board type (1) */

#define DG_CPU_SLAVE	DG_CPU_MS	/* for compatibility */
#define DG_CPU_GOOD	DG_CPU_STATUS	/* for compatibility */

/* values for master/slave status (DG_CPU_MS) */
#define MASTER_CPU	0		/* cpu is the master */
#define SLAVE_CPU	1		/* cpu is slave processor */

/* values for cpu self test status (DG_CPU_STATUS) */
#define CPU_GOOD	0		/* cpu passed self test */
#define CPU_BAD		1		/* cpu failed self test */ 

/******* 
 * If DG_SLOTx contains information specific to system board 
 * or graphics board, add the following:
 */
#define DG_GPX_TYPE	DG_ID_OFF+1	/* graphics type (mono/color) (1) */

/******* 
 * If DG_SLOTx contains information specific to TyBoard 
 * add the following:
 */
#define DG_TY_BAN	DG_ID_OFF+1	/* Bus Adapter Number (0-7) (1) */

/* 
 * The defines below are for backward compatibility between new
 * standalones and old bootroms.  These defines map the old structure
 * of the DG_CONFIG area before 15-slot backplane changes were made.
 * These are the same for Series4 and Series5
 *
 * see also: dgoffset() and dgslotsize() routines
 */
#define ODG_CONFIG	0x200
#define ODG_HDR_SIZE	8
#define ODG_CPU_COUNT	ODG_CONFIG
#define ODG_MEM_COUNT	ODG_CPU_COUNT+ODG_HDR_SIZE
#define ODG_SYS_COUNT	ODG_MEM_COUNT+ODG_HDR_SIZE
#define ODG_GPX_COUNT	ODG_SYS_COUNT+ODG_HDR_SIZE
#define ODG_COP_COUNT	ODG_GPX_COUNT+ODG_HDR_SIZE

/* start of perslot info */
#define ODG_SLOT_INFO	ODG_COP_COUNT+ODG_HDR_SIZE 
#define ODG_SLOT_SIZE	0x20	
#define ODG_SLOT_SHIFT	5	
#define ODG_SLOT1	ODG_SLOT_INFO	
#define ODG_SLOT2	ODG_SLOT1+ODG_SLOT_SIZE
#define ODG_SLOT3	ODG_SLOT2+ODG_SLOT_SIZE
#define ODG_SLOT4	ODG_SLOT3+ODG_SLOT_SIZE
#define ODG_SLOT5	ODG_SLOT4+ODG_SLOT_SIZE
#define ODG_SLOT6	ODG_SLOT5+ODG_SLOT_SIZE
#define ODG_SLOT7	ODG_SLOT6+ODG_SLOT_SIZE
#endif /* Series4 || Series5 */

#ifdef Series6
/*********************************************************************
 * Configuration block definitions (DG_CONFIG) for 15 slot (or less) backplane
 * (These defines were expanded for Series6)
 *
 * If the format must change in the future, change the REV and 
 * modify the dgoffset(), dgslotshift() and dgslotsize() routines 
 * in lib/misc.s.
 */
#define DG_CONFIG_REV	2	/* current format revision */
/*
 * Configuration Header:  1 byte for number of 'type' boards, plus 15 
 * bytes for their slot numbers.
 */
#define DG_HDR_SIZE	32		/* 32 bytes per header entry */
#define DG_CPU_COUNT	DG_CONFIG	/* cpu board count & slots */
#define DG_MEM_COUNT	DG_CPU_COUNT+DG_HDR_SIZE /* mem board count/slots */
#define DG_SYS_COUNT	DG_MEM_COUNT+DG_HDR_SIZE /* sys board count/slots */
#define DG_GPX_COUNT	DG_SYS_COUNT+DG_HDR_SIZE /* gpx board count/slots */
#define DG_COP_COUNT	DG_GPX_COUNT+DG_HDR_SIZE /* cop board count/slots */
#define DG_TY_COUNT	DG_COP_COUNT+DG_HDR_SIZE /* TyBoard count/slots */
#define DG_RES1_COUNT	DG_TY_COUNT+DG_HDR_SIZE	 /* reserved for future */
#define DG_RES2_COUNT	DG_RES1_COUNT+DG_HDR_SIZE /* reserved for future */
#define DG_RES3_COUNT	DG_RES2_COUNT+DG_HDR_SIZE /* reserved for future */

/*******
 * Slot Configuration...
 *
 * per slot information block defines:
 */
#define DG_SLOT_INFO	DG_RES3_COUNT+DG_HDR_SIZE
#define DG_SLOT_SIZE	16			/* size of slot info blocks */
#define DG_SLOT_SHIFT	4			/* shift for x16 */

#define DG_SLOT1	DG_SLOT_INFO		/* slot 1 information */
#define DG_SLOT2	DG_SLOT1+DG_SLOT_SIZE	/* slot 2 information */
#define DG_SLOT3	DG_SLOT2+DG_SLOT_SIZE	/* slot 3 information */
#define DG_SLOT4	DG_SLOT3+DG_SLOT_SIZE	/* slot 4 information */
#define DG_SLOT5	DG_SLOT4+DG_SLOT_SIZE	/* slot 5 information */
#define DG_SLOT6	DG_SLOT5+DG_SLOT_SIZE	/* slot 6 information */
#define DG_SLOT7	DG_SLOT6+DG_SLOT_SIZE	/* slot 7 information */
#define DG_SLOT8	DG_SLOT7+DG_SLOT_SIZE	/* slot 8 information */
#define DG_SLOT9	DG_SLOT8+DG_SLOT_SIZE	/* slot 9 information */
#define DG_SLOTA	DG_SLOT9+DG_SLOT_SIZE	/* slot 10 information */
#define DG_SLOTB	DG_SLOTA+DG_SLOT_SIZE	/* slot 11 information */
#define DG_SLOTC	DG_SLOTB+DG_SLOT_SIZE	/* slot 12 information */
#define DG_SLOTD	DG_SLOTC+DG_SLOT_SIZE	/* slot 13 information */
#define DG_SLOTE	DG_SLOTD+DG_SLOT_SIZE	/* slot 14 information */
#define DG_SLOTF	DG_SLOTE+DG_SLOT_SIZE	/* slot 15 information */

/* miscellaneous configuration information */
#define DG_MEM_TOTAL	DG_SLOTF+DG_SLOT_SIZE	/* total mem size in Mbytes */

/*******  The definitions below must never change *********
 *
 * The first two bytes in each DG_SLOTx block contains the following:
 */
#define DG_BD_PRESENT	0	/* indicates presence of board (1)*/
#define DG_ID_OFF	1	/* ID space offset (1) */

/******* 
 * If DG_SLOTx contains information specific to a memory board,
 * add the following:
 */
#define DG_MEM_SIZE	DG_ID_OFF+1	/* size in Mbytes (2)*/
#define DG_MEM_BASE	DG_MEM_SIZE+2	/* base address (4) */

/******* 
 * If DG_SLOTx contains information specific to a cpu board, add
 * the following:
 */
#define DG_CPU_MS	DG_ID_OFF+1	/* master/slave status (1) */
#define DG_CPU_STATUS	DG_CPU_MS+1	/* self-test status (1) */
#define DG_CPU_TYPE	DG_CPU_STATUS+1	/* board type (1) */

#define DG_CPU_SLAVE	DG_CPU_MS	/* for compatibility */
#define DG_CPU_GOOD	DG_CPU_STATUS	/* for compatibility */

/* values for master/slave status (DG_CPU_MS) */
#define MASTER_CPU	0		/* cpu is the master */
#define SLAVE_CPU	1		/* cpu is slave processor */

/* values for cpu self test status (DG_CPU_STATUS) */
#define CPU_GOOD	0		/* cpu passed self test */
#define CPU_BAD		1		/* cpu failed self test */ 

/******* 
 * If DG_SLOTx contains information specific to system board 
 * or graphics board, add the following:
 */
#define DG_GPX_TYPE	DG_ID_OFF+1	/* graphics type (mono/color) (1) */

/******* 
 * If DG_SLOTx contains information specific to TyBoard 
 * add the following:
 */
#define DG_TY_BAN	DG_ID_OFF+1	/* Bus Adapter Number (0-7) (1) */
#endif /* Series6 */

#ifdef Series7
/*********************************************************************
 * Configuration block definitions (DG_CONFIG) for 15 slot (or less) backplane
 * (These defines were expanded for Series7)
 *
 * If the format must change in the future, change the REV and 
 * modify the dgoffset(), dgslotshift() and dgslotsize() routines 
 * in lib/misc.s.
 */
#define DG_CONFIG_REV	2	/* current format revision */
/*
 * Configuration Header:  1 byte for number of 'type' boards, plus 15 
 * bytes for their slot numbers.
 */
#define DG_CPUHDR_SIZE	40		/* 40 bytes per header entry */
#define DG_HDR_SIZE	16		/* 16 bytes per header entry */
#define DG_CPU_COUNT	DG_CONFIG	/* cpu board count & slots */
#define DG_MEM_COUNT	DG_CPU_COUNT+DG_CPUHDR_SIZE /* mem board count/slots */
#define DG_SYS_COUNT	DG_MEM_COUNT+DG_HDR_SIZE /* sys board count/slots */
#define DG_GPX_COUNT	DG_SYS_COUNT+DG_HDR_SIZE /* gpx board count/slots */
#define DG_COP_COUNT	DG_GPX_COUNT+DG_HDR_SIZE /* cop board count/slots */
#define DG_TY_COUNT	DG_COP_COUNT+DG_HDR_SIZE /* TyBoard count/slots */
#define DG_RES1_COUNT	DG_TY_COUNT+DG_HDR_SIZE	 /* reserved for future */
#define DG_RES2_COUNT	DG_RES1_COUNT+DG_HDR_SIZE /* reserved for future */
#define DG_RES3_COUNT	DG_RES2_COUNT+DG_HDR_SIZE /* reserved for future */

/*******
 * Slot Configuration...
 *
 * per slot information block defines:
 */
#define DG_SLOT_INFO	DG_RES3_COUNT+DG_HDR_SIZE
#define DG_SLOT_SIZE	16			/* size of slot info blocks */
#define DG_SLOT_SHIFT	4			/* shift for x16 */

#define DG_SLOT1	DG_SLOT_INFO		/* slot 1 information */
#define DG_SLOT2	DG_SLOT1+DG_SLOT_SIZE	/* slot 2 information */
#define DG_SLOT3	DG_SLOT2+DG_SLOT_SIZE	/* slot 3 information */
#define DG_SLOT4	DG_SLOT3+DG_SLOT_SIZE	/* slot 4 information */
#define DG_SLOT5	DG_SLOT4+DG_SLOT_SIZE	/* slot 5 information */
#define DG_SLOT6	DG_SLOT5+DG_SLOT_SIZE	/* slot 6 information */
#define DG_SLOT7	DG_SLOT6+DG_SLOT_SIZE	/* slot 7 information */
#define DG_SLOT8	DG_SLOT7+DG_SLOT_SIZE	/* slot 8 information */
#define DG_SLOT9	DG_SLOT8+DG_SLOT_SIZE	/* slot 9 information */
#define DG_SLOTA	DG_SLOT9+DG_SLOT_SIZE	/* slot 10 information */
#define DG_SLOTB	DG_SLOTA+DG_SLOT_SIZE	/* slot 11 information */
#define DG_SLOTC	DG_SLOTB+DG_SLOT_SIZE	/* slot 12 information */
#define DG_SLOTD	DG_SLOTC+DG_SLOT_SIZE	/* slot 13 information */
#define DG_SLOTE	DG_SLOTD+DG_SLOT_SIZE	/* slot 14 information */
#define DG_SLOTF	DG_SLOTE+DG_SLOT_SIZE	/* slot 15 information */

/* miscellaneous configuration information */
#define DG_MEM_TOTAL	DG_SLOTF+DG_SLOT_SIZE	/* total mem size in Mbytes */

/*******  The definitions below must never change *********
 *
 * The first two bytes in each DG_SLOTx block contains the following:
 */
#define DG_BD_PRESENT	0	/* indicates presence of board (1)*/
#define DG_ID_OFF	1	/* ID space offset (1) */

/******* 
 * If DG_SLOTx contains information specific to a memory board,
 * add the following:
 */
#define DG_BD_STATUS	DG_ID_OFF+1	/* Self test status of board (2) */
#define DG_CPU_TYPE	DG_BD_STATUS+2	/* board type (1) */
#define DG_PROC_TYPE	DG_CPU_TYPE+1	/* upper nibble = processor type lower = revision (1) */
#define DG_PROC_PRESENT DG_PROC_TYPE+1	/* processor present in bit image (1) */
#define DG_PROC_STATUS	DG_PROC_PRESENT+1	/* Sub Master/Slave self-test status in bit image (1) */
#define DG_PROC_MS	DG_PROC_STATUS+1	/* processor master/slave bit map (1) */


/* values for processor present bit map (DG_PROC_PRESENT) */
#define PROC_PRESENT_P0	0x1		/* processor present on mbus segment 0 */
#define PROC_PRESENT_P1	0x2		/* processor present on mbus segment 0 */
#define PROC_PRESENT_P2	0x4		/* processor present on mbus segment 1 */
#define PROC_PRESENT_P3	0x8		/* processor present on mbus segment 1 */

/* values for processor POST status (DG_PROC_STATUS) */
#define PROC_STATUS_P0	0x1		/* POST status for processor on mbus segment 0 */
#define PROC_STATUS_P1	0x2		/* POST status for processor on mbus segment 0 */
#define PROC_STATUS_P2	0x4		/* POST status for processor on mbus segment 1 */
#define PROC_STATUS_P3	0x8		/* POST status for processor on mbus segment 1 */

/* values for processor master/slave bit map (DG_PROC_MS) */
#define PROC_MS_P0	0x1		/* processor is submaster on mbus segment 0 */
#define PROC_MS_P1	0x2		/* processor is submaster on mbus segment 0 */
#define PROC_MS_P2	0x4		/* processor is submaster on mbus segment 1 */
#define PROC_MS_P3	0x8		/* processor is submaster on mbus segment 1 */


/* values for processor type (DG_PROC_TYPE) */
#define SUPERSPARC	0
#define HYPERSPARC	1

/******* 
 * If DG_SLOTx contains information specific to a memory board,
 * add the following:
 */
#define DG_MEM_SIZE	DG_ID_OFF+1	/* size in Mbytes (2)*/
#define DG_MEM_BASE	DG_MEM_SIZE+2	/* base address (4) */
#define DG_MEM_STATUS	DG_MEM_BASE+4	/* memboard self-test status */

/******* 
 * If DG_SLOTx contains information specific to system board 
 * or graphics board, add the following:
 */
#define DG_GPX_TYPE	DG_ID_OFF+1	/* graphics type (mono/color) (1) */

/******* 
 * If DG_SLOTx contains information specific to TyBoard 
 * add the following:
 */
#define DG_TY_BAN	DG_ID_OFF+1	/* Bus Adapter Number (0-7) (1) */
#endif /* Series7 */


#endif	_machine_diag_h
