/* @(#) if_fxreg_fddi.h 1.1@(#) Solbourne id 9/22/93 00:11:30 */
/*
 * Copyright 1990 Solbourne Computer, Inc.
 * All rights reserved.
 */
/*
 * 	Copyright (c) 1990 by Communication Machinery Corporation
 * 			All rights reserved.
 *
 * 	This software contains proprietary and confidential information
 * 	of Communication Machinery Corporation and its suppliers.  Use,
 * 	disclosure, or reproduction is prohibited without the prior express
 * 	written consent of Communication Machinery Corporation.
 */

/*
 *	FDDI specific FXP Definitions:
 */
#ifndef	_if_if_fxreg_fddi_h
#define	_if_if_fxreg_fddi_h

/* address information/control */
#define FDDIADR	 struct fddi_addr

struct fddi_list {
    int		fddi_listsize;		/* number of active addr entries */
    FDDIADR	fddi_baseaddr;		/* our fddinet address */
    FDDIADR	fddi_a[16];		/* fddinet multicast addresses */
#define		fddi_addrs	fddi_a
};
typedef	volatile struct fddi_list	FDDILIST;

/* TODO: KLUDGE: bcb stuff... */

/* action block used to pass parameters from SMAP to SMT for service call */
struct acb {
    u_long	acb_op;
    u_long	acb_resource;
    u_long	acb_act;
    u_long	acb_status;
    u_long	acb_param1;
    u_long	acb_param2;
    u_long	acb_param3;
    u_long	acb_param4;
    u_long	acb_acbpsv;
    u_long	acb_where;
    u_long	acb_where_len;
    u_long	acb_result_len;
    u_char	*acb_result;
};
typedef struct acb	ACB;

/* SMT to SMAP event definition */
/* event category */
#define E_STATION	1

/* station event */
#define S_CfmChange	0
#define S_TraceAck	1
#define S_Twisted	2
#define S_UnrootCon	3
#define S_Wrap		4
#define	S_RingChange	5

#define FDDI_RINGOP	((E_STATION<<24)|(S_RingChange<<16)|1)
#define FDDI_RINGDOWN	((E_STATION<<24)|(S_RingChange<<16)|0)
#define FDDI_ISOLATED	((E_STATION<<24)|(S_CfmChange<<16)|0)
#define FDDI_WRAP_A	((E_STATION<<24)|(S_CfmChange<<16)|1)
#define FDDI_WRAP_B	((E_STATION<<24)|(S_CfmChange<<16)|2)
#define FDDI_THRU_A	((E_STATION<<24)|(S_CfmChange<<16)|4)
#define FDDI_WRAPPED	((E_STATION<<24)|(S_Wrap<<16)|0)
#define FDDI_TWISTED_A	((E_STATION<<24)|(S_Twisted<<16)|0)
#define FDDI_TWISTED_B	((E_STATION<<24)|(S_Twisted<<16)|1)

#endif	_if_if_fxreg_fddi_h
