/* @(#) if_fxreg_ether.h 1.1@(#) Solbourne id 9/22/93 00:11:28 */
/*
 * Copyright 1990 Solbourne Computer, Inc.
 * All rights reserved.
 */
/*
 * 	Copyright (c) 1990 by Communication Machinery Corporation
 * 			All rights reserved.
 *
 * 	This software contains proprietary and confidential information
 * 	of Communication Machinery Corporation and its suppliers.  Use,
 * 	disclosure, or reproduction is prohibited without the prior express
 * 	written consent of Communication Machinery Corporation.
 */

/*
 *	ETHERNET specific FXP Definitions:
 */
#ifndef	_if_if_fxreg_ether_h
#define	_if_if_fxreg_ether_h

struct ether_laf {
    u_short   ether_laf_mask[4];	/* a complete LAF filter */
};
typedef volatile struct ether_laf ETHERLAF;
#define ETHERADR	 struct ether_addr

/* address information/control */
struct ether_list {
    u_short	ether_mode;		/* add addr, del addr, or set laf */
#define		  ETHER_MODE_ADD_ADR 0	/* add addr to laf */
#define		  ETHER_MODE_DEL_ADR 1	/* delete addr from laf */
#define		  ETHER_MODE_SET_LAF 2	/* use e_laf to set our LAF */
    u_short	ether_listsize;		/* number of active addr entries */
    ETHERADR	ether_baseaddr;		/* our ethernet address */
    union {				/* rest of struct is either */
	ETHERADR	ether_a[ 16 ];	/* ethernet multicast addresses */
#define		ether_addrs	ether_u.ether_a
	ETHERLAF	ether_l;		/* encoded LAF */
#define		ether_laf	ether_u.ether_l.ether_laf_mask
    } ether_u;
};
typedef	volatile struct ether_list	ETHERLIST;

/* board statistics */
struct ether_stat
{
    u_int	ether_xmit_successful;	/* successful transmissions */
    u_int	ether_mult_retry;	/* multiple retries on xmit */
    u_int	ether_on_retry;		/* single retries */
    u_int	ether_fail_retry;	/* too many retries */
    u_int	ether_deferrals;	/* xmit delayed due to active wire */
    u_int	ether_xmit_buff_err;	/* xmit chaining failed cant happen */
    u_int	ether_silo_underrun;	/* transmit data fetch failed */
    u_int	ether_lat_coll;		/* collision after xmit */
    u_int	ether_lost_carrier;	/* cable droped out */
    u_int	ether_babble;		/* xmit length > 1518 */
    u_int	ether_no_heartbeat;	/* xceiver mismatch, not an err */
    u_int	ether_xmit_mem_err;	/* transmit memory error */
    u_int	ether_rcv_successful;	/* good receptions */
    u_int	ether_rcv_missed;	/* no recv buff available */
    u_int	ether_crc_err;		/* checksum failed */
    u_int	ether_fram_err;		/* crc error && data len != 0 mod 8 */
    u_int	ether_rcv_buff_err;	/* rcv chaining failed, cant happen */
    u_int	ether_silo_overrun;	/* receive data store failed */
    u_int	ether_rcv_mem_err;
};
typedef	volatile struct ether_stat	ETHERSTAT;

/* unique bcb fields */
#define		  BCB_ETHER_XSTAT_COLL	0x0001	/*   collision error */
#define		  BCB_ETHER_XSTAT_MERR	0x0002	/*   memory error */
#define		  BCB_ETHER_XSTAT_RTRY	0x0004	/*   retry exceeded */
#define		  BCB_ETHER_XSTAT_NCAR	0x0008	/*   loss of carrier */
#define		  BCB_ETHER_XSTAT_LCOL	0x0010	/*   late collision */
#define		  BCB_ETHER_XSTAT_BABL	0x0020	/*   tx babble */
#define		  BCB_ETHER_XSTAT_UFLO	0x0040	/*   tx silo underfow */
#define		  BCB_ETHER_XSTAT_XBUF	0x0080	/*   tx buffer error */
#define		  BCB_ETHER_XSTAT_ENP	0x0100	/*   end of packet */
#define		  BCB_ETHER_XSTAT_STP	0x0200	/*   start of packet */
#define		  BCB_ETHER_XSTAT_DEFR	0x0400	/*   cable busy */
#define		  BCB_ETHER_XSTAT_ONE	0x0800	/*   one retry */
#define		  BCB_ETHER_XSTAT_MORE	0x1000	/*   more than one retry */
#define		  BCB_ETHER_XSTAT_ERR	0x4000	/*   error summary */
#define		  BCB_ETHER_XSTAT_FILL	0x2000	/*   stored chip addr */
#define		  BCB_ETHER_XSTAT_DONE	0x8000	/*   buffer complete */
#define		  BCB_ETHER_XSTAT_BITS	\
"\20\20DONE\17ERROR\16FILLED\15RETRY2\14RETRY1\13DEFER\12STP\11ENP\10TXBUFERR\
\7UFLOW\6BABBLE\5LATE_COLLISION\4NO_CARRIER\3RETRY\2MEM_ERROR\1COLLISION"
#define		bcb_rstat		bcb_csr	/* recieve status bits */
#define		  BCB_ETHER_RSTAT_MISS	0x0001	/*   missed packet */
#define		  BCB_ETHER_RSTAT_MERR	0x0002	/*   memory error */
#define		  BCB_ETHER_RSTAT_ENP	0x0100	/*   end of packet */
#define		  BCB_ETHER_RSTAT_STP	0x0200	/*   start of packet */
#define		  BCB_ETHER_RSTAT_RXBUF	0x0400	/*   rx buffer err */
#define		  BCB_ETHER_RSTAT_CRC	0x0800	/*   crc error */
#define		  BCB_ETHER_RSTAT_OFLO	0x1000	/*   silo overflow */
#define		  BCB_ETHER_RSTAT_FRAME	0x2000	/*   framing error */
#define		  BCB_ETHER_RSTAT_ERR	0x4000	/*   error summary */
#define		  BCB_ETHER_RSTAT_DONE	0x8000	/*   buffer complete */
#define		  BCB_ETHER_RSTAT_BITS	\
"\20\20DONE\17ERROR\16FRAME_ERR\15OFLOW\14BAD_CRC\13RXBUFERR\12STP\11ENP\
\2MEM_ERROR\1MISSED_PACKET"

#endif	_if_if_fxreg_ether_h
