/* @(#) if_egvar.h 1.1@(#) Solbourne id 9/22/93 00:10:50 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/* Link-level interface driver for Interphase 4207 (EAGLE) */

typedef struct eg_mem {
	struct eg_mem	*em_nxt;
	struct eg_softc	*em_eg;
	BYTE		*em_addr;
	BYTE		em_loaned;
} EG_MEM;

#define EG_GET(ehd, em, eg) {		/* get memory resource */	\
	(em) = (EG_MEM *)0;						\
	if (ehd) {							\
		(em) = (ehd);						\
		(ehd) = (em)->em_nxt;					\
		(em)->em_nxt = 0;					\
		(em)->em_eg = (EG_SOFTC *)eg;				\
	}								\
}

#define EG_FREE(ehd, em) {		/* free memory resource */	\
	(em)->em_nxt = (ehd);						\
	(ehd) = (em);							\
	(em)->em_eg = (EG_SOFTC *)0;					\
	(em)->em_loaned = 0;						\
}
/* 

 * Ethernet software status per interface.
 * Each interface is referenced by a network interface structure, eg_if, 
 * which the routing code uses to locate the interface.  This structure
 * contains the output queue for the interface, its address, ...
 */
typedef struct  eg_softc {
	struct mb_device *eg_info;	/* pointer to eginfo structure */
        struct arpcom	eg_ac;		/* Ethernet Common Part */
#define			eg_if		eg_ac.ac_if
#define			eg_enaddr	eg_ac.ac_enaddr
	EG_IMOD		eg_IMOD;	/* Current Physical Interface mode */
	EG_SHIO		*eg_shio;	/* Ptr to I/O Space */
	EG_CQE		*eg_cqe;	/* index for feed queue */
	UBYTE		eg_flags;	/* Flags for system */
#define			  EG_FLAGS_CONFIG	0x01
#define			  EG_FLAGS_QUEUE	0x02
	SHORT		eg_FILT[4];	/* Current Logical Address Filter */
	EG_VECT		eg_vector; 	/* vector for driver */
	EG_MEM		*eg_tx_head;    /* Free header for tx bufs */
	EG_MEM		*eg_rx_head;    /* Free header for rx bufs */
	UWORD		eg_rx_sent;	/* Used for RX throttle */
	UWORD		eg_tx_sent;	/* Used for TX throttle */
	BYTE		*eg_alloc;	/* allocated memory pointer */
	ULONG		eg_alloc_size;	/* allocated memory size */
	ULONG		eg_alloc_cookie;/* Magic Cookie from Mballoc() */
	ULONG		eg_alloc_dvma;	/* DVMA Physical Address */
	int		eg_ctlr;	/* This controller number */
	UWORD		eg_topt;	/* transfer options for controller */

	int		eg_reset_count;	/* number of resets for large packets */
	int		eg_max_crb;	/* max number of crb's per interrupt */
	int		eg_rloan_out;	/* # of rcv buffs currently loaned */
	int		eg_rloans;	/* total # of rcv buffs loaned */
	int		eg_stat_pad1;
	int		eg_stat_pad2;
	int		eg_stat_pad3;
	int		eg_stat_pad4;
	EG_MEM		*eg_em_rxstart, *eg_em_rxend,
			*eg_em_txstart, *eg_em_txend;
} EG_SOFTC;

/*
 * Parameters for controlling the eagle
 */
#define EG_BUFSIZE	(14 + ETHERMTU + 4 + 48)
#define EG_RX_BUFSZ	2000		/* Max Rx packet */
#define EG_TX_BUFSZ	2000		/* Max Tx packet */
/*#define EG_TX_NBUFF	(8)		/* Num transmit buffers */
/*#define EG_RX_NBUFF	(MAX_CQE-EG_TX_NBUFF)	/* Num receive buffers */
#define EG_TX_NBUFF	(MAX_CQE/2)		/* Num transmit buffers */
#define EG_RX_NBUFF	(MAX_CQE/2)	/* Num receive buffers */
#define EG_BURST	0		/* Send Whole Message */
#define EG_RX_THROTTLE	(EG_RX_NBUFF-2)	/* Number of RX to have pending */
#define EG_TX_THROTTLE	(EG_TX_NBUFF)	/* Number of TX to have pending */

#define CRB_CLR_DONE(cqe)	(W((cqe)->crb_CRSW) = 0)		
#define CRB_DONE(cqe)		(W((cqe)->crb_CRSW) & M_CRSW_CRBV)	
#define CRB_QSTARTED(cqe)	(W((cqe)->crb_CRSW) & (M_CRSW_CRBV|M_CRSW_QMS))
#define CQE_GO(cqe)		(W((cqe)->cqe_QECR) = M_QECR_GO)	
#define CQE_BUSY(cqe)		(W((cqe)->cqe_QECR) & M_QECR_GO)
#define GET_NEXT_CQE(eg, cqe, shio) {	/* get next cqe */		\
	(cqe) = (eg)->eg_cqe;						\
	if (CQE_BUSY(cqe))						\
		(cqe) = (EG_CQE *)0;					\
	else {								\
		if ((++(eg)->eg_cqe) == &(shio)->sh_CQE[MAX_CQE])	\
			(eg)->eg_cqe = &(shio)->sh_CQE[0];		\
	}								\
}
#define EG_ALIGN(x)	(((ULONG)(x) + 4) & ~3)
#define EG_ALIGN_32(x)	(((ULONG)(x) + 32) & ~31)
