/* @(#) if_egreg.h 1.1@(#) Solbourne id 9/22/93 00:10:45 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/* Link-level interface driver for Interphase 4207 (EAGLE) */

/* Eagle Control IOPB's */
#define CNTR_DIAG		0x40	/* Perform Diagnostics */
#define CNTR_INIT		0x41	/* Initialize Controller */
#define CNTR_INIT_WORKQ		0x42	/* Initialize Work Queue */
#define CNTR_DUMP_INIT		0x43	/* Dump Initialization Parameters */
#define CNTR_REPORT_STATS	0x44	/* Report Statistics */
#define CNTR_CHANGE_NODE	0x45	/* Change Default Node Address */
#define CNTR_CHANGE_FILTER	0x46	/* Change Default Logical Addr Filter */
#define CNTR_DLOAD_SWARE	0x47  	/* Download Executable Software */
#define CNTR_XCUTE_SWARE	0x48  	/* Execute Downloaded Software */
#define CNTR_FLUSH_WORKQ	0x49	/* Flush Work Queue */
#define CNTR_TRANSMIT		0x50	/* Transmit */
#define CNTR_RECEIVE		0x60	/* Receive */
#define CNTR_DMA		0x70	/* DMA */

/* Work queue types */
#define RX_WORKQ        2
#define TX_WORKQ        3

/* Memory types */
#define MEMT_16BIT		1	/* 16 Bit Memory type */
#define MEMT_32BIT		2	/* 32 Bit Memory type */
#define MEMT_SHIO 		3	/* Short I/O Memory type */

/* Transfer types */
#define TT_NORMAL		0	/* Normal Mode Tranfers */
#define TT_BLOCK		1	/* Block  Mode Tranfers */
#define TT_DISABLE_INC_ADDR	2	/* Disable Incrementing Addresses */

#define DIR_READ		0x1000	/* Read from Eagle */
#define DIR_WRITE		0x0000	/* Write to Eagle */

/* LANCE error bits */
#define LANCE_ERR		0x4000	/* Error */
#define LANCE_RERR		0x4000	/* Receive Error */
#define LANCE_RSTP		0x0200	/* Start of Packet */
#define LANCE_RENP		0x0100	/* End of Packet */
#define LAN1_RBITS "\20\20OWN\17ERR\16FRAMING_ERROR\15OVERFLOW\14CRC_ERROR\13BUFFER_ERROR\12STP\11ENP"

#define LANCE_TERR		0x4000	/* Transmit Error */
#define LANCE_TMORE		0x1000	/* More Than One Retry */
#define LANCE_TONE		0x0800	/* Exactly One Retry */
#define LAN1_TBITS "\20\16MULTIPLE-\14RETRY\13DEFERED"
#define LAN3_TBITS "\20\20BUFFER_ERROR\17UNDERFLOW\15LATE_COLLISION\14LOSS_OF_CARRIER\13RETRY_FAILED"

/* Eagle Status Codes */
#define	EG_STATUS_NO_ERROR	0x00
#define	EG_STATUS_XMIT_ERR	0x30
#define	EG_STATUS_RECV_ERR	0x40
#define	EG_STATUS_CODE {					\
	"\000no error",				/* 0x00 */	\
	"\001controller initilization error",	/* 0x01 */	\
	"\002work queue init error",		/* 0x02 */	\
	"\003first command error",		/* 0x03 */	\
	"\004invalid command",			/* 0x04 */	\
	"\005bad queue #",			/* 0x05 */	\
	"\006queue dead",			/* 0x06 */	\
	"\007not ready",			/* 0x07 */	\
	"\010flush error",			/* 0x08 */	\
	"\011not queueing",			/* 0x09 */	\
	"\012no room",				/* 0x0A */	\
	"\013wrong queue",			/* 0x0B */	\
	"\014queue started",			/* 0x0C */	\
	"\020reserved field non-zero",		/* 0x10 */	\
	"\021command not implemented",		/* 0x11 */	\
	"\022controller not initialized",	/* 0x12 */	\
	"\023unknown error",			/* 0x13 */	\
	"\040VMEbus error",			/* 0x20 */	\
	"\041VMEbus timeout",			/* 0x21 */	\
	"\042VMEbus illegal address",		/* 0x22 */	\
	"\060transmit error",			/* 0x30 */	\
	"\061LANCE transmitter disabled",	/* 0x31 */	\
	"\100receive error",			/* 0x40 */	\
	"\120dad NVRAM",			/* 0x50 */	\
	"\200controller bad",			/* 0x80 */	\
	"\240Onboard microprocessor exception",	/* 0xA0 */	\
	"\360spawn process",			/* 0xF0 */	\
	0}
