#ifndef lint
static char *Solbourne_id =
"@(#) xp_conf.c 1.1@(#) Solbourne id 9/22/93 00:09:41\n";
#endif
/*
 * Copyright 1989 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*
 * Xylogics 781 driver
 */

#include "xp.h"
#ifdef NXP > 0

#include <sys/param.h>
#include <sys/termios.h>
#include <sys/buf.h>
#include <sys/stropts.h>
#include <sys/stream.h>
#include <sys/tty.h>
#include <sys/time.h>
#include <sys/clist.h>

#include <dev/mbvar.h>
#include <dev/xpreg.h>
#include <dev/xpvar.h>

/* number of lines */
int	nxp = NXP;

struct mb_device *xpinfo[NXP];

/* per board data structures */
struct xp_softc xp_softc[NXP];
struct xp_cstats xp_cstats[NXP];

/* driver operating parameters */
u_short	xpsoftCAR[NXP] = {0,};
u_short	xpsoftCAR_patched[NXP] = {0,};
u_short	xpsoftDTR[NXP] = {0,};
u_short xpsoftdtr = 0;
int	xpdtrlow = 3;		/* time to hold dtr down */
int	xpb134_weird = 0;	/* if set, old B134 behavior */
int	xp_cmd_timeout = (10000000/20); /* time to poll ARCP befor panic */
int	xpticks = 1;		/* polling frequency */
int	xpfract = 5;		/* fraction of XP_IBUFSIZE for direct stream */
int	xpminpushup = 4;	/* min buffer size to use in upstream push */
int	xpmaxpushup = 128;	/* max buffer size to use in upstream push */
int	xp_wait_line = 1;	/* wait for line commands to complete */
int	xp_force_empty = 0;	/* force empty condition on each write */
int	xp_force_fwrev = 0;	/* force a specific firmware rev */
int	xp_dual_baud = 0;	/* per controller bitmask: should the ports */
				/* support seperate baud rate for transmit/ */
				/* recieve.  NOTE: 4.1 uucp assumes the */
				/* device does NOT support seperate rates. */

/* initial uart params */
struct xp_uart xp_init_uart = {
	U_SCC_1STOPB|U_SCC_PAREVEN|U_SCC_CS7|U_SCC_NO_FLCTL,	/* scc */
	(14<<4) | 14,			/* baud */
	0,				/* modem state */
	0,				/* modem mask */
	30,				/* sec input timeout in 5 ms ticks */
	XP_IBUFSIZE / 2,		/* input min. */
	0,				/* xoff chars */
	0,				/* xon chars */
	XP_OBUFSIZE / 3,		/* low tide */
	50,				/* break time */
	0,				/* res1 */
	0,				/* res2 */
	0,				/* parity erorr */
	0,				/* frame error*/
	0,				/* overflow error */
	0,				/* res3 */
	0				/* res4 */
};

/* map baud rate from cflag to xp */
char xp_speeds[2][16] = {
{	/* baud rate table 0 */
	0x0,	/* B0 */
	0x0,	/* B50 */
	0x1,	/* B75 */
	0x2,	/* B110 */
	0x3,	/* B134.5 */
	0x4,	/* B150 */
	0x9,	/* B200		XP doesn't support, 2000 baud instead */
	0x5,	/* B300 */
	0x6,	/* B600 */
	0x7,	/* B1200 */
	0x8,	/* B1800 */
	0xA,	/* B2400 */
	0xC,	/* B4800 */
	0xE,	/* B9600 */
	0xF,	/* B19200 */
	0xD	/* B38400/EXTB	XP doesn't support, 7200 baud instead */
}, {	/* baud rate table 1 */
	0x0,	/* B0 */
	0x0,	/* B50		XP doesn't support, 100 baud instead */
	0x0,	/* B75		XP doesn't support, 100 baud instead */
	0x0,	/* B110		XP doesn't support, 100 baud instead */
	0x0,	/* B134.5	XP doesn't support, 100 baud instead */
	0x1,	/* B150 */
	0x2,	/* B200		XP doesn't support, 220 baud instead */
	0x4,	/* B300 */
	0x5,	/* B600 */
	0x6,	/* B1200 */
	0xD,	/* B1800	XP doesn't support, 14400 baud instead */
	0x7,	/* B2400 */
	0xA,	/* B4800 */
	0xC,	/* B9600 */
	0xE,	/* B19200 */
	0xF	/* B38400/EXTB */
}};
#endif NXP > 0
