/* @(#) tir.h 1.1@(#) Solbourne id 9/21/93 23:59:39 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

#ifdef Series4
/*
 * Test Information Register defines
 */
#define TIR_MASK	0xfefffcf0	/* TIR mask */

#define TIR_VMATCH1	0x80000000	/* Virtual Match 1 - 31:24 (low true) */
#define TIR_VMATCH0	0x40000000	/* Virtual Match 0 - 23:16 (low true) */
#define TIR_VVALID	0x20000000	/* Virtual Valid (high true) */
#define TIR_VOWN	0x10000000	/* Virtual OWN (high true) */

#define TIR_VOWNHIT	0x08000000	/* Virtual OWN Hit (low true) */
#define TIR_VUP		0x04000000	/* Virtual UP (high true) */
#define TIR_VRO		0x02000000	/* Virtual RO (high true) */
#define TIR_CB		0x01000000	/* Corrupted Block (high true) */

#define TIR_PMATCH2	0x00800000	/* Physical Match 2 - 31:24 (low true) */
#define TIR_PMATCH1	0x00400000	/* Physical Match 1 - 23:16 (low true) */
#define TIR_PMATCH0	0x00200000	/* Physical Match 0 - 15:13 (low true) */	
#define TIR_PVALID	0x00100000	/* Physical Valid (high true) */

#define TIR_POWN	0x00080000	/* Physical Own (high true) */
#define TIR_FLSHVALID	0x00040000	/* Flush Valid (low true) */
#define TIR_TMATCH0	0x00020000	/* TLB Match 0 - 31:23 (low true) */
#define TIR_TTVALID	0x00010000	/* TLB Valid (low true) */

#define TIR_TPVALID	0x00008000	/* TLB Page-valid (high true) */
#define TIR_TUP		0x00004000	/* TLB UP (high true) */
#define TIR_TRO		0x00002000	/* TLB RO (high true) */
#define TIR_FLSHADD0	0x00001000	/* Flush Address 0 (high true) */

#define TIR_FLSHADD1	0x00000800	/* Flush Address 1 (high true) */
#define TIR_FLSHADD2	0x00000400	/* Flush Address 2 (high true) */

#define TIR_IOOP	0x00000080	/* IO operation (TIO|TIOB) (low true) */
#define TIR_BDRT	0x00000040	/* Block Dirty (high true) */
#define TIR_TIO		0x00000020	/* TLB IO (high true) */
#define TIR_TIOB	0x00000010	/* TLB IOB (high true) */
#endif

#ifdef Series5	/* and Series5e */
/*
 * Test Information Register defines
 */
#define TIR_POWN	0x00000001	/* Physical Own (high true) */
#define TIR_CM0		0x00000002	/* CM0 (Cache Match 0) - 20:17 (high true) */	
#define TIR_CM1		0x00000004	/* CM1 - 24:21 (high true) */
#define TIR_CM2		0x00000008	/* CM2 - 28:25 (high true) */

#define TIR_FM0		0x00000010	/* FM0 (FTLB Match 0) - 23:20 (high true) */
#define TIR_FM1		0x00000020	/* FM1 - 27:24 (high true) */
#define TIR_FM2		0x00000040	/* FM2 - FTLB valid (high true) */
#define TIR_FWP		0x00000080	/* FTLB write protect (high true) */

#define TIR_FUP		0x00000100	/* FTLB user protect (high true) */
#define TIR_GM0		0x00000200	/* GM0 (GTLB Match 0) - 27:24 (high true) */
#define TIR_GM1		0x00000400	/* GM1 - 31:28 (high true) */
#define TIR_GM2		0x00000800	/* GM2 - GTLB valid (high true) */

#define TIR_GIO		0x00001000	/* GTLB io bit (high true) */
#define TIR_GUP		0x00002000	/* GTLB user protect (high true) */
#define TIR_GWP		0x00004000	/* GTLB write protect (high true) */
#define TIR_GPV		0x00008000	/* GTLB page valid (high true) */

#define TIR_DIRTY	0x00010000	/* Cache block dirty (high true) */
#define TIR_CORRUPT	0x00020000	/* Cache block corrupt (high true) */
#define TIR_FM3		0x00040000	/* FM3 - 31:28 (high true) */

#ifdef Series5e
#define TIR_CM3		0x00080000	/* CM2 - 31:29 and valid (high true) */
#define TIR_CVAL	TIR_CM3		/* CVAL - Cache Valid (high true) */
#else
#define TIR_CVAL	TIR_CM2		/* CVAL - Cache Valid (high true) */
#endif Series5e
#define TIR_FVAL	TIR_FM2		/* FVAL - FTLB valid (high true) */
#define TIR_GVAL	TIR_GM2		/* GVAL - GTLB valid (high true) */

#ifdef Series5e
#define TIR_MASK	0x007fffff	/* TIR mask */
#define TIR_TAGADD	0x00700000	/* TAGADD - 31:29 (FTIR extension) */
#define TIR_CMASK	(TIR_CM3|TIR_CM2|TIR_CM1|TIR_CM0|TIR_POWN)
#else
#define TIR_MASK	0x0007ffff	/* TIR mask */
#define TIR_CMASK	(TIR_CM2|TIR_CM1|TIR_CM0|TIR_POWN)
#endif Series5e
#define TIR_FMASK	(TIR_FUP|TIR_FWP|TIR_FM3|TIR_FM2|TIR_FM1|TIR_FM0)
#define TIR_GMASK	(TIR_GPV|TIR_GWP|TIR_GUP|TIR_GIO|TIR_GM2|TIR_GM1|TIR_GM0)

#endif
