/* @(#) pte.h 1.1@(#) Solbourne id 9/21/93 23:59:00 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*      @(#)pte.h 1.9 88/09/20 SMI      */

/*
 * Copyright (c) 1988 by Sun Microsystems, Inc.
 */

/*
 * Kbus CPU hardware page table entry
 * 
 * Software must handle updating the reference and modify bits. This
 * is handled via the software protection information.
 */

#ifndef _machine_pte_h
#define _machine_pte_h

#ifndef LOCORE
#ifdef Series4
struct pte {
	unsigned int	pg_pfnum:19;	/* page frame number */
	unsigned int	:1;
	unsigned int	pg_lock:1;	/* software lock pte bit */
	unsigned int	pg_nosync:1;	/* software don't sync pg_r and pg_m */
	unsigned int	pg_sv:1;	/* software valid bit, for pg_r */
	unsigned int	pg_sro:1;	/* software read-only bit , for pg_m */
	unsigned int	pg_tlbinv:1;	/* if 1 => invalidate tlb entry (Series5 only) */
	unsigned int	:1;		/* hardware iob bit, not used */
	unsigned int	pg_io:1;	/* io bit */
	unsigned int	pg_prot:2;	/* access protection */
	unsigned int	pg_m:1;		/* software modify bit */
	unsigned int	pg_r:1;		/* software reference bit */
	unsigned int	pg_v:1;		/* valid bit */
};
#endif Series4
#ifdef Series5
struct pte {
	unsigned int	pg_pfnum:19;	/* page frame number */
	unsigned int	pg_sp3:1;
	unsigned int	pg_lock_sp2:1;	/* software lock pte bit */
#define pg_lock		pg_lock_sp2	/* non io pte */
#define pg_sp2		pg_lock_sp2	/* io pte */
	unsigned int	pg_nosync_sp1:1; /* software don't sync pg_r and pg_m */
#define pg_nosync	pg_nosync_sp1	/* non io pte */
#define pg_sp1		pg_nosync_sp1	/* io pte */
	unsigned int	pg_sp0:1;
	unsigned int	pg_sro:1;	/* software read-only bit , for pg_m */
	unsigned int	pg_tlbinv:1;	/* if 1 => invalidate tlb entry (Series5 only) */
	unsigned int	pg_sv:1;	/* software valid bit, for pg_r */
	unsigned int	pg_io:1;	/* io bit */
	unsigned int	pg_prot:2;	/* access protection */
	unsigned int	pg_m:1;		/* software modify bit */
	unsigned int	pg_r:1;		/* software reference bit */
	unsigned int	pg_v:1;		/* valid bit */
};
#endif Series5
#ifdef refmmu
struct pte {
	unsigned int	pg_pfnum:24;	/* page frame number */
	unsigned int	pg_cacheable:1;	/* if 1 => page is cacheable */
	unsigned int	pg_m:1;		/* hardware modified bit */
	unsigned int	pg_r:1;		/* hardware referenced bit */
	unsigned int	pg_prot:3;	/* access protection */
	unsigned int	pg_type:2;	/* entry type */
};
struct ptp {
	unsigned int	ptp_pa:28;	/* pa of beginning of page table */
	unsigned int	ptp_resvd:2;	/* reserved */
	unsigned int	ptp_type:2;	/* entry type (must be 0x1 for ptp) */
};
#endif refmmu
#if	!(defined(Series4) || defined(Series5) || defined(refmmu))
struct pte {
	unsigned int	dummy;		/* for sun compatibility */
};
#endif
#endif	!LOCORE

#ifdef Series4
#define	PG_V		0x00000001	/* page is valid */
#define	PG_R		0x00000002	/* software reference bit */
#define	PG_M		0x00000004	/* software modify bit */
#define	PG_RO		0x00000008	/* read only page */
#define	PG_UP		0x00000010	/* user protected page */
#define	PG_IO		0x00000020	/* io access */
#define PG_IOB		0x00000040	/* Series4 only IOB bit */
#define	PG_SRO		0x00000100	/* sftw read-only, for sftw pg_m bit */
#define	PG_SV		0x00000200	/* sftw valid, for sftw pg_r bit */
#define	PG_NOSYNC	0x00000400	/* sftw nosync */
#define	PG_LOCK		0x00000800	/* sftw lock */
#define	PG_PFNUM	0xFFFFE000	/* page frame number mask */
#define	PG_PFNUM_INC	0x00002000	/* increment s PFN field by 1 */
#define	PG_BITS		\
"\32\14LOCK\13NOSYNC\12SWVAL\11SWRO\10TLBINV\7IOB\6IO\5UPROT\4RO\3MOD\2REF\1VAL"
#endif Series4

#ifdef Series5
#define	PG_V		0x00000001	/* page is valid */
#define	PG_R		0x00000002	/* software reference bit */
#define	PG_M		0x00000004	/* software modify bit */
#define	PG_RO		0x00000008	/* read only page */
#define	PG_UP		0x00000010	/* user protected page */
#define	PG_IO		0x00000020	/* io access */
#define PG_SV		0x00000040	/* sftw valid, for sftw pg_r bit */
#define	PG_TLBINV	0x00000080	/* invalidate tlb entry */
#define	PG_SRO		0x00000100	/* sftw read-only, for sftw pg_m bit */
#define	PG_NOSYNC	0x00000400	/* sftw nosync */
#define	PG_LOCK		0x00000800	/* sftw lock */
#define PG_SPACE	0x00001E00	/* space bits if io==1 */
#define	PG_PFNUM	0xFFFFE000	/* page frame number mask */
#define	PG_PFNUM_INC	0x00002000	/* increment s PFN field by 1 */
#define	PG_BITS		\
"\32\14LOCK\13NOSYNC\12SWVAL\11SWRO\10TLBINV\7IOB\6IO\5UPROT\4RO\3MOD\2REF\1VAL"
#endif Series5

#ifdef refmmu
#define	PG_R		0x00000020	/* hardware referenced bit */
#define	PG_M		0x00000040	/* hardware modified bit */
#define	PG_CACHEABLE	0x00000080	/* page is cacheable bit */

/*
 * entry type field bits
 */
#define	PG_TYPE		0x00000003	/* entry field mask */
#define	PG_INVALID	0x00000000	/* entry is invalid */
#define	PG_PTP		0x00000001	/* entry is a ptp */
#define	PG_PTE		0x00000002	/* entry is a pte */

/*
 * high order mbus address bits are used as cache ownership
 * hints when filling from kbus memory or used as complement
 * of kbus I/O space bits when making kbus I/O accesses
 */
#ifndef notdef
#define	PFN_KBUS_SPACE_SHARE	0xb00000	/* don't take ownership when filling cache */
#define	PFN_KBUS_SPACE_OWN	0x900000	/* take ownership when filling cache */
#else
/* DEBUG */
#define	PFN_KBUS_SPACE_SHARE	0x900000	/* don't take ownership when filling cache */
#define	PFN_KBUS_SPACE_OWN	0xb00000	/* take ownership when filling cache */
/* DEBUG */
#endif notdef
#define	PFN_KBUS_SPACE_MASK	0x0f0000	/* mask for kbus space bits in pfn */
#define	PFN_MBUS_SPACE_MASK	0xf00000	/* mask for space bits on mbus in pfn */

/*
 * entry type field values
 */
#define	PTE_INVALID	0		/* entry is invalid */
#define	PTE_PTP		1		/* entry is a ptp */
#define	PTE_PTE		2		/* entry is a pte */

#define	PG_PFNUM	0xFFFFFF00	/* page frame number mask */
#define	PG_PFNUM_INC	0x00000100	/* increment PFN field by 1 */
#define	PG_BITS		\
"\32\8CACHEABLE\7MODIFIED\6REFERENCED"

/* dummy field ONLY for driver source compatibility */
#define	PG_IO		0x00000000	/* if CACHEABLE not set, IO assumed */
#define	PG_V		PG_PTE
#endif refmmu


#if	defined(Series4) || defined(Series5)
#define	KW		0x2
#define	KR		0x3
#define	UW		0x0
#define UR		0x1
#define	URKR		0x1
#define RDONLY		0x1
#define KERNONLY	0x2

#define	MAKE_PROT(v)	((v) << 3)
#define	PG_PROT		MAKE_PROT(0x3)
#define	PG_KW		MAKE_PROT(KW)
#define	PG_KR		MAKE_PROT(KR)
#define	PG_UW		MAKE_PROT(UW)
#define	PG_URKR		MAKE_PROT(URKR)
#define	PG_UR		MAKE_PROT(UR)
#define	PG_UPAGE	PG_KW		/* u pages not user accessable */
#define PG_RDONLY	MAKE_PROT(RDONLY)
#endif	Series4 || Series5
#ifdef	refmmu
#define	KW		0x7
#define	KR		0x6
#define KWUR		0x5
#define	UW		0x3
#define UR		0x2
#define	URKR		0x2
#define RDONLY		0x2
#define WRITEABLE	0x1
#define KERNONLY	0x4

#define	MAKE_PROT(v)	((v) << 2)
#define	PG_PROT		MAKE_PROT(0x7)
#define	PG_KW		MAKE_PROT(KW)
#define	PG_KR		MAKE_PROT(KR)
#define	PG_KWUR		MAKE_PROT(KWUR)
#define	PG_UW		MAKE_PROT(UW)
#define	PG_URKR		MAKE_PROT(URKR)
#define	PG_UR		MAKE_PROT(UR)
#define	PG_UPAGE	PG_KW		/* u pages not user accessable */
#define PG_WRITEABLE	MAKE_PROT(WRITEABLE)
#define PG_KERNONLY	MAKE_PROT(KERNONLY)
#endif	refmmu


/*
 * This macro can be used to convert a struct pte * in to the relevant
 * bits needed for things like mapin and cdevsw[] mmap routine which
 * still deal with integers.
 */
#if	defined(Series4) || defined(Series5) || defined(S4000)
#define	MAKE_PFNUM(pte)	(((*(unsigned int *)(pte)) & PG_PFNUM) >> MMU_PAGESHIFT)
#endif	Series4 || Series5 || S4000
#if	defined(Series6) || defined(Series7)
#define	MAKE_PFNUM(ppte)	(((struct pte *)(ppte))->pg_pfnum & ~PFN_MBUS_SPACE_MASK)
#endif	Series6 || Series7

/*
 * Macros to test and set fields in a pte.
 */
/*
 * Macros to test and set fields in a pte.
 */
#if	defined(Series4) || defined(Series5)
#define	pte_valid(pte)	((pte)->pg_v != 0)
#define	pte_svalid(pte)	((pte)->pg_sv != 0)
#define pte_konly(pte)	((*(int *)(pte) & PG_UP) == 0)
#define pte_ronly(pte)	((*(int *)(pte) & PG_RO) != 0)
#define pte_setio(ppte)	(ppte)->pg_io = 1;
#define pte_io(ppte)	((ppte)->pg_io != 0)
#ifdef Series5
#define pte_io_ok(ppte)	(((ppte)->pg_sp3 == 0) && ((ppte)->pg_sp2 == 0) && \
			 ((ppte)->pg_sp1 == 0) && ((ppte)->pg_sp0 == 0))
#endif Series5
#endif	Series4 || Series5
#ifdef	refmmu
#define	pte_valid(pte)	((pte)->pg_type == PTE_PTE)
#define pte_setio(ppte)	(ppte)->pg_cacheable = 0;

#ifdef Series7
#define pte_io(ppte)	((ppte)->pg_cacheable == 0 &&	\
				((ppte)->pg_pfnum & PFN_MBUS_SPACE_MASK) != PFN_KBUS_SPACE_SHARE)
#else
#define pte_io(ppte)	((ppte)->pg_cacheable == 0)
#endif Series7
#endif	refmmu

#if !defined(LOCORE) && defined(KERNEL)
/* utilities defined in locore.s */
extern	struct pte Heapptes[];
extern	char Heapbase[];
extern	char Heaplimit[];
extern	struct pte Bufptes[];
extern	char Bufbase[];
extern	char Buflimit[];
extern	struct pte Sysmap[];
extern	char Sysbase[];
extern	struct pte Forkmap[];
extern	struct pte mmap[];
extern	struct pte CMAP1[];
extern	char CADDR1[];
extern	struct pte CMAP2[];
extern	char CADDR2[];
extern	char Syslimit[];

/*
 * These defines are just here to be an aid
 * for someone that was using these defines.
 */
#define	Usrptmap	Sysmap
#define	usrpt		Sysbase

extern	struct pte mmu_pteinvalid;
#endif !defined(LOCORE) && defined(KERNEL)
#endif !_machine_pte_h
