/* @(#) led.h 1.1@(#) Solbourne id 9/21/93 23:58:12 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/* <machine/led.h> -- LED header file
 *
 * This file contains constants related to the LED's on each
 * CPU board.  The LED's consist of two 7-segment displays.
 *
 * The segments of each digit are labeled as follows:
 *            a           a
 *           ---         ---
 *         f|   |b     f|   |b
 *           -g-         -g-
 *         e|   |c     e|   |c
 *           --- .       --- .
 *            d           d
 *
 * Each segment corresponds to a bit in the LED register:
 *
 *       left hand digit | right hand digit
 *       15                             0
 *       +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *       |.|g|f|e|d|c|b|a|.|g|f|e|d|c|b|a|
 *       +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+ 
 *
 * To turn a segment ON, the bit must be cleared, and to
 * turn a segment OFF, the bit must be set.
 *
 * When a diagnostic test has an error, three things are
 * displayed on the LEDS in a loop:
 *	1. The test number
 *	2. "--" (two dashes)
 *	3. The error code
 *
 * When the ROM code does a reset halt, those three things become:
 *	1. LEDS_ROM_HALT (defined below)
 *	2. "--" (two dashes)
 *	3. The code on the leds at the time the reset halt occurred
 *
 * When the ROM code or a stand-alone program is checking for input,
 * a dash will alternate between the two LEDs.
 *
 * When the UNIX kernel is idle, a small 'o' will move around
 * the LEDs.
 */

/* codes mapped into LED register values: */
#define LED_0		0xc0		/* "0" */	
#define LED_1		0xf9		/* "1" */
#define LED_2		0xa4 		/* "2" */
#define LED_3		0xb0		/* "3" */
#define LED_4		0x99		/* "4" */	
#define LED_5		0x92		/* "5" */
#define LED_6		0x82		/* "6" */
#define LED_7		0xf8		/* "7" */
#define LED_8		0x80		/* "8" */
#define LED_9		0x98		/* "9" */
#define LED_A		0x88		/* "A" */
#define LED_b		0x83		/* "b" */
#define LED_C		0xc6		/* "C" */
#define LED_d		0xa1		/* "d" */
#define LED_E		0x86		/* "E" */
#define LED_F		0x8e		/* "F" */
#define LED_P		0x8c		/* "P" */
#define LED_L		0xc7		/* "L" */
#define LED_S		0x92		/* "S" */
#define LED_U		0xc1		/* "U" */
#define LED_BLANK	0xff		/* " " */
#define LED_BAR		0xfe		/* "-" (upper) */
#define LED_DASH	0xbf		/* "-" (middle) */	
#define LED_RUB		0xf7		/* "_" (lower) */
#define LED_EQU		0xbe		/* "=" (upper) */
#define LED_EQL		0xb7		/* "=" (lower) */
#define LED_OU		0x9c		/* "o" (upper) */
#define LED_OL		0xa3		/* "o" (lower) */
#define LED_DP		0x7f		/* "." */

#define LED_MASK	0xffff

/* First LED code written: */
#define LEDS_ROM_STARTED	0x00	/* ROM started executing */

/*
 * IDPROM checksum failure (right-hand digit contains slot number):
 *	range 0x91-0x97
 */
#define LEDS_ID_CHKSUM		0x90	/* Bad IDPROM checksum */

/*
 * LED codes written by diagnostics (other than test numbers):
 *	range 0xa0 - 0xaf
 */

#define	LEDS_MASTER_FAILED	0xa0	/* master failed */
#define LEDS_GIVING_MASTER	0xa1	/* Relinquishing mastership */
#define LEDS_RECEIVED_MASTER	0xa2	/* slave received mastership */
#define LEDS_GIVING_MASTER_TMO	0xa3	/* Timeout while giving mastership */

#define LEDS_AWAKING_SLAVES	0xa4	/* Awaking Slave CPU */
#define LEDS_RECEIVED_SLAVE	0xa5
#define LEDS_SLAVE_GOOD		0xa6	/* Slave CPU Passed power-up tests */
#define LEDS_SLAVE_FAILED	0xa7	/* slave failed */
#define LEDS_SLAVE_BAD		0xa8	/* Slave CPU Failed power-up tests */
#define LEDS_SLAVE_TMO		0xa9	/* Timeout while awaking Slave CPU */

#define LEDS_DIAG_BURNIN	0xab	/* Burn-in jumper detected, looping */
#define LEDS_DIAG_DONE		0xad	/* ROM power up tests completed */
#define LEDS_INITING_ECC	0xae	/* Initializing ECC */


/*
 * LED codes written by ROM initialization:
 *	range 0xb0 - 0xcf
 */
#define LEDS_ROM_MAIN		0xb0	/* ROM main() starting */
#define LEDS_INITING_IOMAP	0xb1	/* Initializing IO mapping addresses */
#define LEDS_BAD_EECKSUM	0xb2	/* Bad EEROM checksum (warning) */
#define LEDS_INITING_EEROM	0xb3	/* Initializing EEROM */
#define LEDS_INITING_IOB	0xb4	/* Initializing the IOBs */
#define LEDS_INITING_DEVS	0xb5	/* Initializing the devices */
#define LEDS_INITING_IOE	0xb6	/* Initializing stdin,stdout,stderr */
#define LEDS_INITING_FS		0xb7	/* Initializing the file systems */
#define LEDS_INITING_ARP	0xb8	/* Initializing ARP */
#define LEDS_INITING_MBUFS	0xb9	/* Initializing mbufs */
#define LEDS_INITING_SOCK	0xba	/* Initializing sockets */
#define LEDS_INITING_CONS	0xbb	/* Initializing the console */
#define LEDS_CONOPEN_FAILED	0xbc	/* could not open console device */
#define LEDS_INITING_MAIN	0xbd	/* Initializing main before cmdloop */
#define LEDS_COMMAND_LOOP	0xbe	/* Waiting for command from console */
#define LEDS_DO_COMMAND		0xbf	/* Executing a command */
#define LEDS_CRT0		0xc0	/* Stand-alone crt0 starting */
#define LEDS_SA_MAIN		0xc1	/* Stand-alone crt0 calling main */
#define LEDS_NO_SYSBOARD	0xc8	/* No system board found */
#define LEDS_FCR_NZ		0xce	/* FCR not zero on reset */
#define LEDS_ROM_HALT		0xcf	/* Executing a reset halt */

#if	defined(Series6) || defined(Series7)
#define LEDS_FCR_IR		0xcc	/* Inactivity Reset */
#endif Series6 || Series7

/*
 * LED codes for devices (displayed during device initialization):
 *	range 0xd0 - 0xe7
 */
#define LEDS_DEV_TT		0xd0	/* Simulated UART */
#define LEDS_DEV_DI		0xd1	/* Simulated disk */
#define LEDS_DEV_EI		0xd2	/* Lance ethernet */
#define LEDS_DEV_TM		0xd3	/* Real time clock */
#define LEDS_DEV_RD		0xd4	/* Ram disk */
#define LEDS_DEV_EX		0xd5	/* Execelan ethernet */
#define LEDS_DEV_RS		0xd6	/* VME-to-SCSI controller */
#define LEDS_DEV_ZS		0xd7	/* UART driver */
#define LEDS_DEV_KM		0xd8	/* Keyboard/mouse */
#define LEDS_DEV_FB		0xd9	/* Frame buffer */

/*
 * LED codes used by the UNIX kernel:
 *	range 0xe8 - 0xff
 */
#define LEDS_MS_SLAVE_HALT	0xe8	/* slave waiting for master to halt */
#define LEDS_MS_WAIT_CMD	0xe9	/* cpu waiting for command ack */
#define LEDS_MS_DISABLED	0xea	/* slave disabled */
#define LEDS_MS_START_SLAVES	0xeb	/* master waiting for slave to start */
#define LEDS_MS_SLAVE_START	0xec	/* slave start */
#define LEDS_MS_MASTER_HALT	0xed	/* master waiting for slave to halt */
#define LEDS_MS_MASTER_NMI	0xee	/* master waiting for slave to nmi */
#define LEDS_MS_TRACE_DUMP	0xef	/* cpu dumping trace information */
#define LEDS_MS_WAITROM		0xf0	/* cpu waiting to go to rom */
#define LEDS_MS_DUMPSYS		0xf1	/* kernel dumping core */
#define LEDS_MS_CPUHUP		0xf2	/* cpu is hung in idle for panic */
#define LEDS_MS_SLAVE_CALLBACK	0xf3	/* a slave tried to call back to rom */
#define LEDS_MS_IDLE		0xf4	/* idle on process */
#define LEDS_MS_IDLEI		0xf5	/* idle on idle process */
#define LEDS_MS_SYNC		0xf6	/* master starts to sync disks */
#define LEDS_MS_SLAVES_TO_ROM	0xf7	/* master tells slaves, or slaves going */
#define LEDS_MS_ROM_RESET	0xf8	/* master going back to roms */
#define LEDS_MS_NMI		0xf9	/* cpu got an nmi */

/* PA - (PAnic) used in subr_prf for kernel panic */
/* SE - (System Error) used in machdep.c for multibit ecc error */
