/* @(#) if_egstruct.h 1.1@(#) Solbourne id 9/22/93 00:10:47 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/* Link-level interface driver for Interphase 4207 (EAGLE) */

/*
 *   if_eglstruct.h : V/Ethernet 4207 EAGLE.
 *
 *   Created: 11/17/87 by Interphase Corp.
 *
 *   Author: Manlio D. Marquez
 *
 *   Contains all of the structs and types for Eagle MACSI.
 *   This is basically snarfed from the Jaguar code.
 *
 *	Modification History
 *	11/24/87 change layout of MCSB to agree with Eagle internal MACSI
 *		 change layout of CSB to agree with Eagle internal MACSI
 *		 eliminate 'duplicate' init workq iopb definition.
 *
 *	11/24/87 add direction bit to topt for vme transfer direction.
 *
 *  11/28/87 fix misdefinition of interface bits
 *
 *  11/30/87 add iopbs for change node address and filter
 *
 *   6/22/88 add new CSTB definition and scatter gather element desc.
 */

#define MAX_CQE		32		/* must be a power of two */
#define MAX_IOPB	MAX_CQE

#define S_SHORTIO	2048	/* total short i/o space */

#define S_MCSB		sizeof(EG_MCSB)
#define S_MCE		sizeof(EG_CQE)
#define S_CQE		sizeof(EG_CQE)
#define S_IOPB		sizeof(EG_IOPB)
#define S_IOPB_MCE	sizeof(EG_IOPB)
#define S_CRB		sizeof(EG_CRB)
#define S_CSTB		sizeof(EG_CSTB)
#define S_CSB		sizeof(EG_CSB)
#define S_CIB		sizeof(EG_CIB)
#define S_WQIB		sizeof(EG_WQIB)
#define S_WQCF		sizeof(EG_WQCF)

#define O_MCE_IOPB	(S_MCSB+S_MCE+(S_CQE+S_IOPB)*MAX_CQE)
#define S_HUS		(S_SHORTIO - (S_MCSB + S_CQE + \
				((S_CQE + S_IOPB) * MAX_CQE) + S_IOPB_MCE + \
				S_CRB + 4 + S_IOPB + S_CSTB + S_CSB + 4))
#define N_SCRTCH	(unsigned)(S_HUS / sizeof(UWORD))


#define WORDP(x)	((x)->U.w)
#define WORD_(x)	((x).U.w)


/****************     Master Control Status Block (MCSB) ****************** */

typedef struct msr {		/* Master Status Register */
	union {
	struct {
		Bit	     : 13;	/* reserved bits */
		Bit	QFC  :  1;	/* Queue Flush Complete */
		Bit	BOK  :  1;	/* Board OK */
		Bit	CNA  :  1;	/* Controller Not Available */
	} b;
	UWORD	w;
	} U;
} EG_MSR;

#define M_MSR_QFC	0x0004
#define M_MSR_BOK	0x0002
#define M_MSR_CNA	0x0001
#define B_MSR_QFC(x)	((x).U.b.QFC)
#define B_MSR_BOK(x)	((x).U.b.BOK)
#define B_MSR_CNA(x)	((x).U.b.CNA)
#define W_MSR(x)	((x).U.w)

typedef struct mcr {		/* Master Control Register */
	union {
	struct {
		Bit	      : 2;	/* reserved bits */
		Bit	SFEN  : 1;	/* Sysfail Enable */
		Bit	RES   : 1;	/* Reset controller */
		Bit	FLQ   : 1;	/* Flush Queue */
		Bit	      : 8;	/* reserved bits */
		Bit	FLQR  : 1;	/* Flush Queue and Report */
		Bit	      : 1;	/* reserved bits */
		Bit	SQM   : 1;	/* Start Queue Mode */
	} b;
	UWORD	w;
	} U;
} EG_MCR;

#define M_MCR_SFEN	0x2000
#define M_MCR_RES	0x1000
#define M_MCR_FLQ	0x0800
#define M_MCR_FLQR	0x0004
#define M_MCR_SQM	0x0001
#define B_MCR_SFEN(x)	((x).U.b.SFEN)
#define B_MCR_RES(x)	((x).U.b.RES)
#define B_MCR_FLQ(x)	((x).U.b.FLQ)
#define B_MCR_FLQR(x)	((x).U.b.FLQR)
#define B_MCR_SQM(x)	((x).U.b.SQM)
#define W_MCR(x)	((x).U.w)


typedef struct iqar {		/* Interrupt on Queue Available Reg */
	union {
	struct {
		Bit	IQEA : 1;	/* Interrupt on Queue entry Available */
		Bit	IQEH : 1;	/* Interrupt on Queue Half Empty Enable */
		Bit	     : 3;	/* Reserved bits */
		Bit	ILVL : 3;	/* Interrupt Level on Queue Available */
		Bit	IVCT : 8;	/* Interrupt Vector on Queue Available */
	} b;
	UWORD	w;
	} U;
} EG_IQAR;

#define M_IQAR_IQEA	0x8000
#define M_IQAR_IQEH	0x4000
#define M_IQAR_ILVL	0x0700
#define M_IQAR_IVCT	0x00FF
#define B_IQAR_IQEA(x)	((x).U.b.IQEA)
#define B_IQAR_IQEH(x)	((x).U.b.IQEH)
#define B_IQAR_ILVL(x)	((x).U.b.ILVL)
#define B_IQAR_IVCT(x)	((x).U.b.IVCT)
#define W_IQAR(x)	((x).U.w)

typedef struct mcsb {		/* Master control/Status Block */
	EG_MSR	mcsb_MSR;		/* Master status register */
	UWORD	mcsb_RES0;		/* Reserved word 0 */
	EG_MCR	mcsb_MCR;		/* Master Control register */
	EG_IQAR	mcsb_IQAR;		/* Interrupt on Queue Available Reg */
	UWORD	mcsb_QHDP;		/* Queue head pointer */
	UWORD	mcsb_RES1;		/* Reserved word 1 */
	UWORD	mcsb_RES2;		/* Reserved word 2 */
	UWORD	mcsb_RES3;		/* Reserved word 3 */
} EG_MCSB;

/**************** END Master Control Status Block (MCSB) ****************** */

/***************      Controller Initialization Block (CIB)**************** */

typedef struct imod {		/* Interface Specific Mode / 
					   Physical Interface Mode */
	union {
	struct {
		Bit	 PRM : 1;	/* Promiscuous Mode */
		Bit	 INL : 1;	/* Internal Loopback */
		Bit	 DRY : 1;	/* Disable Retry */
		Bit	 COL : 1;	/* Force Collision */
		Bit	 DTC : 1;	/* Disable Transmit CRC */
		Bit	  LP : 1;	/* Loopback */
		Bit	 DTX : 1;	/* Disable Transmit */
		Bit	 DRX : 1;	/* Disable Receive */
		Bit		 : 4;	/* Reserved */
		Bit	PX25 : 1;	/* X.25 (not supported) */
		Bit	PSTR : 1;	/* Starlan (not supported) */
		Bit	   PIEEE : 1;	/* IEEE 802.3 */
		Bit	  PE : 1;	/* Ethernet */
	} b;
	UWORD	w;
	} U;
} EG_IMOD;

#define M_IMOD_PRM	0x8000
#define M_IMOD_INL	0x4000
#define M_IMOD_DRY	0x2000
#define M_IMOD_COL	0x1000
#define M_IMOD_DTC	0x0800
#define M_IMOD_LP	0x0400
#define M_IMOD_DTX	0x0200
#define M_IMOD_DRX	0x0100
#define M_IMOD_PX	0x0008
#define M_IMOD_PS	0x0004
#define M_IMOD_PIEEE	0x0002
#define M_IMOD_PE	0x0001
#define B_IMOD_PRM(x)	((x).U.b.PRM)
#define B_IMOD_INL(x)	((x).U.b.INL)
#define B_IMOD_DRY(x)	((x).U.b.DRY)
#define B_IMOD_COL(x)	((x).U.b.COL)
#define B_IMOD_DTC(x)	((x).U.b.DTC)
#define B_IMOD_LP(x)	((x).U.b.LP)
#define B_IMOD_DTX(x)	((x).U.b.DTX)
#define B_IMOD_DRX(x)	((x).U.b.DRX)
#define B_IMOD_PE(x)	((x).U.b.PE)
#define B_IMOD_PIEEE(x)	((x).U.b.PIEEE)
#define B_IMOD_PS(x)	((x).U.b.PS)
#define B_IMOD_PX(x)	((x).U.b.PX)

typedef struct vect {		/* Vector structure */
	union {
	struct {
		Bit	     : 5;	/* Reserved bits */
		Bit	ILVL : 3;	/* Interrupt Level */
		Bit	IVCT : 8;	/* Interrupt Vector */
	} b;
	UWORD	w;
	} U;
} EG_VECT;

#define M_VECT_ILVL	0x0700
#define M_VECT_IVCT	0x00FF
#define B_VECT_ILVL(x)	((x).U.b.ILVL)
#define B_VECT_IVCT(x)	((x).U.b.IVCT)
#define W_VECT(x)	((x).U.w)

typedef struct cib {		/* Controller Initialization Block */
	UBYTE	 cib_RES0;		/* Reserved byte 0 */
	UBYTE	 cib_NCQE;		/* Number of Command Queue Entries */
	EG_IMOD cib_IMOD;		/* Interface Modes */
	UBYTE	 cib_NTXR;		/* Num LANCE Tx Rings */
	UBYTE	 cib_NRXR;		/* Num LANCE Rx Rings */
	UBYTE	 cib_PHY[6];		/* Ethernet Physical Address */
	UBYTE	 cib_FILT[8];		/* Ethernet Logical Address Filter */
	UWORD	 cib_RXSIZ;		/* Rx Buffer Size / Length */
	UWORD	 cib_NRBUF;		/* Number of Rx buffers */
	UWORD	 cib_TXSIZ;		/* Tx Buffer Size / Length */
	UWORD	 cib_NIBUF;		/* Number of Internal Tx Buffers */
	UWORD	 cib_NHBUF;		/* Number of Host Managed Tx Buffers */
	EG_VECT cib_NVECT;		/* Normal Completion Vector */
	EG_VECT cib_EVECT;		/* Error Completion Vector */
	UWORD	 cib_BURST;		/* DMA Burst count */
	UWORD	 cib_RES1[4];		/* Reserved words */
} EG_CIB;

typedef struct wqs {		/* Work queue Status */
	union	{
	struct	{
		Bit	IACT : 1;	/* Initialized Active */
		Bit	   INACT : 1;	/* Initialized Inactive */
		Bit		 : 14;	/* Reserved Bits */
	} b;
	UWORD	w;
	} U;
} EG_WQS;

#define M_WQS_IACT	0x8000
#define M_WQS_INACT	0x4000
#define B_WQS_IACT(x)	((x).U.b.IACT)
#define B_WQS_INACT(x)	((x).U.b.INACT)
#define W_WQS(x)	((x).U.w)

typedef struct wqib {		/* Work Queue Information Block */
	EG_WQS	wqib_WQS;		/* Work Queue Status */
	ULONG	wqib_MAXENT;	/* Work Queue Max Entries */
	ULONG	wqib_CURENT;	/* Work Queue Current Entries */
	UWORD	wqib_REF;		/* Work Queue Reference Number */
	UWORD	wqib_PRIO;		/* Work Queue Priority */
	UWORD	wqib_WDIV;		/* Work Queue Work division */
} EG_WQIB;

/**************** END Controller Initialization Block (CIB)**************** */

/****************     Command Queue Entry (CQE)          ****************** */

typedef struct qecr {		/* Queue Entry Control Register */
	union {
	struct {
		Bit	     : 13;	/* Reserved bits */
		Bit	HPC  : 1;	/* High Priority Command */
		Bit	AA   : 1;	/* Abort Acknowledge */
		Bit	GO   : 1;	/* Go/Busy */
	} b;
	UWORD	w;
	} U;
} EG_QECR;

#define M_QECR_HPC	0x0004
#define M_QECR_AA	0x0002
#define M_QECR_GO	0x0001
#define B_QECR_HPC(x)	((x).U.b.HPC)
#define B_QECR_AA(x)	((x).U.b.AA)
#define B_QECR_GO(x)	((x).U.b.GO)
#define W_QECR(x)	((x).U.w)

typedef struct cqe {		/* Command Queue Entry */
	EG_QECR	cqe_QECR;		/* Queue Entry Control Register */
	UWORD	cqe_IOPB_ADDR;      /* IOPB Address */
	ULONG	cqe_CTAG;		/* Command Tag */
	UBYTE	cqe_RES0;		/* Reserved */
	UBYTE	cqe_WORK_QUEUE;	/* Work Queue Number */
	UWORD	cqe_RES1;		/* Reserved word */
} EG_CQE;

/**************** END Command Queue Entry (CQE)          ****************** */

/****************     Command Response Block (CRB)       ****************** */

typedef struct crsw {		/* Command Response Status Word */
	union {
	struct {
		Bit	      : 9;	/* Reserved bits */
		Bit	QEA   : 1;	/* Queue Entry Available */
		Bit	QMS   : 1;	/* Queue Mode Started */
		Bit	AQ    : 1;	/* Abort Queue */
		Bit	EX    : 1;	/* Exception */
		Bit	ER    : 1;	/* Error */
		Bit	CC    : 1;	/* Command Complete */
		Bit	CRBV  : 1;	/* Command Response Block Valid/Clear */
	} b;
	UWORD	w;
	} U;
} EG_CRSW;

#define M_CRSW_QEA	0x0040
#define M_CRSW_QMS	0x0020
#define M_CRSW_AQ	0x0010
#define M_CRSW_EX	0x0008
#define M_CRSW_ER	0x0004
#define M_CRSW_CC	0x0002
#define M_CRSW_CRBV	0x0001
#define B_CRSW_QEA(x)	((x).U.b.QEA)
#define B_CRSW_QMS(x)	((x).U.b.QMS)
#define B_CRSW_AQ(x)	((x).U.b.AQ)
#define B_CRSW_EX(x)	((x).U.b.EX)
#define B_CRSW_ER(x)	((x).U.b.ER)
#define B_CRSW_CC(x)	((x).U.b.CC)
#define B_CRSW_CRBV(x)	((x).U.b.CRBV)
#define W_CRSW(x)	((x).U.w)

typedef struct crb {		/* Command Response Block */
	EG_CRSW	crb_CRSW;		/* Command Response Status Word */
	UWORD	crb_RES0;		/* Reserved word */
	ULONG	crb_CTAG;		/* Command Tag */
	UBYTE	crb_RES1;		/* Reserved byte */
	UBYTE	crb_WORK_QUEUE;	/* Work Queue Number */
	UWORD	crb_RES2;		/* Reserved word */
} EG_CRB;

#define CRB_CLR_DONE(cqe)	(W((cqe)->crb_CRSW) = 0)		
#define CRB_DONE(cqe)		(W((cqe)->crb_CRSW) & M_CRSW_CRBV)	
#define CRB_QSTARTED(cqe)	(W((cqe)->crb_CRSW) & (M_CRSW_CRBV|M_CRSW_QMS))
#define CQE_GO(cqe)		(W((cqe)->cqe_QECR) = M_QECR_GO)	
#define CQE_BUSY(cqe)		(W((cqe)->cqe_QECR) & M_QECR_GO)

/**************** END Command Response Block (CRB)       ****************** */

/****************     Configuration Status Block (CSTB)   ****************** */

typedef struct cstb {		/* Configuration Status Block 72 bytes */
	UBYTE	cstb_RES0[1];		/* Reserved byte */
	UBYTE	cstb_PCODE[3];		/* Product Code */
	UBYTE	cstb_RES1[1];		/* Reserved byte */
	UBYTE	cstb_PVAR;		/* Product Variation */
	UBYTE	cstb_RES2[1];		/* Reserved byte */
	UBYTE	cstb_FREV[3];		/* Firmware Revision level */
	UBYTE	cstb_FDATE[8];		/* Firmware Release date */
	UBYTE	cstb_RES3[1];		/* Reserved byte */
	UBYTE	cstb_SREV[3];		/* Software Revision Level */
	UBYTE	cstb_SDATE[8];		/* Software Release Date */
	UWORD	cstb_BSIZE;		/* Buffer size in Kbytes */
	ULONG	cstb_HUSO;		/* Host Usable Space Offset */
	ULONG	cstb_RBPO;		/* Receive Buffer Pool Offset */
	ULONG	cstb_HMTBO; 		/* Host Managed TX Buffer Pool Offset */
	ULONG	cstb_HUBO;		/* Host Usable Buffer Memory Offset */
	UBYTE	cstb_PHY[6];		/* Current Physical Node Address */
	UBYTE	cstb_FILT[8];		/* Current Logical Address Filter */
	UBYTE	cstb_RES4[10];		/* Reserved bytes */
} EG_CSTB;

/**************** END Configuration Status Block (CSTB)  ****************** */

/****************     Controller Statistics Block (CSB)  ****************** */

typedef struct csb {		/* Controller Statistics Block */
	ULONG	csb_TX_ATT;		    /* Number of Incoming TX IOPBs */
	ULONG   csb_TX_DMA;             /* Number of DMA completions */
	ULONG   csb_TX_INTR;            /* Number of LANCE TX interrupts */
	ULONG   csb_TX_GOOD;            /* Number of Good TXs */
	ULONG   csb_TX_ERR;             /* Number of TXs with errors */
	ULONG   csb_TX_DONE;            /* Number of TX dones posted */
	ULONG   csb_RX_ATT;             /* Number of RX attempted */
	ULONG   csb_RX_STARVE;          /* Number of Misses due to no IOPB */
	ULONG   csb_RX_INTR;            /* Number of LANCE RX interrupts */
	ULONG   csb_RX_GOOD;            /* Number of Good RXs */
	ULONG   csb_RX_ERR;             /* Number of RXs with errors */
	ULONG   csb_RX_DMA;             /* Number of RX DMA completions */
	ULONG   csb_RX_DONE;            /* Number of RX Dones posted */
	ULONG   csb_MISC_DMA;           /* Number of MISC DMAs */
	ULONG   csb_LAN_INTR;           /* Number of LANCE Interrupts */
	ULONG   csb_CSR0_ERR;           /* Number of CSR0 errors */
	ULONG   csb_CSR0_BABL;          /* Number of CSR0 babbles */
	ULONG   csb_CSR0_CERR;          /* Number of CSR0 collisions */
	ULONG   csb_CSR0_MISS;          /* Number of CSR0 miss errors */
	ULONG   csb_CSR0_MERR;          /* Number of CSR0 memory errors */
} EG_CSB;

/**************** END Controller Statistics Block (CSB)  ****************** */

/****************     IOPB Format (IOPB)                 ****************** */

typedef struct option {		/* IOPB Option word */
	union {
	struct {
		Bit	      : 6;	/* Reserved bits */
		Bit	DATA  : 1;	/* Transmit - pointer to data only */
		Bit	BABL  : 1;	/* Transmit - ignore babble errors */
		Bit	      : 2;	/* Reserved bits */
		Bit	BABLA : 1;	/* Revicve - report address on babble */
		Bit	      : 2;	/* Reserved bits */
		Bit	DMA   : 1;	/* DMA Enable */
		Bit	SG    : 1;	/* Scatter/Gather bit */
		Bit	IE    : 1;	/* Interrupt Enable */
	} b;
	UWORD	w;
	} U;
} EG_OPT;

#define M_OPT_DATA	0x0200
#define M_OPT_BABL	0x0100
#define M_OPT_BABLA	0x0020
#define M_OPT_DMA	0x0004
#define M_OPT_SG	0x0002
#define M_OPT_IE	0x0001
#define B_OPT_DATA(x)	((x).U.b.DATA)
#define B_OPT_BABL(x)	((x).U.b.BABL)
#define B_OPT_BABLA(x)	((x).U.b.BABLA)
#define B_OPT_DMA(x)	((x).U.b.DMA)
#define B_OPT_SG(x)	((x).U.b.SG)
#define B_OPT_IE(x)	((x).U.b.IE)
#define W_OPT(x)	((x).U.w)

typedef struct topt {		/* VME bus transfer options */
	union {
	struct {
		Bit	      : 3;	/* Reserved bits */
		Bit	 DIR  : 1;	/* Direction */
		Bit	TRANS : 2;	/* Transfer Type */
		Bit	MEMT  : 2;	/* Memory   Type */
		Bit		  : 2;	/* Reserved bits */
		Bit	ADRM  : 6;	/* Address modifier */
	} b;
	UWORD	w;
	} U;
} EG_TOPT;

#define M_TOPT_DIR	0x1000
#define M_TOPT_TRANS	0x0C00
#define M_TOPT_MEMT	0x0300
#define M_TOPT_MOD	0x003F
#define B_TOPT_DIR(x)	((x).U.b.DIR)
#define B_TOPT_TRANS(x)	((x).U.b.TRANS)
#define B_TOPT_MEMT(x)	((x).U.b.MEMT)
#define B_TOPT_MOD(x)	((x).U.b.ADRM)
#define W_TOPT(x)	((x).U.w)



typedef struct iopb {		/* Transmit / Receive IOPB */
	UWORD	 iopb_CMD;		/* IOPB Command code 0x50 / 0x60 */
	EG_OPT	 iopb_OPTION;		/* IOPB Option word */
	UWORD	 iopb_STATUS;		/* IOPB Return Status word */
	EG_VECT iopb_NVCT;		/* IOPB Normal completion Vector */
	EG_VECT iopb_EVCT;		/* IOPB Error  completion Vector */
	EG_TOPT iopb_TOPT;		/* IOPB VME bus transfer options */
	ULONG	 iopb_BUFF;		/* IOPB Buffer Address */
	ULONG	 iopb_LENGTH;		/* IOPB Max-Transfer Length */
	UWORD	 iopb_HBUF;		/* IOPB Host Managed Buffer Number */
	UWORD	 iopb_PTLF;		/* IOPB Packet Type / Length Field */
	UBYTE	 iopb_NODE[6];		/* IOPB Node Address */
	UWORD	 iopb_SGEC;		/* IOPB Scatter / Gather Element Count */
	UWORD	 iopb_LAN1;		/* IOPB LANCE Descriptor Word 1 */
	UWORD	 iopb_LAN3;		/* IOPB LANCE Descriptor Word 3 */
} EG_IOPB;

typedef struct ic_iopb {		/* Initialize Controller IOPB */
	UWORD	 ic_iopb_CMD;		/* IOPB Command code 0x41 */
	EG_OPT	 ic_iopb_OPTION;	/* IOPB Option word */
	UWORD	 ic_iopb_STATUS;	/* IOPB Return Status word */
	EG_VECT ic_iopb_NVCT;		/* IOPB Normal completion Vector */
	EG_VECT ic_iopb_EVCT;		/* IOPB Error  completion Vector */
	UWORD	 ic_iopb_RES0;		/* IOPB Reserved word */
	ULONG	 ic_iopb_BUFF;		/* IOPB Buffer Address */
	ULONG	 ic_iopb_RES1[5];	/* IOPB Reserved words */
} EG_IC_IOPB;

typedef struct cn_iopb {		/* Change Node Address IOPB */
	UWORD	 cn_iopb_CMD;		/* IOPB Command code 0x45 */
	EG_OPT	 cn_iopb_OPTION;	/* IOPB Option word */
	UWORD	 cn_iopb_STATUS;	/* IOPB Return Status word */
	EG_VECT cn_iopb_NVCT;		/* IOPB Normal completion Vector */
	EG_VECT cn_iopb_EVCT;		/* IOPB Error  completion Vector */
	UWORD	 cn_iopb_RES0[5];	/* IOPB Reserved word */
	UBYTE	 cn_iopb_PHY[6];	/* IOPB New Node Address */
	UWORD	 cn_iopb_RES1[5];	/* IOPB Reserved words */
} EG_CN_IOPB;

typedef struct cf_iopb {		/* Change Address FilterIOPB */
	UWORD	 cf_iopb_CMD;		/* IOPB Command code 0x46 */
	EG_OPT	 cf_iopb_OPTION;	/* IOPB Option word */
	UWORD	 cf_iopb_STATUS;	/* IOPB Return Status word */
	EG_VECT cf_iopb_NVCT;		/* IOPB Normal completion Vector */
	EG_VECT cf_iopb_EVCT;		/* IOPB Error  completion Vector */
	UWORD	 cf_iopb_RES0[5];	/* IOPB Reserved word */
	UBYTE	 cf_iopb_FILT[8];	/* IOPB New Logical Address Filter */
	UWORD	 cf_iopb_RES1[4];	/* IOPB Reserved words */
} EG_CF_IOPB;

typedef struct dl_iopb {		/* Download Software IOPB */
	UWORD	 dl_iopb_CMD;		/* IOPB Command code 0x47 */
	EG_OPT	 dl_iopb_OPTION;	/* IOPB Option word */
	UWORD	 dl_iopb_STATUS;	/* IOPB Return Status word */
	EG_VECT dl_iopb_NVCT;		/* IOPB Normal completion Vector */
	EG_VECT dl_iopb_EVCT;		/* IOPB Error  completion Vector */
    ULONG    dl_iopb_VMEADDR;       /* IOPB VME Address of transfer buffer */
	ULONG	 dl_iopb_BUFFMEM;	/* IOPB Buffer Memory of Target code */
	ULONG	 dl_iopb_SIZE;   	/* IOPB Codesize of downloaded code */
	EG_TOPT dl_iopb_TOPT;		/* IOPB VME bus transfer options */
	UWORD	 dl_iopb_RES0[6];	/* IOPB Reserved words */
} EG_DL_IOPB;

typedef struct ex_iopb {		/* Execute Software IOPB */
	UWORD	 ex_iopb_CMD;		/* IOPB Command code 0x48 */
	EG_OPT	 ex_iopb_OPTION;	/* IOPB Option word */
	UWORD	 ex_iopb_STATUS;	/* IOPB Return Status word */
	EG_VECT ex_iopb_NVCT;		/* IOPB Normal completion Vector */
	EG_VECT ex_iopb_EVCT;		/* IOPB Error  completion Vector */
	UWORD	 ex_iopb_RES0[1];	/* IOPB Reserved words */
    ULONG    ex_iopb_STRTADDR;      /* IOPB Start address of xecutable code */
	UWORD	 ex_iopb_RES1[9];	/* IOPB Reserved words */
} EG_EX_IOPB;

/**************** END IOPB Format (IOPB)                 ****************** */

/****************     Initialize Work Queue Command Format (WQCF)********** */

typedef struct wopt {		/* Work Queue Options */
	union {
	struct {
		Bit	IWQ  : 1;	/* Initialize Work Queue */
		Bit	     : 14;	/* Reserved bits */
		Bit	AE   : 1;	/* Abort Enable */
	} b;
	UWORD	w;
	} U;
} EG_WOPT;

#define M_WOPT_IWQ	0x8000
#define M_WOPT_AE	0x0001
#define B_WOPT_IWQ(x)	((x).U.b.IWQ)
#define B_WOPT_AE(x)	((x).U.b.AE)
#define W_WOPT(x)	((x).U.w)

#define EG_MISCQ	0x00	/* Miscellaneous Work queue */
#define EG_DMAQ	0x01	/* DMA Work Queue */
#define EG_RECVQ	0x02	/* Receive Work Queue */
#define EG_XMTQN(x)	((x) + 0x03)/* Transmit Work Queue N */


typedef struct wqcf {		/* Initialize Work Queue Command Format */
	UWORD	 wqcf_CMD;		/* Command Normally (0x42) */
	EG_OPT	 wqcf_OPTION;		/* Command Options */
	UWORD	 wqcf_STATUS;		/* Return Status */
	EG_VECT wqcf_NVCT;		/* Normal Completion Vector */
	EG_VECT wqcf_EVCT;		/* Error  Completion Vector */
	UWORD	 wqcf_RES0[5];		/* Reserved Words */
	UWORD	 wqcf_WORKQ;		/* Work Queue Number */
	EG_WOPT wqcf_WOPT;		/* Work Queue Options */
	UWORD	 wqcf_SLOTS;		/* Number of slots in the Work Queues */
	UWORD	 wqcf_PRIORITY;		/* Priority Level */
	UWORD	 wqcf_WDIV;		/* Work Division */
	UWORD	 wqcf_RES1[3];		/* Reserved words */
} EG_WQCF;

/**************** END Initialize Work Queue Command Format (WQCF)********** */

/****************     Short I/O Format                   ****************** */

typedef struct shortio {
	EG_MCSB	sh_MCSB;		/* Master Control / Status Block */
	EG_CQE	sh_MCE;		/* Master Command Entry */
	EG_CQE	sh_CQE[MAX_CQE];	/* Command Queue Entry */
	EG_IOPB	sh_IOPB[MAX_IOPB];	/* Host IOPB Space */
	EG_IOPB	sh_MCE_IOPB;	/* Host MCE IOPB Space */
	UWORD	sh_SCRTCH[N_SCRTCH];/* Scratch Area for Parameter IOPBS */
	EG_CRB	sh_CRB;		/* Command Response Block */
	UWORD	sh_FILL[2];		/* filler */
	EG_IOPB	sh_RET_IOPB;	/* Returned IOPB */
	EG_CSTB	sh_CSTB;		/* Controller Status Block */
	EG_CSB	sh_CSB;		/* Controller Statistics Block */
	UWORD	sh_PSEM;		/* Printf Semaphores */
	UWORD	sh_VMEIV;		/* VME bus Interrupt Vector */
} EG_SHIO;

/**************** END Short I/O Format                   ****************** */

/* Scatter/Gather Descriptor block
 *
 *	+-------------------------------------------------------+
 *	|                     Address MSW                       |
 *	+-------------------------------------------------------+
 *	|                     Address LSW                       |
 *	+-------------------------------------------------------+
 *	|                   Transfer Options                    |
 *	+-------------------------------------------------------+
 *	|                      Byte Count                       |
 *	+-------------------------------------------------------+
 */

typedef struct sgentry {
	ULONG	 sg_paddr;		/* Physical Address */
	EG_TOPT sg_TOPT;		/* IOPB VME bus transfer options */
	UWORD	 sg_bcount;		/* Byte Count for transfer */
} SGENTRY;


/*
 * For driver statistics
 */
typedef struct stats {
        LONG            st_babble;
	LONG            st_collisions;
	LONG            st_missed;
	LONG            st_memerr;
	LONG            st_rx_go;
	LONG            st_rx_ok;
	LONG            st_rx_err;
	LONG            st_rx_fram;
	LONG            st_rx_oflow;
	LONG            st_rx_crc;
	LONG            st_rx_buferr;
	LONG            st_tx_go;
	LONG            st_tx_ok;
	LONG            st_tx_err;
	LONG            st_tx_retry;
	LONG            st_tx_more_retry;
	LONG            st_tx_one_retry;
	LONG            st_tx_def_retry;
	LONG            st_tx_buferr;
	LONG            st_tx_uflow;
	LONG            st_tx_latecoll;
	LONG            st_tx_lcar;
} STATISTICS;

/************************  LANCE INITIALIZATION BLOCK ********************* */

/*
 * LANCE Descriptor Ring Pointer
 * The address contained in this structure must be longword aligned 
 */
typedef struct {                /* Descriptor Ring Pointer */
        UWORD  drp_laddr;       /* Low 16 bits of ring address */
        UWORD  drp_haddr_len;   /* High 8 bits of ring address - exponent */
} LE_DRP;

/*
 * Ethernet Physcial Address
 */
typedef struct {
	 char   paddr[6];
} EPADDR;

/*
 * Ethernet Logical Address Filter
 */
typedef struct {
	 char   laddr[8];
} ELADDR;

/*
 * LANCE Initialization Block.  This structure is constructed in memory,
 * and it's address is written into the chip during initialization.
 * The chip then fetches it's initialization info from the structure.
 */
typedef struct {
        /* In the normal mode, these 16 bits are all 0 */
        UWORD   ib_mode;        /* Chip's operating parameters */
        /*
         * The bytes must be swapped within the word, so that, for example,
         * the address 8:0:20:1:25:5a is written in the order
         *             0 8 1 20 5a 25
 */
        EPADDR  ib_paddr;       /* Physical address */
        ELADDR  ib_laddr;       /* Logical address filter */
        LE_DRP  ib_rdrp;        /* Receive Descriptor Ring Pointer */
        LE_DRP  ib_tdrp;        /* Transmit Descriptor Ring Pointer */
} LE_IB;

/********************************  PUDSTAT *********************************** */

/*
 * This is really at the location of the MCE, but we redefine the space the
 * way the power-up diagnostics use it
 */
typedef struct pudstat {
	ULONG   ps_error;       /* The PUD error code */
	ULONG   ps_A4;          /* The A4 contents, (where we failed) */
	ULONG   ps_A5;          /* The A5 contents, (where we failed) */
} EG_PUDSTAT;
