#ifndef lint
static char *Solbourne_id =
"@(#) fd_conf.c 1.1@(#) Solbourne id 9/22/93 00:06:18\n";
#endif
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

#include "fd.h"
#if NFD > 0

#include <sys/param.h>
#include <sys/types.h>
#include <sys/buf.h>
#include <sys/mtio.h>
#include <mfg/dkio.h>

#include <dev/mbvar.h>
#include <dev/fdreg.h>
#include <dev/fdvar.h>

int	nfd = NFDC*NFD_PER_FDC;

struct mb_ctlr		*fdcinfo[NFDC];
struct mb_device	*fddinfo[NFDC*NFD_PER_FDC];
struct buf		cfdbuf[NFDC*NFD_PER_FDC];	/* special buffers */
struct buf		rfdbuf[NFDC*NFD_PER_FDC];	/* raw I/O buffers */

/* partition information for different sized disks */
struct dk_allmap fd_disk_720K_map = { {0, 1422}, {79, 18}, {0, 1440}, };
struct dk_allmap fd_disk_1_4M_map = { {0, 2844}, {79, 36}, {0, 2880}, };

/* disk definitions */
struct fd_disk	fd_disk_720K = { "720K", &fd_disk_720K_map,
    CMD_DEN_MFM, 250, 135, 80, 2,  9, 512, 0xFF, 0x1B, 0x54, 1, 3, 42, 2, 0 };
struct fd_disk	fd_disk_1_4M = { "1.4M", &fd_disk_1_4M_map,
    CMD_DEN_MFM, 500, 135, 80, 2, 18, 512, 0xFF, 0x1B, 0x54, 1, 0, 0, 2, 0 };


/* types of disks supported by drives, null terminated */
struct fd_disk	*fd_disks_mit[]  = {&fd_disk_1_4M, &fd_disk_720K, 0};
struct fd_disk	*fd_disks_sony[]  = {&fd_disk_1_4M, &fd_disk_720K, 0};

/* drive definitions */
struct fd_drive fd_drive_mit = { "Mitisubishi",
    fd_disks_mit,	&fd_disk_1_4M, &fd_disk_720K,
    5, 5, 0, 0, 4, 2, 300, 0};
struct fd_drive	fd_drive_sony  = { "SONY",
    fd_disks_sony,	&fd_disk_1_4M, &fd_disk_720K,
    5, 5, 0, 0, 4, 2, 300, 1};

/* types of controllers supported */
struct fd_ctlr fd_ctlr_idt = {"82077",	
	&fd_drive_sony, 0, 0, 0,
	1, FD_WOPT_COUNT_NORMAL, FD_COUNT_NORMAL, 1, 18, 10, 30};
struct fd_ctlr fd_ctlr_vfd = {"82072",	
	&fd_drive_mit, 0, 0, 0,
	1, FD_WOPT_COUNT_NORMAL, FD_COUNT_NORMAL, 1, 18, 10, 30};

/* controllers installed */
struct fd_ctlr *fd_ctlr[] = {&fd_ctlr_idt, &fd_ctlr_vfd};

struct fd_softc fd_softc[NFDC*NFD_PER_FDC];
#endif	NFD > 0
