/* @(#) debug.h 1.1@(#) Solbourne id 9/21/93 23:48:37 */
/*
 * Copyright 1990 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*	@(#)debug.h 1.9 88/08/19 SMI; from S5R3 sys/debug.h 10.2	*/

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef _sys_debug_h
#define _sys_debug_h

#ifdef	KERNEL
#include <lckdeb.h>
#endif	KERNEL

/*
 * When "lint" is being run, don't put the predicate in an "if",
 * so that you don't get complaints about "ASSERT(0);".
 */
#ifdef ASS
#   if  defined(lint)
#	define ASSERT(EX)  assfail("", "", 0)
#   else
#	define ASSERT(EX) if (!(EX))assfail("EX", __FILE__, __LINE__)
#   endif
#else
#	define ASSERT(x)
#endif

#if NCPUS > 1 && NLCKDEB > 0
#   if defined(lint)
#	define ASSERT_LOCK(LOCK) assfail("", "", 0)
#	define ASSERT_NOLOCK(LOCK) assfail("", "", 0)
#   else
#	define LOCKED(LOCK) ((lock_style != LS_DEBUG) || \
			    (LOCK)->owner_cpu == cpu_number())
#	define UNLOCKED(LOCK) ((lock_style != LS_DEBUG) || \
			    (LOCK)->owner_cpu != cpu_number())
#	define ASSERT_LOCK(LOCK) ASSERT(LOCKED(LOCK))
#	define ASSERT_NOLOCK(LOCK) ASSERT(UNLOCKED(LOCK))
#   endif
#else 
#   define ASSERT_LOCK(LOCK)
#   define ASSERT_NOLOCK(LOCK)
#endif

#endif /*!_sys_debug_h*/
