/* @(#) asynch.h 1.1@(#) Solbourne id 9/21/93 23:48:17 */
/*
 * Copyright 1992 Solbourne Computer, Inc.
 * All rights reserved.
 */
/*	@(#) asynch.h 1.2 91/11/22 SMI	*/

/*
 * Copyright (c) 1988 by Sun Microsystems, Inc.
 */

#ifndef _sys_asynch_h
#define _sys_asynch_h

#ifdef KERNEL
#ifndef	solbourne
#include <lwp/lwp.h>
#endif	solbourne
#endif KERNEL

#define	AIO_INPROGRESS	-2	/* values not set by the system */
#define ALL_AIO -1		/* used by exec and exit to kill all aio */
#define	MAXASYNCHIO	200	/* maximum number of system asynch IO's at once */

typedef struct aio_result_t {
	int aio_return;	/* return value of read or write */
	int aio_errno;	/* errno generated by the IO */
} aio_result_t;

#ifdef KERNEL
/*
 * The auiotemp & aiodone structures are only used by the kernel
 */
#include <sys/uio.h>
#include <sys/file.h>

typedef struct auiotemp {
	struct uio auio;
	struct iovec aiov;
	struct file af;
}auiotemp_t;

typedef struct aiodone {
	struct aiodone *aiod_next;
	aio_result_t *aiod_result;
	struct thread *aiod_thread;
	int aiod_state;
	int aiod_fd;
#ifdef	solbourne
	struct auiotemp *atp;
#endif	solbourne
} aiodone_t;
#endif KERNEL

#endif  /*!_sys_asynch_h*/

