/* @(#) if_fxreg.h 1.1@(#) Solbourne id 9/22/93 00:11:26 */
/*
 * Copyright 1990 Solbourne Computer, Inc.
 * All rights reserved.
 */
/*
 * 	Copyright (c) 1990 by Communication Machinery Corporation
 * 			All rights reserved.
 *
 * 	This software contains proprietary and confidential information
 * 	of Communication Machinery Corporation and its suppliers.  Use,
 * 	disclosure, or reproduction is prohibited without the prior express
 * 	written consent of Communication Machinery Corporation.
 */

/*
 *	FXP Ram Definitions:  Since the amount of ram depends on the type
 *	of controller installed, the device is broken up into two segments:
 *	a low "fxdevice" structure which describes the mail boxes and
 *	iface structures, and a high "fxctl" area which is the last portion
 *	of memory and contains locations that reset and interrupt the board
 *	when referenced from the host.
 */
#ifndef	_if_if_fxreg_h
#define	_if_if_fxreg_h

#define	volatile

#define K		*1024
#define FX_MAXSIZE	(1024 K)	/* max VMEbus space for fx card */

#include <if/if_fxreg_ether.h>		/* ETHERNET specific info */
#include <if/if_fxreg_fddi.h>		/* FDDI specific info */

/* Ring structures */
#define	ring(size)				\
	struct ring/**/size {			\
		short	r_ri;			\
		short	r_wi;			\
		short	r_size;			\
		short	r_threshold;		\
		u_int	r_slot[size];		\
	}

#define	RINGINIT(rp, s) ((rp)->r_ri = (rp)->r_wi = 0, (rp)->r_size = (s))
#define	RINGNEXTW(rp)	(((rp)->r_wi + 1) & ((rp)->r_size - 1))
#define	RINGNEXTR(rp)	(((rp)->r_ri + 1) & ((rp)->r_size - 1))
#define	RINGEMPTY(rp)	((rp)->r_ri == (rp)->r_wi)
#define	RINGFULL(rp)	(RINGNEXTW(rp) == (rp)->r_ri)
#define	RINGSIZE(rp)	(((rp)->r_wi >= (rp)->r_ri) ?	\
			((rp)->r_wi - (rp)->r_ri) :	\
			((rp)->r_size + (rp)->r_wi - (rp)->r_ri))

#define	sizeof_ring(size)	((4*size)+8)

typedef	volatile ring(1)	RING1;
typedef	volatile ring(16)	RING16;
typedef	volatile ring(256)	RING256;
#define	RING			RING1


/* FX low ram data layout: message boxes and interface structures */
#define	FX_STATS_OFF	0x0400		/* interface statistics offset */
#define	FX_MBOX_OFF	0x1000		/* CK1 mailbox */
#define SKIP_TO_ADDR	0x3c		/*   skip from top_ram to boardaddr */
#define	FX_DIAG_OFF	0x1010		/* CK1 PowerOn SelfTest results */
#define	FX_RPC_OFF	0x1040		/* CK1 Remote Performance Interface */
#define	FX_SCRATCH_OFF	0x1080
#define	FX_IFACE_OFF	0x1100		/* Interface offset */

/* FX low ram structure... */
union fxdevice {
    u_char	fx_ram[FX_MAXSIZE];
    struct {				/* interface statistics offset */
	u_char	s_pad[FX_STATS_OFF];
	ETHERSTAT s_stat;
#define		fx_stat		stat.s_stat
    } stat;
    struct {				/* status/control mailbox */
	u_char	m_pad[FX_MBOX_OFF];
	u_short	m_go;
#define		fx_cmd		mbox.m_go
#define		  FX_CMD_GO	0x8080
#define		  FX_CMD_DEBUG	0x0001
	u_short	m_ctl;
#define		fx_ctl		mbox.m_ctl	/* write control */
#define		  FX_CTL_NX	0x0008		/*   no xfer to prom on RST */
#define		  FX_CTL_IE	0x0040		/*   intr enable bus debug */
#define		fx_sr		mbox.m_ctl	/* read status */
#define		  FX_SR_ONLINE	0x0002		/*   entered appl fw */
#define		  FX_SR_RDY	0x0004		/*   reset complete CK1 idle */
#define		  FX_SR_ERR	0x8000		/*   failed diags... */
	u_int	(*m_pstart)();		/* application start address, rpc */
#define		fx_pstart	mbox.m_pstart
	u_int	(*m_system)();		/* warm reset address */
#define		fx_system	mbox.m_system
	u_int	m_top_ram;		/* amount of ram */
#define		fx_top_ram	mbox.m_top_ram
	u_char	m_pad2[SKIP_TO_ADDR];
	char	m_boardaddr[64];	/* primary LLC network station addr */
#define		fx_boardaddr	mbox.m_boardaddr
    } mbox;
    struct {				/* failed diagnostic information */
	u_char	d_pad[FX_DIAG_OFF];
	struct	d_diag {
	    u_short	diag_err_count;		/* counter and semaphore */
	    u_short	diag_testno;		/* test in progress, if any */
	    u_short	diag_subtest;		/* subtest number */
	    u_short	diag_result;		/* test result */
	    u_int	diag_rsv_0;
	    u_int	diag_rsv_1;
	    u_int	diag_address;		/* address of error */
	    u_short	diag_expected;		/* expected value */
	    u_short	diag_actual;		/* actual value */
	    u_int	diag_rsv_2;
	}	d_diag;
#define		fx_diag		diag.d_diag
    } diag;
    struct {				/* remote proc call (rpc) info */
	u_char	r_pad[FX_RPC_OFF];
	u_int	(*r_rpc)();
#define		fx_rpc		rpc.r_rpc
	u_int	r_rpc_param[6];
#define		fx_rpc_param	rpc.r_rpc_param
	u_int	r_rpc_base;		/* base of board viewed from host */
#define		fx_rpc_base	rpc.r_rpc_base
    } rpc;
    struct {				/* scratch area */
	u_char	s_pad[FX_SCRATCH_OFF];
	u_char	s_scratch[0x80];
#define		fx_scratch	scratch.s_scratch
    } scratch;
    struct {				/* interface structure */
	u_char	e_pad[FX_IFACE_OFF];
	u_short	e_fxstate;		/* State of board */
#define		fx_state	iface.e_fxstate
#define		  FX_STATE_UNKNOWN	00	/* unknown */
#define		  FX_STATE_RESET	01	/* in reset */
#define		  FX_STATE_RUN		02	/* running */
#define		  FX_STATE_RIP		03	/* response in progress */
	u_short	h_fxmode;		/* operational parameters */
#define		fx_mode	iface.h_fxmode
#define		  FX_MODE_SWAP16	0x0001	/* swap 8s within 16 */
#define		  FX_MODE_SWAP32	0x0002	/* swap 16s within 32 */
#define		  FX_MODE_SWAPRD	0x0004	/* swap on read */
#define		  FX_MODE_SWAPWRT	0x0008	/* swap on write */
#define		  FX_MODE_XMT_DMA	0x0010	/* do dma xmit data moves */
#define		  FX_MODE_ARP		0x0020	/*-Reserved for Future Use */
#define		  FX_MODE_DONTINT	0x0040	/* do not interrupt host */
#define		  FX_MODE_NOTERM	0x0080	/* don't use serial port */
#define		  FX_MODE_RCV_DMA	0x0100	/* do dma rcv data moves */
#define		  FX_MODE_DO_TRAILERS	0x0200	/*-Reserved for Future Use */
#define		  FX_MODE_UDO_TRAILERS	0x0400	/* de-encapusulate trailers */
/* START ETHER */
#define		  FX_MODE_NO_SRC_ADDR	0x0800	/* dont t set src addr */
#define		  FX_MODE_PROMISCUOUS	0x1000	/* accept everything */
#define		  FX_MODE_RBUF_SHWD	0x2000	/* align rcv buf on short wd */
#define		  FX_MODE_RESET_STATS	0x4000	/* reset statistics */
#define		  FX_MODE_EXAM_LIST	0x8000	/* must examine addr list */
#define		  FX_MODE_BITS	\
"\20\20EXAM\17RESET_STATS\16SHWD\15PROMISC\14NOSRC\13UDOTRAIL\12DOTRAIL\
\11RCV_DMA\10NOTERM\7DONTINT\6ARP\5XMT_DMA\4SWAPWRT\3SWAPRD\2SWAP32\1SWAP16"
/* END   ETHER */
	u_int	h_fxbase;		/* base of board viewed from host */
#define		fx_base	iface.h_fxbase
	u_short	e_fxrun;		/* ++ at least once/s by board... */
#define		fx_fxrun	iface.e_fxrun
	u_short	h_intvector;		/* interrupt vector */
#define		fx_intvector	iface.h_intvector

	RING256	h_tofx;		/* transmit rings */
#define		fx_tofx	iface.h_tofx
	RING256	h_hostfree;
#define		fx_hostfree	iface.h_hostfree

	RING256	e_tohost;		/* non-dma recieve rings */
#define		fx_tohost	iface.e_tohost
	RING256	e_fxfree;
#define		fx_fxfree	iface.e_fxfree

	RING256 e_rcvdma;		/* dma recieve rings */
#define		fx_rcvdma	iface.e_rcvdma
	RING256 h_rcv_d;
#define		fx_rcv_d	iface.h_rcv_d

	union	{
	  struct {		/* ether specific */
	    ETHERSTAT	e_stat;
#define		    fx_ether_stat	iface.iface_u.ether.e_stat
	    ETHERLIST	e_addr;
#define		    fx_ether_addr	iface.iface_u.ether.e_addr
	  } ether;
	  struct {		/* fddi specific */
	    RING16  smt_free;
#define		    fx_fddi_smt_free	iface.iface_u.fddi.smt_free
	    RING16  smt_req;
#define		    fx_fddi_smt_req	iface.iface_u.fddi.smt_req
	    RING16  smt_ind;
#define		    fx_fddi_smt_ind	iface.iface_u.fddi.smt_ind
	    RING16  smt_event;
#define		    fx_fddi_smt_event	iface.iface_u.fddi.smt_event
	    FDDILIST f_addr
#define		    fx_fddi_addr	iface.iface_u.fddi.f_addr
	  } fddi;
	} iface_u;
    } iface;
};
typedef	volatile union fxdevice	FXDEVICE;


/* bus description block */
struct busd {
    struct busd *busd_link;		/* next BUSD */
    u_int	*busd_addr;		/* VMEbus address */
    u_int	busd_len;		/* length in bytes */
    u_short	busd_mod;		/* VMEbus address modifier */
    u_short	busd_pad;
    u_int	busd_cookie;		/* driver: DVMA address */
    u_int	busd_reserved_board[2];
    u_int	*busd_buf_addr;		/* driver: loaned mbuf address */
};
typedef volatile struct busd BUSD;

/* buffer control block */
struct bcb
{
    struct bcb	*bcb_link;
    u_short	bcb_csr;			/* control and status */
#define		bcb_xctl		bcb_csr	/* transmit control bits */
#define		  BCB_XCTL_NOVDMA	0x0002	/*   disable vme xmit dma */
#define		  BCB_XCTL_FILL		0x2000	/*   store chip addr on output */
/* Device specific BCB_STAT BITS IN if_fxreg_ether.h and if_fxreg_fddi.h */
#define		bcb_xstat		bcb_csr	/* transmit status bits */
#define		  BCB_XSTAT_ERR		0x4000	/*   error summary */
#define		  BCB_XSTAT_DONE	0x8000	/*   buffer complete */
#define		bcb_rstat		bcb_csr	/* recieve status bits */
#define		  BCB_RSTAT_ERR		0x4000	/*   error summary */
#define		  BCB_RSTAT_DONE	0x8000	/*   buffer complete */
    u_short	bcb_len;
    u_int	*bcb_addr;
    u_short	bcb_msglen;
    u_short	bcb_pad;
    struct mbuf	*bcb_mbuf;		/* driver: pointer to mbuf chain */
    BUSD	*bcb_busd;		/* driver: pointer to BUSD chain */
    u_int	bcb_reserved_board[2];
};
typedef	volatile struct bcb BCB;
#endif	_if_if_fxreg_h
