#ifndef lint
static char *Solbourne_id =
"@(#) scsiconf.c 1.1@(#) Solbourne id 9/22/93 00:07:46\n";
#endif
/*
 * Copyright 1988-1993 Solbourne Computer, Inc.
 * All rights reserved.
 */

#include "si.h"			/* IOASIC SCSI */
#include "sc.h"			/* Ciprico Rimfire 3500 SCSI */
#include "sv.h"			/* Interphase V/SCSI (4210/4220) */
#if ((NSI > 0) || (NSC > 0) || (NSV > 0))

#include <sys/param.h>
#include <sys/types.h>
#include <sys/buf.h>
#include <mfg/dkio.h>
#include <sys/mtio.h>
#include <dev/scsivar.h>
#include <dev/scsi.h>

int	scsi_verbose = 0;
int	scsi_verbose_watchdog_decay = 0;
int	scsi_hur_discon = 0x8000;	/* < 32K scsi disconnect huristic */
int	scsi_timeout_debug = 0;
int	scsi_reset_delay = 100000;	/* in usec's (.1 sec) */
int	scsi_alloc_resume = 5;
int	scsi_ntags_max_c = 2;		/* tagging only to controller */
int	scsi_ntags_max_d = NUM_TAG_CMDS;/* tagging to drive */
int	scsi_fair = 1;
int	scsi_qbp = 0;			/* maintain qbp stats */

/* 
 * To avoid timeouts of low priority devices caused by a congested scsi 
 * bus we avoid starting new commands for scsi_congestion_recovery seconds
 * in the hope that the bus will free up and allow low priority devices to
 * get some bandwidth.
 */
int	scsi_congestion_recovery = 2;	/* seconds... */
int	scsi_congested_debug = 0;

/* If host adaptor (controller) exists, declare controller structures. */
struct	scsi_ctlr	*scsi_ctlrs = NULL;
#if NSI > 0
struct scsi_ctlr	sictlr[NSI];
extern int		si_cmd(), si_reset(), si_perror();
#endif
#if NSV > 0
struct scsi_ctlr	svctlr[NSV];
extern int		sv_cmd(), sv_ecal(), sv_reset(), sv_perror();
#endif
#if NSC > 0
struct scsi_ctlr	scctlr[NSC];
extern int		sc_cmd(), sc_reset(), sc_perror();
#endif

/* host adaptor/controller switch table */
struct scsi_ctlr_sw	scsi_ctlr_sw[] = {	/* device -> ctlr linkage */
#if NSI > 0
	/* NOTE: DKC_RF3500 is a KLUDGE */
	{ "si", NSI, sictlr, si_cmd, NULL, NULL, si_reset, si_perror,
	    DKC_IOASIC,
	    SCS_FLAGS_PARITY|SCS_FLAGS_DISCON|SCS_FLAGS_SYNC|
	    SCS_FLAGS_RRESET|SCS_FLAGS_XPAD},
#endif
#if NSV > 0
	{ "sv", NSV, svctlr, sv_cmd, sv_ecal, NULL, sv_reset, sv_perror,
	    DKC_VSCSI,
	    SCS_FLAGS_PARITY|SCS_FLAGS_DISCON|SCS_FLAGS_SYNC|
	    SCS_FLAGS_RRESET|SCS_FLAGS_QTAG_C|SCS_FLAGS_QTAG_D|
	    SCS_FLAGS_INTEL},
#endif
#if NSC > 0
	{ "sc", NSC, scctlr, sc_cmd, NULL, NULL, sc_reset, sc_perror,
	    DKC_RF3500,
	    SCS_FLAGS_PARITY|SCS_FLAGS_DISCON|SCS_FLAGS_SYNC|
	    SCS_FLAGS_INTEL},
#endif
	{ 0, }
};

/* If device (unit) exists, declare unit structures. */
#include "sd.h"		/* scsi disk */
#include "st.h"		/* scsi tape */
#include "sf.h"		/* scsi floppy */
#include "sa.h"		/* scsi access */
#include "sod.h"	/* scsi optical disk */
#include "sr.h"		/* scsi cdrom */

#if NSD > 0
#include		<dev/sdvar.h>
struct scsi_unit	sdunit[NSD];
struct scsi_disk	sdisk[NSD];
char 			*sd_state_ascii[]	= SD_STATE_ASCII;
extern int		sdattach(), sdstrategy(), sdstart(), sdintr(), sdperror();
extern int		sddiscon(), sdrecon();
#endif
#if NST > 0
#include		<dev/stvar.h>
struct scsi_unit	stunit[NST];
struct scsi_tape	stape[NST];
extern int		stattach(), ststrategy(), ststart(), stintr(), stperror();
#endif
#if NSF > 0
#include		<dev/sfvar.h>
struct scsi_unit	sfunit[NSF];
struct scsi_floppy	sfloppy[NSF];
extern int		sfattach(), sfstrategy(), sfstart(), sfintr(), sfperror();
#endif
#if NSA > 0
#include		<dev/savar.h>
struct scsi_unit	saunit[NSA];
struct scsi_user	sauser[NSA];
extern int		saattach(), sastrategy(), sastart(), saintr();
#endif
#if NSOD > 0
#include		<dev/sodreg.h>
struct scsi_unit	sodunit[NSOD];
struct scsi_disk	sodisk[NSOD];
struct scsi_odisk	sodisk2[NSOD];
extern int		sodattach(), sodstrategy(), sodstart(), sodintr(), sodperror();
#endif
#if NSR > 0
#include		<dev/srvar.h>
struct scsi_unit	srunit[NSR];
struct scsi_rcd		srcd[NSR];
char 			*sr_state_ascii[]	= SR_STATE_ASCII;
extern int		srattach(), srstrategy(), srstart(), srintr(), srperror();
#endif

/* unit/device switch table */
struct	scsi_unit_sw	scsi_unit_sw[] = {	/* ctlr -> device linkage */
#if NSD > 0
	{ "sd", NSD, sdunit, sdattach, sdstrategy, sdstart, sdintr, sdperror,
	    4, 8, 50, 30, 5, 1, sddiscon, sdrecon},
#endif
#if NST > 0
	{ "st", NST, stunit, stattach, ststrategy, ststart, stintr, stperror,
	    0, 0,  0, 360, 5, 0},		/* 30 min rewind time! */
#endif
#if NSF > 0
	{ "sf", NSF, sfunit, sfattach, sfstrategy, sfstart, sfintr, sfperror,
	    0, 0,  0, 30, 5, 1},
#endif
#if NSA > 0
	{ "sa", NSA, saunit, saattach, sastrategy, sastart, saintr, 0,
	    0, 0,  0, 30, 5, 0},
#endif
#if NSOD > 0
        { "sod", NSOD, sodunit, sodattach, sodstrategy, sodstart, sodintr, sodperror,
	    1, 1, 10, 30, 5, 0},
#endif
#if NSR > 0
	{ "sr", NSR, srunit, srattach, srstrategy, srstart, srintr, srperror,
	    4, 1, 10, 30, 5, 1},
#endif
	{ 0, }
};

struct scsi_ctlb	scsi_ctlb[]		= SCSI_CTLB;
int			nscsi_ctlb		= NSCSI_CTLB;
char			*scsi_phase[]		= SCSI_PHASE_ASCII;
char			*scsi_error_class_ascii[] = ERROR_CLASS_ASCII;
char			*scsi_intr_ascii[]	= INTR_ASCII;
char 			*sns_ext_key_ascii[]	= SNS_EXT_KEY_ASCII;
char			*inq_pdt_ascii[]	= INQ_PDT_ASCII;
char			*scb_status_ascii[]	= SCB_STATUS_ASCII;

/* controller specific stubs referenced by target drivers */
#if	NSV == 0
sv_cfwupd() { return (ENODEV);}		/* firmware update with sv */
sv_csnupd() { return (ENODEV);}		/* update serial number with sv */
#endif	NSV == 0

#endif ((NSI > 0) || (NSC > 0) || (NSV > 0))
