/* @(#) param.h 1.1@(#) Solbourne id 9/22/93 00:01:44 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*	@(#)param.h 1.3 89/08/03 SMI	*/

/*
 * Copyright (c) 1990 by Solbourne Computer, Inc.
 *
 * This file is intended to contain the basic
 * specific details of a given architecture.
 */

#ifndef _IDT_PARAM_
#define _IDT_PARAM_

/*
 * Machine dependent constants for kbus systems.
 * XXX included for the idt since some shared source uses it
 */
#define	MAXNCPUS	16	/* maximum number of CPUS supported */

#ifdef MULTIPROCESSOR
#define NCPU MAXNCPUS
#else
#define NCPU 1
#endif

/*
 * MMU_PAGES* describes the physical page size used by the mapping hardware.
 * PAGES* describes the logical page size used by the system.
 */

#define	MMU_PAGESIZE	0x2000		/* 8192 bytes */
#define	MMU_PAGESHIFT	13		/* log2(MMU_PAGESIZE) */
#define	MMU_PAGEOFFSET	(MMU_PAGESIZE-1)/* Mask of address bits in page */
#define	MMU_PAGEMASK	(~MMU_PAGEOFFSET)

#define	PAGESIZE	0x2000		/* All of the above, for logical */
#define	PAGESHIFT	13
#define	PAGEOFFSET	(PAGESIZE - 1)
#define	PAGEMASK	(~PAGEOFFSET)

/*
 * DATA_ALIGN is used to define the alignment of the Unix data segment.
 */
#define	DATA_ALIGN	0x2000

/*
 * Some random macros for units conversion.
 */

/*
 * MMU pages to bytes, and back (with and without rounding)
 */
#define	mmu_ptob(x)	((x) << MMU_PAGESHIFT)
#define	mmu_btop(x)	(((unsigned)(x)) >> MMU_PAGESHIFT)
#define	mmu_btopr(x)	((((unsigned)(x) + MMU_PAGEOFFSET) >> MMU_PAGESHIFT))

/*
 * pages to bytes, and back (with and without rounding)
 */
#define	ptob(x)		((x) << PAGESHIFT)
#define	btop(x)		(((unsigned)(x)) >> PAGESHIFT)
#define	btopr(x)	((((unsigned)(x) + PAGEOFFSET) >> PAGESHIFT))

/*
 * 2 versions of pages to disk blocks
 */
#define	mmu_ptod(x)	((x) << (MMU_PAGESHIFT - DEV_BSHIFT))
#define	ptod(x)		((x) << (PAGESHIFT - DEV_BSHIFT))

#ifdef KERNEL
/*
 * Delay units are in microseconds.
 */
#define	DELAY(n)	usec_delay(n)
#define	CDELAY(c, n)	\
{ \
	register int N = n; \
	while (--N > 0) { \
		if (c) \
			break; \
		usec_delay(1); \
	} \
}
#else /* !KERNEL */
#define	DELAY(n)	\
{ \
	extern int cpudelay; \
	register int N = ((unsigned)((n)<<4) >> cpudelay); \
 \
	while (--N > 0) ; \
}

#define	CDELAY(c, n)	\
{ \
	extern int cpudelay; \
	register int N = ((unsigned)((n)<<3) >> cpudelay); \
 \
	while (--N > 0) \
		if (c) \
			break; \
}
#endif /* !KERNEL */

/*
 * The two portions of the u-area, the kernel stack and the struct user,
 * always resides at the end of the virtual address space.
 * The struct user must also be <= 4096. The UPAGES constant reflects
 * the number of pages required for the entire u-area.
 */

/* 
 * pages of u-area, NOT including red zone 
 * u-area is split into the struct user and the kernel stack, the struct
 * user is at most 4096 bytes, thus leaving the rest of the UPAGES for
 * the kernel stack
 */
#define	UPAGES		3	
#define UPAGES_U	1
#define UPAGES_KS	(UPAGES-UPAGES_U)

/* 
 * size of the kernel stack 
 */
#define	KERNSTACK	(0x3000)

#if UPAGES == 1
ERROR - UPAGES must be at least 2
#endif UPAGES == 1

/* 
 * u-area virtual address 
 *
 * also specify index within seg_u array for different portions of u-area
 */
#define	KSADDR			(0-(NBPG*UPAGES))
#define	UADDR			(0-4096) 
#define UPAGES_U_INDEX		0
#define UPAGES_KS_INDEX		UPAGES_U

#if !defined(ASSEMBLER) && !defined(LOCORE)
/*
 * this structure contains the information libkvm needs for accessing
 * various kernel information thus removing the need for libkvm to be
 * recompiled for different machines
 */
struct kernel_info {
	unsigned	u_addr;		/* address of struct user */
	unsigned	ks_addr;	/* address of kernel stack */
	short		u_pages;	/* number of struct user pages */
	short		ks_pages;	/* number of kernel stack pages */
	short		u_index;	/* seg_u index of struct user ptes */
	short		ks_index;	/* seg_u index of kernel stack ptes */
	short		total_upages;	/* total number of uarea pages */
	unsigned	usrstack;	/* address of top of user stack */
	unsigned	sysbase;	/* start of kernel allocated memory */
	unsigned	kernelbase;	/* start of kernel virtual */
	unsigned	physwin_base;	/* start of kernel physical window */
	unsigned	physwin_limit;	/* end of kernel physical window */
	unsigned	cpu;		/* cpu type */
	unsigned	mmu_clsize;	/* pages per cluster */
	unsigned	mmu_pagesize;	/* page size */
	unsigned	mmu_pageoffset;	/* page offset mask */
	unsigned	mmu_pageshift;	/* page shift value */
	unsigned	mmu_pg_sv_msk;	/* mask for software valid */
	unsigned	mmu_pg_sv;	/* value for software valid */
	unsigned	mmu_pg_v_msk;	/* mask for valid */
	unsigned	mmu_pg_v;	/* value for valid */
	unsigned	kinfo_magic;	/* kinfo struct magic number */
#define			 KINFO_MAGIC	0xABBADABA
};
#endif !ASSEMBLER && !LOCORE

/*
 * KERNELSIZE is the amount of virtual address space the kernel
 * uses in all contexts.
 */
#define	KERNELSIZE	(128*1024*1024)

/*
 * KERNELBASE is the first kernel virtual address 
 */
#define	KERNELBASE	(0-KERNELSIZE)

/*
 * SYSBASE is the virtual address which
 * the kernel allocated memory mapping starts in 
 */
#define	SYSBASE		(0 - (16*1024*1024))

/*
 * MBPOOLBYTES gives the amount of virtual space to reserve for mbuf
 * NOTE: S4000 MBPOOLBYTES only 1 Meg rather than 2 Meg due to 
 * kernel virtual space limitations.
 * storage.
 */
#define	MBPOOLBYTES	(1024*1024)
#define MBPOOLMMUPAGES	(MBPOOLBYTES / MMU_PAGESIZE)

/*
 * BUFBYTES: Maximal size of Disk Buffer Cache
 * BUFBASE - BUFLIMIT: Disk Buffer Cache
 */
#define BUFBYTES	(2*1024*1024)
#define BUFPAGES	(BUFBYTES / MMU_PAGESIZE)
#define BUFLIMIT	SYSLIMIT
#define BUFBASE		(BUFLIMIT - BUFBYTES)

/*
 * HEAPBYTES: Maximal size of Kernel Heap
 * HEAPBASE - HEAPLIMIT: Kernel Heap
 */
#define HEAPBYTES	(6*1024*1024)
#define HEAPPAGES	(HEAPBYTES / MMU_PAGESIZE)
#define HEAPLIMIT	BUFBASE
#define HEAPBASE	(HEAPLIMIT - HEAPBYTES)

/*
 * Msgbuf size.
 */
#define MSG_BSIZE       ((7 * 1024) - sizeof (struct msgbuf_hd))

/*
 * XXX - Macros for compatibility
 */
/* Clicks (MMU PAGES) to disk blocks */
#define	ctod(x)		mmu_ptod(x)

/* Clicks (MMU PAGES) to bytes, and back (with rounding) */
#define	ctob(x)		mmu_ptob(x)
#define	btoc(x)		mmu_btopr(x)

/*
 * XXX - Old names for some backwards compatibility
 */
#define	NBPG		MMU_PAGESIZE
#define	PGOFSET		MMU_PAGEOFFSET
#define	PGSHIFT		MMU_PAGESHIFT

#define	CLSIZE		1
#define	CLSIZELOG2	0
#define	CLBYTES		PAGESIZE
#define	CLOFSET		PAGEOFFSET
#define	CLSHIFT		PAGESHIFT
#define	clrnd(i)	(i)

#endif /* _IDT_PARAM_ */
