/* @(#) mmu.h 1.1@(#) Solbourne id 9/22/93 00:01:26 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*	@(#)mmu.h 1.1 88/03/29 SMI	*/

/*
 * Copyright (c) 1985 by Sun Microsystems, Inc.
 */

#ifndef _MMU_
#define _MMU_

/* 
 * KAP memory management units.
 * All KAP implementations use 32 bits of address.
 */

/* 
 * Hardware context and segment information
 * Mnemonic decoding:
 *	PTE - Page Table Entry 
 *	PT  - A page table or group of PTEs (aka "segment")
 *	PDE - Page Directory Entry
 * 	PDT - Page Directory Table or group of PDEs 
 */
#define	NPTEPERPT	1024		/* number of ptes per page table */
#define	NPTEPERPTSHIFT	10		/* log2(NPTEPERPT) */
#define NPDEPERPDT	512		/* number of pdes per page dir table */
#define NPDEPERPDTSHIFT	9		/* log2(NPDEPERPDT) */
#define	MMU_SEGSIZE	(NPTEPERPT * PAGESIZE)
#define MMU_SEGOFFSET	(MMU_SEGSIZE - 1)
#define	MMU_SEGSHIFT	(PAGESHIFT + NPTEPERPTSHIFT)
#define	MMU_SEGMASK	(~MMU_SEGOFFSET)

#define DVMASIZE (0x200000 - 0x6a000)
/*
 * defines for performing software table walk based on a virtual address
 */
#define PDT_INDEX_SIZE	9		/* num bits of pdt index in va */
#define PT_INDEX_SIZE	10		/* num bits of pt index in va */
#define PDT_INDEX_SHIFT	23		/* shift for pde index */
#define PT_INDEX_SHIFT	13		/* shift for pt index */
#define PDT_INDEX_MASK	0xff800000	/* mask for pdt index */
#define PT_INDEX_MASK	0x007fe000	/* mask for pdt index */
#define	FAULT_VA_ALIGN	0x3		/* mask to align virtual address */
#define PDE_SIZE_SHIFT	3		/* log2(sizeof(struct pde)) */
#define PTE_SIZE_SHIFT	2		/* log2(sizeof(struct pte)) */
#define	PTE_OFFSET_MASK	0xffc
#define PT_OFFSET_SHIFT	(PT_INDEX_SHIFT-PTE_SIZE_SHIFT)
#define PT_INDEX_SHIFT_MASK	0xffc	/* mast for pt index after shift */

/*
 * macros for getting from a virtual address to the proper entry
 * in either page directory table or page table
 */
#define PDT_INDEX(addr) \
	(((unsigned)addr & PDT_INDEX_MASK) >> PDT_INDEX_SHIFT)
#define PDT_OFFSET(addr)	(PDT_INDEX(addr) << PDE_SIZE_SHIFT)

#define PT_INDEX(addr)	\
	(((unsigned)addr & PT_INDEX_MASK) >> PT_INDEX_SHIFT)
#define PT_OFFSET(addr)		(PT_INDEX(addr) << PTE_SIZE_SHIFT)

#ifndef LOCORE
/*
 * Variables set at boot time to reflect cpu type.
 */
extern u_int segmask;		/* mask for segment number */
extern addr_t hole_start;	/* addr of start of MMU "hole" */
extern addr_t hole_end;		/* addr of end of MMU "hole" */

/*
 * Macro to determine whether an address is within the range of the MMU.
 *
 * Sun4 machine has a hole in the virtual address space, KAP does not
 * thus all 32 bit addresses are good
 */
#define good_addr(a)	(1)
#endif !LOCORE

/*
 * The PTWs are set by the ROM so that:
 *	virtual space 0xfd is physical memory (lowest 16 megs)
 *	virtual space 0xfe is same as 0xfd but non-cacheable
 *	virtual space 0x0 is the bootrom text (later disabled by kernel)
 */
#define	PHYSICAL_WINDOW		0xfd000000	/* physical memory window */
#define	KERN_PHYS_WIN		PHYSICAL_WINDOW	/* physical window alias */
#define	SA_PHYS_WIN		PHYSICAL_WINDOW	/* physical window alias */
#define	PHYSICAL_WINDOW_NCACHE	0xfe000000	/* non-cached memory window */
#define	PHYSICAL_WIN_MASK	0xff000000	/* mask for phys windows */
#define	PHYS_WIN_SIZE		0x01000000	/* phys. window size (bytes) */
/* after rom callbacks are finished, ptw0 is available for an sbus slot */
#define SBUS_PHYS_WINDOW	0xf9000000	/* i/o to an sbus slot */
#define SGABASE			0xfa000000	/* virtual seg for sga cards */
#define SGASIZE			(512 * MMU_PAGESIZE)

/*
 * VIRT_TO_CACHE will return an address that's in PHYSICAL_WINDOW.
 * VIRT_TO_NCACHE will return an address that's in PHYSICAL_WINDOW_NCACHE
 */
#define VIRT_TO_CACHE(x) \
  (((x) & ~PHYSICAL_WIN_MASK) | PHYSICAL_WINDOW)
#define VIRT_TO_NCACHE(x) \
  (((x) & ~PHYSICAL_WIN_MASK) | PHYSICAL_WINDOW_NCACHE)

/*
 * the lower bits of the PDBR may hold special information
 */
#define PDBR_CLEAN	0x02	/* process requires clean windows */

#define KAPBUG_S433	/* determine ticc trap type in software */
#define KAPBUG_FCR	/* zero fcr after reading it */
#define KAPBUG_S462	/* force trap after interrupted fdiv[sd] */

/* table walk instead of lookup to dereference %l1 on ticc, save, restore */
/*#define TWALK_FETCH_L1 /**/

/*#define TMISS_CIRCULAR /* use a circular tlb replacement instead of random */

#if defined(KAPBUG_S444) && !defined(TMISS_CIRCULAR)
	ERROR -- must use circular tlb replacement with KAPBUG_S444
#endif

#ifdef TMISS_CIRCULAR
/*
 * keep a shadow of the tlb.  the index passed-in is shifted
 * left by 3 for the mmu.  we also want it shifted left by 3
 * (since each tlb_shadow entry is 8 bytes).
 *
 * the arguments to TLB_SHADOW are:
 *	the register containing the pte
 *	the register containing the gtlb index
 *	two "trashable" registers
 *
 * for example:
 *
 *	sta	%g1,[%g4]ASI_GTLB_DROPIN
 *	TLB_SHADOW(%g1, %g4, %o0, %o1);
 */
#define TLB_SHADOW(r_pte, r_idx, r_scratch1, r_scratch2) \
	set	_tlb_shadow, r_scratch1; \
	set	PHYSICAL_WINDOW, r_scratch2; \
	andn	r_scratch1, r_scratch2, r_scratch1; \
	set	PHYSICAL_WINDOW_NCACHE, r_scratch2; \
	or	r_scratch1, r_scratch2, r_scratch1; \
	lda	[%g0]ASI_FVAR, r_scratch2; \
	add	r_scratch1, r_idx, r_scratch1; \
	st	r_pte, [r_scratch1 + 4]; \
	st	r_scratch2, [r_scratch1]
#else
/* shadowing isn't possible unless dropin is deterministic */
#define TLB_SHADOW(r_pte, r_idx, r_scratch1, r_scratch2)
#endif TMISS_CIRCULAR

#if defined(KERNEL) && !defined(LOCORE)
extern int cpu;				/* machine type we are running on */
#endif

#define PTW_V		0x00000001 /* valid bit */
#define PTW_RO		0x00000002 /* read only bit */
#define PTW_UP		0x00000004 /* user protect */
#define 		PTW_MA(V) ((V) << 3)
#define PTW_IO		PTW_MA(0) /* I/O Attribute */
#define PTW_CACHE	PTW_MA(1) /* Cache Attribute */
#define PTW_BYTE_SHARED	PTW_MA(2) /* Byte-Writeable Shared */
#define PTW_SHARED	PTW_MA(3) /* Non-Byte-Writeable Shared */
#define PTW_MASK(V)	((V & 0xff) << 8)
#define PTW_TPA(V)	((V & 0xff) << 16)
#define PTW_TVA(V)	((V & 0xff) << 24)

#define MMCR_TE		0x00000001 /* enable translations */
#define MMCR_PM		0x00000002 /* PTW Match status bit */
#define MMCR_IM		0x00000004 /* ITLB Match status bit */
#define MMCR_GM		0x00000008 /* GM Match status bit */
#define MMCR_IO		0x00000000 /* I/0 Memory Attribute */
#define MMCR_CACHE	0x00001000 /* Cacheable */
#define MMCR_BYTE_SHARE	0x00002000 /* Byte-Writeable Shared */
#define MMCR_SHARED	0x00003000 /* Non-Byte-Writeable Shared */
#define MMCR_ISET0	0x00000080 /* icache set zero */
#define MMCR_ISET1	0x00000100 /* icache set one */
#define MMCR_ISET2	0x00000200 /* icache set two */
#define MMCR_ISETMSK	(MMCR_ISET0|MMCR_ISET1|MMCR_ISET2)
#define MMCR_DSET0	0x00000400 /* dcache set zero */
#define MMCR_DSET1	0x00000800 /* dcache set one */

#define GTLB_FIXED	(128 << 3) /* addr of first fixed entry in gtlb */
#define GTLB_FIXED_INCR	(1 << 3)   /* increment to next fixed entry */
#define GTLB_FIXED_U	(128 << 3)	/* fixed slot used for u area */
#define GTLB_FIXED_KS0	(129 << 3)	/* fixed slot used for kernel stack */
#define GTLB_FIXED_KS1	(130 << 3)	/* fixed slot used for kernel stack */
#define GTLB_FIXED_IS	(131 << 3)	/* fixed slot used for int stack */
#define GTLB_FIXED_SPT	(132 << 3)	/* fixed slot used for user sp top */
#define GTLB_FIXED_SPB	(133 << 3)	/* fixed slot used for user sp bot */
#define GTLB_FIXED6	(134 << 3)
#define GTLB_FIXED_SASH	(135 << 3)	/* fixed slot used for sash dropins */

#define BCR_SYNMSK	0x000000ff /* syndrome byte for the last ECC error */
#define BCR_EE		0x00000100 /* enable ECC */
#define BCR_ECCSDIS	0x02000000 /* disable ECCS faults */

#define FCR_MASK	0x0000000f
#define FCR_PNV		0x00000001 /* page not valid */
#define FCR_WP		0x00000002 /* write protect */
#define FCR_UP		0x00000004 /* user protect */
#define FCR_EF		0x00000100 /* external fault */
#define FCR_ECS		0x00000200 /* single-bit ECC */
#define FCR_ECM		0x00000400 /* multi-bit ECC */
#define FCR_SOFT	0x00000800 /* software generate fault */
#define FCR_BITS	"\20\13ECM\12ECS\11EF\3UP\2WP\1PNV"


				/*     +-- Translated		*/
				/*     | +-- Internal/External	*/
				/*     | | +-- Type		*/
				/*     | | |			*/
				/*     v v v			*/
#define ASI_LOOKUPD		128 /* Y I RO -- Data translation lookup */
#define ASI_LOOKUPI		136 /* Y I RO -- Instr. translation lookup */

#define ASI_GTLB_RANDOM		192 /* N I WO -- Random tlb dropin */
#define ASI_GTLB_DROPIN		193 /* N I WO -- tlb dropin */
#define ASI_GTLB_INVAL_ENTRY	194 /* N I WO -- invalidate entry */
#define ASI_GTLB_INVAL_PID	195 /* N I WO -- invalidate PID */
#define ASI_GTLB_INVALIDATE	196 /* N I WO -- invalidate tlb */

#define ASI_ITLB_DROPIN		200 /* N I WO -- dropin entry into ITLB */

#define ASI_DCACHE_FLUSH	208 /* N I RO -- flush dcache block */
#define ASI_DCACHE_LOOKUP	209 /* N I RO -- check for dcache hit */
#define ASI_DCACHE_RW		210 /* N I RW -- read/write dcache */
#define ASI_DCACHE_INVAL	211 /* N I WO -- invalidate dcache */

#define ASI_PHYS_IO		212 /* N I RW -- phys. I/O (not cached) */
#define ASI_PHYS_CACHED		213 /* N I RW -- phys. cached */
#define ASI_PHYS_SHARED_B	214 /* N I RW -- phys. shared byte-writes */
#define ASI_PHYS_SHARED		215 /* N I RW -- phys. shared */

#define ASI_ICACHE_LOOKUP	217 /* N I RO -- check for icache hit */
#define ASI_ICACHE_RW		218 /* N I RW -- read/write icache */
#define ASI_ICACHE_INVAL	219 /* N I WO -- invalidate icache */

#define ASI_MMCR		224 /* N I RW -- mmu/cache control/stat reg */
#define ASI_PDBR		225 /* N I RW -- page directory base addr */
#define ASI_FVAR		226 /* N I RW -- fault virtual addr */
#define ASI_PDER		227 /* N I RO -- page dir entry pointer */
#define ASI_PTOR		228 /* N I RO -- page table offset */
#define ASI_FPAR		229 /* N I RW -- fault physical addr */
#define ASI_FPSR		230 /* N I RW -- fault physical space */
#define ASI_PIID		231 /* N I RW -- process ID invalidation */
#define ASI_PID			232 /* N I RW -- process ID */

#define ASI_BCR			233 /* N I RW -- bus control */

#define ASI_FCR			234 /* N I RW -- fault cause */

#define ASI_PTW0		235 /* N I RW -- PTW 0 */
#define ASI_PTW1		236 /* N I RW -- PTW 1 */
#define ASI_PTW2		237 /* N I RW -- PTW 2 */

#define ASI_WAR0		238 /* N I RW -- watchpoint addr 0 */
#define ASI_WAR1		239 /* N I RW -- watchpoint addr 1 */
#define ASI_WCR			240 /* N I RW -- watchpoint control */


#ifndef LOCORE

/*
 * macro for checking if mmu is enabled
 */
#define MMU_ENABLED	(1)
#endif !LOCORE

#if defined(KERNEL) && !defined(LOCORE)
/*
 * Low level mmu-specific functions 
 */
void mmu_getkpte(/* addr_t, struct pte *  */);
void mmu_getpte(/* addr_t, struct pte * */);
void mmu_setpte(/* addr_t, struct pte * */);
void mmu_assetpte(/* struct as *, addr_t, struct pte * */);
void mmu_asgetpte(/* struct as *, addr_t, struct pte * */);
#endif defined(KERNEL) && !defined(LOCORE)

#endif _MMU_
