#! /bin/sh

#
#* Copyright 1992 Solbourne Computer, Inc.
#* All rights reserved.
#*
#* Solbourne_id = "@(#) %A% Solbourne id $Date: 1993/01/04 12:15:07 $ "
#

#
# ext_deps.sh
#
# a SolPatch shell tool
# Extract any dependencies from a patch package
#


USAGE="ERROR in Usage:  ext_deps.sh directory package_id"

if  [ "$#" -ne 2 ]
then
   echo "$USAGE"
   exit 1
fi

DIR="$1"
PKG="$2"
DEP_FILE="$DIR/$PKG/install/depend"
DIRERR="ERROR in ext_deps.sh:  no such directory, \"$DIR\""
PKGERR="ERROR in ext_deps.sh:  no such package, \"$PKG\""

if  [ -d "$DIR" ]
then
   if  [ -d "$DIR/$PKG" ]
   then
      if  [ -f "$DEP_FILE" ]
      then
         awk '{print $2}'  < "$DEP_FILE"
      else
         :  pkg has no depend file, hence no dependencies
      fi
   else
      echo "$PKGERR"
      exit 1
   fi
else
   echo "$DIRERR"
   exit 1
fi

exit 0

