#
#	@(#)make.script 1.36 90/12/20 SMI
#
# This file should reside in both /var/yp/Makefile and /usr/lib/NIS.Makefile.
# It should only be executed from /var/yp.
# Placement in /usr/lib is for the assistance of SysAdmins who have servers
# with releases prior to SunOS 4.1.1 Rev B and thus do not have the 
# "timezone", "auto.master" and "auto.home" NIS maps.  This will provide 
# them easy access to a version of Makefile with those new maps.
#
# Set the following variable to "-b" to have NIS servers use the domain name
# resolver for hosts not in the current domain. 
#B=-b
B=
DIR =/etc
DOM = `domainname`
NOPUSH = ""
ALIASES = /etc/aliases
YPDIR=/usr/etc/yp
YPDBDIR=/var/yp
YPPUSH=$(YPDIR)/yppush
MAKEDBM=$(YPDIR)/makedbm
REVNETGROUP=$(YPDIR)/revnetgroup
STDETHERS=$(YPDIR)/stdethers
STDHOSTS=$(YPDIR)/stdhosts
MKNETID=$(YPDIR)/mknetid
MKALIAS=$(YPDIR)/mkalias

CHKPIPE=  || (  echo "NIS make terminated:" $@ 1>&2; kill -TERM 0 )


k:
	@if [ ! $(NOPUSH) ]; then $(MAKE)  $(MFLAGS) -k all; \
	else $(MAKE) $(MFLAGS) -k all NOPUSH=$(NOPUSH);fi

all: passwd group hosts ethers networks rpc services protocols \
	netgroup bootparams aliases publickey netid netmasks c2secure \
	timezone auto.master auto.home

c2secure:
	-@if [ -f $(DIR)/security/passwd.adjunct ]; then \
		if [ ! $(NOPUSH) ]; then $(MAKE)  $(MFLAGS) -k \
		passwd.adjunct.time group.adjunct.time; \
		else $(MAKE) $(MFLAGS) -k NOPUSH=$(NOPUSH) \
		passwd.adjunct.time group.adjunct.time; \
		fi; \
	fi

passwd.time: $(DIR)/passwd
	@(awk 'BEGIN { FS=":"; OFS="\t"; } /^[a-zA-Z0-9_]/ { print $$1, $$0 }' $(DIR)/passwd  $(CHKPIPE))| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/passwd.byname; 
	@(awk 'BEGIN { FS=":"; OFS="\t"; } /^[a-zA-Z0-9_]/ { printf("%-10d ", $$3); print $$0 }' $(DIR)/passwd $(CHKPIPE))| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/passwd.byuid; 
	@touch passwd.time; 
	@echo "updated passwd"; 
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) passwd.byname; fi
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) passwd.byuid; fi
	@if [ ! $(NOPUSH) ]; then echo "pushed passwd"; fi

group.time: $(DIR)/group
	@(awk 'BEGIN { FS=":"; OFS="\t"; } { print $$1, $$0 }' $(DIR)/group $(CHKPIPE))| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/group.byname; 
	@(awk 'BEGIN { FS=":"; OFS="\t"; } { printf("%-10d ", $$3); print $$0 }' $(DIR)/group $(CHKPIPE)) | $(MAKEDBM) - $(YPDBDIR)/$(DOM)/group.bygid; 
	@touch group.time; 
	@echo "updated group"; 
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) group.byname; fi
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) group.bygid; fi
	@if [ ! $(NOPUSH) ]; then echo "pushed group"; fi

hosts.time: $(DIR)/hosts
	@(sed -e "/^#/d" -e s/#.*$$// $(DIR)/hosts $(CHKPIPE)) | \
	($(STDHOSTS) $(CHKPIPE)) | \
	(awk '{for (i = 2; i <= NF; i++) print $$i, $$0}' $(CHKPIPE))| \
	$(MAKEDBM) $(B) -l - $(YPDBDIR)/$(DOM)/hosts.byname 

	@($(STDHOSTS) $(DIR)/hosts $(CHKPIPE))| \
	(awk 'BEGIN { OFS="\t"; } $$1 !~ /^#/ { print $$1, $$0 }' $(CHKPIPE)) | \
	$(MAKEDBM) $(B) - $(YPDBDIR)/$(DOM)/hosts.byaddr; 
	@touch hosts.time; 
	@echo "updated hosts"; 
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) hosts.byname; fi
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) hosts.byaddr; fi
	@if [ ! $(NOPUSH) ]; then echo "pushed hosts"; fi

ethers.time: $(DIR)/ethers
	@($(STDETHERS) $(DIR)/ethers $(CHKPIPE)) \
	|(awk '{print $$1, $$0; for (i = 3;i <= NF;i++) print $$i,$$0}' $(CHKPIPE)) \
	| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/ethers.byaddr 

	@(awk 'BEGIN { OFS="\t"; } $$1 !~ /^#/ { print $$2, $$0 }' \
	   $(DIR)/ethers $(CHKPIPE)) | \
	$(MAKEDBM) - $(YPDBDIR)/$(DOM)/ethers.byname;
	@touch ethers.time; 
	@echo "updated ethers"; 
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) ethers.byname; fi
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) ethers.byaddr; fi
	@if [ ! $(NOPUSH) ]; then echo "pushed ethers"; fi

networks.time: $(DIR)/networks
	@(sed -e "/^#/d" -e s/#.*$$// $(DIR)/networks $(CHKPIPE)) |( awk \
	    '{print $$1, $$0; for (i = 3;i <= NF;i++) print $$i,$$0}' \
	    $(CHKPIPE) )| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/networks.byname; 
	@(awk 'BEGIN { OFS="\t"; } $$1 !~ /^#/ { print $$2, $$0 }' \
	   $(DIR)/networks $(CHKPIPE)) | $(MAKEDBM) - $(YPDBDIR)/$(DOM)/networks.byaddr;
	@touch networks.time; 
	@echo "updated networks"; 
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) networks.byname; fi
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) networks.byaddr; fi
	@if [ ! $(NOPUSH) ]; then echo "pushed networks"; fi

services.time: $(DIR)/services
	@(awk 'BEGIN { OFS="\t"; } $$1 !~ /^#/ { print $$2, $$0 }' \
	    $(DIR)/services $(CHKPIPE))| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/services.byname;

	@touch services.time; 
	@echo "updated services"; 
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) services.byname; fi
	@if [ ! $(NOPUSH) ]; then echo "pushed services"; fi

rpc.time: $(DIR)/rpc
	@(awk 'BEGIN { OFS="\t"; } $$1 !~ /^#/ { print $$2, $$0 }' \
	    $(DIR)/rpc $(CHKPIPE))| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/rpc.bynumber;
	@touch rpc.time; 
	@echo "updated rpc"; 
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) rpc.bynumber; fi
	@if [ ! $(NOPUSH) ]; then echo "pushed rpc"; fi

protocols.time: $(DIR)/protocols
	@(awk 'BEGIN { OFS="\t"; } $$1 !~ /^#/ { print $$2, $$0 }' \
	    $(DIR)/protocols $(CHKPIPE)) | $(MAKEDBM) - \
	    $(YPDBDIR)/$(DOM)/protocols.bynumber; 

	@(sed -e "/^#/d" -e s/#.*$$// $(DIR)/protocols $(CHKPIPE)) |( awk \
	    '{print $$1,$$0; for (i = 3;i <= NF;i++) print $$i, $$0}' \
	    $(CHKPIPE))| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/protocols.byname; 

	@touch protocols.time; 
	@echo "updated protocols"; 
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) protocols.byname; fi
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) protocols.bynumber; fi
	@if [ ! $(NOPUSH) ]; then echo "pushed protocols"; fi

netgroup.time: $(DIR)/netgroup
	@$(MAKEDBM) $(DIR)/netgroup $(YPDBDIR)/$(DOM)/netgroup
	@($(REVNETGROUP) < $(DIR)/netgroup -u $(CHKPIPE))| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/netgroup.byuser
	@($(REVNETGROUP) < $(DIR)/netgroup -h $(CHKPIPE))| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/netgroup.byhost
	@touch netgroup.time; 
	@echo "updated netgroup"; 
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) netgroup; fi
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) netgroup.byuser; fi
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) netgroup.byhost; fi
	@if [ ! $(NOPUSH) ]; then echo "pushed netgroup"; fi

bootparams.time: $(DIR)/bootparams
	@(sed -e '/^#/d' -e s/#.*$$// -e 's/[	 ][	 ]*$$//' \
	    -e '/\\$$/s/\\$$/ /' $(DIR)/bootparams $(CHKPIPE))\
	|( awk '/ $$/ {printf "%s", $$0} !/ $$/ {print}' $(CHKPIPE))\
	|( sed -e 's/[	 ][	 ]*/ /g' $(CHKPIPE))\
	| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/bootparams;
	@touch bootparams.time; 
	@echo "updated bootparams"; 
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) bootparams; fi
	@if [ ! $(NOPUSH) ]; then echo "pushed bootparams"; fi

aliases.time: $(ALIASES)
	@cp $(ALIASES) $(YPDBDIR)/$(DOM)/mail.aliases; 
	@/usr/lib/sendmail -bi -oA$(YPDBDIR)/$(DOM)/mail.aliases; 
	$(MKALIAS) $(YPDBDIR)/$(DOM)/mail.aliases $(YPDBDIR)/$(DOM)/mail.byaddr; 
	rm $(YPDBDIR)/$(DOM)/mail.aliases; 
	@touch aliases.time; 
	@echo "updated aliases"; 
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) mail.aliases; fi
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) mail.byaddr; fi
	@if [ ! $(NOPUSH) ]; then echo "pushed aliases"; fi

netmasks.time: $(DIR)/netmasks
	$(MAKEDBM) $(DIR)/netmasks $(YPDBDIR)/$(DOM)/netmasks.byaddr; 
	@touch netmasks.time; 
	@echo "updated netmasks"; 
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) netmasks.byaddr; fi
	@if [ ! $(NOPUSH) ]; then echo "pushed netmasks"; fi


publickey.time: $(DIR)/publickey
	@(sed "/^#/d" < $(DIR)/publickey $(CHKPIPE))| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/publickey.byname; 
	@touch publickey.time; 
	@echo "updated publickey"; 
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) publickey.byname; fi
	@if [ ! $(NOPUSH) ]; then echo "pushed publickey"; fi

netid.time: $(DIR)/passwd $(DIR)/group $(DIR)/hosts $(DIR)/netid
	@$(MKNETID) -q -p $(DIR)/passwd -g $(DIR)/group -h $(DIR)/hosts -m $(DIR)/netid > .ypjunk; 
	@$(MAKEDBM) .ypjunk $(YPDBDIR)/$(DOM)/netid.byname; 
	@rm -f .ypjunk; 
	@touch netid.time; 
	@echo "updated netid"; 
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) netid.byname; fi
	@if [ ! $(NOPUSH) ]; then echo "pushed netid"; fi


passwd.adjunct.time: $(DIR)/security/passwd.adjunct
	@(awk 'BEGIN { FS=":"; OFS="\t"; } /^[a-zA-Z0-9_]/ { print $$1, $$0 }' \
	  $(DIR)/security/passwd.adjunct $(CHKPIPE)) | \
	$(MAKEDBM) -s - $(YPDBDIR)/$(DOM)/passwd.adjunct.byname; 
	@chmod 600 $(YPDBDIR)/$(DOM)/passwd.adjunct.byname.dir; 
	@chmod 600 $(YPDBDIR)/$(DOM)/passwd.adjunct.byname.pag; 
	@touch passwd.adjunct.time 
	@echo "updated passwd.adjunct"; 
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) passwd.adjunct.byname; fi
	@if [ ! $(NOPUSH) ]; then echo "pushed passwd.adjunct"; fi

group.adjunct.time: $(DIR)/security/group.adjunct
	@(awk 'BEGIN { FS=":"; OFS="\t"; } /^[a-zA-Z0-9_]/ { print $$1, $$0 }' \
	  $(DIR)/security/group.adjunct $(CHKPIPE)) | \
	$(MAKEDBM) -s - $(YPDBDIR)/$(DOM)/group.adjunct.byname; 
	@chmod 600 $(YPDBDIR)/$(DOM)/group.adjunct.byname.dir; 
	@chmod 600 $(YPDBDIR)/$(DOM)/group.adjunct.byname.pag; 
	@touch group.adjunct.time 
	@echo "updated group.adjunct"; 
	@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) group.adjunct.byname; fi
	@if [ ! $(NOPUSH) ]; then echo "pushed group.adjunct"; fi
	
timezone.time:  $(DIR)/timezone
	-@if [ -f $(DIR)/timezone ]; then \
		sed -e "/^#/d" -e s/#.*$$// $(DIR)/timezone \
		| awk '{for (i = 2; i<=NF; i++) print $$i, $$0}' \
		| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/timezone.byname; \
		touch timezone.time; \
		echo "updated timezone"; \
		if [ ! $(NOPUSH) ]; then \
			$(YPPUSH) timezone.byname; \
			echo "pushed timezone"; \
		else \
		: ; \
		fi \
	else \
		echo "couldn't find $(DIR)/timezone"; \
	fi

auto.master.time:  $(DIR)/auto.master
	-@if [ -f $(DIR)/auto.master ]; then \
		sed -e "/^#/d" -e s/#.*$$// $(DIR)/auto.master \
		| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/auto.master; \
		touch auto.master.time; \
		echo "updated auto.master"; \
		if [ ! $(NOPUSH) ]; then \
			$(YPPUSH) auto.master; \
			echo "pushed auto.master"; \
		else \
		: ; \
		fi \
	else \
		echo "couldn't find $(DIR)/auto.master"; \
	fi

auto.home.time:  $(DIR)/auto.home
	-@if [ -f $(DIR)/auto.home ]; then \
		sed -e "/^#/d" -e s/#.*$$// $(DIR)/auto.home \
		| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/auto.home; \
		touch auto.home.time; \
		echo "updated auto.home"; \
		if [ ! $(NOPUSH) ]; then \
			$(YPPUSH) auto.home; \
			echo "pushed auto.home"; \
		else \
		: ; \
		fi \
	else \
		echo "couldn't find $(DIR)/auto.home"; \
	fi


passwd: passwd.time
group: group.time
hosts: hosts.time
ethers: ethers.time
networks: networks.time
rpc: rpc.time
services: services.time
protocols: protocols.time
netgroup: netgroup.time
bootparams: bootparams.time
aliases: aliases.time
publickey: publickey.time
netid: netid.time
passwd.adjunct: passwd.adjunct.time
group.adjunct: group.adjunct.time
netmasks: netmasks.time
timezone: timezone.time
auto.master: auto.master.time
auto.home: auto.home.time
$(DIR)/netid:
$(DIR)/timezone:
$(DIR)/auto.master:
$(DIR)/auto.home:
