/* @(#) utmp.h 1.1@(#) Solbourne id 9/22/93 00:40:59 */
/*	@(#)utmp.h 1.8 88/08/19 SMI; from UCB 4.2 83/05/22	*/

#ifndef _utmp_h
#define _utmp_h

/*
 * Structure of utmp and wtmp files.
 *
 * XXX - Assuming the number 8 is unwise.
 */
struct utmp {
	char	ut_line[8];		/* tty name */
	char	ut_name[8];		/* user id */
	char	ut_host[16];		/* host name, if remote */
	long	ut_time;		/* time on */
};

/*
 * This is a utmp entry that does not correspond to a genuine user
 */
#define nonuser(ut) ((ut).ut_host[0] == 0 && \
	strncmp((ut).ut_line, "tty", 3) == 0 && ((ut).ut_line[3] == 'p' \
					      || (ut).ut_line[3] == 'q' \
					      || (ut).ut_line[3] == 'r' \
					      || (ut).ut_line[3] == 's' \
					      || (ut).ut_line[3] == 't' \
					      || (ut).ut_line[3] == 'u' \
					      || (ut).ut_line[3] == 'v' \
					      || (ut).ut_line[3] == 'w' \
					      || (ut).ut_line[3] == 'x' \
					      || (ut).ut_line[3] == 'y' \
					      || (ut).ut_line[3] == 'z' \
					      || (ut).ut_line[3] == 'P' \
					      || (ut).ut_line[3] == 'Q' \
					      || (ut).ut_line[3] == 'R' \
					      || (ut).ut_line[3] == 'S' \
					      || (ut).ut_line[3] == 'T' \
					      || (ut).ut_line[3] == 'U' \
					      || (ut).ut_line[3] == 'V' \
					      || (ut).ut_line[3] == 'W' \
					      || (ut).ut_line[3] == 'X' \
					      || (ut).ut_line[3] == 'Y' \
					      || (ut).ut_line[3] == 'Z' \
					      || (ut).ut_line[3] == 'A' \
					      || (ut).ut_line[3] == 'B' \
					      || (ut).ut_line[3] == 'C' \
					      || (ut).ut_line[3] == 'D' \
					      || (ut).ut_line[3] == 'E' \
					      || (ut).ut_line[3] == 'F' \
					      || (ut).ut_line[3] == 'G' \
					      || (ut).ut_line[3] == 'H' \
					      || (ut).ut_line[3] == 'I' \
					      || (ut).ut_line[3] == 'J' \
					      || (ut).ut_line[3] == 'K' \
					      || (ut).ut_line[3] == 'L' \
					      || (ut).ut_line[3] == 'M' \
					      || (ut).ut_line[3] == 'N' \
					      || (ut).ut_line[3] == 'O' \
					      || (ut).ut_line[3] == 'd' \
					      || (ut).ut_line[3] == 'e' \
					      || (ut).ut_line[3] == 'f' \
					      || (ut).ut_line[3] == 'g' \
					      || (ut).ut_line[3] == 'h' \
					      || (ut).ut_line[3] == 'i' \
					      || (ut).ut_line[3] == 'j' \
					      || (ut).ut_line[3] == 'k' \
					      || (ut).ut_line[3] == 'l' \
					      || (ut).ut_line[3] == 'm' \
					      || (ut).ut_line[3] == 'n'))

#endif /*!_utmp_h*/
