/* @(#) trace.h 1.14@(#) Solbourne id 3/10/94 20:57:59 */
/*
 * Copyright 1990 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*	@(#)trace.h 2.17 89/05/04 SMI; from UCB 7.1 6/4/86	*/

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 * Copyright (c) 1987 by Sun Microsystems, Inc.
 */

#ifndef _sys_trace_h
#define _sys_trace_h

/*
 * Trace point definitions.  Beware of conflicts with the
 * window system keyboard translation macros (TR_ASCII et al).
 *
 * The set of active trace points is recorded in the variable
 * tracedevents.  Because we declare this variable as an tr_set,
 * the maximum allowable trace point index is bounded by TR_SETSIZE.
 *
 * For the most part, these trace points are quite specific to SunOS 4.0.
 *
 * The trace point definitions follow stringent conventions for the benefit
 * of postprocessors wishing to manipulate trace information.  The names
 * all start with TR_, and each definition is followed on the next line by
 * a comment whose content is a printf-like formatting string.  Successive
 * format items are fed by successive tr_datum* values from the current
 * trace item.  The only unusual format is %C, which is followed by an angle
 * bracketed, comma separated list of (unquoted) strings, the i-th of which
 * is to be printed when the associated value is i (0-origin).
 *
 * Note that the current trace points confine themselves to the C, d, and
 * x formats so that postprocessors can confine themselves to supporting
 * only these formats.  This situation may change when additional trace
 * points are defined.
 */

#ifndef	TR_SETSIZE
#define	TR_SETSIZE	2048
#endif	TR_SETSIZE

typedef	long	tr_mask;
#define	NTRBITS	(sizeof (tr_mask) * NBBY)	/* bits per mask */
#ifndef	howmany
#ifdef	sun386
#define	howmany(x, y)   ((((u_int)(x))+(((u_int)(y))-1))/((u_int)(y)))
#else
#define	howmany(x, y)	(((x)+((y)-1))/(y))
#endif
#endif

typedef	struct tr_set {
	tr_mask	trs_bits[howmany(TR_SETSIZE, NTRBITS)];
} tr_set;

#define	TR_SET(n, p)	((p)->trs_bits[(n)/NTRBITS] |= (1 << ((n) % NTRBITS)))
#define	TR_CLR(n, p)	((p)->trs_bits[(n)/NTRBITS] &= ~(1 << ((n) % NTRBITS)))
#define	TR_ISSET(n, p)	((p)->trs_bits[(n)/NTRBITS] & (1 << ((n) % NTRBITS)))
#define	TR_ZERO(p)	bzero((char *)(p), sizeof (*(p)))

/*
 * User-level trace annotation.
 */
#define TR_STAMP		0	/* user: vtrace(VTR_STAMP, value); */
/* "value %d pid %d" */

/*
 * Paging trace points.  The TR_PG_* trace points all start by recording
 * pp, vp, and off values.
 */
#define TR_PG_POCLEAN		1	/* about to clean a page in pageout */
/* "pp %x vp %x off %d hand %d freemem %d" */
#define TR_PG_POFREE		2	/* add page to free list in pageout */
/* "pp %x vp %x off %d hand %d freemem %d" */
#define TR_PG_RECLAIM		3	/* page obtained in page_reclaim */
/* "pp %x vp %x off %d ap %x age %d freemem %d" */
#define TR_PG_ENTER		4 /* page_enter: page assoc. with <vp,off> */
/* "pp %x vp %x off %d retval %d" */
#define TR_PG_ABORT		5 /* page_abort: page disassoc. w/ <vp,off> */
/* "pp %x vp %x off %d code %C<aborted,kept,intrans>" */
#define TR_PG_FREE		6	/* call to page_free */
/* "pp %x vp %x off %d dontneed %d freemem %d code %C<gone,free,cachetl,cachehd>" */
#define TR_PG_ALLOC		7	/* single page allocated in page_get */
/* "pp %x vp %x off %d age %d fromcache %d" */
#define TR_PG_SEGMAP_FLT	8	/* segmap_fault sets p_ref = 1 */
/* "pp %x vp %x off %d softlock %d" */
#define TR_PG_SEGVN_FLT		9	/* segvn_fault sets p_ref = 1 */
/* "pp %x vp %x off %d softlock %d" */
#define TR_PG_PVN_DONE		10	/* pvn_done sets p_gone = 1 */
/* "pp %x vp %x off %d" */
#define TR_PG_PVN_GETDIRTY	11	/* pvn_getdirty sets p_ref = 0 */
/* "pp %x vp %x off %d" */
#define TR_PG_HAT_NEWSEG	12	/* hat_newseg OR's p_ref */
/* "pp %x vp %x off %d referenced %d" */
#define TR_PG_HAT_GETPME	13	/* hat_getpme OR's p_ref */
/* "pp %x vp %x off %d referenced %d" */
#define TR_PG_POREF		14	/* clock hand finds p_ref == 1 */
/* "pp %x vp %x off %d hand %d" */
#define TR_PG_RELSE		15	/* page_relse */
/* "pp %x vp %x free %d keepcnt %d gone %d" */

#define TR_PAGE_GET_SLEEP	19	/* sleep during page alloc request */
/* "bytes %x canwait %d freemem %d after? %d" */
#define TR_PAGE_GET		20	/* page allocation request */
/* "bytes %x canwait %d freemem %d code %C<allocated,toobig,nomem>" */

/*
 * Page abort codes
 */
#define TRC_ABORT_ABORTED	0
#define TRC_ABORT_KEPT		1
#define TRC_ABORT_INTRANS	2

/*
 * Page free codes
 */
#define TRC_FREE_GONE		0
#define TRC_FREE_FREE		1
#define TRC_FREE_CACHETL	2
#define TRC_FREE_CACHEHD	3

/*
 * Page get codes
 */
#define TRC_GET_ALLOCATED	0
#define TRC_GET_TOOBIG		1
#define TRC_GET_NOMEM		2

/*
 * File system buffer tracing points; all trace <dev, bn>
 */
#define TR_BREADHIT		21	/* buffer read found in cache */
/* "vp %x bn %d bp %x flags %x" */
#define TR_BREADMISS		22	/* buffer read not in cache */
/* "vp %x bn %d bp %x flags %x" */
#define TR_BWRITE		23	/* buffer written */
/* "vp %x bn %d bp %x flags %x" */
#define TR_BRELSE		24	/* brelse */
/* "vp %x bn %d bp %x flags %x" */
#define TR_BOWRITE		25	/* buffer written using overlap */
/* "vp %x bn %d bp %x flags %x seq %x" */
#define TR_BOWRITEN		26	/* starting next write for overlap */
/* "vp %x bn %d bp %x flags %x seq %x" */
#define TR_BWAIT		27	/* wait for buffer I/O done */
/* "vp %x bn %d bp %x flags %x seq %x" */
#define TR_BDONE		28	/* buffer I/O done */
/* "vp %x bn %d bp %x flags %x" */
#define TR_BIOCHWT		29	/* Wait on biochain */
/* "proc %x chain %x" */

/*
 *  Calibration trace record
 */
#define TR_CALIBRATE		30	/* calibration point in hardclock */
/* "seqnum %d sec %d usec %d" */

/*
 * Paging daemon trace points
 */
#define TR_PAGEOUT		31	/* pageout daemon statistics */
/* "after? %d nscan %d desscan %d freemem %d lotsfree %d" */
#define TR_PAGEOUT_CALL		32	/* pageout daemon call */
/* "callpoint %C<getnpage,getfrlw,schedcpu,schedpag,swdone>" */
#define TR_PAGEOUT_MAXPGIO	33	/* pushes > maxpgio in checkpage */
/* "freemem %d nscan %d" */
#define TR_PAGEOUT_WRAP		34	/* front clock hand wrap around */
/* "freemem %d hand %d" */
/*
 * Pageout daemon call location codes
 */
#define TRC_POCALL_GETNPAGE	0
#define TRC_POCALL_GETFRLW	1
#define TRC_POCALL_SCHEDCPU	2
#define TRC_POCALL_SCHEDPAG	3
#define TRC_POCALL_SWDONE	4

#define TR_RUNRUN		35	/* runrun has been set */
/* "runrun cpu %d lcpu %d pam %x from %d pri %d %d" */
#define TR_ROUNDROBIN		36	/* roundrobin */
/* "roundrobin pri %d: %d %d %d %d %d" */

#define	TR_KMEM_ALLOC		38
/* "kmem_alloc %x len %x: from %x %x %x %x" */
#define	TR_KMEM_FREE		39
/* "kmem_free  %x len %x: from %x %x %x %x" */

/*
 * Mapping of objects to vnode and <vnode, offset> values
 */
#define TR_MP_SWAP		40	/* allocate a page of swap */
/* "vp %x off %d ap %x" */
#define TR_MP_LNODE		41	/* allocate an lnode */
/* "vp %x lvp %x" */
#define TR_MP_SNODE		42	/* allocate an snode */
/* "vp %x dev %x makespecvp %d" */
#define TR_MP_INODE		43	/* allocate an inode */
/* "vp %x dev %x inode %x" */
#define TR_MP_RNODE		44	/* allocate an rnode */
/* "vp %x fsid %x %x len %x fid %x %x" */
#define TR_MP_TRUNC0		45	/* truncate file to zero length */
/* "vp %x" */
#define TR_MP_TRUNC		46	/* truncate file */
/* "vp %x newlen %d oldlen %d" */
#define TR_MP_SWAPFREE		47	/* free a page of swap */
/* "vp %x off %d ap %x" */

/*
 * Segment trace points
 */
#define TR_SEG_GETMAP		50	/* get a segmap */
/* "seg %x addr %x type %C<kseg,segkmap,anon,file,unk> vp %x off %d" */
#define TR_SEG_RELMAP		51	/* release a segmap */
/* "seg %x addr %x type %C<kseg,segkmap,anon,file,unk> refcnt %d" */
#define TR_SEG_ALLOCPAGE	52	/* call to rm_allocpage */
/* "seg %x addr %x type %C<kseg,segkmap,anon,file,unk> vp %x off %d pp %x" */
#define TR_SEG_GETPAGE		53	/* call to VOP_GETPAGE */
/* "seg %x addr %x type %C<kseg,segkmap,anon,file,unk>" */
#define TR_SEG_KLUSTER		54	/* call to pvn_kluster */
/* "seg %x addr %x readahead %d" */

/*
 * Segment type codes
 */
#define TRC_SEG_KSEG		0
#define TRC_SEG_SEGKMAP		1
#define TRC_SEG_ANON		2
#define TRC_SEG_FILE		3
#define TRC_SEG_UNK		4

/*
 * Process trace points
 */
#define TR_WAKEUP_TRACEBACK	59
/* "wakeup from %a, %a, %a, %a, %a, %a" */
#define TR_PR_SLEEP		60
/* "wchan %x proc %x pri %d" */
#define TR_PR_SLEEP_UNLOCK	61
/* "wchan %x proc %x pri %d lp %x" */
#define TR_SLEEP_TRACEBACK	62
/* "sleep from %a, %a, %a, %a, %a, %a" */
#define TR_PR_USER_SLEEP	63
/* "wchan %x proc %x pri %d" */
#define TR_PR_UNSLEEP		66
/* "wchan %x proc %x pri %d" */
#define TR_PR_UNSLEEP_NOLOCK	67
/* "wchan %x proc %x pri %d" */
#define TR_PR_WAKEUP_P		68	/* before call to wakeup */
/* "ptime %d cpu %d stime %d runout %d" */
#define TR_PR_WAKEUP		69
/* "wchan %x proc %x pri %d stat %C<ZERO,SLEEP,WAIT,SRUN,SIDL,SZOMB,SSTOP> slptime %d" */

/*
 * Swapper trace points
 */
#define TR_SWAP_LOOP		70	/* at loop: in sched */
/* "mapwant %d avenrun %d avefree %d avefree30 %d pginrate %d pgoutrate %d" */
#define TR_SWAP_OUT		71	/* call to swapout */
/* "proc %x hardwap? %d freed %d" */
#define TR_SWAP_SLEEP		72	/* sched calls sleep() */
/* "chan %x runin %d runout %d wantin %d" */
#define TR_SWAP_IN_CHECK	73	/* decision point on calling swapin */
/* "proc %x freemem %d deficit %d needs %d outpri %d maxslp %d" */
#define TR_SWAP_OUT_CHECK	74	/* decision point on calling swapout */
/* "proc %x sleeper %d desperate %d deservin %d inpri %d maxslp %d" */
#define TR_SWAP_IN		75	/* call to swapin */
/* "proc %x taken %d" */
#define TR_SWAP_OUT_CHECK0	76	/* decision point on calling swapout */
/* "proc %x freemem %d rssize %d slptime %d maxslp %d swappable %x" */
#define TR_HAT_ALLOC		77
/* "as %x ctx %x" */
#define TR_HAT_FREE		78
/* "as %x ctx %x" */

/*
 * ufs trace points
 */
#define TR_UFS_RWIP		80	/* call to rwip */
/* "inode %x uio %x rw %x ioflag %d offset %d location %C<enter,getmap,bmapalloc,zero,uiomove,release,iupdat,return>" */
#define TR_UFS_INODE		81	/* inode */
/* "inode %x flag %x dev %x number %d mode/rdev %x last %d" */
#define TR_UFS_INSTATS		82	/* inode stats */
/* "inode %x dev %x number %x cache %C<miss,hit> misses %d hits %d" */
#define TR_UFS_INSTATS_RESET	83	/* inode stats reset */
/* "" */
#define TR_BGETBNO		84	/* call to bgetbno */
/* "bgetbno vp %x dp %x: bnop %x sizep %x tbnp %x" */
#define	TR_UFS_GETAPAGE		85
/* "vp %x off %x pl %x addr %x %x %C<enter,reread,again,pageio,2nd>" */
#define	TR_UFS_WRITEDONE	86
/* "bp %x ip %x" */
#define	TR_UFS_WRITELBN		87
/* "bp %x ip %x pp %x len %x flags %x" */
#define	TR_UFS_PUTPAGE		88
/* "vp %x ip %x %x %x %x %C<enter,again,dirty>" */
#define	TR_UFS_BMAP		89
/* "%C<read,write,bap> %x %x %x %x %x" */
/* no trace data generated for this one */

/*
 * rwip location type codes
 */
#define TRC_RWIP_ENTER		0
#define TRC_RWIP_GETMAP		1
#define TRC_RWIP_BMAPALLOC	2
#define TRC_RWIP_ZERO		3
#define TRC_RWIP_UIOMOVE	4
#define TRC_RWIP_RELEASE	5
#define TRC_RWIP_IUPDAT		6
#define TRC_RWIP_RETURN		7

/*
 * Cache hit/miss codes
 */
#define TRC_INSTATS_MISS	0
#define TRC_INSTATS_HIT		1

/* GETAPAGE type codes */
#define	TRC_GETAPAGE_ENTER	0
#define	TRC_GETAPAGE_REREAD	1
#define	TRC_GETAPAGE_AGAIN	2
#define	TRC_GETAPAGE_PAGEIO	3
#define	TRC_GETAPAGE_2ND	4

/* PUTPAGE type codes */
#define	TRC_PUTPAGE_ENTER	0
#define	TRC_PUTPAGE_AGAIN	1
#define	TRC_PUTPAGE_DIRTY	2

/* BMAP type codes */
#define	TRC_BMAP_READ		0
#define	TRC_BMAP_WRITE		1
#define	TRC_BMAP_BAP		2

/*
 * Memory allocator trace points; all trace the amount of memory involved.
 */

/*
 * Trace points for the external VM model
 *
 * First, paging-related trace points
 */
#define TR_PG_INIT		90	/* call to page_init */
/* "pages %x num %d" */
#define TR_PG_ALLOC1		91	/* page allocated in page_get() */
/* "pp %x plist %x %C<free,cache>list" */
#define TR_PG_UNFREE		92	/* call to page_unfree */
/* "pp %x %C<free,cache>list" */
#define TR_PG_HASHIN		93	/* call to page_hashin */
/* "pp %x vp %x off %x lock %d" */
#define TR_PG_HASHOUT		94	/* call to page_hashout */
/* "pp %x vp %x %d" */
#define TR_PG_SETREF		95	/* page ref bit set */
/* "pp %x ref %d" */
#define TR_PG_SETMOD		96	/* page mod bit set */
/* "pp %x mod %d" */
#define TR_PG_PINIT		97	/* return initial per-page data */
/* "pp %x vp %x off %x free %d" */

/*
 * Special page tracing points.
 */
#define TR_SPG_FLT		110	/* Various information on page faults */
/* "pc %a addr %x vp %x offset %x type %C<file,anon,zero,cowr,smap>" */
#define TR_SPG_FLT_PROC		111	/* Process generating a fault */
/* "sec %x usec %x name %s2" */

#define TRC_SPG_FILE		0
#define TRC_SPG_ANON		1
#define TRC_SPG_ZERO		2
#define TRC_SPG_COW		3
#define TRC_SPG_SMAP		4

#define TR_SPG_PAGECOPY		112	/* pagecopy invoked */
/* "addr %x pp %x" */
#define TR_SPG_PAGEZERO		113	/* pagezero invoked */
/* "pp %x off %d len %d" */

/*
 * Vnode tracing points.
 */
#define TR_VN_LOOKUP		115	/* VOP_LOOKUP() */
/* "vp %x name %s1" */
#define TR_VN_CREATE		116	/* VOP_CREAT() */
/* "vp %x name %s1" */ 
#define TR_VN_MKDIR		117	/* VOP_MKDIR() */
/* "vp %x name %s1" */ 
#define TR_VN_INACTIVE		119	/* VOP_INACTIVE() */
/* "vp %x" */
#define TR_VN_DNLC		120	/* Read entries out of the dnlc */
/* "vp %x count %d name %s2" */
#define TR_VN_RELE		121	/* Call to VN_RELE() macro */
/* "vp %x" */
#define TR_VN_LOOKUPNAME	122	/* lookupname (), pathname to a vnode */
/* "vp %x name %s1" */
#define TR_VN_REUSE 		123
/* "vp %x pagecount %d" */


/*
 * Process tracing points.
 */
#define TR_PROC_EXEC 		124	/* Exec'ing a process */
/* "name %s0" */
#define TR_PROC_EXECARGS	125	/* Arguments of exec'ing process */
/* "args %s0" */
#define TR_PROC_EXIT 		126	/* Exiting process */
/* "name %s0" */
#define TR_PROC_FORK 		127	/* Forked process */
/* "pid %d name %s1" */

/*
 * System call trace points.
 */
#define TR_GETHOSTID		134	/* gethostid system calls */
/* "gethostid %x %x %x %x %x %x" */
#define TR_SYSCALL		135	/* System calls */
/* "syscall %S pc %x args %x %x %x %x" */
#define TR_SYSCALL_DONE		136	/* System calls */
/* "end-syscall %S u_eosys %C<NORMALRETURN,JUSTRETURN,RESTARTSYS> u_errno %d: r_val1 %x r_val2 %x" */

/*
 * Interrupt trace points.
 */
#define TR_INTERRUPT		137	/* Interrupts */
/* "handler %x" */
#define TR_TLB_SHOT		138	/* TLB shoot receipt */
/* "addr %x len %d" */

/*
 * trap trace point
 */
#define TR_TRAP			139	/* System traps */
/* "type %x pc %a rp %x addr %x fcr %x rw %x" */


/*
 * Hat layer trace points
 */
#define TR_HAT_PTELOAD		140	/* load pte to page tables */
/* "seg %x addr %x pp %x pte %x flags %x" */
#define TR_HAT_UNLOAD		141	/* unload va from page tables */
/* "seg %x addr %x len %x" */
#define TR_HAT_PAGEUNLOAD	142	/* unload page from page tables */
/* "pp %x" */
#define TR_MMU_SETPTE		143	/* set pte into page tables */
/* "addr %x pte %x" */
#define TR_MMU_SETREF		144	/* set reference bit into pte */
/* "addr %x pte %x" */
#define TR_MMU_SETMOD		145	/* set modify bit into pte */
/* "addr %x pte %x" */

/*
 * idle cpu trace points
 */
#define	TR_MULTIIDLE_START	146
/* "multiidle start" */
#define	TR_MULTIIDLE_END	147
/* "multiidle end" */
#define TR_IDLES		148
/* "idle start pid %d.%x" */
#define TR_IDLEE		149
/* "idle end pid %d.%x" */

/*
 * context switching trace points
 */
#define TR_SWITCH_SETRQ		150
/* "pid %d.%x" */
#define TR_SWITCH_REMRQ		151
/* "pid %d.%x" */
#define TR_SWITCH_SWTCH		152
/* "pid %d.%x p %x exiting %d name %s2" */
#define TR_SWITCH_RESUME 	153	/* Resumed process */
/* "pid %d.%x name %s2" */
#define TR_SWITCH_FASTRESUME 	154	/* Resumed process */
/* "pid %d.%x name %s2" */
#define TR_SWITCH_NONE		155
/* "pid %d.%x whichqs %x" */
#define TR_SWITCH_NEWP		156
/* "oldp %d.%x newp %d.%x p %d.%x" */
#define TR_SWITCH_LOADCTX	157
/* "pid %d.%x" */
#define TR_SWITCH_CP_ENTER	158
/* "pid %d.%x exiting %d" */
#define TR_SWITCH_CP_NONE	160
/* "pid %d.%x whichqs %x" */
#define TR_SWITCH_CP_GONE	161
/* "pid %d.%x whichqs %x" */
#define TR_SWITCH_CP_PRI	162
/* "old pid %d.%x pri %d, newp %d.%x pri %d" */
#define TR_SWITCH_CP_NEWP	163
/* "pid %d.%x" */
#define TR_SWITCH_SNAP_RESUME	164
/* "pid %d.%x" */
#define TR_SWITCH_CP_CONT	165
/* "skip %d.%x type %d" */
#define TR_SWITCH_CP_CONTN	166
/* "none in %d" */
#define TR_SWITCH_TRACEBACK	167
/* "multi_swtch from %a, %a, %a, %a, %a, %a" */

#define TR_SEGU_SWAPOUT		170
/* "pid %d swa0 %x swa1 %x swa2 %x" */
#define TR_SEGU_SWAPIN		171
/* "pid %d swa0 %x swa1 %x swa2 %x" */
#define TR_SEGU_EXIT		172
/* "pid %d swa0 %x swa1 %x swa2 %x" */

#define TR_PSIG_STOP		173
/* "pid %d p %x sig %d" */
#define	TR_PSIGNAL_STOP		174
/* "pid %d sig %d=0x%x ignore=0x%x mask=0x%x catch=0x%x" */
#define	TR_PSIGNAL_CONT		175
/* "pid %d sig %d=0x%x ignore=0x%x mask=0x%x catch=0x%x" */
#define	TR_SENDSIG		176
/* "sendsig proc %x pid %d sig %d mask %x func %a" */
#define	TR_SIGCLEANUP		177
/* "sigcleanup scp %x pc %a mask %x sp %x" */
#define TR_PSIGNAL		178
/* "pid %d sig %d=0x%x ignore=0x%x mask=0x%x catch=0x%x" */
#define TR_PSIGNAL1		179
/* "p %x stat %C<ZERO,SLEEP,WAIT,SRUN,SIDL,SZOMB,SSTOP> pri %d nice %d flag %x action %x" */
#define TR_PSIGNAL2		180
/* "cpu %d noproc %d p_uarea %x usermode %d" */
#define TR_ISSIG		181
/* "pid %d p %x flag %d return %d p_cursig %d" */
#define	TR_ISSIG_HOLD_LOCKS 	182
/* "pid %d flag %d lp %x return %d p_cursig %d %d" */
#define TR_PSIG			183
/* "pid %d p %x sig %d" */

/*
 * trace traceback...
 */
#define TR_TRACEBACK		184
/* "called from %a, %a, %a, %a, %a, %a" */

#define	TR_EGDEBUG		185
/* "egdebug %x %x %x" */

#define	TR_DVMACACHE_1		186
/* "dvmacache search  ppage %x npf %d" */
#define	TR_DVMACACHE_2		187
/* "dvmacache hit     reg %04x npf %d refcnt %d" */
#define	TR_DVMACACHE_3		188
/* "dvmacache alloc   reg %04x npf %d" */
#define	TR_DVMACACHE_4		189
/* "dvmacache free    reg %04x npf %d" */
#define	TR_DVMACACHE_5		190
/* "dvmacache reclaim reg %04x" */

#define	TR_RMAP_1		191
/* "rminit  map %08x size %08x addr %08x name %08x mapsize %08x" */
#define	TR_RMAP_2		192
/* "rmalloc map %08x size %08x addr %08x" */
#define	TR_RMAP_3		193
/* "rmfree  map %08x size %08x addr %08x" */
#define	TR_RMAP_4		194
/* "rmget   map %08x size %08x addr %08x" */
#define	TR_RMAP_5		195
/* "rmalloc_wslp map %08x size %08x" */
#define TR_RMAP_TRACEBACK	196
/* "from %a, %a, %a, %a, %a, %a" */

#define TR_NFS_1                200
/* "nfs_inactive vp 0x%x count %d" */
#define TR_NFS_2                201
/* "nfs_remove vp 0x%x count %d" */
#define TR_NFS_3                202
/* "nfs_putpage vp 0x%x count %d oldcount %d" */

/* trace codes for non specific locks */
#define TR_REGEN_GETLOCK	210
/* "%s0_GET" */
#define TR_REGEN_GOTLOCK	211
/* "%s0_GOT" */
#define TR_REGEN_DROPLOCK	212
/* "%s0_DROP" */
#define TR_REGEN_FAILLOCK	213
/* "%s0_FAIL" */

/* trace codes for vm locks */
#define TR_REGEN_VMGETLOCK	214
/* "%s0_VMGET" */
#define TR_REGEN_VMGOTLOCK	215
/* "%s0_VMGOT" */
#define TR_REGEN_VMDROPLOCK	216
/* "%s0_VMDROP" */
#define TR_REGEN_VMFAILLOCK	217
/* "%s0_VMFAIL" */

/* trace codes for interrupts */
#define TR_REGEN_INTS		220	/* level Interrupts */
/* "%s0_INTS" */
#define TR_REGEN_INTE		221	/* level Interrupts */
/* "%s0_INTE" */
#define TR_REGEN_VINT		222	/* start VME Interrupt (need locks?) */
/* "%s0_VINTS" */
#define TR_REGEN_VINTV		223	/* vector to VME Interrupt handler */
/* "%s0_VINTV" */
#define TR_REGEN_VINTE		224	/* end of VME Interrupts */
/* "%s0_VINTE" */

#define	TR_TAG_SEQ		225	
/* "seq %d tag %d trace_buffer %x" */

#define	TR_U_SLAVE_TICK		226
/* "relay usr %d ticks: sec %d usec %d" */
#define	TR_S_SLAVE_TICK		227
/* "relay sys %d ticks: sec %d usec %d" */
#define	TR_U_HARD_TICK		228
/* "hard usr %d ticks: sec %d usec %d" */
#define	TR_S_HARD_TICK		229
/* "hard sys %d ticks: sec %d usec %d" */
#define	TR_RELAY_TICK		232
/* "hard relay: prof %x stats %x" */
#define TR_TIMEOUT_RETURN	236
/* "timeout expired call return %a arg %x" */
#define	TR_TIMEOUT		237
/* "timeout func %a arg %x lck %x" */
#define	TR_UNTIMEOUT		238
/* "untimeout timeout func %a arg %x" */
#define	TR_TIMEOUT_CALL		239
/* "timeout expired call func %a arg %x lck %x" */

#define TR_SEM_CTL		240
/* "semctl id.num %x.%x: cmd %C<0,1,2,GETNCNT,GETPID, GETVAL,GETALL,GETZCNT,SETVAL,SETALL> arg %x" */
#define TR_SEM_CTL_WAKEUP	241
/* "semop_CTL_wakeup id.num %x.%x chan %x: %x" */
#define TR_SEM_EXIT		242
/* "semexit: pid %d" */
#define TR_SEM_EXIT_WAKEUP	243
/* "semop_EXIT_wakeup chan %x: %x" */
#define TR_SEM_GET		244
/* "semget: key %x nsems %x semflg %x" */
#define TR_SEM_OP		245
/* "semop id %x: nsops %x" */
#define TR_SEM_OP_DONE		246
/* "semop_done id %x: error %d: sig %d" */
#define TR_SEM_OPOP		247
/* "semop_op id.num %x.%x: op %x val %x" */
#define TR_SEM_OP_SLEEP		248
/* "semop_op_sleep id.num %x.%x chan %x: %x val %x cnt %x" */
#define TR_SEM_OP_WAKEUP	249
/* "semop_op_wakeup id.num %x.%x chan %x: %x val %x cnt %x" */

#define	TR_SD_STRAT		260
/* "sd_strategy dev %x bn %x bp %x cnt %x" */
#define	TR_SD_START		261
/* "sd_start    dev %x bn %x bp %x cnt %x" */
#define	TR_SD_DONE		262
/* "sd_done     dev %x bn %x bp %x" */

#define TR_XD_STRAT		270
/* "xd_strategy dev %x bn %x count %x bp %x" */
#define TR_XD_START		271
/* "xd_start    dev %x bn %x count %x bp %x" */
#define TR_XD_EXEC		273
/* "xd_exec     ctlr %x iopb %x phase %d" */
#define TR_XD_DONE		274
/* "xd_done     dev %x bn %x bp %x place %d" */

#define	TR_EVENT_INIT		280
/* "init: ev %x" */
#define	TR_EVENT_ADVANCE	281
/* "advance: ev %x by %x == %x" */
#define	TR_EVENT_ADVANCE_WAKE	282
/* "adv wakeup: ev %x evw %x value %x" */
#define	TR_EVENT_AWAIT		283
/* "evcnt await sleep: ev %x evw %x for value %x, currently at %x" */
#define	TR_EVENT_AWAIT_ALREADY	284
/* "evcnt await already occured: ev %x for value %x, currently at %x" */
#define	TR_EVENT_AWAIT_SIG	285
/* "evcnt await sig: ev %x evw %x sig %x" */
#define	TR_EVENT_AWAIT_DONE	286
/* "evcnt await done: ev %x evw %x for value %x, currently at %x" */
#define	TR_EVENT_DESTROY	287

/* nfs trace points */
#define	TR_NFS_S_READ		300
/* "nfs_s_read vp %x off %x cnt %x" */
#define	TR_NFS_S_WRITE		301
/* "nfs_s_write vp %x off %x cnt %x" */
#define	TR_NFS_S_GETREQ		302
/* "svc_getreq " */

#define	TR_MBUF_INFO		310
/* "mbuf %x next %x data %x len.type %x fun %x(%x)" */
#define	TR_MBUF_DATA		311
/* "mbuf %x data %x %x %x %x %x" */
#define	TR_MBUF_MCLGET		312
/* "mclget %d m %x p %x: %x" */
#define	TR_MBUF_MCLPUT		313
/* "mclput %d m %x p %x: %x" */

#define	TR_UDP_INPUT		320
/* "udp_input m0 %x ifp %x" */
#define	TR_UDP_INPUT_FULL	321
/* "udp_input sockfull m0 %x ifp %x nfull %d space %x" */

#define	TR_THREAD_INIT		350
/* "thread_init   %x.%x.%x n_threads %x" */
#define	TR_THREAD_GET		351
/* "thread_get    %x.%x.%x cached %d threadcnt %d" */
#define	TR_THREAD_FREE		352
/* "thread_free   %x.%x.%x threadcnt %d" */
#define	TR_THREAD_DELETE	353
/* "thread_delete %x.%x.%x n_threads %x threadcnt %d" */
#define	TR_THREAD_FORK		354
/* "thread_fork   %x.%x.%x funp %x(%x, %x, %x)" */
#define	TR_THREAD_FORKC		355
/* "thread_forkc  %x.%x.%x funp %x(%x, %x, %x)" */
#define	TR_THREAD_SCHED		356
/* "thread_sched  %x.%x.%x" */
#define	TR_THREAD_SCHEDR	357
/* "thread_schedr  %x.%x.%x" */
#define	TR_THREAD_SLEEP		358
/* "thread_sleep  %x.%x.%x chan %x pri %d lp %x" */
#define	TR_THREAD_WAKEUP	359
/* "thread_wakeup %x.%x.%x chan %x p_wchan %x" */
#define	TR_THREAD_KILLG		360
/* "thread_killg  %x.%x.%x" */
#define	TR_THREAD_FORKS		361
/* "thread_frkstk %x.%x.%x psp %x csp %x size %x" */
#define	TR_THREAD_REMAP		362
/* "thread_remap  %x.%x.%x spte %x %x" */

#define	TR_AIO_READ		370
/* "aio_read proc %x fd %d dev 0x%x offset 0x%x whence %d bufsz 0x%x" */
#define	TR_AIO_WRITE		371
/* "aio_write proc %x fd %d dev 0x%x offset 0x%x whence %d bufsz 0x%x" */
#define	TR_AIO_DOIT		372
/* "aio_doit proc %x thread %x at=%x" */
#define	TR_AIO_DOIT_DONE	373
/* "aio_doit_done proc %x thread %x at=%x return %x errno %x count %d" */
#define	TR_AIO_CANCEL		374
/* "aio_cancel proc %x" */
#define	TR_AIO_WAIT		375
/* "aio_wait proc %x completed %d runable threads %d pending %d tv %x" */
#define	TR_AIO_STOP		376
/* "aio_stop proc %x" */
#define	TR_AIO_CANCELAIO	377
/* "aio_cancelaio proc %x thread %x" */
#define	TR_AIO_DONE		378
/* "aio_done proc %x thread %x" */

/* SCSI trace points */
#define	TR_SCSI_USTART		380
/* "scsi_ustart %C<already_queued,queue> c %x un %x: %x %x %x" */
#define TRC_SCSI_USTART_AQUEUE	0
#define TRC_SCSI_USTART_QUEUE	1

#define	TR_SCSI_START		381
/* "scsi_start %C<start,ddone,nal,delay,ntag,rstart,s,ndma,efault,ns,done,congest> c %x un %x c_flags %x un_flags %x: %x" */
#define	TRC_SCSI_START_START	0
#define	TRC_SCSI_START_DDONE	1
#define	TRC_SCSI_START_NAL	2
#define	TRC_SCSI_START_DELAY	3
#define	TRC_SCSI_START_NTAG	4
#define	TRC_SCSI_START_RSTART	5
#define	TRC_SCSI_START_S	6
#define	TRC_SCSI_START_NDMA	7
#define	TRC_SCSI_START_EFAULT	8
#define	TRC_SCSI_START_NS	9
#define	TRC_SCSI_START_DONE	10
#define	TRC_SCSI_START_CONGEST	11

#define	TR_SCSI_TIMER		382
/* "scsi_timer c %x un %x tag %x ba %d a %d d %d" */
#define	TR_SCSI_CMD		383
/* "scsi_cmd c %x un %x c_flags %x un_flags %x op %x intr %d" */
#define	TR_SCSI_TRIGGER		384
/* "scsi_trigger c %x un %x" */
#define	TR_SCSI_RESTART		385
/* "scsi_restart c %x un %x c_flags %x un_flags %x bp %x: %x" */
#define	TR_SCSI_RESUME_TIMEOUT	386
/* "scsi_resume_timeout c %x un %x c_flags %x un_flags %x: %x %x" */
#define	TR_SCSI_RESUME		387
/* "scsi_resume c %x un %x c_flags %x un_flags %x: %x %x" */
#define	TR_SCSI_SUSPEND		388
/* "scsi_suspend c %x un %x c_flags %x un_flags %x t %d %x" */

#define	TR_SCSI_INTR		389
/* "scsi_intr %C<start> c %x un %x c_flags %x un_flags %x ec %d" */
#define TRC_SCSI_INTR_START	0

#define	TR_SCSI_DONE		390
/* "scsi_done c %x un %x c_flags %x un_flags %x bp %x flags %x" */
#define	TR_SCSI_DISCON		391
/* "scsi_discon %d c %x un %x tag %x c_flags %x un_flags %x bp %x" */
#define	TR_SCSI_RECON		392
/* "scsi_recon c %x un %x tag %x c_flags %x un_flags %x bp %x" */
#define	TR_SCSI_IDLE		393
/* "scsi_idle c %x c_flags %x" */
#define	TR_SCSI_RESET_TIMEOUT	394
/* "scsi_reset_timeout c %x c_flags %x" */
#define	TR_SCSI_RESET		395
/* "scsi_reset c %x un %x c_flags %x un_flags %x send %x intr %x" */
#define	TR_SCSI_PREEMPTED	396
/* "scsi_preempted c %x un %x tag %x: %x %x %x" */
#define	TR_SCSI_DVMAAVAIL	397
/* "scsi_dmaavail c %x c_flags %x" */
#define	TR_SCSI_CANTIMER	398
/* "scsi_cancel_timer c %x c_flags %x" */
#define	TR_SCSI_IODONE		399
/* "scsi_iodone c %x un %x c_flags %x un_flags %x bp %x b_flags %x" */

#define TR_KLUSTSORT_BEGIN	400
/* "klustsort begin dp %x bp %x dev %x flg %x size %d" */
#define TR_KLUSTSORT_END	401
/* "klustsort end dp %x bp %x dev %x where %d qlen %d" */

#define	TR_IFP_CALL		402
/* "ifp %x call %a(%x, %x, %x) %x" */

#define	TR_CLNT_KUDP		403
/* "clnt_kudp %C<call,bbusy,send,recv,recvw,recvd,done,hbusy,hdone,busy,bfree,ckuw> %x %x %x %x %x" */
#define	TRC_CLNT_KUDP_CALL	0
#define	TRC_CLNT_KUDP_BBUSY	1
#define	TRC_CLNT_KUDP_SEND	2
#define	TRC_CLNT_KUDP_RECV	3
#define	TRC_CLNT_KUDP_RECVW	4
#define	TRC_CLNT_KUDP_RECVD	5
#define	TRC_CLNT_KUDP_DONE	6
#define	TRC_CLNT_KUDP_HBUSY	7
#define	TRC_CLNT_KUDP_HDONE	8
#define	TRC_CLNT_KUDP_BUSY	9
#define	TRC_CLNT_KUDP_BFREE	10
#define	TRC_CLNT_KUDP_CKUW	11

#define	TR_CLOCK_ADJ		404
/* "sec %d usec %d timedelta %d tickdelta %d delta %d" */
#define TR_SETCPUSTATUS_ENABLE	405
/* "enable %d: %x" */
#define TR_SETCPUSTATUS_DISABLE	406
/* "disable %d: %x" */
#define TR_SETCPUSTATUS_MOVE	407
/* "move process %d: pam %x -> %x" */
#define TR_SETPAMAFFINITY	408
/* "pid %d: pam %x -> %x" */
#define TR_BALPAMAFFINITY	409
/* "pid %d: pam %x -> %x" */
#define TR_LODPAMAFFINITY	410
/* "pid %d: pam %x -> %x" */

#define	TR_RFS_CALL		411
/* "rfs_call %C<start,clnt_calls,clnt_calle,calld> %x %x %x %x %x" */
#define	TRC_RFS_CALL_START	0
#define	TRC_RFS_CALL_CLNT_CALLS	1
#define	TRC_RFS_CALL_CLNT_CALLE	2
#define	TRC_RFS_CALL_CLNT_CALLD	3

#define	TR_IOM_DVMA_LOAD	412
/* "load   mapix %x ov %x nv %x from %a" */
#define	TR_IOM_DVMA_UNLOAD	413
/* "unload mapix %x ov %x nv %x from %a" */

#define	TR_SETRUN		414
/* "pid %d stat %C<ZERO,SLEEP,WAIT,SRUN,SIDL,SZOMB,SSTOP> runq %d slptime %d p_flag %x runout %d" */
#define TR_STOP			415
/* "pid %d stat %C<ZERO,SLEEP,WAIT,SRUN,SIDL,SZOMB,SSTOP> p_flag %x p_tptr %x p_pptr %x p %x" */

#define	TR_SETJMP		430
/* "jb %x pc %a sp %x" */
#define	TR_LONGJMP		431
/* "jb %x pc %a sp %x csp %x" */

#define	TR_SOFTCALL		440
/* "func %a arg %x parallel %x code %d sc %x ast_softint %d" */
#define	TR_SOFTCALL_DUP		441
/* "func %a arg %x parallel %x code %d sc %x ast_softint %d" */
#define	TR_SOFTINT_CALL		442
/* "call func %a arg %x parallel %d vm_ctx %d.%d ast_softint %d" */
#define	TR_SOFTINT_RECALL	443
/* "call func %a arg %x parallel %d vm_ctx %d.%d ast_softint %d" */
#define	TR_SOFTINTS		444
/* "start %a arg %x parallel %x vm_ctx %d.%d ast_softint %d" */
#define	TR_SOFTINTE		445
/* "end ast_softint %d serviced %d" */
#define	TR_SOFTINT_LOOPMAX	446
/* "LOOPMAX %d serviced %d" */
#define	TR_SOFTCLOCKS		447
/* "start softclock %x %x %x" */
#define	TR_SOFTCLOCKE		448
/* "end softclock %x %x %x" */

#define	TR_ZSAINTR		450
/* "zsa_%C<attach,txint,xsint,rxint,srint,softint> unit %d %d chars" */
#define	TR_ZSAPROCESS		451
/* "zsa_process unit %d" */
#define	TR_ZSAPROCESS_CHAR	452
/* "zsa_process_char %x unit %d" */
#define	TR_ZSINTR3S		453
/* "zsintr start" */
#define	TR_ZSINTR3E		454
/* "zsintr end" */
#define	TR_ZSSTART		455
/* "zsstart unit %d %d chars" */
#define	TR_ZSRESUME		456
/* "zsresume unit %d %d chars" */
#define	TR_ZSPOLLS		457
/* "zspoll start direct %d consolidated softcalls %d" */
#define	TR_ZSPOLLE		458
/* "zspoll end %d" */
#define	TR_ZSNULLINTR		459
/* "zsnull_%C<attach,txint,xsint,rxint,srint,softint> unit %d %d chars" */
#define	TR_ZSERROR		460
/* "zserror %C<hw_overrun,parity_err,frame_err,sw_overrun> %x %x %x %x %x " */

#define	TR_IPINTRS		470
/* "start %x %x %x %x" */
#define	TR_IPINTRE		471
/* "end %x %x %x %x" */
#define	TR_IPINTR		472
/* "mbuf %x qlen %d" */
#define	TR_IPINTR_PROTO		473
/* "proto-call %a (%x, %x)" */

/* NOTE: these must match order of bits in if_eivar.h! */
#define	TR_EI_DRIVER		480
/* "BOGUS unit %d: %x %x" */
#define	TR_EI_DRIVER_INIT	481
/* "init unit %d: rb %x i %x" */
#define	TR_EI_DRIVER_FREE	482
/* "free unit %d: lbp %x %x" */
#define	TR_EI_DRIVER_LOAN	483
/* "loan unit %d: %x %x" */
#define	TR_EI_DRIVER_HANG	484
/* "hang unit %d: %x %x" */
#define	TR_EI_DRIVER_IHANG	485
/* "ihang unit %d: rb %x i %x" */
#define	TR_EI_DRIVER_MISS	486
/* "miss unit %d: %x %x" */
#define	TR_EI_DRIVER_REHANGA	487
/* "rehanga unit %d: %x %x" */
#define	TR_EI_DRIVER_REHANGB	488
/* "rehangb unit %d: %x %x" */
#define	TR_EI_DRIVER_INTRS	489
/* "intr start unit %d: %x %x" */
#define	TR_EI_DRIVER_INTRREL	490
/* "intr release unit %d: %x %x" */
#define	TR_EI_DRIVER_INTRSVC	491
/* "intr serviced unit %d: %x %x" */
#define	TR_EI_DRIVER_INTRCSR	492
/* "intr csr unit %d: csr %x %x" */
#define	TR_EI_DRIVER_INTRE	493
/* "intr end unit %d: %x %x" */
#define	TR_EI_DRIVER_DOG	494
/* "dog unit %d: csr0 %x flags %x" */
#define	TR_EI_DRIVER_TXSTART	495
/* "start unit %d: m %x tb %x" */
#define	TR_EI_DRIVER_TXNSTART	496
/* "start notmds unit %d: tb %x t %x" */

#define	TR_NOTE			500
/* "NOTE: %s0" */
#define	TR_ASSERT		501
/* "assertion failed: %s0" */
#define	TR_PANIC		502
/* "panic: %s0" */
#define	TR_PRINTF		503
/* "printf: %s0" */

#ifdef	solbourne
/*
 * converted "PA" points. These need to be phased out over time...
 */
#ifdef	TRACE
#define PA(w, x, y, z)	trace1(y, z);
#else	TRACE
#define PA(w, x, y, z)
#endif	TRACE
#define	PA_IO1			1030
/* "rwip-vp %x" */
#define	PA_IO2			1031
/* "getpage-off %x" */
#define	PA_IO3			1032
/* "getpage-len %d" */
#define	PA_IO4			1033
/* "putpage-off %x" */
#define	PA_IO5			1034
/* "putpage-len %d" */
#define	PA_NET1			1035
/* "eiread-top" */
#define	PA_NET1A		1036
/* "egintr-top" */
#define	PA_NET4			1039
/* "sbappend-mbuf %x" */
#define	PA_NET5			1040
/* "sbwait-sb %x" */
#define	PA_NET6			1041
/* "sbwakeup-sb %x" */
#define	PA_NET7			1042
/* "ip-output-mbuf %x" */
#define	PA_NET8			1043
/* "do_protocol-mbuf %x" */
#define	PA_NET9			1044
/* "svc_run" */
#define	PA_SIGNAL1		1051
/* "psignal-pid %d" */
#define	PA_SIGNAL2		1052
/* "e-psignal-sig %d" */
#define	PA_SIGNAL3		1053
/* "psig-sig %d" */
#define	PA_SIGNAL4		1054
/* "pre-sendsig" */
#define	PA_SIGNAL5		1055
/* "post-sendsig" */
#define	PA_SIGNAL6		1056
/* "psig-exit" */
#define	PA_SLOCK1		1057
/* "contend-lp %x" */
#define	PA_SLOCK2		1058
/* "contend-cnt %d" */
#define	PA_SWITCH		1059
/* "sw-mstr-clr %x" */
#define	PA_TLB0			1060
/* "tlbshot-addr %x" */
#define	PA_TLB1			1061
/* "shot-addr %x" */
#define	PA_TLB2			1062
/* "shot-len %x" */
#define	PA_TLB3			1063
/* "shotcpu-done %d" */
/*#define	PA_UCOMM		1064 */
/* "cmd-name $4chr" */
#define	PA_VM1			1065
/* "kern-flt-va %x" */
#define	PA_VM2			1066
/* "flt-va %x" */
#define	PA_VM3			1067
/* "serial-flt" */
#define	PA_VM4			1068
/* "as-flt-res %d" */
#define	PA_VM5			1069
/* "ref-flt" */
#define	PA_VM6			1070
/* "mod-flt" */
#define	PA_XD1			1071
/* "xdgetcbi-xdcbi %x" */
#define	PA_XD2			1072
/* "xdputcbi-xdcbi %x" */
#define	PA_XD3			1073
/* "xdstrat-bp %x" */
#define	PA_XD4			1074
/* "xdintr-ctlr %x" */
#define	PA_XD5			1075
/* "xdgo-xdcbi %x" */
#define	PA_GRAB_VM		1076
/* "grab_vm_ctx %x" */
#define	PA_DROP_VM		1077
/* "drop_vm_ctx %x" */
/*#define	PA_SPLSCHED		1078 /**/
/* "splsched-caller %x" */
/*#define	PA_SPLBLOCK		1079 /**/
/* "splblock-caller %x" */
#define	PA_SPL7			1080
/* "spl7-caller %x" */
#define	PA_SPLHIGH		1081
/* "splhigh-caller %x" */
#define	PA_SPLVME		1082
/* "splvme-caller %x" */
#define	PA_SPL6			1083
/* "spl6-caller %x" */
#define	PA_SPLCLOCK		1084
/* "splclock-caller %x" */
#define	PA_SPL5			1085
/* "spl5-caller %x" */
#define	PA_SPLTTY		1086
/* "spltty-caller %x" */
#define	PA_SPLZS		1087
/* "splzs-caller %x" */
#define	PA_SPL4			1088
/* "spl4-caller %x" */
#define	PA_SPL3			1089
/* "spl3-caller %x" */
#define	PA_SPLIMP		1090
/* "splimp-caller %x" */
#define	PA_SPLBIO		1091
/* "splbio-caller %x" */
#define	PA_SPL2			1092
/* "spl2-caller %x" */
#define	PA_SPL1			1093
/* "spl1-caller %x" */
#define	PA_SPLNET		1094
/* "splnet-caller %x" */
#define	PA_SPLSFTCLK		1095
/* "splsoftclock-caller %x" */
#define	PA_SPL0			1096
/* "spl0-caller %x" */
#define	PA_SPLX			1097
/* "splx-caller %x" */
#define	PA_SPLR			1098
/* "splr-caller %x" */
#define	PA_SPLVM		1099
/* "splvm-caller %x" */
#define	PA_ATIPL0		1100
/* "at-ipl0" */
#define	PA_ATIPL		1101
/* "at-ipl %d" */
/*#define	PA_SLWAK1		1102 /**/
/* "sleep-chan %x" */
/*#define	PA_SLWAK2		1103 /**/
/* "sleep-caller %x" */
/*#define	PA_SLWAK3		1104 /**/
/* "sleep-psig" */
/*#define	PA_SLWAK4		1105 /**/
/* "slp+unlk-chan %x" */
/*#define	PA_SLWAK5		1106 /**/
/* "slp+unlk-caller %x" */
/*#define	PA_SLWAK6		1107 /**/
/* "slp+unlk-lp %x" */
/*#define	PA_SLWAK7		1108 /**/
/* "slp+unlk-psig %x" */
/*#define	PA_SLWAK8		1109 /**/
/* "wakeup-chan %x" */
#define	PA_FLATMOUSE		1110
/* "mouse-overrun" */
#define	PA_MOUSEINTR		1111
/* "mouse-interrupt" */
#define	PA_SISEQ		1118
/* "siseq %x" */
#define	PA_SICMD		1119
/* "sicmd %x" */
#define	PA_SIDISC		1120
/* "sidisconnect %x" */
#define	PA_SIRECON		1121
/* "sireconnect %x" */
#define	PA_SVCMD		1122
/* "svcmd %x" */
#define	PA_SVINTR		1123
/* "svintr %x" */
#define	PA_SVSINTR		1124
/* "svsintr %x" */
#define	PA_SVCLASS		1125
/* "svclass %x" */
#define	PA_FX1			1129
/* "fxstart-xdma %x" */
#define	PA_FX2			1130
/* "fxstart-xndma %x" */
#define	PA_FX3			1131
/* "fxdone-rdma %x" */
#define	PA_FX4			1132
/* "fxdone-rndma %x" */
#define	PA_FX5			1133
/* "fxintr-start %x" */
#define	PA_FX6			1134
/* "fxstrip-ringsize %x" */
#define	PA_FX7			1135
/* "fxintr-done %x" */
#define	PA_PG1			1136
/* "prgintr %d" */
#define	PA_PG2			1137
/* "prgrecieve" */
#define	PA_PG3			1138
/* "prgxmit-mbuf" */
#define	PA_PG4			1139
/* "prgxmit" */
#define	PA_PG5			1140
/* "prgxmit-strip %x" */
#define	PA_PG6			1141
/* "prgrbuf_free" */
#define	PA_PG7			1142
/* "prgstart" */
#define	PA_PG8			1143
/* "prgstart_loop" */
#define	PA_PG9			1144
/* "prgstart_mbuf %x" */
#define	PA_PGA			1145
/* "prgintr-done %d" */
#define	PA_NETLOOP1		1146
/* "looutput_mbuf %x" */
#define	PA_NETLOOP2		1147
/* "looptput_netisr %x" */
#define	PA_SOCKET1		1150
/* "sosend_usrreqfunc %a" */
#define	PA_SOCKET2		1151
/* "soreceive_usrreqfunc %a" */
#define	PA_SOCKET3		1152
/* "sosent_start %x" */
#define	PA_SOCKET4		1153
/* "so_uiomove %x" */
#define	PA_SOCKET5		1154
/* "so_end_uiomove %x" */
#define	PA_UDP1			1155
/* "udp_usrreq_start_req %x" */
#define	PA_UDP2			1156
/* "udp_usrreq_done_req %x" */
#define	PA_IP1			1157
/* "ip_output_start %x" */
#define	PA_IP2			1158
/* "ip_output_done %x" */
#define	PA_IP3			1159
/* "ip_output_frag" */

#define PA_ADOIT_B		1164
/* "adoit begin" */
#define PA_ADOIT_E		1165
/* "adoit end" */
#define PA_ADOIT_1		1166
/* "adoit after wakeup" */
#define PA_TWORK_B		1173
/* "thread_worker begin" */
#define PA_TWORK_E		1174
/* "thread_worker end" */
#define PA_SPL_B		1182
/* "splclock begin" */
#define PA_SPL_E		1183
/* "splclock end" */
#define PA_STR_kbdrput		1208
/* "gkbdrput %x" */
#define PA_STR_kbdopen		1209
/* "gkbdopen %x" */
#define PA_STR_kbdclose		1210
/* "gkbdclose %x" */
#define PA_STR_kbdwput		1211
/* "gkbdwput %x" */
#define PA_STR_msrput		1212
/* "gmsrput %x" */
#define PA_STR_msrserv		1213
/* "gmsrserv %x" */
#define PA_STR_msopen		1214
/* "gmsopen %x" */
#define PA_STR_msclose		1215
/* "gmsclose %x" */
#define PA_STR_mswput		1216
/* "gmswput %x" */
#define PA_STR_putq		1217
/* "gputq %x" */
#define PA_STR_mtiopen		1218
/* "gmtiopen %x" */
#define PA_STR_mticlose		1219
/* "gmticlose %x" */
#define PA_STR_mtiwput		1220
/* "gmtiwput %x" */
#define PA_STR_suopen		1221
/* "gsuopen %x" */
#define PA_STR_suclose		1222
/* "gsuclose %x" */
#define PA_STR_suwput		1223
/* "gsuwput %x" */
#define PA_STR_zsopen		1224
/* "gzsopen %x" */
#define PA_STR_zsclose		1225
/* "gzsclose %x" */
#define PA_STR_zswput		1226
/* "gzswput %x" */
#define PA_STR_strrput		1227
/* "gstrrput %x" */
#define PA_STR_strwsrv		1228
/* "gstrwsrv %x" */
#define PA_STR_ldtermrput	1229
/* "gldtermrput %x" */
#define PA_STR_ldtermrsrv	1230
/* "gldtermrsrv %x" */
#define PA_STR_ldtermopen	1231
/* "gldtermopen %x" */
#define PA_STR_ldtermclose	1232
/* "gldtermclose %x" */
#define PA_STR_ldtermwput	1233
/* "gldtermwput %x" */
#define PA_STR_ldtermwsrv	1234
/* "gldtermwsrv %x" */
#define PA_STR_ldtermopen_wakeup	1235
/* "gldtermopen_wakeup %x" */
#define PA_STR_ptsrserv		1236
/* "gptsrserv %x" */
#define PA_STR_ptsopen		1237
/* "gptsopen %x" */
#define PA_STR_ptsclose		1238
/* "gptsclose %x" */
#define PA_STR_ptswput		1239
/* "gptswput %x" */
#define PA_STR_ptcwrite		1240
/* "gptswput %x" */
#define PA_STR_ttcompatrput	1241
/* "gttcompatrput %x" */
#define PA_STR_ttcompatopen	1242
/* "gttcompatopen %x" */
#define PA_STR_ttcompatclose	1243
/* "gttcompatclose %x" */
#define PA_STR_ttcompatwput	1244
/* "gttcompatwput %x" */
#define PA_STR_conskbdopen	1245
/* "gconskbdopen %x" */
#define PA_STR_conskbdclose	1246
/* "gconskbdclose %x" */
#define PA_STR_conskbduwput	1247
/* "gconskbduwput %x" */
#define PA_STR_conskbdlrput	1248
/* "gconskbdlrput %x" */
#define PA_STR_conskbdlwserv	1249
/* "gconskbdlwserv %x" */
#define PA_STR_consmsopen	1250
/* "gconsmsopen %x" */
#define PA_STR_consmsclose	1251
/* "gconsmsclose %x" */
#define PA_STR_consmsuwput	1252
/* "gconsmsuwput %x" */
#define PA_STR_consmslrput	1253
/* "gconsmslrput %x" */
#define PA_STR_consmslwserv	1254
/* "gconsmslwserv %x" */
#define PA_STR_wcopen		1255
/* "gwcopen %x" */
#define PA_STR_wcclose		1256
/* "gwcclose %x" */
#define PA_STR_wcuwput		1257
/* "gwcuwput %x" */
#define PA_STR_wclrput		1258
/* "gwclrput %x" */
#define PA_STR_nbrput		1259
/* "gnbrput %x" */
#define PA_STR_nbopen		1260
/* "gnbopen %x" */
#define PA_STR_nbclose		1261
/* "gnbclose %x" */
#define PA_STR_nbwput		1262
/* "gnbwput %x" */
#define PA_STR_snit_open	1263
/* "gsnit_open %x" */
#define PA_STR_snit_close	1264
/* "gsnit_close %x" */
#define PA_STR_snit_put		1265
/* "gsnit_put %x" */
#define PA_STR_pfrput		1266
/* "gpfrput %x" */
#define PA_STR_pfopen		1267
/* "gpfopen %x" */
#define PA_STR_pfclose		1268
/* "gpfclose %x" */
#define PA_STR_pfwput		1269
/* "gpfwput %x" */
#define PA_STR_tcptli_open	1270
/* "gtcptli_open %x" */
#define PA_STR_tcptli_close	1271
/* "gtcptli_close %x" */
#define PA_STR_tcptli_wput	1272
/* "gtcptli_wput %x" */
#define PA_STR_tcptli_wsrv	1273
/* "gtcptli_wsrv %x" */
#define	PA_STR_timodrput	1274
/* "gtimodrput %x" */
#define	PA_STR_timodopen	1275
/* "gtimodopen %x" */
#define	PA_STR_timodwput	1276
/* "gtimodwput %x" */
#define	PA_STR_tirdwrrput	1277
/* "gtirdrwrput %x" */
#define	PA_STR_tirdwropen	1278
/* "gtirdwropen %x" */
#define	PA_STR_tirdwrwput	1279
/* "gtirdwrwput %x" */
#define	PA_STR_tirdwrclose	1280
/* "gtirdwrclose %x" */
#define PA_STR_allocb		1281
/* "gallocb %x" */
#define PA_STR_xdballoc		1282
/* "gxdballoc %x" */
#define PA_STR_xmballoc		1283
/* "gxmballoc %x" */
#define PA_STR_esballoc		1284
/* "gesballoc %x" */
#define PA_STR_esbbcall		1285
/* "gesbbcall %x" */
#define PA_STR_testb		1286
/* "gtestb %x" */
#define PA_STR_bufcall		1287
/* "gbufcall %x" */
#define PA_STR_unbufcall	1288
/* "gunbufcall %x" */
#define PA_STR_freeb		1289
/* "gfreeb %x" */
#define PA_STR_freemsg		1290
/* "gfreemsg %x" */
#define PA_STR_dupb		1291
/* "gdupb %x" */
#define PA_STR_dupmsg		1292
/* "gdupmsg %x" */
#define PA_STR_copyb		1293
/* "gcopyb %x" */
#define PA_STR_copymsg		1294
/* "gcopymsg %x" */
#define PA_STR_linkb		1295
/* "glinkb %x" */
#define PA_STR_unlinkb		1296
/* "gunlinkb %x" */
#define PA_STR_rmvb		1297
/* "grmvb %x" */
#define PA_STR_pullupmsg	1298
/* "gpullupmsg %x" */
#define PA_STR_adjmsg		1299
/* "gadjmsg %x" */
#define PA_STR_xmsgsize		1300
/* "gxmsgsize %x" */
#define PA_STR_msgdsize		1301
/* "gmsgdsize %x" */
#define PA_STR_getq		1302
/* "ggetq %x" */
#define PA_STR_rmvq		1303
/* "grmvq %x" */
#define PA_STR_flushq		1304
/* "gflushq %x" */
#define PA_STR_qhiwat		1305
/* "gqhiwat %x" */
#define PA_STR_qspace		1306
/* "gqspace %x" */
#define PA_STR_canput		1307
/* "gcanput %x" */
#define PA_STR_canputextra	1308
/* "gcanputextra %x" */
#define PA_STR_putbq		1309
/* "gputbq %x" */
#define PA_STR_insq		1310
/* "ginsq %x" */
#define PA_STR_putctl		1311
/* "gputctl %x" */
#define PA_STR_putctl1		1312
/* "gputctl1 %x" */
#define PA_STR_strinit		1313
/* "gstrinit %x" */
#define PA_STR_allocstr		1314
/* "gallocstr %x" */
#define PA_STR_freestr		1315
/* "gfreestr %x" */
#define PA_STR_allocq		1316
/* "gallocq %x" */
#define PA_STR_backq		1317
/* "gbackq %x" */
#define PA_STR_qreply		1318
/* "gqreply %x" */
#define PA_STR_qenable		1319
/* "gqenable %x" */
#define PA_STR_queuerun		1320
/* "gqueuerun %x" */
#define PA_STR_runqueues	1321
/* "grunqueues %x" */
#define PA_STR_findmod		1322
/* "gfindmod %x" */
#define PA_STR_qsize		1323
/* "gqsize %x" */
#define PA_STR_sealloc		1324
/* "gsealloc %x" */
#define PA_STR_sefree		1325
/* "gsefree %x" */
#define PA_STR_stropen		1326
/* "gstropen %x" */
#define PA_STR_assign_ctty	1327
/* "gassign_ctty %x" */
#define PA_STR_strclose		1328
/* "gstrclose %x" */
#define PA_STR_strdismantle	1329
/* "gstrdismantle %x" */
#define PA_STR_strclean		1330
/* "gstrclean %x" */
#define PA_STR_strread		1331
/* "gstrread %x" */
#define PA_STR_strkread		1332
/* "gstrkread %x" */
#define PA_STR_strsendsig	1333
/* "gstrsendsig %x" */
#define PA_STR_str_sigio	1334
/* "gstr_sigio %x" */
#define PA_STR_strwakepoll	1335
/* "gstrwakepoll %x" */
#define PA_STR_strwrite		1336
/* "gstrwrite %x" */
#define PA_STR_strcheckoutq	1337
/* "gstrcheckoutq %x" */
#define PA_STR_stroutput	1338
/* "gstroutput %x" */
#define PA_STR_strioctl		1339
/* "gstrioctl %x" */
#define PA_STR_ldreplace	1340
/* "gldreplace %x" */
#define PA_STR_dopush		1341
/* "gdopush %x" */
#define PA_STR_initialize_ldtab	1342
/* "ginitialize_ldtab %x" */
#define PA_STR_getcompatqueue	1343
/* "ggetcompatqueue %x" */
#define PA_STR_getmname		1344
/* "ggetmname %x" */
#define PA_STR_strdoioctl	1345
/* "gstrdoioctl %x" */
#define PA_STR_getiocseqno	1346
/* "ggetiocseqno %x" */
#define PA_STR_strgetmsg	1347
/* "gstrgetmsg %x" */
#define PA_STR_strputmsg	1348
/* "gstrputmsg %x" */
#define PA_STR_strpoll		1349
/* "gstrpoll %x" */
#define PA_STR_strselect	1350
/* "gstrselect %x" */
#define PA_STR_qattach		1351
/* "gqattach %x" */
#define PA_STR_qdetach		1352
/* "gqdetach %x" */
#define PA_STR_tty_rd_wait	1353
/* "gtty_rd_wait %x" */
#define PA_STR_tty_wr_wait	1354
/* "gtty_wr_wait %x" */
#define PA_STR_strtime		1355
/* "gstrtime %x" */
#define PA_STR_str2time		1356
/* "gstr2time %x" */
#define PA_STR_str3time		1357
/* "gstr3time %x" */
#define PA_STR_putiocd		1358
/* "gputiocd %x" */
#define PA_STR_getiocd		1359
/* "ggetiocd %x" */
#define PA_STR_alloclink	1360
/* "galloclink %x" */
#define PA_STR_linkcycle	1361
/* "glinkcycle %x" */
#define PA_STR_findlinks	1362
/* "gfindlinks %x" */
#define PA_STR_getendq		1363
/* "ggetendq %x" */
#define PA_STR_munlinkone	1364
/* "gmunlinkone %x" */
#define PA_STR_munlinkall	1365
/* "gmunlinkall %x" */
#define PA_STR_setq		1366
/* "gsetq %x" */
#define PA_STR_strmakemsg	1367
/* "gstrmakemsg %x" */
#define PA_STR_strwaitbuf	1368
/* "gstrwaitbuf %x" */
#define PA_STR_strunbcall	1369
/* "gstrunbcall %x" */
#define PA_STR_strwaitq		1370
/* "gstrwaitq %x" */
#define PA_STR_strvtime		1371
/* "gstrvtime %x" */
#define PA_STR_spopen		1372
/* "gspopen %x" */
#define PA_STR_spclose		1373
/* "gspclose %x" */
#define PA_STR_spput		1374
/* "gspput %x" */
#define PA_STR_getmsg		1375
/* "ggetmsg %x" */
#define PA_STR_putmsg		1376
/* "gputmsg %x" */
#define PA_STR_msgio		1377
/* "gmsgio %x" */
#define PA_STR_poll		1378
/* "gpoll %x" */
#define PA_STR_pollreset	1379
/* "gpollreset %x" */
#define PA_STR_polltime		1380
/* "gpolltime %x" */
#define PA_STR_pollsel		1381
/* "gpollsel %x" */
#define	PA_STR_run_streams	1382
/* "grun_streams %x" */
#define	PA_LOCK_REQ		1383
/* "greq_lock %x" */
#define	PA_LOCK_GET		1384
/* "gget_lock %x" */
#define	PA_LOCK_PUT		1385
/* "gput_lock %x" */
#endif	solbourne

/*
 * Parameters needed for trace post-processing.  Be careful to keep this
 * up-to-date.  MAXTRACEID is the highest number used for a trace id.
 * MAXTRACECODE is the highest number used to represent a code, for example
 * the codes for TR_PG_FREE are gone, free, cachetl, and cachehd.  These are
 * represented as 0, 1, 2, and 3, respectively.  If 3 were the highest code
 * used for any trace point, that would be the value of MAXTRACECODE.

 */
#define MAXTRACEID	TR_INTERRUPT
#define MAXTRACECODE	TRC_RWIP_RETURN

/*
 * Generic format for data saved with trace calls.
 *
 * The format of tr_time varies depending on whether or not there's
 * a high resolution timer available.  If so, it's the timer's value;
 * if not, it's the low 16 bits of time.tv_sec concatenated to the
 * high 16 bits of time.tv_usec.  Tr_pid records the process active
 * at the time of the trace call; it's not meaningful if called from
 * interrupt level.
 */
struct trace_rec {
	u_long	tr_time;
#ifdef	solbourne
	u_long	tr_tag;
	u_char	tr_ipl;
	u_char	tr_cpu;
#else	solbourne
	short	tr_tag;
#endif	solbourne
	u_short	tr_pid;
	u_long	tr_datum0;
	u_long	tr_datum1;
	u_long	tr_datum2;
	u_long	tr_datum3;
	u_long	tr_datum4;
	u_long	tr_datum5;
#ifdef	solbourne
	u_long	tr_caller;
#endif	solbourne
};



/*
 * Requests for the vtrace() system call.
 */
#define VTR_DISABLE	0		/* trace specified events */
#define VTR_ENABLE	1		/* don't trace specified events */
#define VTR_VALUE	2		/* return currently-traced events */
#define VTR_STAMP	3		/* cause TR_STAMP event */
#define VTR_RESET	4		/* reset eventstraced to zero */
#define VTR_EXEC	5		/* execute the specified trace points */

#ifdef	KERNEL
#ifdef	TRACE

extern tr_set	tracedevents;
extern u_int	tracebufents;
extern u_int	eventstraced;
extern struct	trace_rec *tracebuffer;
extern		int traceval;
extern void	inittrace();
extern void	resettracebuf();
extern int	traceit();

#define pack(a, b)	((a)<<16)|(b)

/*
 * Lint doesn't believe that there are valid reasons for comparing
 * constants to each other...
 */
#ifdef	lint
#define trace(ev, d0, d1, d2, d3, d4, d5) \
	traceit((ev), (u_long)(d0), (u_long)(d1), (u_long)(d2), \
			(u_long)(d3), (u_long)(d4), (u_long)(d5))
#else	lint
#define trace(ev, d0, d1, d2, d3, d4, d5) \
	(((u_int)(ev) < TR_SETSIZE && TR_ISSET((ev), &tracedevents)) ? \
		traceit((ev), (u_long)(d0), (u_long)(d1), (u_long)(d2), \
			(u_long)(d3), (u_long)(d4), (u_long)(d5)) : 0)
#endif	lint

/* string arguments are passed by value! */
#ifdef	solbourne
/* strings may not be int aligned, defined as a function in kern_trace.c */
#else	solbourne
#define trs(cp, num)	(((u_long *) cp)[num])
#endif	solbourne

#define trace6(ev, d0, d1, d2, d3, d4, d5) \
					trace(ev, d0, d1, d2, d3, d4, d5)
#define trace5(ev, d0, d1, d2, d3, d4)	trace(ev, d0, d1, d2, d3, d4, 0)
#define trace4(ev, d0, d1, d2, d3)	trace(ev, d0, d1, d2, d3, 0, 0)
#define trace3(ev, d0, d1, d2)		trace(ev, d0, d1, d2, 0, 0, 0)
#define trace2(ev, d0, d1)		trace(ev, d0, d1, 0, 0, 0, 0)
#define trace1(ev, d0)			trace(ev, d0, 0, 0, 0, 0, 0)

#else	TRACE

#define pack(a, b)

#define trace	trace6
#define trace6(ev, d0, d1, d2, d3, d4, d5)
#define trace5(ev, d0, d1, d2, d3, d4)
#define trace4(ev, d0, d1, d2, d3)
#define trace3(ev, d0, d1, d2)
#define trace2(ev, d0, d1)
#define trace1(ev, d0)
#define	tracetraceback(ev)
#define	tracetraceback1(ev, d0)
#define	tracetraceback2(ev, d0, d1)
#define	trace_string(ev, string_d, d0, d1, d2, d3, d4, d5)
#endif	TRACE
#endif	KERNEL

#endif /*!_sys_trace_h*/
