/* @(#) osmp_lock.h 1.1@(#) Solbourne id 9/21/93 23:50:07 */
/*
 * Copyright 1990 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*
 * osmp_lock.h - datatype definitions for lock objects.
 */

#ifndef _sys_osmp_lock_h
#define _sys_osmp_lock_h 1
#ifdef LKSTAT
#include <sys/lkstat.h>
#endif
/* 
 * general lock structure.
 * if lock debugging is not enabled, some fields may not be used
 */
typedef struct simple_lock {
	unsigned char	intlk;		/* interlock byte */
	unsigned char	owner_cpu;	/* owning CPU, -1 => not held */
	unsigned int	oldpsr;		/* for block_n_lock - the old psr */
	char 		*name;		/* string with lock name */
	unsigned int	order_no;	/* this locks order number */
	struct simple_lock *next;	/* next lock held by this cpu */
	unsigned int	c1;		/* backtrace info... */
	unsigned int	c2;
	unsigned int	c3;
#ifdef LKSTAT
	lkstat_t	lkstat_ptr;	/* lockstat pointer */
#else
	int		*filler;	/* filler to make a struct proc
					   the same size (make ps work!) */
#endif
	struct simple_lock *list;	/* list of all locks */
#ifdef	Q_VM_CONTEXT
	int		wakeup_chan;	/* wakeup channel */
	struct	slock_queue	{
	    struct	slock_queue	*queue_next;
	    int				queue_pid;
	}		*queue, *queue_t;
#endif	Q_VM_CONTEXT
} slock;

typedef slock	*slock_t;

/* public version of lock */
#define	public_simple_lock	simple_lock
typedef slock	public_slock;
typedef slock	*public_slock_t;

#endif _sys_osmp_lock_h
