/* @(#) kmem_alloc.h 1.2@(#) Solbourne id 11/29/93 19:06:31 */
/*
 * Copyright 1990 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*	@(#)kmem_alloc.h 1.2 89/11/27	SMI	*/

/*
 * Declarations and definitions for the kernel memory allocator
 */

#ifndef	__sys_kmem_alloc_h
#define	__sys_kmem_alloc_h

#include <sys/types.h>

#ifdef KERNEL
#ifdef	solbourne
caddr_t	internal_new_kmem_fast_alloc();
#ifdef	RECORD_USAGE
caddr_t	kmem_alloc();
caddr_t	kmem_fast_alloc();
caddr_t	new_kmem_fast_alloc();
caddr_t	new_kmem_fast_alloc_locked();
#else	RECORD_USAGE
#define	kmem_alloc(nbytes)					\
	new_kmem_alloc(nbytes, servicing_interrupt())
#define	kmem_fast_alloc(base, size, chunks)			\
	internal_new_kmem_fast_alloc(base, size, chunks, servicing_interrupt())
#define	new_kmem_fast_alloc(base, size, chunks, nosleep)	\
	internal_new_kmem_fast_alloc(base, size, chunks, nosleep)
#define	kmem_fast_alloc_locked(base, size, chunks, clp)		\
	new_kmem_fast_alloc_locked(base, size, chunks, servicing_interrupt(), clp)
#endif	RECORD_USAGE
caddr_t	kmem_zalloc();
caddr_t	kmem_fast_zalloc();
caddr_t kmem_resize();
caddr_t	new_kmem_alloc();
caddr_t	new_kmem_zalloc();
caddr_t	new_kmem_fast_zalloc();
caddr_t new_kmem_resize();
caddr_t getpages();
void	freepages();
extern caddr_t kernelmap_alloc();
extern caddr_t kernelmap_zalloc();
caddr_t	kmem_fast_zalloc_locked();
caddr_t	new_kmem_fast_alloc_locked();
caddr_t	new_kmem_fast_zalloc_locked();
#else	solbourne
caddr_t	kmem_alloc();
caddr_t	kmem_zalloc();
caddr_t	kmem_fast_alloc();
caddr_t	kmem_fast_zalloc();
caddr_t kmem_resize();
caddr_t	new_kmem_alloc();
caddr_t	new_kmem_zalloc();
caddr_t	new_kmem_fast_alloc();
caddr_t	new_kmem_fast_zalloc();
caddr_t new_kmem_resize();
caddr_t getpages();
void	freepages();
extern caddr_t kernelmap_alloc();
extern caddr_t kernelmap_zalloc();
#endif	solbourne
#endif /* KERNEL */

#define	KMEM_SLEEP	0
#define	KMEM_NOSLEEP	1

#endif	/* !__sys_kmem_alloc_h */
