/* network interface structure */
struct ifnet {
	struct sockaddr	if_addr;	/* address of interface */
	short		if_unit;	/* sub-unit for lower level driver */
	short		if_mtu;		/* maximum transmission unit */
	short		if_flags;	/* up/down, broadcast, etc. */
	int		(*if_output)();	/* output routine */
};

/* standalone binding for an internet connection */
struct inet_bind {
	struct sockaddr		ib_srcaddr;	/* source address */
	struct sockaddr		ib_dstaddr;	/* destination address */
	struct socket		*ib_socket;	/* socket for connection */
	struct ifnet		*ib_ifp;	/* interface for connection */
};

#define	IFF_UP		0x1		/* interface is up */
#define	IFF_BROADCAST	0x2		/* broadcast address valid */
#define	IFF_DEBUG	0x4		/* turn on debugging */
#define	IFF_LOOPBACK	0x8		/* is a loopback net */
#define	IFF_POINTOPOINT	0x10		/* interface is point-to-point link */
#define	IFF_NOTRAILERS	0x20		/* avoid use of trailers */
#define	IFF_RUNNING	0x40		/* resources allocated */
#define	IFF_NOARP	0x80		/* no address resolution protocol */
#define	IFF_PROMISC	0x100		/* receive all packets */
#define	IFF_ALLMULTI	0x200		/* receive all multicast packets */
#define IFF_PRIVATE	0x8000		/* do not advertise */

/* flags set internally only: */
#define	IFF_CANTCHANGE \
		(IFF_BROADCAST | IFF_POINTOPOINT | IFF_RUNNING | IFF_PROMISC)
