/*
 *	fb -- definitions for generic frame buffer driver
 */

#define	ROW_SPACING	2	/* space between char and row boundary */

extern FontInfoRec	builtin_font_header;
extern CharInfoRec	builtin_font_charinfo;
extern char		builtin_font_glyphs;

#define	FB_MAXLINES	256		/* maximum number of lines */
#define FB_FIRST_SPACE	0xa		/* first assignable i/o space */

/*
 * Information structure for each graphics board found
 */

struct fb_info {
	char	*frame_buffer;		/* Frame buffer base address */
	char	*keyboard;		/* keyboard base address */
	int	slot;			/* Kbus slot */
	int	space;			/* i/o space */
	int	size;			/* size of frame buffer */
	unsigned char fb_type;		/* info from cap table... */
	unsigned char no_of_planes;
	unsigned char access_size;
	int	white_value;
	int	black_value;
	int	FBclipleft;		/* font stuff... */
	int	FBcliptop;
	int	FBclipright;
	int	FBclipbottom;
	int	FBwidth_bits;
	int	FBheight_bits;
	int	FBwidth_chars;		/* = FBwidth_bits / 8 */
	short	cur_row;		/* Current cursor row on screen */
	short	cur_col;		/* Current cursor column on screen */
	short	fb_flags;		/* Device type/options flags */
};

/*
 * Device type/options fb_flags bits
 */

#define	FB_EXISTS	0x1		/* Device exists */
#define FB_CONSOLE	0x2		/* Device is console */

extern int halt_flag;
#define INTR_HALT()	(halt_flag ? suspend(0) : 0)

/*
 * Define op codes for initialization table.
 */
#define CONT_OP		0x01		/* Continue At	      */
#define DEP_OP		0x02		/* Deposit Data	      */
#define ILOOP_OP	0x03		/* Initialize Loop    */
#define SSR_OP		0x04		/* Set Space Register */
#define SLOOP_OP	0x05		/* Status Loop	      */
#define STOP_OP		0xff		/* Stop		      */
