/* @(#) boot.h 1.1@(#) Solbourne id 9/21/93 23:57:04 */
/*
 * Copyright 1988 Solbourne Computer, Inc.
 * All rights reserved.
 */

/*
 * Data structures and defines for a boot partition "filesystem".
 * All files in a boot partition are in contiguous sectors and are 
 * an integral number of sectors long.  The first sector in a boot
 * partition contains the directory for the boot partition.
 */

#define BOOT_NUMENT	15		/* maximum items in boot partition */
#define	BOOT_NAMESIZE	16		/* length of a boot directory name */
#define	BOOT_OFFSET	1		/* boot directory offset in partition */
#define	BOOT_MAGIC	0x424f4f54	/* boot directory magic number */

/*
 * Error logs, media defect maps, and first level boot programs
 * are located within the boot partition. The following structure 
 * provides a mechanism for locating these within the boot partition.
 */
struct bootinfo {
	char		bi_name[BOOT_NAMESIZE]; /* name of item */
	int		bi_start;	/* logical sector address */
	int		bi_size;	/* # of sectors in item */ 
	int		bi_free;	/* unused space to next entry */
	int		bi_info;	/* entry specific information */
};


struct bootdir {
	int		b_psize;	/* boot partition size in sectors */
	struct bootinfo	b_entry[BOOT_NUMENT];	/* boot partition files */
	unsigned int	b_magic;	/* magic number for boot directory */
	char		b_pad[24];	/* pad to 512 bytes */
};

