/* @(#) if_prgvar.h 1.4@(#) Solbourne id 1/29/94 23:59:18 */
/*
 * Copyright 1991 Solbourne Computer, Inc.
 * All rights reserved.
 */
#ifndef if_if_prgvar_h
#define	if_if_prgvar_h

/* This file contains definitions specifiec to the driver */

#define	PRG_XFER_OPTS 0x23d
typedef struct ether_addr E_NET_ADDR;

/*
 * Number of microseconds to wait after issuing a board reset.
 */
#define	PRG_RESET_WAIT	2000000

/*
 * Frequency at which we get timer interrupts from the board on response
 * channels.  This is the minimum interrupt interval, only get interrupted
 * if there is work queued on the channel.  Value is in units of 100
 * microseconds.
 */
#define	PRG_RESP_INTR_TIMER	1

/*
 * Default amount of time to wait for the board to respond to a command
 * when not using interrupts.  Value is in microseconds.
 */
#define	RC_DEF_WAIT	2000

/* control specific configuration information */
struct prg_conf {
    char	*pc_bname;			/* board name */
    char	*pc_pname;			/* customer product name */
    int		pc_type;
#define		  PC_TYPE_ETHER		1
#define		  PC_TYPE_FDDI		2
#define		  PC_TYPE_ASCII		{ "UNKNOWN", "ETHER", "FDDI", }
    int		pc_flags;
#define		  PC_FLAGS_BLOCK_R	0x0001	/* block mode rcv works */
#define		  PC_FLAGS_BLOCK_X	0x0002	/* block mode xmit works */
#define		  PC_FLAGS_XMIT_MBUF	0x0004	/* transmit from mbufs */
#define		  PC_FLAGS_FLASH	0x0008	/* flash */
#define		  PC_FLAGS_BITS	"\20\4FLASH\3XMIT_MBUF\2BLK_X\1BLK_R"
    int		pc_align_board;		/* board dma alignment requirements */
    int		pc_align_driver;	/* driver alignment desire 1->byte */
    int		pc_min_tu;		/* min size packet */
    int		pc_max_tu;		/* max size packet */
    int		pc_buf_sz;		/* size of buffer for packet */
    int		pc_nrecv;		/* number of recieve buffers */
    int		pc_nrecv_loan;		/* max # of recieve buffers to loan */
    int		pc_rx_throttle;		/* # packets moved before response */
    int		pc_nxmit;		/* number transmit buffers (no dvma) */
    int		pc_nxmit_dvma;		/* number of mbuf transmit buffers */
    int		pc_nxmit_frags;		/* number of frags per transmit buf */
    int		pc_minlen_rdma_loan;	/* min len for rcv dma to loan mbuf */
    int		pc_max_xbackback;	/* max # of back-to-back xmits */
    int		pc_max_xdrain;		/* max # of xmits to strip at a time */
    int		pc_resp_intr_timer;	/* common response intr timer value */
    int		pc_xresp_intr_timer;	/* xmit chnl interrupt timer value */
    int		pc_h2b_channels;	/* # of host to board channels (>=1) */
    int		pc_b2h_channels;	/* # of board to host channels (>=1) */
    int		pc_segs_per_channel;	/* Number of segments per channel */
    int		pc_seg_size;		/* Size of a channel segment */
};

/* Network software status per interface.  */
struct prg_softc {
    struct arpcom	ps_ac;		/* common ethernet stuctures */
#define			ps_if		ps_ac.ac_if
#define			ps_enaddr	ps_ac.ac_enaddr	/* internet bit order */
#define			ps_mcaddr	ps_ac.ac_mcaddr	/* multicast addr vec */
#define			ps_nmcaddr	ps_ac.ac_nmcaddr/* # multicast addrs */
					/* current board addresses */
    struct ether_addr	ps_brd_addr;	/* internet bit order (canon) */
    struct fddi_addr	ps_brd_wireaddr;/* network bit order (non-canon) */
    short		ps_unit;	/* unit # of board */
    short		ps_flags;
#define			  PS_FLAGS_RUNNING	0x0001 /* board is running */
#define			  PS_FLAGS_CONNECTED	0x0002 /* SMT connection */
#define			  PS_FLAGS_RINGOP	0x0004 /* ring operational */
#define			  PS_FLAGS_MIB_BUSY	0x0008 /* mib data busy */
#define			  PS_FLAGS_MIB_WANTED	0x0010 /* mib data wanted */
#define			  PS_FLAGS_NO_CHECK	0x0020 /* dont check mac addr */
#define			  PS_FLAGS_SERVICING	0x0040 /* servicing device */
#define			  PS_FLAGS_WAITING	0x0080 /* wait for ioctl/intr */
#define			  PS_FLAGS_IOCTL_BUSY	0x0100 /* ioctl in progress */
#define			  PS_FLAGS_START_TO	0x0200
#define			  PS_FLAGS_BITS	\
"\20\12START_TO\11IOCTL_BUSY\10WAITING\7SERVICING\6NO_CHECK\5MIB_WANT\
\4MIB_BUSY\3RINGOP\2CONNECTED\1RUNNING"
    struct prg_conf	*ps_pc;		/* configuration information */
    struct prg_dstat	*ps_dstat;	/* driver statistics */
    struct prg_shio	*ps_shio;	/* Address of brd short io space */
    struct prg_cb	*ps_shio_cb;	/* Address of common boot interface */
    struct prg_rc	*ps_shio_rc;	/* Address of RC interface */
    struct prg_cb_herald ps_cb_herald;	/* cb_herald field found after reset */
    struct rc_crsb_info ps_crsb_info;	/* firmware rev information */
    ushort		ps_int_vector;	/* interrupt vector */
    ushort		ps_int_xvector;	/* transmit interrupt vector */
    ushort		ps_int_level;	/* interrupt level */
    ushort		ps_promisc;	/* we are in promisc mode */
    ushort		ps_cam_active;	/* we have stuff in the CAM */
    struct ps_hcdesc {
	u_short	hcdesc_seg;
	caddr_t	hcdesc_va;
    }			*ps_hcd;	/* ptr to array of host channel desc */
    struct ps_segdesc {
	caddr_t	segdesc_addr;		/* Virtual address of segment. */
	u_int	segdesc_paddr;		/* Physical address of segment. */
	ushort	segdesc_segno;		/* Segment number */
    }			*ps_xsegp,
			*ps_rsegp; /* pointer to array of segdesc */
    struct ps_bufdesc {
	struct ps_bufdesc *bufdesc_next;/* next driver chained buffer */
	caddr_t		bufdesc_addr;	/* Address of start of buffer */
	int		bufdesc_len;	/* Length in bytes of buffer */
	struct mbuf	*bufdesc_m;	/* Address of mbuf(s) attached to buf */
    }			*ps_rbdp;	/* for receive buffers */
    struct ps_txf {			/* transmit frag descriptor free list */
	struct ps_txf	*txf_next;
	struct mbuf	*txf_m;
	u_int		txf_len;
	u_int		txf_cookie;
    }			*ps_txf_free,
			*ps_txf_base;

    union ps_ccbcrs {
	struct rc_crs	*ccbcrs_crs[3];	/* current response pointer */
	struct rc_ccb	*ccbcrs_ccb[3];	/* current command pointer */
			/* KLUDGE... 3 is the number of segments */
    }			ps_ccbcrs;
#define	ps_crs	ps_ccbcrs.ccbcrs_crs
#define	ps_ccb	ps_ccbcrs.ccbcrs_ccb

    caddr_t		ps_recv;	/* pointer to base of recv buffers */
    u_int		ps_recv_cookie;	/* cookie for base of recv buffers */
    int			ps_recv_tlen;	/* length of allocated recv buffers */
    caddr_t		ps_recv_align;	/* aligned pointer to 1st recv buf */
    u_int		ps_recv_span;	/* # bytes from one recv buf to next */
    int			ps_recv_loaned_out;	/* # currently loaned out */

    struct rc_rcvble	*ps_rcvbl;	/* virtual add of recv buffer list */
    u_int		ps_rcvbl_cookie;/* bus cookie for base of rcvbl */
    int			ps_rcvbl_tlen;	/* length of allocated recv buf list */
    struct rc_rcvble	*ps_rcvbl_w;	/* write pointer to recv buffer list */
    struct rc_rcvble	*ps_rcvbl_wrap;	/* address where recv pointer wrap */

    caddr_t		ps_xmit;	/* pointer to base of xmit buffers */
    int			ps_xmit_tlen;	/* length of allocated xmit buffers */
    caddr_t		ps_xmit_align;	/* aligned pointer to 1st xmit buf */
    u_int		ps_xmit_span;	/* # bytes from one xmit buf to next */
    struct mbuf		*ps_xmit_freebuf; /* list of free transmit buffers */
    int			ps_nxmit_dvma;	/* amount of DVMA in use */

    caddr_t		ps_rcmem;	/* channel/segment memory */
    int			ps_rcmem_tlen;	/* length of rcmem */
    u_int		ps_rcmem_cookie;/* bus cookie for base of rcmem */

    struct mbuf		*ps_mbuf_tofree;/* list of mbufs to free */

    char		ps_mib_data[256];	/* MIB information */
};

/* driver statistics: seperate from softc so it is easy to find */
struct prg_dstat {
    int		prg_dstat_intr;			/* number of interrupts */
    int		prg_dstat_xintr;		/* number of xmit interrupts */
    int		prg_dstat_npkt;			/* number of packets */
#define		  PRG_STAT_NPKT_BINS	16
    int		prg_dstat_npkt_intr[PRG_STAT_NPKT_BINS]; /* histogram pkt/intr*/
    int		prg_dstat_r;			/* number of rcv's */
    int		prg_dstat_x;			/* number of xmit's */
    int		prg_dstat_sumxlen;		/* number of bytes xmited */
    int		prg_dstat_sumrlen;		/* number of bytes rcved */
    int		prg_dstat_xalo;			/* dma xmit allocations */
    int		prg_dstat_xrel;			/* dma xmit releases */
    int		prg_dstat_xdma_unal;		/* dma xmit unaligned use buf */
    int		prg_dstat_xdma_toofrag;		/* dma xmit too fragmented */
    int		prg_dstat_xdma_nocl;		/* dma xmit w no cluster */
    int		prg_dstat_xbufs_mbuf;		/* try dma from mbuf */
    int		prg_dstat_xqueue;		/* xmit packet requeued */
    int		prg_dstat_xnotxf;		/* out of xmitmbuf frag desc */
    int		prg_dstat_xnodvma;		/* out of xmitmbuf dvma space */
    int		prg_dstat_xnobuf;		/* out of xmit buffer space */
    int		prg_dstat_nxmit_dvma;		/* amount of DVMA in use */
    int		prg_dstat_rbufs_loaned;		/* # receive loaned */
    int		prg_dstat_rbufs_freed;		/* # receive returned */
    int		prg_dstat_xbufs_issued;		/* # transmit issued */
    int		prg_dstat_xbufs_returned;	/* # transmit returned */
    int		prg_dstat_nocmd_space;		/* out of command space */
#define		  PRG_STAT_LEN_BINS	13
    int		prg_dstat_xlen[PRG_STAT_LEN_BINS]; /* histogram pkt xmit len */
    int		prg_dstat_rlen[PRG_STAT_LEN_BINS]; /* histogram pkt rcv len */
    int         prg_dstat_max_rbufs_loaned;     /* high water mark for 
						    ps_recv_loaned_out */
};
#endif	if_if_prgvar_h
